/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.GlobalContext;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.objectives.Fitness;

public class RandomSearchStrategy
implements IStrategy {
    private int maxDepth = -1;
    private Random rnd = new Random();
    private SharedData shared;
    private TrajectoryInfo trajectoryInfo;
    int nth;
    private ThreadContext context;
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private Logger logger = Logger.getLogger(IStrategy.class);

    public RandomSearchStrategy(int minDepth, int maxDepth, int numberOfTries) {
        this.shared = new SharedData(minDepth, maxDepth, numberOfTries);
    }

    private RandomSearchStrategy() {
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        this.trajectoryInfo = context.getTrajectoryInfo();
        GlobalContext gc = context.getGlobalContext();
        Object sharedObject = gc.getSharedObject();
        if (sharedObject == null) {
            gc.setSharedObject(this.shared);
            this.logger.info((Object)"Random exploration strategy is initied.");
            this.startThreads();
        } else {
            this.shared = (SharedData)sharedObject;
        }
        this.maxDepth = this.rnd.nextInt(this.shared.maxDepth - this.shared.minDepth) + this.shared.minDepth;
    }

    @Override
    public void explore() {
        do {
            boolean globalConstraintsAreSatisfied;
            if (!(globalConstraintsAreSatisfied = this.context.checkGlobalConstraints())) {
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Global contraint is not satisifed and cannot backtrack.");
                    break;
                }
                this.logger.debug((Object)"Global contraint is not satisifed, backtrack.");
                continue;
            }
            Fitness fitness = this.context.calculateFitness();
            if (fitness.isSatisifiesHardObjectives()) {
                this.context.newSolution();
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Found a solution but cannot backtrack.");
                    break;
                }
                this.logger.debug((Object)"Found a solution, backtrack.");
                continue;
            }
            if (this.trajectoryInfo.getDepth() < this.maxDepth) {
                Collection<Object> transitions = this.context.getCurrentActivationIds();
                int index = this.rnd.nextInt(transitions.size());
                Object transition = RandomSearchStrategy.getByIndex(transitions, index);
                this.context.executeAcitvationId(transition);
            } else {
                this.nth = this.shared.triesLeft.getAndDecrement();
                this.logger.debug((Object)(String.valueOf(this.nth) + " tries left"));
                if (this.nth <= 0) break;
                this.context.backtrackUntilRoot();
                this.maxDepth = this.rnd.nextInt(this.shared.maxDepth - this.shared.minDepth) + this.shared.minDepth;
            }
            boolean loopInTrajectory = this.context.isCurrentStateInTrajectory();
            if (!loopInTrajectory) continue;
            boolean isSuccessfulUndo = this.context.backtrack();
            if (!isSuccessfulUndo) {
                throw new DSEException("The new state is present in the trajectoy but cannot bactkrack. Should never happen!");
            }
            this.logger.info((Object)"The new state is already visited in the trajectory, backtrack.");
        } while (this.isInterrupted.get());
        this.logger.info((Object)"Terminated.");
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted.set(true);
    }

    private void startThreads() {
        this.context.startAllThreads(RandomSearchStrategy::new);
    }

    private static Object getByIndex(Collection<Object> availableTransitions, int index) {
        int i = 0;
        for (Object transition : availableTransitions) {
            if (i == index) {
                return transition;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("size: " + availableTransitions.size() + ", index: " + index);
    }

    private static class SharedData {
        public final AtomicInteger triesLeft;
        public final int minDepth;
        public final int maxDepth;

        public SharedData(int minDepth, int maxDepth, int numberOfTries) {
            this.minDepth = minDepth;
            this.maxDepth = maxDepth;
            this.triesLeft = new AtomicInteger(numberOfTries);
        }
    }
}

