/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api.strategy.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.Fitness;

public class DepthFirstStrategy
implements IStrategy {
    private int maxDepth;
    private AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private ThreadContext context;
    private Logger logger = Logger.getLogger(IStrategy.class);
    private Random random = new Random();
    private boolean backTrackIfSolution = true;

    public DepthFirstStrategy() {
        this.maxDepth = Integer.MAX_VALUE;
    }

    public DepthFirstStrategy(int maxDepth) {
        this.maxDepth = maxDepth < 0 ? Integer.MAX_VALUE : maxDepth;
    }

    public DepthFirstStrategy continueIfHardObjectivesFulfilled() {
        this.backTrackIfSolution = false;
        return this;
    }

    @Override
    public void initStrategy(ThreadContext context) {
        this.context = context;
        if (context.getSharedObject() == null) {
            context.setSharedObject(new Object());
            this.logger.info((Object)"Depth-first exploration strategy is initied.");
            this.startThreads();
        }
    }

    private void startThreads() {
        this.context.startAllThreads(() -> new DepthFirstStrategy(this.maxDepth));
    }

    @Override
    public void explore() {
        block0: while (true) {
            Collection<Object> activationIds;
            boolean globalConstraintsAreSatisfied;
            if (!(globalConstraintsAreSatisfied = this.context.checkGlobalConstraints())) {
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Global contraint is not satisifed and cannot backtrack.");
                    break;
                }
                this.logger.debug((Object)"Global contraint is not satisifed, backtrack.");
                continue;
            }
            Fitness fitness = this.context.calculateFitness();
            if (fitness.isSatisifiesHardObjectives()) {
                this.context.newSolution();
                if (this.backTrackIfSolution) {
                    boolean isSuccessfulUndo = this.context.backtrack();
                    if (!isSuccessfulUndo) {
                        this.logger.info((Object)"Found a solution but cannot backtrack.");
                        break;
                    }
                    this.logger.debug((Object)"Found a solution, backtrack.");
                    continue;
                }
            }
            if (this.context.getDepth() >= this.maxDepth) {
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"Reached max depth but cannot bactrack.");
                    break;
                }
                this.logger.debug((Object)"Reached max depth, bactrack.");
                continue;
            }
            if (this.isInterrupted.get()) {
                this.logger.info((Object)"Interrupted, stop exploration.");
                break;
            }
            Object activationId = null;
            do {
                if (!(activationIds = this.context.getUntraversedActivationIds()).isEmpty()) continue;
                boolean isSuccessfulUndo = this.context.backtrack();
                if (!isSuccessfulUndo) {
                    this.logger.info((Object)"No more transitions from current state and cannot backtrack.");
                    break block0;
                }
                this.logger.debug((Object)"No more transitions from current state, backtrack.");
            } while (activationIds.isEmpty());
            int index = this.random.nextInt(activationIds.size());
            Iterator<Object> iterator = activationIds.iterator();
            while (index-- > 0) {
                iterator.next();
            }
            activationId = iterator.next();
            this.context.executeAcitvationId(activationId);
            boolean loopInTrajectory = this.context.isCurrentStateInTrajectory();
            if (!loopInTrajectory) continue;
            boolean isSuccessfulUndo = this.context.backtrack();
            if (!isSuccessfulUndo) {
                throw new DSEException("The new state is present in the trajectoy but cannot bactkrack. Should never happen!");
            }
            this.logger.info((Object)"The new state is already visited in the trajectory, backtrack.");
        }
        this.logger.info((Object)"Terminated.");
    }

    @Override
    public void interruptStrategy() {
        this.isInterrupted.set(true);
    }
}

