/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.viatra.query.patternlanguage.emf.vql.*;

import org.eclipse.xtext.xtype.XImportSection;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage
 * @generated
 */
public class PatternLanguageAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static PatternLanguagePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PatternLanguageAdapterFactory()
	{
		if (modelPackage == null)
		{
			modelPackage = PatternLanguagePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object)
	{
		if (object == modelPackage)
		{
			return true;
		}
		if (object instanceof EObject)
		{
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PatternLanguageSwitch<Adapter> modelSwitch =
		new PatternLanguageSwitch<Adapter>()
		{
			@Override
			public Adapter caseVQLImportSection(VQLImportSection object)
			{
				return createVQLImportSectionAdapter();
			}
			@Override
			public Adapter casePackageImport(PackageImport object)
			{
				return createPackageImportAdapter();
			}
			@Override
			public Adapter casePatternImport(PatternImport object)
			{
				return createPatternImportAdapter();
			}
			@Override
			public Adapter caseEClassifierConstraint(EClassifierConstraint object)
			{
				return createEClassifierConstraintAdapter();
			}
			@Override
			public Adapter caseEnumValue(EnumValue object)
			{
				return createEnumValueAdapter();
			}
			@Override
			public Adapter casePatternModel(PatternModel object)
			{
				return createPatternModelAdapter();
			}
			@Override
			public Adapter caseClassType(ClassType object)
			{
				return createClassTypeAdapter();
			}
			@Override
			public Adapter caseReferenceType(ReferenceType object)
			{
				return createReferenceTypeAdapter();
			}
			@Override
			public Adapter casePattern(Pattern object)
			{
				return createPatternAdapter();
			}
			@Override
			public Adapter caseAnnotation(Annotation object)
			{
				return createAnnotationAdapter();
			}
			@Override
			public Adapter caseAnnotationParameter(AnnotationParameter object)
			{
				return createAnnotationParameterAdapter();
			}
			@Override
			public Adapter caseModifiers(Modifiers object)
			{
				return createModifiersAdapter();
			}
			@Override
			public Adapter caseExpression(Expression object)
			{
				return createExpressionAdapter();
			}
			@Override
			public Adapter caseVariable(Variable object)
			{
				return createVariableAdapter();
			}
			@Override
			public Adapter caseVariableReference(VariableReference object)
			{
				return createVariableReferenceAdapter();
			}
			@Override
			public Adapter caseType(Type object)
			{
				return createTypeAdapter();
			}
			@Override
			public Adapter caseEntityType(EntityType object)
			{
				return createEntityTypeAdapter();
			}
			@Override
			public Adapter casePatternBody(PatternBody object)
			{
				return createPatternBodyAdapter();
			}
			@Override
			public Adapter caseConstraint(Constraint object)
			{
				return createConstraintAdapter();
			}
			@Override
			public Adapter casePatternCall(PatternCall object)
			{
				return createPatternCallAdapter();
			}
			@Override
			public Adapter caseValueReference(ValueReference object)
			{
				return createValueReferenceAdapter();
			}
			@Override
			public Adapter caseLiteralValueReference(LiteralValueReference object)
			{
				return createLiteralValueReferenceAdapter();
			}
			@Override
			public Adapter caseComputationValue(ComputationValue object)
			{
				return createComputationValueAdapter();
			}
			@Override
			public Adapter caseParameterRef(ParameterRef object)
			{
				return createParameterRefAdapter();
			}
			@Override
			public Adapter caseParameter(Parameter object)
			{
				return createParameterAdapter();
			}
			@Override
			public Adapter caseLocalVariable(LocalVariable object)
			{
				return createLocalVariableAdapter();
			}
			@Override
			public Adapter caseJavaType(JavaType object)
			{
				return createJavaTypeAdapter();
			}
			@Override
			public Adapter caseRelationType(RelationType object)
			{
				return createRelationTypeAdapter();
			}
			@Override
			public Adapter caseTypeCheckConstraint(TypeCheckConstraint object)
			{
				return createTypeCheckConstraintAdapter();
			}
			@Override
			public Adapter casePatternCompositionConstraint(PatternCompositionConstraint object)
			{
				return createPatternCompositionConstraintAdapter();
			}
			@Override
			public Adapter caseCompareConstraint(CompareConstraint object)
			{
				return createCompareConstraintAdapter();
			}
			@Override
			public Adapter caseCheckConstraint(CheckConstraint object)
			{
				return createCheckConstraintAdapter();
			}
			@Override
			public Adapter casePathExpressionConstraint(PathExpressionConstraint object)
			{
				return createPathExpressionConstraintAdapter();
			}
			@Override
			public Adapter caseStringValue(StringValue object)
			{
				return createStringValueAdapter();
			}
			@Override
			public Adapter caseNumberValue(NumberValue object)
			{
				return createNumberValueAdapter();
			}
			@Override
			public Adapter caseBoolValue(BoolValue object)
			{
				return createBoolValueAdapter();
			}
			@Override
			public Adapter caseListValue(ListValue object)
			{
				return createListValueAdapter();
			}
			@Override
			public Adapter caseFunctionEvaluationValue(FunctionEvaluationValue object)
			{
				return createFunctionEvaluationValueAdapter();
			}
			@Override
			public Adapter caseAggregatedValue(AggregatedValue object)
			{
				return createAggregatedValueAdapter();
			}
			@Override
			public Adapter caseCallableRelation(CallableRelation object)
			{
				return createCallableRelationAdapter();
			}
			@Override
			public Adapter caseUnaryTypeConstraint(UnaryTypeConstraint object)
			{
				return createUnaryTypeConstraintAdapter();
			}
			@Override
			public Adapter caseXImportSection(XImportSection object)
			{
				return createXImportSectionAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object)
			{
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target)
	{
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection <em>VQL Import Section</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VQLImportSection
	 * @generated
	 */
	public Adapter createVQLImportSectionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport <em>Package Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport
	 * @generated
	 */
	public Adapter createPackageImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport <em>Pattern Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternImport
	 * @generated
	 */
	public Adapter createPatternImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint <em>EClassifier Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EClassifierConstraint
	 * @generated
	 */
	public Adapter createEClassifierConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue <em>Enum Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EnumValue
	 * @generated
	 */
	public Adapter createEnumValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel <em>Pattern Model</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel
	 * @generated
	 */
	public Adapter createPatternModelAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType <em>Class Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType
	 * @generated
	 */
	public Adapter createClassTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType <em>Reference Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType
	 * @generated
	 */
	public Adapter createReferenceTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern <em>Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern
	 * @generated
	 */
	public Adapter createPatternAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation
	 * @generated
	 */
	public Adapter createAnnotationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter <em>Annotation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter
	 * @generated
	 */
	public Adapter createAnnotationParameterAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers <em>Modifiers</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Modifiers
	 * @generated
	 */
	public Adapter createModifiersAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Expression
	 * @generated
	 */
	public Adapter createExpressionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Variable <em>Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Variable
	 * @generated
	 */
	public Adapter createVariableAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference <em>Variable Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference
	 * @generated
	 */
	public Adapter createVariableReferenceAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Type <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Type
	 * @generated
	 */
	public Adapter createTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.EntityType <em>Entity Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.EntityType
	 * @generated
	 */
	public Adapter createEntityTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody <em>Pattern Body</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternBody
	 * @generated
	 */
	public Adapter createPatternBodyAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Constraint <em>Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Constraint
	 * @generated
	 */
	public Adapter createConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall <em>Pattern Call</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall
	 * @generated
	 */
	public Adapter createPatternCallAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference <em>Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference
	 * @generated
	 */
	public Adapter createValueReferenceAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.LiteralValueReference <em>Literal Value Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.LiteralValueReference
	 * @generated
	 */
	public Adapter createLiteralValueReferenceAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ComputationValue <em>Computation Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ComputationValue
	 * @generated
	 */
	public Adapter createComputationValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef <em>Parameter Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ParameterRef
	 * @generated
	 */
	public Adapter createParameterRefAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.Parameter
	 * @generated
	 */
	public Adapter createParameterAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.LocalVariable <em>Local Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.LocalVariable
	 * @generated
	 */
	public Adapter createLocalVariableAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType <em>Java Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.JavaType
	 * @generated
	 */
	public Adapter createJavaTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.RelationType <em>Relation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.RelationType
	 * @generated
	 */
	public Adapter createRelationTypeAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint <em>Type Check Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.TypeCheckConstraint
	 * @generated
	 */
	public Adapter createTypeCheckConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint <em>Pattern Composition Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCompositionConstraint
	 * @generated
	 */
	public Adapter createPatternCompositionConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint <em>Compare Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CompareConstraint
	 * @generated
	 */
	public Adapter createCompareConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint <em>Check Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CheckConstraint
	 * @generated
	 */
	public Adapter createCheckConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint <em>Path Expression Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint
	 * @generated
	 */
	public Adapter createPathExpressionConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue <em>String Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue
	 * @generated
	 */
	public Adapter createStringValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue <em>Number Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.NumberValue
	 * @generated
	 */
	public Adapter createNumberValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue <em>Bool Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.BoolValue
	 * @generated
	 */
	public Adapter createBoolValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue <em>List Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue
	 * @generated
	 */
	public Adapter createListValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue <em>Function Evaluation Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.FunctionEvaluationValue
	 * @generated
	 */
	public Adapter createFunctionEvaluationValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue <em>Aggregated Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.AggregatedValue
	 * @generated
	 */
	public Adapter createAggregatedValueAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation <em>Callable Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.CallableRelation
	 * @generated
	 */
	public Adapter createCallableRelationAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint <em>Unary Type Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.UnaryTypeConstraint
	 * @generated
	 */
	public Adapter createUnaryTypeConstraintAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.xtext.xtype.XImportSection <em>XImport Section</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.xtext.xtype.XImportSection
	 * @generated
	 */
	public Adapter createXImportSectionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter()
	{
		return null;
	}

} //PatternLanguageAdapterFactory
