/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.euclidean;

import java.io.Serializable;
import org.eclipse.gef4.geometry.utils.PrecisionUtils;

public class Angle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double RAD_180 = Math.PI;
    private static final double RAD_360 = Math.PI * 2;
    private double rad = 0.0;

    public static Angle fromDeg(double degrees) {
        return new Angle(degrees * (Math.PI / 180));
    }

    public static Angle fromRad(double radians) {
        return new Angle(radians);
    }

    public Angle() {
    }

    public Angle(double rad) {
        this.setRad(rad);
    }

    public Angle clone() {
        return this.getCopy();
    }

    public double deg() {
        return this.rad * 57.29577951308232;
    }

    public boolean equals(Object otherObj) {
        if (otherObj != null && otherObj instanceof Angle) {
            Angle other = (Angle)otherObj;
            double myRad = this.rad;
            double otherRad = other.rad;
            if (myRad > 4.71238898038469 && otherRad < 1.5707963267948966) {
                otherRad += Math.PI * 2;
            } else if (myRad < 1.5707963267948966 && otherRad > 4.71238898038469) {
                myRad += Math.PI * 2;
            }
            return PrecisionUtils.equal(myRad, otherRad);
        }
        return false;
    }

    public Angle getAdded(Angle other) {
        return Angle.fromRad(this.rad + other.rad);
    }

    public Angle getCopy() {
        return Angle.fromRad(this.rad);
    }

    public Angle getMultiplied(double factor) {
        return Angle.fromRad(this.rad * factor);
    }

    public Angle getOppositeFull() {
        return Angle.fromRad(Math.PI * 2 - this.rad);
    }

    public Angle getOppositeSemi() {
        return Angle.fromRad(Math.PI - this.rad);
    }

    public int hashCode() {
        return 0;
    }

    private Angle normalize() {
        this.rad -= Math.PI * 2 * Math.floor(this.rad / (Math.PI * 2));
        return this;
    }

    public double rad() {
        return this.rad;
    }

    public Angle setDeg(double degrees) {
        this.rad = degrees * (Math.PI / 180);
        this.normalize();
        return this;
    }

    public Angle setRad(double radians) {
        this.rad = radians;
        this.normalize();
        return this;
    }

    public String toString() {
        return "Angle(" + Double.toString(this.rad) + "rad (" + Double.toString(this.deg()) + "deg))";
    }
}

