/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.algorithms.BarycentricCrossingReducer;
import org.eclipse.gef4.layout.algorithms.DFSLayerProvider;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.algorithms.SimpleLayerProvider;
import org.eclipse.gef4.layout.interfaces.CrossingReducer;
import org.eclipse.gef4.layout.interfaces.LayerProvider;
import org.eclipse.gef4.layout.interfaces.LayoutContext;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugiyamaLayoutAlgorithm
implements LayoutAlgorithm,
LayerProvider,
CrossingReducer {
    private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();
    private final Direction direction;
    private final Dimension dimension;
    private LayoutContext context;
    private int last;
    private LayerProvider layerProvider;
    private CrossingReducer crossingReducer;

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim, LayerProvider layering, CrossingReducer crossing) {
        this.direction = dir;
        this.dimension = dim;
        this.layerProvider = layering;
        this.crossingReducer = crossing;
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider, CrossingReducer crossing) {
        this(dir, null, layerProvider, crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider) {
        this(dir, null, layerProvider, new BarycentricCrossingReducer());
    }

    public SugiyamaLayoutAlgorithm(Direction dir, CrossingReducer crossing) {
        this(dir, null, new SimpleLayerProvider(), crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim) {
        this(dir, dim, new SimpleLayerProvider(), new BarycentricCrossingReducer());
    }

    public SugiyamaLayoutAlgorithm(Direction dir) {
        this(dir, null, new SimpleLayerProvider(), new BarycentricCrossingReducer());
    }

    public SugiyamaLayoutAlgorithm() {
        this(Direction.VERTICAL, null, new DFSLayerProvider(), new BarycentricCrossingReducer());
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.context;
    }

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.layers.clear();
        this.map.clear();
        ArrayList<NodeLayout> nodes = new ArrayList<NodeLayout>();
        ArrayList<NodeLayout> nodes2 = new ArrayList<NodeLayout>();
        NodeLayout[] nodeLayoutArray = this.context.getNodes();
        int n = nodeLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout nodeLayout = nodeLayoutArray[n2];
            nodes.add(nodeLayout);
            nodes2.add(nodeLayout);
            ++n2;
        }
        if (this.layerProvider != null) {
            this.clearAssignedNodes();
            this.addAssignedNode((NodeLayout)nodes.get(0), 0);
            this.addAssignedNode((NodeLayout)nodes.get(nodes.size() - 1), 0);
            this.layers = this.calculateLayers(nodes, this.getAssignedNodes());
        } else {
            ArrayList<NodeWrapper> arrayList = new ArrayList<NodeWrapper>();
            int i = 0;
            while (i < nodes.size()) {
                NodeWrapper nodeWrapper = new NodeWrapper((NodeLayout)nodes.get(i), 0);
                nodeWrapper.index = i++;
                arrayList.add(nodeWrapper);
            }
            this.layers.add(arrayList);
        }
        if (this.crossingReducer != null) {
            this.map = this.crossReduction(this.layers);
        }
        for (List<NodeWrapper> list : this.layers) {
            if (list.size() > this.last) {
                this.last = list.size();
            }
            for (NodeWrapper nodeWrapper : list) {
                this.map.put(nodeWrapper.node, nodeWrapper);
            }
        }
        this.calculatePositions();
    }

    private void calculatePositions() {
        Rectangle boundary = this.context.getBounds();
        if (this.dimension != null) {
            boundary = new Rectangle(0.0, 0.0, this.dimension.getWidth(), this.dimension.getHeight());
        }
        double dx = boundary.getWidth() / (double)this.layers.size();
        double dy = boundary.getHeight() / (double)(this.last + 1);
        if (this.direction == Direction.HORIZONTAL) {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node = nodeLayoutArray[n2];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.layer + 0.5) * dx, ((double)nw.index + 0.5) * dy);
                ++n2;
            }
        } else {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n3 = 0;
            while (n3 < n) {
                NodeLayout node = nodeLayoutArray[n3];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.index + 0.5) * dx, ((double)nw.layer + 0.5) * dy);
                ++n3;
            }
        }
    }

    @Override
    public Map<NodeLayout, NodeWrapper> crossReduction(List<List<NodeWrapper>> nodes) {
        if (this.crossingReducer != null) {
            return this.crossingReducer.crossReduction(nodes);
        }
        return null;
    }

    @Override
    public Map<NodeLayout, Integer> getAssignedNodes() {
        if (this.layerProvider != null) {
            return this.layerProvider.getAssignedNodes();
        }
        return null;
    }

    @Override
    public void addAssignedNode(NodeLayout node, int layer) {
        if (this.layerProvider != null) {
            this.layerProvider.addAssignedNode(node, layer);
        }
    }

    @Override
    public void clearAssignedNodes() {
        if (this.layerProvider != null) {
            this.layerProvider.clearAssignedNodes();
        }
    }

    @Override
    public List<List<NodeWrapper>> calculateLayers(List<NodeLayout> nodes, Map<NodeLayout, Integer> assignedNodes) {
        if (this.layerProvider != null) {
            return this.layerProvider.calculateLayers(nodes, assignedNodes);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

