/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Straight;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.AbstractMultiShape;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IMultiShape;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;

public class Ring
extends AbstractMultiShape
implements ITranslatable<Ring>,
IScalable<Ring>,
IRotatable<Ring> {
    private static final long serialVersionUID = 1L;
    private ArrayList<Polygon> triangles = new ArrayList();

    private static Polygon[] triangulate(Polygon p, Line l) {
        boolean intersecting;
        if (p == null) {
            throw new IllegalArgumentException("The given Polygon parameter may not be null.");
        }
        if (l == null) {
            throw new IllegalArgumentException("The given Line parameter may not be null.");
        }
        boolean bl = intersecting = l.getIntersections(p.getOutline()).length == 2;
        if (!intersecting) {
            Point[] pointArray = l.getPoints();
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point lp = pointArray[n2];
                if (p.contains(lp) && !p.getOutline().contains(lp)) {
                    intersecting = true;
                    break;
                }
                ++n2;
            }
            if (!intersecting) {
                return new Polygon[]{p.getCopy()};
            }
        }
        Straight s = new Straight(l);
        Point[] inters = new Point[2];
        int i = 0;
        Line[] lineArray = p.getOutlineSegments();
        int n = lineArray.length;
        int n3 = 0;
        while (n3 < n) {
            block12: {
                block11: {
                    Point poi;
                    Line e = lineArray[n3];
                    Vector vi = s.getIntersection(new Straight(e));
                    if (vi == null || !e.contains(poi = vi.toPoint())) break block11;
                    if (i > 0 && inters[0].equals(poi)) break block12;
                    inters[i++] = poi;
                }
                if (i > 1) break;
            }
            ++n3;
        }
        if (inters[0] == null || inters[1] == null) {
            throw new IllegalStateException("The determined points of intersection do not lie on the polygon. Call: triangulate(" + p + ", " + l + ")");
        }
        return Ring.triangulate(p, inters[0], inters[1]);
    }

    private static Polygon[] triangulate(Polygon p, Point p1, Point p2) {
        Point[] v;
        Point[] pointArray = v = p == null ? new Point[]{} : p.getPoints();
        if (v.length != 3) {
            throw new IllegalArgumentException("Only triangles are allowed as the Polygon parameter.");
        }
        if (p1 == null) {
            throw new IllegalArgumentException("The given p1 Point parameter may not be null.");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("The given p2 Point parameter may not be null.");
        }
        Line[] e = new Line[]{new Line(v[0], v[1]), new Line(v[1], v[2]), new Line(v[2], v[0])};
        boolean p1_on_e0 = e[0].contains(p1);
        boolean p1_on_e1 = e[1].contains(p1);
        boolean p1_on_e2 = e[2].contains(p1);
        boolean p2_on_e0 = e[0].contains(p2);
        boolean p2_on_e1 = e[1].contains(p2);
        boolean p2_on_e2 = e[2].contains(p2);
        if (p1_on_e0 && p2_on_e0 || p1_on_e1 && p2_on_e1 || p1_on_e2 && p2_on_e2) {
            return new Polygon[]{p.getCopy()};
        }
        if (!p1_on_e0 && !p1_on_e1 && !p1_on_e2 || !p2_on_e0 && !p2_on_e1 && !p2_on_e2) {
            throw new IllegalArgumentException("The Point objects have to lie on the outline of the Polygon object.");
        }
        if (p1.equals(v[0])) {
            return new Polygon[]{new Polygon(v[0], v[1], p2), new Polygon(v[0], v[2], p2)};
        }
        if (p1.equals(v[1])) {
            return new Polygon[]{new Polygon(v[0], v[1], p2), new Polygon(v[1], v[2], p2)};
        }
        if (p1.equals(v[2])) {
            return new Polygon[]{new Polygon(v[0], v[2], p2), new Polygon(v[1], v[2], p2)};
        }
        if (p2.equals(v[0])) {
            return new Polygon[]{new Polygon(v[0], v[1], p1), new Polygon(v[0], v[2], p1)};
        }
        if (p2.equals(v[1])) {
            return new Polygon[]{new Polygon(v[0], v[1], p1), new Polygon(v[1], v[2], p1)};
        }
        if (p2.equals(v[2])) {
            return new Polygon[]{new Polygon(v[0], v[2], p1), new Polygon(v[1], v[2], p1)};
        }
        if (p1_on_e0 && p2_on_e2 || p1_on_e2 && p2_on_e0) {
            return new Polygon[]{new Polygon(v[0], p1, p2), new Polygon(p1, p2, v[1]), new Polygon(p1_on_e0 ? p2 : p1, v[1], v[2])};
        }
        if (p1_on_e0 && p2_on_e1 || p1_on_e1 && p2_on_e0) {
            return new Polygon[]{new Polygon(v[1], p1, p2), new Polygon(p1, p2, v[0]), new Polygon(p1_on_e0 ? p2 : p1, v[0], v[2])};
        }
        if (p1_on_e1 && p2_on_e2 || p1_on_e2 && p2_on_e1) {
            return new Polygon[]{new Polygon(v[2], p1, p2), new Polygon(p1, p2, v[1]), new Polygon(p1_on_e1 ? p2 : p1, v[1], v[0])};
        }
        throw new IllegalStateException("Unreachable, because for two points on a triangle, they have to be located either (edge, edge), (vertex, edge), or (edge, vertex).");
    }

    public Ring() {
    }

    public Ring(Polygon ... polygons) {
        this();
        Polygon[] polygonArray = polygons;
        int n = polygons.length;
        int n2 = 0;
        while (n2 < n) {
            Polygon p = polygonArray[n2];
            this.add(p);
            ++n2;
        }
    }

    public Ring(Ring other) {
        this();
        for (Polygon p : other.triangles) {
            this.add(p);
        }
    }

    public Ring add(Polygon p) {
        Polygon triangleToAdd;
        Stack<Polygon> toAdd = new Stack<Polygon>();
        Polygon[] polygonArray = p.getTriangulation();
        int n = polygonArray.length;
        int n2 = 0;
        while (n2 < n) {
            triangleToAdd = polygonArray[n2];
            if (triangleToAdd.getArea() != 0.0) {
                toAdd.push(triangleToAdd);
            }
            ++n2;
        }
        while (!toAdd.empty()) {
            triangleToAdd = (Polygon)toAdd.pop();
            Stack<Polygon> localAddends = new Stack<Polygon>();
            localAddends.push(triangleToAdd);
            for (Polygon triangleAlreadyThere : this.triangles) {
                Line[] lineArray = triangleAlreadyThere.getOutlineSegments();
                int n3 = lineArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Line e = lineArray[n4];
                    Stack<Polygon> nextAddends = new Stack<Polygon>();
                    Iterator i = localAddends.iterator();
                    while (i.hasNext()) {
                        Polygon addend = (Polygon)i.next();
                        i.remove();
                        Polygon[] polygonArray2 = Ring.triangulate(addend, e);
                        int n5 = polygonArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Polygon subTriangleToAdd = polygonArray2[n6];
                            if (!triangleAlreadyThere.contains(subTriangleToAdd)) {
                                nextAddends.push(subTriangleToAdd);
                            }
                            ++n6;
                        }
                    }
                    localAddends = nextAddends;
                    ++n4;
                }
            }
            for (Polygon addend : localAddends) {
                this.triangles.add(addend);
            }
        }
        this.optimizeTriangles();
        return this;
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IMultiShape)this, g);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ring) {
            Ring o = (Ring)obj;
            return this.contains(o) && o.contains(this);
        }
        return false;
    }

    private boolean findSharedAndOuterVertices(Polygon t1, Polygon t2, Point[] shared, Point[] outer) {
        Point[] t1Points = t1.getPoints();
        Point[] t2Points = t2.getPoints();
        boolean[] t1IsShared = new boolean[3];
        boolean[] t2IsShared = new boolean[3];
        int sc = 0;
        int i = 0;
        while (i < t1Points.length) {
            int j = 0;
            while (j < t2Points.length) {
                if (t1Points[i].equals(t2Points[j])) {
                    if (sc++ == 2) {
                        return false;
                    }
                    t1IsShared[i] = true;
                    t2IsShared[j] = true;
                }
                ++j;
            }
            ++i;
        }
        if (sc != 2) {
            return false;
        }
        i = 0;
        int c = 0;
        while (i < t1Points.length) {
            if (t1IsShared[i]) {
                shared[c++] = t1Points[i];
            } else {
                outer[0] = t1Points[i];
            }
            if (!t2IsShared[i]) {
                outer[1] = t2Points[i];
            }
            ++i;
        }
        return true;
    }

    @Override
    protected Line[] getAllEdges() {
        Stack<Line> edges = new Stack<Line>();
        for (Polygon t : this.triangles) {
            Line[] lineArray = t.getOutlineSegments();
            int n = lineArray.length;
            int n2 = 0;
            while (n2 < n) {
                Line e = lineArray[n2];
                edges.push(e);
                ++n2;
            }
        }
        return edges.toArray(new Line[0]);
    }

    @Override
    public Rectangle getBounds() {
        if (this.triangles.size() == 0) {
            return null;
        }
        Rectangle bounds = this.triangles.get(0).getBounds();
        int i = 1;
        while (i < this.triangles.size()) {
            bounds.union(this.triangles.get(i).getBounds());
            ++i;
        }
        return bounds;
    }

    @Override
    public Ring getCopy() {
        return new Ring(this);
    }

    @Override
    public Ring getRotatedCCW(Angle angle) {
        return this.getCopy().rotateCCW(angle);
    }

    @Override
    public Ring getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCCW(angle, cx, cy);
    }

    @Override
    public Ring getRotatedCCW(Angle angle, Point center) {
        return this.getCopy().rotateCCW(angle, center);
    }

    @Override
    public Ring getRotatedCW(Angle angle) {
        return this.getCopy().rotateCW(angle);
    }

    @Override
    public Ring getRotatedCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCW(angle, cx, cy);
    }

    @Override
    public Ring getRotatedCW(Angle angle, Point center) {
        return this.getCopy().rotateCW(angle, center);
    }

    @Override
    public Ring getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    @Override
    public Ring getScaled(double fx, double fy) {
        return this.getCopy().scale(fx, fy);
    }

    @Override
    public Ring getScaled(double factor, double cx, double cy) {
        return this.getCopy().scale(factor, cx, cy);
    }

    @Override
    public Ring getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().scale(fx, fy, cx, cy);
    }

    @Override
    public Ring getScaled(double fx, double fy, Point center) {
        return this.getCopy().scale(fx, fy, center);
    }

    @Override
    public Ring getScaled(double factor, Point center) {
        return this.getCopy().scale(factor, center);
    }

    public Polygon[] getShapes() {
        return this.triangles.toArray(new Polygon[0]);
    }

    @Override
    public Ring getTransformed(AffineTransform t) {
        ArrayList<Polygon> transformedTriangles = new ArrayList<Polygon>();
        for (Polygon p : this.triangles) {
            transformedTriangles.add(p.getTransformed(t));
        }
        return new Ring(transformedTriangles.toArray(new Polygon[0]));
    }

    @Override
    public Ring getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public Ring getTranslated(Point d) {
        return this.getCopy().translate(d.x, d.y);
    }

    private Polygon mergeTriangles(Polygon t1, Polygon t2) {
        Point[] shared = new Point[2];
        Point[] outer = new Point[2];
        boolean found = this.findSharedAndOuterVertices(t1, t2, shared, outer);
        if (found) {
            Line outerLink = new Line(outer[0], outer[1]);
            if (outerLink.contains(shared[0])) {
                return new Polygon(outer[0], outer[1], shared[1]);
            }
            if (outerLink.contains(shared[1])) {
                return new Polygon(outer[0], outer[1], shared[0]);
            }
        }
        return null;
    }

    private void optimizeTriangles() {
        int i = 0;
        while (i < this.triangles.size()) {
            Polygon t1 = this.triangles.get(i);
            int j = i + 1;
            while (j < this.triangles.size()) {
                Polygon t2 = this.triangles.get(j);
                Polygon merge = this.mergeTriangles(t1, t2);
                if (merge != null) {
                    this.triangles.set(i, merge);
                    t1 = merge;
                    this.triangles.remove(j);
                    j = i;
                }
                ++j;
            }
            ++i;
        }
    }

    public Ring rotateCCW(Angle angle) {
        Point centroid = this.getBounds().getCenter();
        return this.rotateCCW(angle, centroid.x, centroid.y);
    }

    public Ring rotateCCW(Angle angle, double cx, double cy) {
        for (Polygon p : this.triangles) {
            p.rotateCCW(angle, cx, cy);
        }
        return this;
    }

    public Ring rotateCCW(Angle angle, Point center) {
        return this.rotateCCW(angle, center.x, center.y);
    }

    public Ring rotateCW(Angle angle) {
        Point centroid = this.getBounds().getCenter();
        return this.rotateCW(angle, centroid.x, centroid.y);
    }

    public Ring rotateCW(Angle angle, double cx, double cy) {
        for (Polygon p : this.triangles) {
            p.rotateCW(angle, cx, cy);
        }
        return this;
    }

    public Ring rotateCW(Angle angle, Point center) {
        return this.rotateCW(angle, center.x, center.y);
    }

    @Override
    public Ring scale(double factor) {
        return this.scale(factor, factor);
    }

    @Override
    public Ring scale(double fx, double fy) {
        Point center = this.getBounds().getCenter();
        return this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public Ring scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public Ring scale(double fx, double fy, double cx, double cy) {
        for (Polygon p : this.triangles) {
            p.scale(fx, fy, cx, cy);
        }
        return this;
    }

    @Override
    public Ring scale(double fx, double fy, Point center) {
        return this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public Ring scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    @Override
    public Ring translate(double dx, double dy) {
        for (Polygon p : this.triangles) {
            p.translate(dx, dy);
        }
        return this;
    }

    @Override
    public Ring translate(Point d) {
        return this.translate(d.x, d.y);
    }
}

