/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

abstract class AbstractRectangleBasedGeometry<T extends AbstractRectangleBasedGeometry<?, ?>, S extends IGeometry>
extends AbstractGeometry
implements ITranslatable<T>,
IScalable<T>,
IRotatable<S> {
    private static final long serialVersionUID = 1L;
    double x;
    double y;
    double width;
    double height;

    public T expand(double h, double v) {
        this.x -= h;
        this.width += h + h;
        this.y -= v;
        this.height += v + v;
        return (T)this;
    }

    public T expand(double left, double top, double right, double bottom) {
        this.x -= left;
        this.y -= top;
        this.width += left + right;
        this.height += top + bottom;
        return (T)this;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public T getExpanded(double h, double v) {
        return ((AbstractRectangleBasedGeometry)this.getCopy()).expand(h, v);
    }

    public T getExpanded(double left, double top, double right, double bottom) {
        return ((AbstractRectangleBasedGeometry)this.getCopy()).expand(left, top, right, bottom);
    }

    public final double getHeight() {
        return this.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    @Override
    public T getScaled(double factor) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factor);
    }

    @Override
    public T getScaled(double factorX, double factorY) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factorX, factorY);
    }

    @Override
    public T getScaled(double factor, double centerX, double centerY) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factor, centerX, centerY);
    }

    @Override
    public T getScaled(double factorX, double factorY, double centerX, double centerY) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factorX, factorY, centerX, centerY);
    }

    @Override
    public T getScaled(double factorX, double factorY, Point center) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factorX, factorY, center);
    }

    @Override
    public T getScaled(double factor, Point center) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).scale(factor, center);
    }

    public T getShrinked(double h, double v) {
        return ((AbstractRectangleBasedGeometry)this.getCopy()).shrink(h, v);
    }

    public T getShrinked(double left, double top, double right, double bottom) {
        return ((AbstractRectangleBasedGeometry)this.getCopy()).shrink(left, top, right, bottom);
    }

    public final Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public T getTranslated(double dx, double dy) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).translate(dx, dy);
    }

    @Override
    public T getTranslated(Point pt) {
        return (T)((AbstractRectangleBasedGeometry)this.getCopy()).translate(pt);
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @Override
    public T scale(double factor) {
        return (T)this.scale(factor, factor);
    }

    @Override
    public T scale(double fx, double fy) {
        return (T)this.scale(fx, fy, this.getCenter());
    }

    @Override
    public T scale(double factor, double cx, double cy) {
        return (T)this.scale(factor, factor, cx, cy);
    }

    @Override
    public T scale(double fx, double fy, double cx, double cy) {
        this.x = (this.x - cx) * fx + cx;
        this.y = (this.y - cy) * fy + cy;
        this.width *= fx;
        this.height *= fy;
        return (T)this;
    }

    @Override
    public T scale(double fx, double fy, Point center) {
        return (T)this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public T scale(double factor, Point center) {
        return (T)this.scale(factor, center.x, center.y);
    }

    public final T setBounds(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        return (T)this;
    }

    public final T setBounds(Point loc, Dimension size) {
        this.setBounds(loc.x, loc.y, size.width, size.height);
        return (T)this;
    }

    public final T setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
        return (T)this;
    }

    public final T setHeight(double height) {
        if (height < 0.0) {
            height = 0.0;
        }
        this.height = height;
        return (T)this;
    }

    public final T setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        return (T)this;
    }

    public final T setLocation(Point p) {
        this.setLocation(p.x, p.y);
        return (T)this;
    }

    public final T setSize(Dimension d) {
        this.setSize(d.width, d.height);
        return (T)this;
    }

    public final T setSize(double w, double h) {
        if (w < 0.0) {
            w = 0.0;
        }
        if (h < 0.0) {
            h = 0.0;
        }
        this.width = w;
        this.height = h;
        return (T)this;
    }

    public final T setWidth(double width) {
        if (width < 0.0) {
            width = 0.0;
        }
        this.width = width;
        return (T)this;
    }

    public final T setX(double x) {
        this.x = x;
        return (T)this;
    }

    public final T setY(double y) {
        this.y = y;
        return (T)this;
    }

    public T shrink(double h, double v) {
        this.x += h;
        this.width -= h + h;
        this.y += v;
        this.height -= v + v;
        return (T)this;
    }

    public T shrink(double left, double top, double right, double bottom) {
        this.x += left;
        this.y += top;
        this.width -= left + right;
        this.height -= top + bottom;
        return (T)this;
    }

    @Override
    public T translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return (T)this;
    }

    @Override
    public T translate(Point p) {
        return (T)this.translate(p.x, p.y);
    }
}

