/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.AbstractDebugListSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationComparator;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class RunDebugPropertiesPage
extends PropertyPage {
    private final Set<ILaunchConfigurationWorkingCopy> fDeletedConfigurations = new HashSet<ILaunchConfigurationWorkingCopy>();
    private Set<ILaunchConfiguration> fOriginalCandidates;
    private Set<ILaunchConfigurationWorkingCopy> fChangedConfigurations = new HashSet<ILaunchConfigurationWorkingCopy>();
    private List<ILaunchConfigurationType> fTypeCandidates = null;
    private TableViewer fViewer;
    private Button fNewButton = null;
    private Button fEditButton = null;
    private Button fDuplicateButton = null;
    private Button fDeleteButton = null;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.run_debug_resource_property_page");
        this.collectConfigCandidates(this.getResource());
        Composite topComposite = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createWrapLabel(topComposite, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_0, 2, 300);
        SWTFactory.createVerticalSpacer(topComposite, 2);
        SWTFactory.createWrapLabel(topComposite, MessageFormat.format(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_1, this.getResource().getName()), 2, 300);
        this.fViewer = this.createViewer(topComposite);
        Composite buttonComp = SWTFactory.createComposite(topComposite, 1, 1, 1040);
        GridLayout layout = (GridLayout)buttonComp.getLayout();
        layout.marginHeight = 0;
        this.fNewButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_2, null);
        this.fNewButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_3);
        this.fNewButton.setEnabled(this.collectTypeCandidates().length > 0);
        this.fNewButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleNew();
            }
        });
        this.fDuplicateButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_4, null);
        this.fDuplicateButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_5);
        this.fDuplicateButton.setEnabled(false);
        this.fDuplicateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleCopy();
            }
        });
        this.fEditButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_6, null);
        this.fEditButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_7);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleEdit();
            }
        });
        this.fDeleteButton = SWTFactory.createPushButton(buttonComp, DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_8, null);
        this.fDeleteButton.setToolTipText(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_9);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunDebugPropertiesPage.this.handleDelete();
            }
        });
        this.fViewer.setSelection((ISelection)new StructuredSelection());
        this.applyDialogFont(topComposite);
        return topComposite;
    }

    protected TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        viewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setComparator((ViewerComparator)new LaunchConfigurationComparator());
        Table builderTable = viewer.getTable();
        GridData tableGridData = new GridData(1808);
        tableGridData.heightHint = 300;
        tableGridData.widthHint = 300;
        builderTable.setLayoutData((Object)tableGridData);
        IResource resource = this.getResource();
        viewer.setInput(this.collectConfigCandidates(resource));
        viewer.addSelectionChangedListener(event -> {
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)sel;
                boolean empty = ss.isEmpty();
                int size = ss.size();
                this.fEditButton.setEnabled(!empty && size == 1);
                this.fDuplicateButton.setEnabled(!empty && size == 1);
                this.fDeleteButton.setEnabled(!empty);
                this.setErrorMessage(null);
            }
        });
        viewer.addDoubleClickListener(arg0 -> this.handleEdit());
        return viewer;
    }

    public void dispose() {
        if (this.fOriginalCandidates != null) {
            this.fOriginalCandidates.clear();
            this.fOriginalCandidates = null;
        }
        if (this.fChangedConfigurations != null) {
            this.fChangedConfigurations.clear();
            this.fChangedConfigurations = null;
        }
        super.dispose();
    }

    protected TableViewer getViewer() {
        return this.fViewer;
    }

    protected LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfigurationType[] collectTypeCandidates() {
        if (this.fTypeCandidates == null) {
            String[] types = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableConfigurationTypes(this.getResource());
            this.fTypeCandidates = new ArrayList<ILaunchConfigurationType>(types.length);
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this.fTypeCandidates.add(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(type));
                ++n2;
            }
            Collections.sort(this.fTypeCandidates, (o1, o2) -> {
                ILaunchConfigurationType t1 = o1;
                ILaunchConfigurationType t2 = o2;
                return t1.getName().compareTo(t2.getName());
            });
        }
        return this.fTypeCandidates.toArray(new ILaunchConfigurationType[this.fTypeCandidates.size()]);
    }

    protected Set<ILaunchConfiguration> collectConfigCandidates(IResource resource) {
        if (this.fOriginalCandidates == null) {
            this.fOriginalCandidates = new HashSet<ILaunchConfiguration>();
            try {
                ILaunchConfiguration[] configs;
                ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getApplicableLaunchConfigurations(null, resource);
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    this.fOriginalCandidates.add((ILaunchConfiguration)config.getWorkingCopy());
                    ++n2;
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return this.fOriginalCandidates;
    }

    protected IResource getResource() {
        IAdaptable element = this.getElement();
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element != null) {
            resource = (IResource)Adapters.adapt((Object)element, IResource.class);
        }
        if (resource == null && element != null) {
            return (IResource)Adapters.adapt((Object)element, IProject.class);
        }
        return resource;
    }

    public boolean performOk() {
        for (ILaunchConfigurationWorkingCopy currentConfig : this.fDeletedConfigurations) {
            try {
                if (currentConfig.getOriginal() == null) continue;
                currentConfig.getOriginal().delete();
            }
            catch (CoreException e) {
                DebugPlugin.logMessage((String)("Problem deleting configuration " + currentConfig.getName()), (Throwable)e);
            }
        }
        for (ILaunchConfigurationWorkingCopy currentConfig : this.fChangedConfigurations) {
            try {
                currentConfig.doSave();
            }
            catch (CoreException e) {
                DebugPlugin.logMessage((String)("Problem saving changes to configuration " + currentConfig.getName()), (Throwable)e);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.setErrorMessage(null);
        this.setValid(true);
        this.fOriginalCandidates.clear();
        this.fOriginalCandidates = null;
        this.getViewer().setInput(this.collectConfigCandidates(this.getResource()));
        this.fChangedConfigurations.clear();
        this.fDeletedConfigurations.clear();
        this.fViewer.refresh(true, true);
        super.performDefaults();
    }

    private Set<String> getConfigurationNames() {
        HashSet<String> names = new HashSet<String>();
        for (ILaunchConfiguration iLaunchConfiguration : this.fOriginalCandidates) {
            names.add(iLaunchConfiguration.getName());
        }
        for (ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy : this.fChangedConfigurations) {
            names.add(iLaunchConfigurationWorkingCopy.getName());
        }
        return names;
    }

    private ILaunchConfigurationWorkingCopy[] getSelectedConfigurations() {
        IStructuredSelection ss = this.fViewer.getStructuredSelection();
        return ss.toList().toArray(new ILaunchConfigurationWorkingCopy[ss.size()]);
    }

    private void handleCopy() {
        ILaunchConfigurationWorkingCopy configuration = this.getSelectedConfigurations()[0];
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).generateUniqueLaunchConfigurationNameFrom(configuration.getName(), this.getConfigurationNames()));
            copy.setAttributes(configuration.getAttributes());
            this.fChangedConfigurations.add(copy);
            this.fViewer.add((Object)copy);
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)copy));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void handleDelete() {
        ILaunchConfigurationWorkingCopy[] configurations;
        Table table = this.fViewer.getTable();
        int[] indices = table.getSelectionIndices();
        Arrays.sort(indices);
        ILaunchConfigurationWorkingCopy[] iLaunchConfigurationWorkingCopyArray = configurations = this.getSelectedConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationWorkingCopy configuration = iLaunchConfigurationWorkingCopyArray[n2];
            this.fDeletedConfigurations.add(configuration);
            this.fChangedConfigurations.remove(configuration);
            this.fViewer.remove((Object)configuration);
            ++n2;
        }
        if (indices[0] < table.getItemCount()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(indices[0]).getData()));
        } else if (table.getItemCount() > 0) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(table.getItemCount() - 1).getData()));
        }
    }

    private void handleEdit() {
        ILaunchConfigurationWorkingCopy config = this.getSelectedConfigurations()[0];
        int ret = this.edit(config, false);
        if (ret == 0) {
            this.fChangedConfigurations.add(config);
            this.fViewer.refresh((Object)config, true, true);
        } else if (ret == 7) {
            this.setErrorMessage(MessageFormat.format(DebugPreferencesMessages.RunDebugPropertiesPage_0, config.getName()));
        }
    }

    private int edit(ILaunchConfigurationWorkingCopy configuration, boolean setDefaults) {
        try {
            LaunchConfigurationManager lcm = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
            ILaunchGroup group = null;
            ILaunchConfigurationType type = configuration.getType();
            if (type.supportsMode("run")) {
                group = lcm.getLaunchGroup(type, "run");
            } else if (type.supportsMode("debug")) {
                group = lcm.getLaunchGroup(type, "debug");
            } else if (type.supportsMode("profile")) {
                group = lcm.getLaunchGroup(type, "profile");
            } else {
                for (Set modes : type.getSupportedModeCombinations()) {
                    group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(type, modes);
                    if (group != null) break;
                }
            }
            if (group != null) {
                return DebugUIPlugin.openLaunchConfigurationPropertiesDialog(this.getShell(), (ILaunchConfiguration)configuration, group.getIdentifier(), this.getConfigurationNames(), null, setDefaults);
            }
        }
        catch (CoreException coreException) {}
        return 7;
    }

    private void handleNew() {
        Object[] result;
        final ILaunchConfigurationType[] typeCandidates = this.collectTypeCandidates();
        AbstractDebugListSelectionDialog dialog = new AbstractDebugListSelectionDialog(this.getShell()){

            @Override
            protected String getDialogSettingsId() {
                return DebugUIPlugin.getUniqueIdentifier() + ".SELECT_CONFIGURATION_TYPE_DIALOG";
            }

            @Override
            protected Object getViewerInput() {
                return typeCandidates;
            }

            @Override
            protected String getHelpContextId() {
                return "org.eclipse.debug.ui.select_configuration_type_dialog";
            }

            @Override
            protected String getViewerLabel() {
                return DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_12;
            }
        };
        dialog.setTitle(DebugPreferencesMessages.DefaultLaunchConfigurationsPropertiesPage_11);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            ILaunchConfigurationType type = (ILaunchConfigurationType)result[0];
            try {
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).generateUniqueLaunchConfigurationNameFrom("New_configuration", this.getConfigurationNames()));
                int ret = this.edit(wc, true);
                if (ret == 0) {
                    this.fChangedConfigurations.add(wc);
                    this.fViewer.add((Object)wc);
                    this.fViewer.setSelection((ISelection)new StructuredSelection((Object)wc));
                } else if (ret == 7) {
                    this.setErrorMessage(MessageFormat.format(DebugPreferencesMessages.RunDebugPropertiesPage_0, wc.getName()));
                }
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
    }
}

