/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CompositeChange
extends Change {
    private String fName;
    private List<Change> fChanges;
    private boolean fIsSynthetic;
    private Change fUndoUntilException;

    public CompositeChange(String name) {
        this(name, new ArrayList<Change>(2));
    }

    public CompositeChange(String name, Change[] children) {
        this(name, new ArrayList<Change>(children.length));
        this.addAll(children);
    }

    private CompositeChange(String name, List<Change> changes) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull(changes);
        this.fName = name;
        this.fChanges = changes;
    }

    public boolean isSynthetic() {
        return this.fIsSynthetic;
    }

    public void markAsSynthetic() {
        this.fIsSynthetic = true;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void add(Change change) {
        if (change != null) {
            Assert.isTrue((change.getParent() == null ? 1 : 0) != 0);
            this.fChanges.add(change);
            change.setParent(this);
        }
    }

    public void addAll(Change[] changes) {
        Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            this.add(change);
            ++n2;
        }
    }

    public void merge(CompositeChange change) {
        Change[] others;
        Change[] changeArray = others = change.getChildren();
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            Change other = changeArray[n2];
            change.remove(other);
            this.add(other);
            ++n2;
        }
    }

    public boolean remove(Change change) {
        Assert.isNotNull((Object)change);
        boolean result = this.fChanges.remove(change);
        if (result) {
            change.setParent(null);
        }
        return result;
    }

    public Change[] clear() {
        Change[] result = this.fChanges.toArray(new Change[this.fChanges.size()]);
        this.fChanges.clear();
        return result;
    }

    public Change[] getChildren() {
        return this.fChanges.toArray(new Change[this.fChanges.size()]);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Change change : this.fChanges) {
            change.setEnabled(enabled);
        }
    }

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
        pm.beginTask("", this.fChanges.size());
        for (Change change : this.fChanges) {
            change.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.worked(1);
        }
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", this.fChanges.size());
        Iterator<Change> iter = this.fChanges.iterator();
        while (iter.hasNext() && !result.hasFatalError()) {
            Change change = iter.next();
            if (change.isEnabled()) {
                result.merge(change.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
        return result;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        this.fUndoUntilException = null;
        ArrayList<Change> undos = new ArrayList<Change>(this.fChanges.size());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (String)RefactoringCoreMessages.CompositeChange_performingChangesTask_name, (int)this.fChanges.size());
        Change change = null;
        boolean canceled = false;
        try {
            Iterator<Change> iter = this.fChanges.iterator();
            while (iter.hasNext()) {
                change = iter.next();
                if (canceled && !this.internalProcessOnCancel(change)) continue;
                if (change.isEnabled()) {
                    Change undoChange = null;
                    try {
                        undoChange = change.perform((IProgressMonitor)sm.split(1));
                    }
                    catch (OperationCanceledException e) {
                        canceled = true;
                        if (!this.internalContinueOnCancel()) {
                            throw e;
                        }
                        undos = null;
                    }
                    if (undos != null) {
                        if (undoChange == null) {
                            undos = null;
                        } else {
                            undos.add(undoChange);
                        }
                    }
                }
                iter.remove();
                final Change changeToDispose = change;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        changeToDispose.dispose();
                    }

                    public void handleException(Throwable exception) {
                        RefactoringCorePlugin.log(exception);
                    }
                });
            }
            if (canceled) {
                throw new OperationCanceledException();
            }
            if (undos != null) {
                Collections.reverse(undos);
                Change change2 = this.createUndoChange(undos.toArray(new Change[undos.size()]));
                return change2;
            }
            return null;
        }
        catch (RuntimeException | CoreException e) {
            this.handleUndos(change, undos);
            this.internalHandleException(change, e);
            throw e;
        }
        finally {
            pm.done();
        }
    }

    private void handleUndos(Change failedChange, List<Change> undos) {
        Change partUndoChange;
        if (undos == null) {
            this.fUndoUntilException = null;
            return;
        }
        if (failedChange instanceof CompositeChange && (partUndoChange = ((CompositeChange)failedChange).getUndoUntilException()) != null) {
            undos.add(partUndoChange);
        }
        if (undos.isEmpty()) {
            this.fUndoUntilException = null;
            return;
        }
        Collections.reverse(undos);
        this.fUndoUntilException = this.createUndoChange(undos.toArray(new Change[undos.size()]));
    }

    protected void internalHandleException(Change change, Throwable t) {
    }

    protected boolean internalContinueOnCancel() {
        return false;
    }

    protected boolean internalProcessOnCancel(Change change) {
        return false;
    }

    @Override
    public void dispose() {
        for (final Change change : this.fChanges) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                    RefactoringCorePlugin.log(exception);
                }
            });
        }
    }

    public Change getUndoUntilException() {
        return this.fUndoUntilException;
    }

    protected Change createUndoChange(Change[] childUndos) {
        return new CompositeChange(this.getName(), childUndos);
    }

    @Override
    public Object[] getAffectedObjects() {
        if (this.fChanges.isEmpty()) {
            return new Object[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Change change : this.fChanges) {
            Object[] affectedObjects = change.getAffectedObjects();
            if (affectedObjects == null) {
                return null;
            }
            result.addAll(Arrays.asList(affectedObjects));
        }
        return result.toArray();
    }

    @Override
    public Object getModifiedElement() {
        return null;
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        for (Change change : this.fChanges) {
            ChangeDescriptor descriptor = change.getDescriptor();
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getName());
        buff.append("\n");
        for (Change change : this.fChanges) {
            buff.append("<").append(change.toString()).append("/>\n");
        }
        return buff.toString();
    }

    public int getFilenumber() {
        if (this.fChanges.size() > 0) {
            if (this.fChanges.get(0) instanceof CompositeChange) {
                CompositeChange obj = (CompositeChange)this.fChanges.get(0);
                return obj.getAmount();
            }
            return 1;
        }
        return 0;
    }

    private int getAmount() {
        return this.fChanges.size();
    }
}

