/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.ctf.core.tests.shared.LttngTraceGenerator;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.ControlView;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewSwtBotUtil;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    protected static final String INIT_SCENARIO_NAME = "Initialize";
    private static final String CREATE_SESSION_WITH_LTTNG_2_8_SCENARIO_NAME = "CreateSession_2.8";
    private static final String SESSION_NAME = "mysession";
    private static final String UST_CHANNEL_NAME = "channel0";
    private static final String NODE_NAME = "myNode";
    private static final String PERSPECTIVE_ID = "org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.perspective";
    private static final long IMPORT_TIME_OUT = 120000L;
    protected static final Logger fLogger = Logger.getRootLogger();
    protected static SWTWorkbenchBot fBot;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    protected @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    protected SWTBotTree fTree;
    protected ITraceControlComponent fRoot;
    protected TargetNodeComponent fNode;
    protected String fTestFile;

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        WaitUtils.waitForJobs();
        SWTBotUtils.switchToPerspective((String)PERSPECTIVE_ID);
    }

    @AfterClass
    public static void afterClass() {
        fLogger.removeAllAppenders();
    }

    @Before
    public void beforeTest() throws Exception {
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        WaitUtils.waitForJobs();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + this.getTestStream()), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        viewBot.setFocus();
        IViewPart part = viewBot.getViewReference().getView(true);
        ControlView view = (ControlView)part;
        this.fRoot = view.getTraceControlRoot();
        this.fNode = new TargetNodeComponent(this.getNodeName(), this.fRoot, (RemoteSystemProxy)this.fProxy);
        this.fRoot.addChild((ITraceControlComponent)this.fNode);
        this.fTree = viewBot.bot().tree();
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        if (this.fRoot != null) {
            this.fRoot.removeAllChildren();
        }
    }

    protected String getTestStream() {
        return TEST_STREAM;
    }

    protected String getSessionName() {
        return SESSION_NAME;
    }

    protected String getNodeName() {
        return NODE_NAME;
    }

    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario(INIT_SCENARIO_NAME);
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_WITH_LTTNG_2_8_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableKernelEvent();
        this.testEnableSyscalls();
        this.testEnableUstChannel();
        this.testEnableUstEvents();
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testImport(false, true);
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)"Remote");
        this.testImport(true, true);
        SWTBotUtils.clearTracesFolder((SWTWorkbenchBot)fBot, (String)"Remote");
        SWTBotUtils.createExperiment((SWTWorkbenchBot)fBot, (String)"Remote", (String)"mysession-20151201-205959");
        this.testImport(true, false);
        SWTBotUtils.clearExperimentFolder((SWTWorkbenchBot)fBot, (String)"Remote");
        this.testDestroySession();
        this.testDisconnectFromNode();
        SWTBotUtils.deleteProject((String)"Remote", (SWTWorkbenchBot)fBot);
    }

    protected void testConnectToNode() {
        SWTBotTreeItem nodeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName()});
        nodeItem.select();
        SWTBotMenu menuBot = nodeItem.contextMenu("Connect");
        menuBot.click();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Sessions", (SWTBotTreeItem)nodeItem));
        fBot.waitUntil(ControlViewSwtBotUtil.isStateChanged(this.fNode, TargetNodeState.CONNECTED));
        WaitUtils.waitForJobs();
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)this.fNode.getTargetNodeState());
    }

    protected void testCreateSession() {
        SWTBotTreeItem nodeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName()});
        SWTBotTreeItem sessionGroupItem = nodeItem.getNode("Sessions");
        sessionGroupItem.select();
        SWTBotMenu menuBot = sessionGroupItem.contextMenu("Create Session...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Create Session").activate();
        SWTBotText sessionText = shell.bot().textWithLabel("Session Name");
        sessionText.setText(SESSION_NAME);
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        sessionGroupItem.expand();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)this.getSessionName(), (SWTBotTreeItem)sessionGroupItem));
        Assert.assertEquals((long)1L, (long)sessionGroupItem.getNodes().size());
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        Assert.assertEquals((Object)this.getSessionName(), (Object)sessionItem.getText());
    }

    protected void testEnableKernelEvent() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "Tracepoint Events").click();
        SWTBotTree tracepointsTree = shell.bot().treeInGroup("Tracepoint Events");
        SWTBotTreeItem allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)tracepointsTree, (String[])new String[]{"All"});
        allItem.check();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME});
        Assert.assertEquals((Object)UST_CHANNEL_NAME, (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME, "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
        SWTBotTreeItem kernelDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel"});
        Assert.assertEquals((Object)"Kernel", (Object)kernelDomainItem.getText());
    }

    protected void testEnableSyscalls() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "Syscall Events").click();
        SWTBotTree syscallsTree = shell.bot().treeInGroup("Syscall Events");
        SWTBotTreeItem allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)syscallsTree, (String[])new String[]{"All"});
        allItem.check();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem kernelDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel"});
        Assert.assertEquals((Object)"Kernel", (Object)kernelDomainItem.getText());
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME});
        Assert.assertEquals((Object)UST_CHANNEL_NAME, (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME, "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
        sessionItem.select();
        menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "Syscall Events").click();
        syscallsTree = shell.bot().treeInGroup("Syscall Events");
        allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)syscallsTree, (String[])new String[]{"All"});
        allItem.expand();
        SWTBotTreeItem writeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)syscallsTree, (String[])new String[]{"All", "write"});
        writeItem.check();
        SWTBotTreeItem readItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)syscallsTree, (String[])new String[]{"All", "read"});
        readItem.check();
        SWTBotTreeItem closeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)syscallsTree, (String[])new String[]{"All", "close"});
        closeItem.check();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        kernelDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel"});
        Assert.assertEquals((Object)"Kernel", (Object)kernelDomainItem.getText());
        channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME});
        Assert.assertEquals((Object)UST_CHANNEL_NAME, (Object)channelItem.getText());
        eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME, "write"});
        Assert.assertEquals((Object)"write", (Object)eventItem.getText());
        eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME, "read"});
        Assert.assertEquals((Object)"read", (Object)eventItem.getText());
        eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", UST_CHANNEL_NAME, "close"});
        Assert.assertEquals((Object)"close", (Object)eventItem.getText());
    }

    protected void testEnableUstChannel() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Channel...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Channel").activate();
        SWTBotText channelText = shell.bot().textWithLabel("Channel Name");
        channelText.setText(UST_CHANNEL_NAME);
        shell.bot().radioInGroup("UST", "Domain").click();
        shell.bot().radioInGroup("Per UID buffers", "Buffer Type").click();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"UST global", (SWTBotTreeItem)sessionItem));
    }

    protected void testEnableUstEvents() {
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global", UST_CHANNEL_NAME});
        Assert.assertEquals((Object)UST_CHANNEL_NAME, (Object)channelItem.getText());
        channelItem.select();
        SWTBotMenu menuBot = channelItem.contextMenu("Enable Event...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        SWTBotTree tracepointsTree = shell.bot().tree();
        tracepointsTree.select(new String[]{"All"});
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "UST global", UST_CHANNEL_NAME, "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
    }

    protected void testStartStopTracing(TraceSessionState state) {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        if (state == TraceSessionState.ACTIVE) {
            menuBot = sessionItem.contextMenu("Start");
            menuBot.click();
            WaitUtils.waitForJobs();
        } else {
            menuBot = sessionItem.contextMenu("Stop");
            menuBot.click();
            WaitUtils.waitForJobs();
        }
        TraceSessionComponent sessionComp = ControlViewSwtBotUtil.getSessionComponent(this.fNode, this.getSessionName());
        fBot.waitUntil(ControlViewSwtBotUtil.isSessionStateChanged(sessionComp, state));
        Assert.assertEquals((Object)state, (Object)sessionComp.getSessionState());
    }

    protected void testDestroySession() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Destroy Session...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Destroy Confirmation").activate();
        shell.bot().button("OK").click();
        WaitUtils.waitForJobs();
        SWTBotTreeItem sessionGroupItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions"});
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeRemoved((int)0, (SWTBotTreeItem)sessionGroupItem));
        Assert.assertEquals((long)0L, (long)sessionGroupItem.getNodes().size());
    }

    protected void testDisconnectFromNode() {
        SWTBotTreeItem nodeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName()});
        nodeItem.select();
        SWTBotMenu menuBot = nodeItem.contextMenu("Disconnect");
        menuBot.click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ControlViewSwtBotUtil.isStateChanged(this.fNode, TargetNodeState.DISCONNECTED));
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)this.fNode.getTargetNodeState());
        Assert.assertEquals((long)0L, (long)nodeItem.getNodes().size());
    }

    protected void testImport(boolean createExperiment, boolean defaultExperiment) {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        TraceSessionComponent sessionComp = ControlViewSwtBotUtil.getSessionComponent(this.fNode, this.getSessionName());
        String pathString = sessionComp.isSnapshotSession() ? sessionComp.getSnapshotInfo().getSnapshotPath() : sessionComp.getSessionPath();
        Path path = new Path(pathString);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceDirectory = workspace.getRoot().getLocation().toFile();
        Path workspacePath = new Path(workspaceDirectory.toString());
        if (workspacePath.isPrefixOf((IPath)path)) {
            ControlViewTest.generateTrace((IPath)path);
            SWTBotMenu menuBot = sessionItem.contextMenu("Import...");
            menuBot.click();
            SWTBotShell shell = fBot.shell("Fetch Remote Traces").activate();
            ControlViewTest.closeImportWizard(shell, "Cancel");
            TmfProjectElement tmfProject = ControlViewTest.verifyRemoteProject();
            menuBot = sessionItem.contextMenu("Import...");
            menuBot.click();
            shell = fBot.shell("Fetch Remote Traces").activate();
            String experimentName = ControlViewTest.prepareAndVerifyExperimentHandling(shell.bot(), createExperiment, defaultExperiment, (IPath)path);
            ControlViewTest.closeImportWizard(shell, "Finish");
            ControlViewTest.verifyExperimentFolder(createExperiment, tmfProject, experimentName);
        }
    }

    private static TmfProjectElement verifyRemoteProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Remote");
        Assert.assertTrue((boolean)project.exists());
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        return tmfProject;
    }

    private static void verifyExperimentFolder(boolean createExperiment, TmfProjectElement tmfProject, String experimentName) {
        TmfExperimentFolder expFolder = tmfProject.getExperimentsFolder();
        Assert.assertNotNull((Object)expFolder);
        if (createExperiment) {
            if (experimentName != null) {
                TmfExperimentElement expElement = expFolder.getExperiment(experimentName);
                Assert.assertNotNull((Object)expElement);
                Assert.assertEquals((long)1L, (long)expElement.getTraces().size());
            }
        } else {
            Assert.assertTrue((expFolder.getExperiments().size() == 0 ? 1 : 0) != 0);
        }
    }

    private static void generateTrace(IPath path) {
        File traceParent = path.toFile();
        traceParent.mkdirs();
        LttngTraceGenerator.generateLttngTrace((File)path.append("kernel").toFile());
    }

    private static void closeImportWizard(SWTBotShell shell, String buttonName) {
        SWTBotButton button = shell.bot().button(buttonName);
        shell.bot().waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)button));
        button.click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
        WaitUtils.waitForJobs();
    }

    private static String prepareAndVerifyExperimentHandling(SWTBot bot, boolean createExperiment, boolean defaultExperiment, IPath path) {
        String experimentName = path.lastSegment();
        if (createExperiment) {
            SWTBotCheckBox checkBox = bot.checkBox();
            checkBox.click();
            if (!defaultExperiment) {
                experimentName = ControlViewTest.verifyExperimentNameHandling(bot, experimentName);
            }
        }
        return experimentName;
    }

    private static @NonNull String verifyExperimentNameHandling(SWTBot bot, String aExperimentName) {
        String experimentName = aExperimentName;
        ControlViewTest.checkFinishButton(bot, false);
        SWTBotText expText = bot.textInGroup("Options");
        expText.setText(String.valueOf(' '));
        ControlViewTest.checkFinishButton(bot, false);
        expText.setText(String.valueOf('/'));
        ControlViewTest.checkFinishButton(bot, false);
        experimentName = String.valueOf(experimentName) + '_';
        expText.setText(experimentName);
        return experimentName;
    }

    private static void checkFinishButton(SWTBot bot, boolean isEnabled) {
        SWTBotButton finishButton = bot.button("Finish");
        Assert.assertTrue((finishButton.isEnabled() == isEnabled ? 1 : 0) != 0);
    }
}

