/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class DebugPopup
extends PopupDialog {
    private Point fAnchor;
    private IHandlerActivation fActivation;
    private IHandlerService fHandlerService;
    private String fCommandId;
    private boolean fPersisted = false;

    public DebugPopup(Shell parent, Point anchor, String commandId) {
        super(parent, 16, true, true, false, true, false, null, null);
        this.fAnchor = anchor;
        this.fCommandId = commandId;
    }

    protected String getInfoText() {
        if (this.getCommandId() != null && this.getActionText() != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            String formattedBinding = bindingService.getBestActiveBindingFormattedFor(this.getCommandId());
            String infoText = null;
            if (formattedBinding != null) {
                infoText = MessageFormat.format(DebugUIViewsMessages.InspectPopupDialog_1, formattedBinding, this.getActionText());
            }
            return infoText;
        }
        return null;
    }

    protected String getActionText() {
        return null;
    }

    protected String getCommandId() {
        return this.fCommandId;
    }

    protected void persist() {
        this.fPersisted = true;
    }

    protected boolean wasPersisted() {
        return this.fPersisted;
    }

    protected abstract Control createDialogArea(Composite var1);

    protected Point getInitialLocation(Point initialSize) {
        if (this.fAnchor == null) {
            return super.getInitialLocation(initialSize);
        }
        Point point = this.fAnchor;
        Rectangle monitor = this.getShell().getMonitor().getClientArea();
        if (monitor.width < point.x + initialSize.x) {
            point.x = Math.max(0, point.x - initialSize.x);
        }
        if (monitor.height < point.y + initialSize.y) {
            point.y = Math.max(0, point.y - initialSize.y);
        }
        return point;
    }

    protected IDialogSettings getDialogSettings() {
        return PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(DebugPopup.class)).getDialogSettings();
    }

    public int open() {
        String infoText;
        IWorkbench workbench = PlatformUI.getWorkbench();
        String commandId = this.getCommandId();
        if (commandId != null) {
            AbstractHandler fCloseHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    DebugPopup.this.persist();
                    DebugPopup.this.close();
                    return null;
                }
            };
            this.fHandlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
            this.fActivation = this.fHandlerService.activateHandler(commandId, (IHandler)fCloseHandler);
        }
        if ((infoText = this.getInfoText()) != null) {
            this.setInfoText(infoText);
        }
        return super.open();
    }

    public boolean close() {
        if (this.fActivation != null) {
            this.fHandlerService.deactivateHandler(this.fActivation);
        }
        return super.close();
    }
}

