/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.LogicalStructureCache;

public class VariableContentProvider
extends ElementContentProvider {
    private static LogicalStructureCache fgLogicalCache;

    @Override
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getAllChildren(element, context).length;
    }

    @Override
    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return this.getElements(this.getAllChildren(parent, context), index, length);
    }

    @Override
    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return ((IVariable)element).getValue().hasVariables();
    }

    @Override
    protected boolean supportsContextId(String id) {
        return id.equals("org.eclipse.debug.ui.ExpressionView") || id.equals("org.eclipse.debug.ui.VariableView") || id.equals("org.eclipse.debug.ui.RegisterView");
    }

    protected Object[] getAllChildren(Object parent, IPresentationContext context) throws CoreException {
        IVariable variable = (IVariable)parent;
        IValue value = variable.getValue();
        if (value != null) {
            return this.getValueChildren((IDebugElement)variable, value, context);
        }
        return EMPTY;
    }

    protected boolean isShowLogicalStructure(IPresentationContext context) {
        Boolean show = (Boolean)context.getProperty("PRESENTATION_SHOW_LOGICAL_STRUCTURES");
        return show != null && show != false;
    }

    protected int getArrayPartitionSize() {
        return 100;
    }

    protected IValue getLogicalValue(IValue value, IPresentationContext context) throws CoreException {
        return this.getLogicalValue(value, new ArrayList<String>(), context);
    }

    protected Object[] getValueChildren(IDebugElement parent, IValue value, IPresentationContext context) throws CoreException {
        IIndexedValue indexedValue;
        int partitionSize;
        if (value == null) {
            return EMPTY;
        }
        IValue logicalValue = this.getLogicalValue(value, context);
        if (logicalValue instanceof IIndexedValue && (partitionSize = this.computeParitionSize(indexedValue = (IIndexedValue)logicalValue)) > 1) {
            int offset = indexedValue.getInitialOffset();
            int length = indexedValue.getSize();
            int numPartitions = length / partitionSize;
            int remainder = length % partitionSize;
            if (remainder > 0) {
                ++numPartitions;
            }
            Object[] partitions = new IVariable[numPartitions];
            int i = 0;
            while (i < numPartitions - 1) {
                partitions[i] = new IndexedVariablePartition(parent, indexedValue, offset, partitionSize);
                offset += partitionSize;
                ++i;
            }
            if (remainder == 0) {
                remainder = partitionSize;
            }
            partitions[numPartitions - 1] = new IndexedVariablePartition(parent, indexedValue, offset, remainder);
            return partitions;
        }
        if (logicalValue == null) {
            logicalValue = value;
        }
        return logicalValue.getVariables();
    }

    protected int computeParitionSize(IIndexedValue value) {
        int partitionSize = 1;
        try {
            int length = value.getSize();
            int partitionDepth = 0;
            int preferredSize = this.getArrayPartitionSize();
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0) {
                if (remainder == 0 && length == 1) break;
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            int i = 0;
            while (i < partitionDepth) {
                partitionSize *= preferredSize;
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return partitionSize;
    }

    protected IValue getLogicalValue(IValue value, List<String> previousStructureIds, IPresentationContext context) throws CoreException {
        ILogicalStructureType type;
        ILogicalStructureType[] types;
        if (this.isShowLogicalStructure(context) && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0 && (type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types)) != null && !previousStructureIds.contains(type.getId())) {
            IValue logicalValue = this.getLogicalStructureCache().getLogicalStructure(type, value);
            previousStructureIds.add(type.getId());
            return this.getLogicalValue(logicalValue, previousStructureIds, context);
        }
        return value;
    }

    protected synchronized LogicalStructureCache getLogicalStructureCache() {
        if (fgLogicalCache == null) {
            fgLogicalCache = new LogicalStructureCache();
            DebugPlugin.getDefault().addDebugEventListener(events -> {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8) {
                        fgLogicalCache.clear();
                        break;
                    }
                    if (event.getKind() == 1 && event.getDetail() != 128) {
                        fgLogicalCache.clear();
                        break;
                    }
                    if (event.getKind() == 2 && event.getDetail() != 128) {
                        fgLogicalCache.clear();
                        break;
                    }
                    if (event.getKind() == 16 && event.getDetail() == 512) {
                        fgLogicalCache.clear();
                        break;
                    }
                    ++n2;
                }
            });
        }
        return fgLogicalCache;
    }
}

