/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd;

import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.TimeCompressionBar;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.ConfigureMinMax;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.FirstPage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.KeyBindingsManager;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.LastPage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.MoveToMessage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.NextPage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.OpenSDFiltersDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.OpenSDFindDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.OpenSDPagesDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.PrevPage;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.Print;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.ShowNodeEnd;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.ShowNodeStart;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.Zoom;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.IExtendedFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.IExtendedFindProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDCollapseProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDExtendedActionBarProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDPropertiesProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class SDView
extends ViewPart
implements IPartListener {
    public static final String UML2SD_VIEW_MODES_SEPARATOR = "UML2SD_VIEW_MODES";
    public static final String UML2SD_WORKING_SET_SEPARATOR = "UML2SD_WORKING_SET";
    public static final String UML2SD_SORTING_SEPARATOR = "UML2SD_SORTING";
    public static final String UML2SD_FILTERING_SEPARATOR = "UML2SD_FILTERING";
    public static final String UML2SD_VIEW_LAYOUT_SEPARATOR = "UML2SD_VIEW_LAYOUT";
    public static final String UML2SD_LINK_EDITOR_SEPARATOR = "UML2SD_LINK_EDITOR";
    public static final String UML2SD_OTHER_COMMANDS_SEPARATOR = "UML2SD_OTHER_COMMANDS";
    public static final String UML2SD_OTHER_PLUGINS_COMMANDS_SEPARATOR = "UML2SD_OTHER_PLUGINS_COMMANDS";
    private SDWidget fSdWidget = null;
    private TimeCompressionBar fTimeCompressionBar = null;
    private ISDFindProvider fSdFindProvider = null;
    private ISDPagingProvider fSdPagingProvider = null;
    private ISDFilterProvider fSdFilterProvider = null;
    private IExtendedFilterProvider fSdExFilterProvider = null;
    private IExtendedFindProvider fSdExFindProvider = null;
    private ISDExtendedActionBarProvider fSdExtendedActionBarProvider = null;
    private ISDPropertiesProvider fSdPropertiesProvider = null;
    private NextPage fNextPageButton = null;
    private PrevPage fPrevPageButton = null;
    private FirstPage fFirstPageButton = null;
    private LastPage fLastPageButton = null;
    private MenuManager fMenuMgr = null;
    private boolean fNeedInit = true;
    private Cursor fWaitCursor;
    private Zoom fResetZoomAction;
    private Zoom fNoZoomAction;
    private Zoom fZoomInAction;
    private Zoom fZoomOutAction;
    private ActionHandler fPrintActionHandler;
    private IHandlerActivation fPrintHandlerActivation;

    public void createPartControl(Composite c) {
        Composite parent = new Composite(c, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parent.setLayout((Layout)parentLayout);
        GridData timeLayoutdata = new GridData(1040);
        timeLayoutdata.widthHint = 10;
        GridData seqDiagLayoutData = new GridData(1808);
        this.fTimeCompressionBar = new TimeCompressionBar(parent, 0);
        this.fTimeCompressionBar.setLayoutData(timeLayoutdata);
        this.fSdWidget = new SDWidget(parent, 0);
        this.fSdWidget.setLayoutData(seqDiagLayoutData);
        this.fSdWidget.setSite(this);
        this.fSdWidget.setTimeBar(this.fTimeCompressionBar);
        KeyBindingsManager.getInstance().add(this.getSite().getId());
        this.createCoolbarContent();
        this.hookContextMenu();
        this.fTimeCompressionBar.setVisible(false);
        parent.layout(true);
        this.fPrintActionHandler = new ActionHandler((IAction)new Print(this));
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.fNeedInit = this.restoreLoader();
    }

    protected void loadBlank() {
        BlankUml2SdLoader loader = new BlankUml2SdLoader();
        loader.setViewer(this);
        this.setContentDescription(loader.getTitleString());
    }

    public void setFocus() {
        if (this.fSdWidget != null) {
            KeyBindingsManager.getInstance().setSdView(this);
            this.fSdWidget.setFocus();
        }
        if (this.isViewReady() && this.fNeedInit) {
            this.fNeedInit = this.restoreLoader();
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        KeyBindingsManager.getInstance().remove(this.getSite().getId());
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().removeAll();
        bars.getMenuManager().removeAll();
        this.disposeZoomActions();
        this.fPrintActionHandler.dispose();
        super.dispose();
    }

    private void disposeZoomActions() {
        if (this.fResetZoomAction != null) {
            this.fResetZoomAction.dispose();
        }
        if (this.fNoZoomAction != null) {
            this.fNoZoomAction.dispose();
        }
        if (this.fZoomInAction != null) {
            this.fZoomInAction.dispose();
        }
        if (this.fZoomOutAction != null) {
            this.fZoomOutAction.dispose();
        }
    }

    public SDWidget getSDWidget() {
        return this.fSdWidget;
    }

    public void setSDFindProvider(ISDFindProvider provider) {
        this.fSdFindProvider = provider;
        this.fSdExFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public void setExtendedFindProvider(IExtendedFindProvider provider) {
        this.fSdExFindProvider = provider;
        this.fSdFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            KeyBindingsManager.getInstance().setFindEnabled(true);
        } else {
            KeyBindingsManager.getInstance().setFindEnabled(false);
        }
    }

    public IExtendedFindProvider getExtendedFindProvider() {
        return this.fSdExFindProvider;
    }

    public void resetProviders() {
        KeyBindingsManager.getInstance().setFindEnabled(false);
        this.fSdFindProvider = null;
        this.fSdExFindProvider = null;
        this.fSdFilterProvider = null;
        this.fSdExFilterProvider = null;
        this.fSdPagingProvider = null;
        this.fSdExtendedActionBarProvider = null;
        this.fSdPropertiesProvider = null;
        if (this.fSdWidget != null && !this.fSdWidget.isDisposed()) {
            this.fSdWidget.setCollapseProvider(null);
        }
    }

    public void setSDFilterProvider(ISDFilterProvider provider) {
        this.fSdFilterProvider = provider;
        this.createCoolbarContent();
    }

    public void setExtendedFilterProvider(IExtendedFilterProvider provider) {
        this.fSdExFilterProvider = provider;
        this.createCoolbarContent();
    }

    public IExtendedFilterProvider getExtendedFilterProvider() {
        return this.fSdExFilterProvider;
    }

    public void setCollapsingProvider(ISDCollapseProvider provider) {
        if (this.fSdWidget != null && !this.fSdWidget.isDisposed()) {
            this.fSdWidget.setCollapseProvider(provider);
        }
    }

    public void setSDPagingProvider(ISDPagingProvider provider) {
        this.fSdPagingProvider = provider;
        this.createCoolbarContent();
    }

    public ISDPagingProvider getSDPagingProvider() {
        return this.fSdPagingProvider;
    }

    public ISDFindProvider getSDFindProvider() {
        return this.fSdFindProvider;
    }

    public ISDFilterProvider getSDFilterProvider() {
        return this.fSdFilterProvider;
    }

    public void setSDExtendedActionBarProvider(ISDExtendedActionBarProvider provider) {
        this.fSdExtendedActionBarProvider = provider;
        this.createCoolbarContent();
    }

    public ISDExtendedActionBarProvider getSDExtendedActionBarProvider() {
        return this.fSdExtendedActionBarProvider;
    }

    public void setSDPropertiesProvider(ISDPropertiesProvider provider) {
        this.fSdPropertiesProvider = provider;
    }

    public ISDPropertiesProvider getSDPropertiesProvider() {
        return this.fSdPropertiesProvider;
    }

    protected void setSDWidget(SDWidget sdWidget) {
        this.fSdWidget = sdWidget;
    }

    protected void setTimeBar(TimeCompressionBar timeCompressionbar) {
        this.fTimeCompressionBar = timeCompressionbar;
    }

    protected void setNeedInit(boolean needInit) {
        this.fNeedInit = needInit;
    }

    protected void hookContextMenu() {
        this.fMenuMgr = new MenuManager("#PopupMenu");
        this.fMenuMgr.setRemoveAllWhenShown(true);
        this.fMenuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = this.fMenuMgr.createContextMenu(this.fSdWidget.getViewControl());
        this.fSdWidget.getViewControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fMenuMgr, this.fSdWidget.getSelectionProvider());
    }

    public MenuManager getMenuManager() {
        return this.fMenuMgr;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("Additions"));
        if (this.getSDWidget() != null && this.getSDWidget().getCurrentGraphNode() != null) {
            MoveToMessage goToMessage;
            Object node2;
            ISelectionProvider selProvider = this.fSdWidget.getSelectionProvider();
            ISelection sel = selProvider.getSelection();
            int nbMessage = 0;
            for (Object node2 : (StructuredSelection)sel) {
                if (!(node2 instanceof BaseMessage)) continue;
                ++nbMessage;
            }
            if (nbMessage != 1) {
                return;
            }
            node2 = this.getSDWidget().getCurrentGraphNode();
            if (node2 instanceof SyncMessageReturn && ((SyncMessageReturn)node2).getMessage() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(Messages.SequenceDiagram_GoToMessage);
                manager.add((IAction)goToMessage);
            }
            if (node2 instanceof SyncMessage && ((SyncMessage)node2).getMessageReturn() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(Messages.SequenceDiagram_GoToMessageReturn);
                manager.add((IAction)goToMessage);
            }
        }
        manager.add((IContributionItem)new Separator("MultiSelectAdditions"));
    }

    public void setEnableAction(String actionName, boolean state) {
        IContributionItem item;
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar != null && (item = bar.getMenuManager().find(actionName)) != null && item instanceof ActionContributionItem) {
            IAction action = ((ActionContributionItem)item).getAction();
            if (action != null) {
                action.setEnabled(state);
            }
            item.setVisible(state);
            bar.updateActionBars();
        }
    }

    protected void createCoolbarContent() {
        Action action;
        IActionBars bar = this.getViewSite().getActionBars();
        bar.getMenuManager().removeAll();
        bar.getToolBarManager().removeAll();
        this.disposeZoomActions();
        this.createMenuGroup();
        this.fResetZoomAction = new Zoom(this, Zoom.ZoomType.ZOOM_RESET);
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fResetZoomAction);
        bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fResetZoomAction);
        this.fNoZoomAction = new Zoom(this, Zoom.ZoomType.ZOOM_NONE);
        this.fNoZoomAction.setChecked(true);
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fNoZoomAction);
        bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fNoZoomAction);
        this.fZoomInAction = new Zoom(this, Zoom.ZoomType.ZOOM_IN);
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fZoomInAction);
        bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fZoomInAction);
        this.fZoomOutAction = new Zoom(this, Zoom.ZoomType.ZOOM_OUT);
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fZoomOutAction);
        bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fZoomOutAction);
        MenuManager navigation = new MenuManager(Messages.SequenceDiagram_Navigation);
        ShowNodeStart showNodeStart = new ShowNodeStart(this);
        showNodeStart.setText(Messages.SequenceDiagram_ShowNodeStart);
        showNodeStart.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        showNodeStart.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeStart");
        navigation.add((IAction)showNodeStart);
        ShowNodeEnd showNodeEnd = new ShowNodeEnd(this);
        showNodeEnd.setText(Messages.SequenceDiagram_ShowNodeEnd);
        showNodeEnd.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        showNodeEnd.setActionDefinitionId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ShowNodeEnd");
        navigation.add((IAction)showNodeEnd);
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IContributionItem)navigation);
        ConfigureMinMax minMax = new ConfigureMinMax(this);
        minMax.setText(Messages.SequenceDiagram_ConfigureMinMax);
        minMax.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.ConfigureMinMax");
        bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)minMax);
        if (this.fSdWidget.getFrame() != null && this.fSdWidget.getFrame().hasTimeInfo()) {
            minMax.setEnabled(true);
        } else {
            minMax.setEnabled(false);
        }
        if (this.fSdPagingProvider != null) {
            this.fNextPageButton = new NextPage(this);
            bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fNextPageButton);
            this.fNextPageButton.setEnabled(this.fSdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fNextPageButton);
            this.fPrevPageButton = new PrevPage(this);
            bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fPrevPageButton);
            this.fPrevPageButton.setEnabled(this.fSdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fPrevPageButton);
            this.fFirstPageButton = new FirstPage(this);
            bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fFirstPageButton);
            this.fFirstPageButton.setEnabled(this.fSdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fFirstPageButton);
            this.fLastPageButton = new LastPage(this);
            bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fLastPageButton);
            this.fLastPageButton.setEnabled(this.fSdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)this.fLastPageButton);
        }
        if (this.fSdExFilterProvider != null && (action = this.fSdExFilterProvider.getFilterAction()) != null) {
            if (action.getId() == null) {
                action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFilter");
            }
            if (action.getImageDescriptor() == null) {
                action.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/filter_items.gif"));
            }
            if (action.getText() == null || action.getText().length() == 0) {
                action.setText(Messages.SequenceDiagram_EditFilters);
            }
            bar.getMenuManager().prependToGroup(UML2SD_FILTERING_SEPARATOR, (IAction)action);
            bar.getToolBarManager().prependToGroup(UML2SD_FILTERING_SEPARATOR, (IAction)action);
        }
        if (this.fSdFilterProvider != null) {
            bar.getMenuManager().appendToGroup(UML2SD_FILTERING_SEPARATOR, (IAction)new OpenSDFiltersDialog(this, this.fSdFilterProvider));
        }
        if (this.fSdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IContributionItem sdPaging = bar.getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            if (sdPaging != null) {
                bar.getMenuManager().remove(sdPaging);
                sdPaging = null;
            }
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)new OpenSDPagesDialog(this, (ISDAdvancedPagingProvider)this.fSdPagingProvider));
            this.updatePagesMenuItem(bar);
        }
        if (this.fSdExFindProvider != null) {
            action = this.fSdExFindProvider.getFindAction();
            if (action != null) {
                if (action.getId() == null) {
                    action.setId("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.extendedFind");
                }
                if (action.getImageDescriptor() == null) {
                    action.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/search_seqdiag_menu.gif"));
                }
                if (action.getText() == null) {
                    action.setText(Messages.SequenceDiagram_Find + "...");
                }
                bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)action);
                bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)action);
            }
        } else if (this.fSdFindProvider != null) {
            bar.getMenuManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)new OpenSDFindDialog(this));
            bar.getToolBarManager().appendToGroup(UML2SD_OTHER_COMMANDS_SEPARATOR, (IAction)new OpenSDFindDialog(this));
        }
        if (this.fSdExtendedActionBarProvider != null) {
            this.fSdExtendedActionBarProvider.supplementCoolbarContent(bar);
        }
        bar.updateActionBars();
    }

    public void updateCoolBar() {
        if (this.fSdPagingProvider != null) {
            IAction lastPageAction;
            IContributionItem lastPage;
            IAction firstPageAction;
            IContributionItem firstPage;
            IAction prevPageAction;
            IContributionItem prevPage;
            IAction nextPageAction;
            IActionBars bar = this.getViewSite().getActionBars();
            if (bar == null) {
                return;
            }
            IToolBarManager barManager = bar.getToolBarManager();
            if (barManager == null) {
                return;
            }
            IContributionItem nextPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.nextpage");
            if (nextPage instanceof ActionContributionItem && (nextPageAction = ((ActionContributionItem)nextPage).getAction()) instanceof NextPage) {
                ((NextPage)nextPageAction).setEnabled(this.fSdPagingProvider.hasNextPage());
            }
            if ((prevPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.prevpage")) instanceof ActionContributionItem && (prevPageAction = ((ActionContributionItem)prevPage).getAction()) instanceof PrevPage) {
                ((PrevPage)prevPageAction).setEnabled(this.fSdPagingProvider.hasPrevPage());
            }
            if ((firstPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.firstpage")) instanceof ActionContributionItem && (firstPageAction = ((ActionContributionItem)firstPage).getAction()) instanceof FirstPage) {
                ((FirstPage)firstPageAction).setEnabled(this.fSdPagingProvider.hasPrevPage());
            }
            if ((lastPage = barManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.lastpage")) instanceof ActionContributionItem && (lastPageAction = ((ActionContributionItem)lastPage).getAction()) instanceof LastPage) {
                ((LastPage)lastPageAction).setEnabled(this.fSdPagingProvider.hasNextPage());
            }
            this.updatePagesMenuItem(bar);
        }
    }

    protected void updatePagesMenuItem(IActionBars bar) {
        if (this.fSdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IMenuManager menuManager = bar.getMenuManager();
            ActionContributionItem contributionItem = (ActionContributionItem)menuManager.find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.sdPaging");
            IAction openSDPagesDialog = null;
            if (contributionItem != null) {
                openSDPagesDialog = contributionItem.getAction();
            }
            if (openSDPagesDialog instanceof OpenSDPagesDialog) {
                openSDPagesDialog.setEnabled(((ISDAdvancedPagingProvider)this.fSdPagingProvider).pagesCount() > 1);
            }
        }
    }

    public void setFrame(Frame frame) {
        this.setFrame(frame, true);
    }

    protected void setFrame(Frame frame, boolean resetPosition) {
        IContributionItem shortKeysMenu;
        MenuManager shortKeys;
        if (this.getSDWidget() == null) {
            return;
        }
        if (frame == null) {
            this.loadBlank();
            return;
        }
        IUml2SDLoader loader = LoadersManager.getInstance().getCurrentLoader(this.getViewSite().getId(), this);
        if (loader == null) {
            return;
        }
        if (loader.getTitleString() != null) {
            this.setContentDescription(loader.getTitleString());
        }
        this.getSDWidget().setFrame(frame, resetPosition);
        if (this.fTimeCompressionBar != null) {
            this.fTimeCompressionBar.setFrame(frame);
        }
        this.updateCoolBar();
        if (this.fTimeCompressionBar != null) {
            if (!frame.hasTimeInfo()) {
                parent = this.fTimeCompressionBar.getParent();
                this.fTimeCompressionBar.setVisible(false);
                parent.layout(true);
            } else {
                parent = this.fTimeCompressionBar.getParent();
                this.fTimeCompressionBar.setVisible(true);
                parent.layout(true);
            }
        }
        if ((shortKeys = (MenuManager)(shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers"))) != null) {
            IContributionItem[] items = shortKeys.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()) != null) {
                    action.setEnabled(true);
                }
                ++i;
            }
        }
        this.createCoolbarContent();
    }

    public void setEnableCommand(String id, boolean value) {
        IAction action;
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys == null) {
            return;
        }
        IContributionItem item = shortKeys.find(id);
        if (item != null && item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) != null) {
            action.setEnabled(value);
        }
    }

    public void setFrameSync(Frame frame) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(() -> {
            if (this.getSDWidget() == null || this.getSDWidget().isDisposed() || this.fTimeCompressionBar != null && this.fTimeCompressionBar.isDisposed()) {
                return;
            }
            this.setFrame(frame);
        });
    }

    public void ensureVisibleSync(GraphNode sm) {
        this.getSDWidget().getDisplay().syncExec(() -> {
            if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
                return;
            }
            this.getSDWidget().ensureVisible(sm);
        });
    }

    public void setFrameAndEnsureVisibleSync(Frame frame, GraphNode sm) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(() -> {
            if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
                return;
            }
            this.setFrameAndEnsureVisible(frame, sm);
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, GraphNode sm) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(sm);
    }

    public void setFrameAndEnsureVisibleSync(Frame frame, int x, int y) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().syncExec(() -> this.setFrameAndEnsureVisible(frame, x, y));
    }

    public void setFrameAndEnsureVisible(Frame frame, int x, int y) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(x, y);
        this.getSDWidget().redraw();
    }

    public void toggleWaitCursorAsync(boolean wait) {
        if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
            return;
        }
        this.getSDWidget().getDisplay().asyncExec(() -> {
            if (this.getSDWidget() == null || this.getSDWidget().isDisposed()) {
                return;
            }
            if (wait) {
                if (this.fWaitCursor != null && !this.fWaitCursor.isDisposed()) {
                    this.fWaitCursor.dispose();
                }
                this.fWaitCursor = new Cursor((Device)this.getSDWidget().getDisplay(), 1);
                this.getSDWidget().setCursor(this.fWaitCursor);
                this.getSDWidget().getDisplay().update();
            } else {
                if (this.fWaitCursor != null && !this.fWaitCursor.isDisposed()) {
                    this.fWaitCursor.dispose();
                }
                this.fWaitCursor = null;
                this.getSDWidget().setCursor(null);
                this.getSDWidget().getDisplay().update();
            }
        });
    }

    public TimeCompressionBar getTimeCompressionBar() {
        return this.fTimeCompressionBar;
    }

    public Frame getFrame() {
        if (this.getSDWidget() != null) {
            return this.getSDWidget().getFrame();
        }
        return null;
    }

    protected boolean isNeedInit() {
        return this.fNeedInit;
    }

    protected boolean restoreLoader() {
        String id = this.getViewSite().getId();
        if (id == null) {
            return true;
        }
        IUml2SDLoader loader = LoadersManager.getInstance().getCurrentLoader(id, this);
        if (loader != null) {
            loader.setViewer(this);
            return false;
        }
        this.loadBlank();
        return true;
    }

    protected boolean isViewReady() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        IViewReference[] ref = page.getViewReferences();
        int i = 0;
        while (i < ref.length) {
            if (ref[i].getView(false) == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createMenuGroup() {
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar == null) {
            return;
        }
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_VIEW_MODES_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_WORKING_SET_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_SORTING_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_FILTERING_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_VIEW_LAYOUT_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_LINK_EDITOR_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_OTHER_COMMANDS_SEPARATOR));
        bar.getToolBarManager().add((IContributionItem)new Separator(UML2SD_OTHER_PLUGINS_COMMANDS_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_VIEW_MODES_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_WORKING_SET_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_SORTING_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_FILTERING_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_VIEW_LAYOUT_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_LINK_EDITOR_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_OTHER_COMMANDS_SEPARATOR));
        bar.getMenuManager().add((IContributionItem)new Separator(UML2SD_OTHER_PLUGINS_COMMANDS_SEPARATOR));
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.fSdPropertiesProvider != null && adapter.equals(IPropertySheetPage.class)) {
            return adapter.cast(this.fSdPropertiesProvider.getPropertySheetEntry());
        }
        return (T)super.getAdapter(adapter);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
            this.fPrintHandlerActivation = ((IHandlerService)service).activateHandler(ActionFactory.PRINT.getCommandId(), (IHandler)this.fPrintActionHandler);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this && this.fPrintHandlerActivation != null) {
            Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
            ((IHandlerService)service).deactivateHandler(this.fPrintHandlerActivation);
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public static class BlankUml2SdLoader
    implements IUml2SDLoader {
        @Override
        public void setViewer(SDView viewer) {
            Frame f = new Frame();
            f.setName("");
            viewer.setFrame(f);
        }

        @Override
        public String getTitleString() {
            return "";
        }

        @Override
        public void dispose() {
        }
    }
}

