/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension;

import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.IModificationContext;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CConfigurationDataProvider {
    public abstract CConfigurationData loadConfiguration(ICConfigurationDescription var1, IProgressMonitor var2) throws CoreException;

    public abstract CConfigurationData createConfiguration(ICConfigurationDescription var1, ICConfigurationDescription var2, CConfigurationData var3, boolean var4, IProgressMonitor var5) throws CoreException;

    public abstract void removeConfiguration(ICConfigurationDescription var1, CConfigurationData var2, IProgressMonitor var3);

    public CConfigurationData applyConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, IProgressMonitor monitor) throws CoreException {
        return baseData;
    }

    public CConfigurationData applyConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, IModificationContext context, IProgressMonitor monitor) throws CoreException {
        CConfigurationData data = this.applyConfiguration(cfgDescription, baseCfgDescription, baseData, monitor);
        if (baseCfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List<ILanguageSettingsProvider> providers;
            String[] defaultIds = ((ILanguageSettingsProvidersKeeper)((Object)baseCfgDescription)).getDefaultLanguageSettingsProvidersIds();
            if (defaultIds != null) {
                providers = ((ILanguageSettingsProvidersKeeper)((Object)baseCfgDescription)).getLanguageSettingProviders();
            } else {
                ICProjectDescription prjDescription = baseCfgDescription.getProjectDescription();
                if (prjDescription != null) {
                    IProject project = prjDescription.getProject();
                    ScannerDiscoveryLegacySupport.defineLanguageSettingsEnablement(project);
                }
                defaultIds = ScannerDiscoveryLegacySupport.getDefaultProviderIdsLegacy(baseCfgDescription);
                providers = LanguageSettingsManager.createLanguageSettingsProviders(defaultIds);
            }
            if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).setDefaultLanguageSettingsProvidersIds(defaultIds);
                ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).setLanguageSettingProviders(providers);
            }
        }
        return data;
    }

    public void dataCached(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
    }
}

