/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.datastore.core.condition;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;

public class ArrayIntegerRangeCondition
implements IntegerRangeCondition {
    private static final int[] MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private final int[] fQuarkArray;
    private final byte[] fQuarkSet;

    public ArrayIntegerRangeCondition(Collection<@NonNull Integer> quarks) {
        if (quarks.isEmpty()) {
            throw new IllegalArgumentException("QuarkArrayRangeCondition requires a non empty collection");
        }
        this.fQuarkArray = new int[quarks.size()];
        int i = 0;
        for (Integer quark : quarks) {
            this.fQuarkArray[i] = quark;
            ++i;
        }
        Arrays.sort(this.fQuarkArray);
        this.fQuarkSet = ArrayIntegerRangeCondition.buildQuarkSet(this.fQuarkArray);
    }

    private ArrayIntegerRangeCondition(int[] intArray) {
        this.fQuarkArray = intArray;
        this.fQuarkSet = ArrayIntegerRangeCondition.buildQuarkSet(intArray);
    }

    private static byte[] buildQuarkSet(int[] sortedQuarkArray) {
        int min = sortedQuarkArray[0];
        int max = sortedQuarkArray[sortedQuarkArray.length - 1];
        byte[] quarkSet = new byte[(max - min) / 8 + 1];
        int[] nArray = sortedQuarkArray;
        int n = sortedQuarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            int quark = nArray[n2];
            int delta = quark - min;
            int index = delta / 8;
            int offset = delta & 7;
            int n3 = index;
            quarkSet[n3] = (byte)(quarkSet[n3] | MASKS[offset]);
            ++n2;
        }
        return quarkSet;
    }

    @Override
    public int min() {
        return this.fQuarkArray[0];
    }

    @Override
    public int max() {
        return this.fQuarkArray[this.fQuarkArray.length - 1];
    }

    @Override
    public boolean test(int element) {
        int offset;
        if (element < this.min() || this.max() < element) {
            return false;
        }
        int delta = element - this.min();
        int index = delta / 8;
        return (this.fQuarkSet[index] & MASKS[offset = delta & 7]) != 0;
    }

    @Override
    public boolean intersects(int low, int high) {
        int lowIndex = Arrays.binarySearch(this.fQuarkArray, low);
        if (lowIndex >= 0) {
            return true;
        }
        if (lowIndex == -this.fQuarkArray.length - 1) {
            return false;
        }
        return this.fQuarkArray[-lowIndex - 1] <= high;
    }

    @Override
    public @Nullable IntegerRangeCondition subCondition(int from, int to) {
        if (from <= this.min() && this.max() <= to) {
            return this;
        }
        int fromIndex = Arrays.binarySearch(this.fQuarkArray, from);
        if (fromIndex == -this.fQuarkArray.length - 1) {
            return null;
        }
        int toIndex = Arrays.binarySearch(this.fQuarkArray, fromIndex = fromIndex >= 0 ? fromIndex : -fromIndex - 1, this.fQuarkArray.length, to);
        if (toIndex == -1) {
            return null;
        }
        int n = toIndex = toIndex >= 0 ? toIndex + 1 : -toIndex - 1;
        if (toIndex <= fromIndex) {
            return null;
        }
        return new ArrayIntegerRangeCondition(Arrays.copyOfRange(this.fQuarkArray, fromIndex, toIndex));
    }

    public String toString() {
        return "ArrayIntegerRangeCondition[" + this.fQuarkSet.length + "](" + this.min() + "\u2025" + this.max() + ")";
    }
}

