/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.osgi.framework.Bundle;

public class ContentAssistUtils {
    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexedRegion getNodeAt(ITextViewer viewer, int documentOffset) {
        if (viewer == null) {
            return null;
        }
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            model = mm.getExistingModelForRead(viewer.getDocument());
        }
        try {
            block9: {
                int lastOffset;
                block8: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block8;
                    if (node != null) return node;
                    if (lastOffset < 0) break block9;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static IStructuredDocumentRegion getStructuredDocumentRegion(ITextViewer viewer, int documentOffset) {
        IStructuredDocumentRegion sdRegion = null;
        if (viewer == null || viewer.getDocument() == null) {
            return null;
        }
        int lastOffset = documentOffset;
        IStructuredDocument doc = (IStructuredDocument)viewer.getDocument();
        sdRegion = doc.getRegionAtCharacterOffset(documentOffset);
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = doc.getRegionAtCharacterOffset(--lastOffset);
        }
        return sdRegion;
    }

    public static Bundle getBundle(IConfigurationElement element) {
        String namespace = element.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    public static void checkExtensionAttributeNotNull(Object value, String attribute, IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        if (value == null) {
            String message = "The extension \"" + element.getDeclaringExtension().getUniqueIdentifier() + "\" from plug-in \"" + element.getContributor().getName() + "\" did not specify a value for the required \"" + attribute + "\" attribute for the element \"" + element.getName() + "\". Disabling the extension.";
            Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    public static boolean isViewerEmpty(ITextViewer textViewer) {
        boolean isEmpty = false;
        String text = textViewer.getTextWidget().getText();
        if (text == null || text != null && text.trim().equals("")) {
            isEmpty = true;
        }
        return isEmpty;
    }
}

