/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTableViewer;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractVirtualContentTableModel;
import org.eclipse.debug.internal.ui.views.memory.renderings.IContentChangeComputer;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class TableRenderingModel
extends AbstractVirtualContentTableModel
implements IContentChangeComputer {
    private final Hashtable<Object, Object> fCache = new Hashtable();
    private final Vector<Object> fOrderedCache = new Vector();
    private boolean fMBSupportsChangeManagement;
    private IMemoryBlock fMemoryBlock;

    public TableRenderingModel(AsynchronousTableViewer viewer) {
        super(viewer);
    }

    @Override
    public int indexOfKey(Object key) {
        if (key instanceof BigInteger) {
            BigInteger address = (BigInteger)key;
            Object[] items = this.getElements();
            int i = 0;
            while (i < items.length) {
                MemorySegment line;
                if (items[i] != null && items[i] instanceof MemorySegment && (line = (MemorySegment)((Object)items[i])).containsAddress(address)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int columnOf(Object element, Object key) {
        BigInteger address;
        MemorySegment line;
        if (element instanceof MemorySegment && key instanceof BigInteger && (line = (MemorySegment)((Object)element)).containsAddress(address = (BigInteger)key) && this.getAddressableUnitsPerColumn() > 0) {
            BigInteger offset = address.subtract(line.getAddress());
            int colAddressableUnit = this.getAddressableUnitsPerColumn();
            int col = offset.intValue() / colAddressableUnit + 1;
            if (col == 0) {
                col = 1;
            }
            return col;
        }
        return -1;
    }

    @Override
    public Object getKey(int idx) {
        Object elmt = this.getElement(idx);
        if (elmt instanceof MemorySegment) {
            return ((MemorySegment)((Object)elmt)).getAddress();
        }
        return null;
    }

    @Override
    public Object getKey(Object element) {
        int idx = this.indexOfElement(element);
        if (idx >= 0) {
            return this.getKey(idx);
        }
        return null;
    }

    @Override
    public Object getKey(int idx, int col) {
        Object element = this.getElement(idx);
        if (element != null && element instanceof MemorySegment) {
            int offset;
            MemorySegment segment = (MemorySegment)((Object)element);
            BigInteger rowAddress = segment.getAddress();
            if (col > 0) {
                int addressableUnit = this.getAddressableUnitsPerColumn();
                offset = (col - 1) * addressableUnit;
            } else {
                offset = 0;
            }
            return rowAddress.add(BigInteger.valueOf(offset));
        }
        return null;
    }

    private int getAddressableUnitsPerColumn() {
        MemoryViewPresentationContext context;
        AsynchronousTableViewer viewer = this.getTableViewer();
        if (viewer.getPresentationContext() instanceof MemoryViewPresentationContext && this.getTableRendering(context = (MemoryViewPresentationContext)viewer.getPresentationContext()) != null) {
            return this.getTableRendering(context).getAddressableUnitPerColumn();
        }
        return -1;
    }

    @Override
    public void cache(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof MemorySegment) {
                this.cache(((MemorySegment)((Object)obj)).getAddress(), obj);
            }
            ++n2;
        }
    }

    private void cache(Object key, Object element) {
        this.fCache.put(key, element);
        this.fOrderedCache.add(element);
    }

    @Override
    public Object[] compare(Object[] newElements) {
        if (this.fCache.isEmpty()) {
            return newElements;
        }
        Object[] objectArray = newElements;
        int n = newElements.length;
        int n2 = 0;
        while (n2 < n) {
            MemorySegment newSegment;
            MemorySegment oldSegment;
            Object obj = objectArray[n2];
            if (obj instanceof MemorySegment && (oldSegment = (MemorySegment)((Object)this.fCache.get((newSegment = (MemorySegment)((Object)obj)).getAddress()))) != null && oldSegment.getNumAddressableUnits() == newSegment.getNumAddressableUnits()) {
                MemoryByte[] newBytes = newSegment.getBytes();
                MemoryByte[] oldBytes = oldSegment.getBytes();
                int i = 0;
                while (i < newBytes.length) {
                    newBytes[i].setHistoryKnown(true);
                    if (newBytes[i].isReadable() != oldBytes[i].isReadable()) {
                        newBytes[i].setChanged(true);
                    } else if (newBytes[i].isReadable() && oldBytes[i].isReadable() && newBytes[i].getValue() != oldBytes[i].getValue()) {
                        newBytes[i].setChanged(true);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return newElements;
    }

    @Override
    public void clearCache() {
        this.fCache.clear();
        this.fOrderedCache.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fCache.isEmpty();
    }

    @Override
    public void handleViewerChanged() {
        this.rebuildCache();
        this.rebuildContent();
    }

    private void rebuildCache() {
        MemorySegment[] newSegments;
        if (this.isEmpty()) {
            return;
        }
        MemoryViewPresentationContext context = (MemoryViewPresentationContext)this.getTableViewer().getPresentationContext();
        AbstractAsyncTableRendering rendering = this.getTableRendering(context);
        if (rendering == null) {
            return;
        }
        ArrayList<Object> segments = new ArrayList<Object>();
        Enumeration<Object> enumeration = this.fOrderedCache.elements();
        BigInteger address = ((MemorySegment)((Object)this.fOrderedCache.get(0))).getAddress();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof MemorySegment)) continue;
            segments.add(element);
        }
        MemoryByte[] bytes = this.convertSegmentsToBytes(segments.toArray(new MemorySegment[0]));
        int bytesPerLine = rendering.getBytesPerLine();
        int numAddressableUnitPerLine = rendering.getAddressableUnitPerLine();
        int addressableSize = rendering.getAddressableSize();
        this.clearCache();
        TableRenderingContentDescriptor descriptor = rendering.getAdapter(TableRenderingContentDescriptor.class);
        boolean alignAddress = true;
        if (descriptor != null && !descriptor.isAlignAddressToBoundary()) {
            alignAddress = descriptor.isAlignAddressToBoundary();
        }
        MemorySegment[] memorySegmentArray = newSegments = this.convertMemoryBytesToSegments(address, bytes, bytesPerLine, numAddressableUnitPerLine, addressableSize, alignAddress);
        int n = newSegments.length;
        int n2 = 0;
        while (n2 < n) {
            MemorySegment newSegment = memorySegmentArray[n2];
            this.cache(newSegment.getAddress(), (Object)newSegment);
            ++n2;
        }
    }

    private void rebuildContent() {
        Object[] elements;
        MemoryViewPresentationContext context = (MemoryViewPresentationContext)this.getTableViewer().getPresentationContext();
        AbstractAsyncTableRendering rendering = this.getTableRendering(context);
        if (rendering == null) {
            return;
        }
        ArrayList<Object> segments = new ArrayList<Object>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof MemorySegment) {
                segments.add(element);
            }
            ++n2;
        }
        MemoryByte[] bytes = this.convertSegmentsToBytes(segments.toArray(new MemorySegment[segments.size()]));
        int bytesPerLine = rendering.getBytesPerLine();
        int numAddressableUnitPerLine = rendering.getAddressableUnitPerLine();
        BigInteger address = (BigInteger)this.getKey(0);
        if (address == null) {
            return;
        }
        int addressableSize = rendering.getAddressableSize();
        TableRenderingContentDescriptor descriptor = rendering.getAdapter(TableRenderingContentDescriptor.class);
        boolean alignAddress = true;
        if (descriptor != null && !descriptor.isAlignAddressToBoundary()) {
            alignAddress = descriptor.isAlignAddressToBoundary();
        }
        MemorySegment[] newSegments = this.convertMemoryBytesToSegments(address, bytes, bytesPerLine, numAddressableUnitPerLine, addressableSize, alignAddress);
        this.remove(this.getElements());
        this.add((Object[])newSegments);
    }

    private MemoryByte[] convertSegmentsToBytes(MemorySegment[] segments) {
        ArrayList toReturn = new ArrayList();
        MemorySegment[] memorySegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            MemorySegment segment = memorySegmentArray[n2];
            MemoryByte[] temp = segment.getBytes();
            Collections.addAll(toReturn, temp);
            ++n2;
        }
        return toReturn.toArray(new MemoryByte[0]);
    }

    private MemorySegment[] convertMemoryBytesToSegments(BigInteger address, MemoryByte[] bytes, int bytesPerLine, int numAddressableUnitPerLine, int addressableSize, boolean alignAddress) {
        BigInteger unitsToSetBack;
        BigInteger tempAddress;
        BigInteger alignedAddress;
        Assert.isTrue((bytesPerLine > 0 ? 1 : 0) != 0);
        Assert.isTrue((numAddressableUnitPerLine > 0 ? 1 : 0) != 0);
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
        MemoryByte[] temp = bytes;
        if (alignAddress && !address.subtract(alignedAddress = MemoryViewUtil.alignToBoundary(address, numAddressableUnitPerLine)).equals(BigInteger.ZERO) && (tempAddress = address.subtract(unitsToSetBack = address.subtract(alignedAddress))).compareTo(BigInteger.ZERO) >= 0) {
            address = alignedAddress;
            int numBytesNeeded = unitsToSetBack.intValue() * addressableSize;
            temp = new MemoryByte[bytes.length + numBytesNeeded];
            int i = 0;
            while (i < numBytesNeeded) {
                temp[i] = new MemoryByte();
                temp[i].setReadable(false);
                temp[i].setWritable(false);
                temp[i].setEndianessKnown(false);
                ++i;
            }
            System.arraycopy(bytes, 0, temp, numBytesNeeded, bytes.length);
            bytes = temp;
        }
        if (bytes.length % bytesPerLine != 0) {
            int numBytesNeeded = bytesPerLine - bytes.length % bytesPerLine;
            temp = new MemoryByte[bytes.length + numBytesNeeded];
            System.arraycopy(bytes, 0, temp, 0, bytes.length);
            int i = bytes.length;
            while (i < temp.length) {
                temp[i] = new MemoryByte();
                temp[i].setReadable(false);
                temp[i].setWritable(false);
                temp[i].setEndianessKnown(false);
                ++i;
            }
            bytes = temp;
        }
        int idx = 0;
        while (idx < bytes.length && idx + bytesPerLine <= bytes.length) {
            MemoryByte[] newBytes = new MemoryByte[bytesPerLine];
            System.arraycopy(bytes, idx, newBytes, 0, bytesPerLine);
            MemorySegment segment = new MemorySegment(address, newBytes, numAddressableUnitPerLine);
            segments.add(segment);
            address = address.add(BigInteger.valueOf(numAddressableUnitPerLine));
            idx += bytesPerLine;
        }
        return segments.toArray(new MemorySegment[segments.size()]);
    }

    private AsynchronousTableViewer getTableViewer() {
        return (AsynchronousTableViewer)this.getViewer();
    }

    @Override
    protected void setChildren(ModelNode parentNode, List<Object> kids) {
        if (this.computeChanges()) {
            Object[] newContent = this.compare(kids.toArray());
            ArrayList<Object> newList = new ArrayList<Object>();
            Collections.addAll(newList, newContent);
            super.setChildren(parentNode, newList);
        } else {
            super.setChildren(parentNode, kids);
        }
    }

    private boolean computeChanges() {
        if (this.isEmpty()) {
            return false;
        }
        return !this.fMBSupportsChangeManagement;
    }

    private IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    @Override
    public void init(Object root) {
        if (root instanceof IMemoryBlock) {
            this.fMemoryBlock = (IMemoryBlock)root;
            new SupportsChangeMgmtJob().schedule();
        }
        super.init(root);
    }

    private AbstractAsyncTableRendering getTableRendering(MemoryViewPresentationContext context) {
        IMemoryRendering memRendering = context.getRendering();
        if (memRendering != null && memRendering instanceof AbstractAsyncTableRendering) {
            return (AbstractAsyncTableRendering)memRendering;
        }
        return null;
    }

    class SupportsChangeMgmtJob
    extends Job {
        SupportsChangeMgmtJob() {
            super("Support Change Management");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IMemoryBlock mb = TableRenderingModel.this.getMemoryBlock();
            if (mb instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension mbExt = (IMemoryBlockExtension)mb;
                TableRenderingModel.this.fMBSupportsChangeManagement = mbExt.supportsChangeManagement();
            }
            return Status.OK_STATUS;
        }
    }
}

