/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class CreateLaunchConfigurationPrototypeAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_CREATE_PROTOTYPE_ACTION = DebugUIPlugin.getUniqueIdentifier() + ".ID_CREATE_PROTOTYPE_ACTION";

    public CreateLaunchConfigurationPrototypeAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.CreateLaunchConfigurationPrototypeAction_Ne_w_1, viewer, mode);
    }

    @Override
    protected void performAction() {
        Object object = this.getStructuredSelection().getFirstElement();
        if (object != null) {
            ILaunchConfigurationType type = null;
            if (object instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)object;
                try {
                    type = config.getType();
                }
                catch (CoreException e) {
                    this.errorDialog(e);
                    return;
                }
            } else {
                type = (ILaunchConfigurationType)object;
            }
            try {
                ILaunchConfigurationTab[] tabs;
                ILaunchConfigurationWorkingCopy wc = type.newPrototypeInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(LaunchConfigurationsMessages.CreateLaunchConfigurationPrototypeAction_New_prototype_2));
                ILaunchConfigurationTabGroup tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)wc, this.getMode());
                ILaunchConfigurationDialog dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
                tabGroup.createTabs(dialog, dialog.getMode());
                ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = tabGroup.getTabs();
                int n = tabs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                    tab.setLaunchConfigurationDialog(dialog);
                    ++n2;
                }
                tabGroup.setDefaults(wc);
                tabGroup.dispose();
                wc.doSave();
            }
            catch (CoreException e) {
                this.errorDialog(e);
                return;
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object object;
        if (selection.size() == 1 && (object = this.getStructuredSelection().getFirstElement()) != null) {
            ILaunchConfigurationType type = null;
            if (object instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)object;
                try {
                    type = config.getType();
                }
                catch (CoreException e) {
                    this.errorDialog(e);
                }
            } else {
                type = (ILaunchConfigurationType)object;
            }
            if (type != null) {
                return type.supportsPrototypes();
            }
        }
        return false;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_DLCL_NEW_PROTO");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_ELCL_NEW_PROTO");
    }

    public String getToolTipText() {
        return LaunchConfigurationsMessages.LaunchConfigurationsDialog_2;
    }
}

