/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

/*
 * generated by Xtext 2.36.0
 */
package org.eclipse.trace4cps.tl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.trace4cps.tl.etl.AndOrFormula;
import org.eclipse.trace4cps.tl.etl.ApFormula;
import org.eclipse.trace4cps.tl.etl.AttributeFilter;
import org.eclipse.trace4cps.tl.etl.Check;
import org.eclipse.trace4cps.tl.etl.ConvSpec;
import org.eclipse.trace4cps.tl.etl.Def;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.EtlPackage;
import org.eclipse.trace4cps.tl.etl.FinallyFormula;
import org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.GloballyFormula;
import org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.IdString;
import org.eclipse.trace4cps.tl.etl.IfThenFormula;
import org.eclipse.trace4cps.tl.etl.Interval;
import org.eclipse.trace4cps.tl.etl.IntervalNN;
import org.eclipse.trace4cps.tl.etl.IntervalNS;
import org.eclipse.trace4cps.tl.etl.IntervalSN;
import org.eclipse.trace4cps.tl.etl.IntervalSS;
import org.eclipse.trace4cps.tl.etl.KeyVal;
import org.eclipse.trace4cps.tl.etl.LatencySignal;
import org.eclipse.trace4cps.tl.etl.MtlAp;
import org.eclipse.trace4cps.tl.etl.MtlApEnd;
import org.eclipse.trace4cps.tl.etl.MtlApStart;
import org.eclipse.trace4cps.tl.etl.NotFormula;
import org.eclipse.trace4cps.tl.etl.ReferenceFormula;
import org.eclipse.trace4cps.tl.etl.ResourceAmountSignal;
import org.eclipse.trace4cps.tl.etl.ResourceClientSignal;
import org.eclipse.trace4cps.tl.etl.SignalDef;
import org.eclipse.trace4cps.tl.etl.StlAp;
import org.eclipse.trace4cps.tl.etl.StlApDeriv;
import org.eclipse.trace4cps.tl.etl.ThroughputSignal;
import org.eclipse.trace4cps.tl.etl.TraceSignal;
import org.eclipse.trace4cps.tl.etl.UntilFormula;
import org.eclipse.trace4cps.tl.etl.UntilUntimedFormula;
import org.eclipse.trace4cps.tl.etl.WipSignal;
import org.eclipse.trace4cps.tl.services.EtlGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class EtlSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private EtlGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == EtlPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case EtlPackage.AND_OR_FORMULA:
				sequence_Formula(context, (AndOrFormula) semanticObject); 
				return; 
			case EtlPackage.AP_FORMULA:
				sequence_Formula(context, (ApFormula) semanticObject); 
				return; 
			case EtlPackage.ATTRIBUTE_FILTER:
				sequence_AttributeFilter(context, (AttributeFilter) semanticObject); 
				return; 
			case EtlPackage.CHECK:
				sequence_TopLevelModelElement(context, (Check) semanticObject); 
				return; 
			case EtlPackage.CONV_SPEC:
				sequence_ConvSpec(context, (ConvSpec) semanticObject); 
				return; 
			case EtlPackage.DEF:
				sequence_TopLevelModelElement(context, (Def) semanticObject); 
				return; 
			case EtlPackage.ETL_MODEL:
				sequence_EtlModel(context, (EtlModel) semanticObject); 
				return; 
			case EtlPackage.FINALLY_FORMULA:
				sequence_Formula(context, (FinallyFormula) semanticObject); 
				return; 
			case EtlPackage.FINALLY_UNTIMED_FORMULA:
				sequence_Formula(context, (FinallyUntimedFormula) semanticObject); 
				return; 
			case EtlPackage.GLOBALLY_FORMULA:
				sequence_Formula(context, (GloballyFormula) semanticObject); 
				return; 
			case EtlPackage.GLOBALLY_UNTIMED_FORMULA:
				sequence_Formula(context, (GloballyUntimedFormula) semanticObject); 
				return; 
			case EtlPackage.ID_STRING:
				sequence_IdString(context, (IdString) semanticObject); 
				return; 
			case EtlPackage.IF_THEN_FORMULA:
				sequence_Formula(context, (IfThenFormula) semanticObject); 
				return; 
			case EtlPackage.INTERVAL:
				sequence_Interval(context, (Interval) semanticObject); 
				return; 
			case EtlPackage.INTERVAL_NN:
				sequence_IntervalNN(context, (IntervalNN) semanticObject); 
				return; 
			case EtlPackage.INTERVAL_NS:
				sequence_IntervalNS(context, (IntervalNS) semanticObject); 
				return; 
			case EtlPackage.INTERVAL_SN:
				sequence_IntervalSN(context, (IntervalSN) semanticObject); 
				return; 
			case EtlPackage.INTERVAL_SS:
				sequence_IntervalSS(context, (IntervalSS) semanticObject); 
				return; 
			case EtlPackage.KEY_VAL:
				sequence_KeyVal(context, (KeyVal) semanticObject); 
				return; 
			case EtlPackage.LATENCY_SIGNAL:
				sequence_Signal(context, (LatencySignal) semanticObject); 
				return; 
			case EtlPackage.MTL_AP:
				sequence_MtlAp(context, (MtlAp) semanticObject); 
				return; 
			case EtlPackage.MTL_AP_END:
				sequence_MtlAp(context, (MtlApEnd) semanticObject); 
				return; 
			case EtlPackage.MTL_AP_START:
				sequence_MtlAp(context, (MtlApStart) semanticObject); 
				return; 
			case EtlPackage.NOT_FORMULA:
				sequence_Formula(context, (NotFormula) semanticObject); 
				return; 
			case EtlPackage.REFERENCE_FORMULA:
				sequence_Formula(context, (ReferenceFormula) semanticObject); 
				return; 
			case EtlPackage.RESOURCE_AMOUNT_SIGNAL:
				sequence_Signal(context, (ResourceAmountSignal) semanticObject); 
				return; 
			case EtlPackage.RESOURCE_CLIENT_SIGNAL:
				sequence_Signal(context, (ResourceClientSignal) semanticObject); 
				return; 
			case EtlPackage.SIGNAL_DEF:
				sequence_TopLevelModelElement(context, (SignalDef) semanticObject); 
				return; 
			case EtlPackage.STL_AP:
				sequence_StlAp(context, (StlAp) semanticObject); 
				return; 
			case EtlPackage.STL_AP_DERIV:
				sequence_StlAp(context, (StlApDeriv) semanticObject); 
				return; 
			case EtlPackage.THROUGHPUT_SIGNAL:
				sequence_Signal(context, (ThroughputSignal) semanticObject); 
				return; 
			case EtlPackage.TRACE_SIGNAL:
				sequence_Signal(context, (TraceSignal) semanticObject); 
				return; 
			case EtlPackage.UNTIL_FORMULA:
				sequence_Formula(context, (UntilFormula) semanticObject); 
				return; 
			case EtlPackage.UNTIL_UNTIMED_FORMULA:
				sequence_Formula(context, (UntilUntimedFormula) semanticObject); 
				return; 
			case EtlPackage.WIP_SIGNAL:
				sequence_Signal(context, (WipSignal) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     AttributeFilter returns AttributeFilter
	 *
	 * Constraint:
	 *     (keyVals+=KeyVal keyVals+=KeyVal*)
	 * </pre>
	 */
	protected void sequence_AttributeFilter(ISerializationContext context, AttributeFilter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     ConvSpec returns ConvSpec
	 *
	 * Constraint:
	 *     (windowWidth=DOUBLE_T windowUnit=TimeUnitEnum)
	 * </pre>
	 */
	protected void sequence_ConvSpec(ISerializationContext context, ConvSpec semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.CONV_SPEC__WINDOW_WIDTH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.CONV_SPEC__WINDOW_WIDTH));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.CONV_SPEC__WINDOW_UNIT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.CONV_SPEC__WINDOW_UNIT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConvSpecAccess().getWindowWidthDOUBLE_TTerminalRuleCall_1_0(), semanticObject.getWindowWidth());
		feeder.accept(grammarAccess.getConvSpecAccess().getWindowUnitTimeUnitEnumEnumRuleCall_2_0(), semanticObject.getWindowUnit());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EtlModel returns EtlModel
	 *
	 * Constraint:
	 *     elements+=TopLevelModelElement+
	 * </pre>
	 */
	protected void sequence_EtlModel(ISerializationContext context, EtlModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns AndOrFormula
	 *
	 * Constraint:
	 *     (left=Formula op=AndOr right=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, AndOrFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__LEFT));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__OP));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.AND_OR_FORMULA__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_4_2_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getFormulaAccess().getOpAndOrEnumRuleCall_4_3_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_4_4_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns ApFormula
	 *
	 * Constraint:
	 *     (mtlAP=MtlAp | stlAP=StlAp)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, ApFormula semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns FinallyFormula
	 *
	 * Constraint:
	 *     (interval=Interval formula=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, FinallyFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.FINALLY_FORMULA__INTERVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.FINALLY_FORMULA__INTERVAL));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.FINALLY_FORMULA__FORMULA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.FINALLY_FORMULA__FORMULA));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_9_2_0(), semanticObject.getInterval());
		feeder.accept(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_9_3_0(), semanticObject.getFormula());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns FinallyUntimedFormula
	 *
	 * Constraint:
	 *     formula=Formula
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, FinallyUntimedFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.FINALLY_UNTIMED_FORMULA__FORMULA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.FINALLY_UNTIMED_FORMULA__FORMULA));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_8_2_0(), semanticObject.getFormula());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns GloballyFormula
	 *
	 * Constraint:
	 *     (interval=Interval formula=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, GloballyFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.GLOBALLY_FORMULA__INTERVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.GLOBALLY_FORMULA__INTERVAL));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.GLOBALLY_FORMULA__FORMULA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.GLOBALLY_FORMULA__FORMULA));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_7_2_0(), semanticObject.getInterval());
		feeder.accept(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_7_3_0(), semanticObject.getFormula());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns GloballyUntimedFormula
	 *
	 * Constraint:
	 *     formula=Formula
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, GloballyUntimedFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.GLOBALLY_UNTIMED_FORMULA__FORMULA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.GLOBALLY_UNTIMED_FORMULA__FORMULA));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_6_2_0(), semanticObject.getFormula());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns IfThenFormula
	 *
	 * Constraint:
	 *     (left=Formula right=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, IfThenFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.IF_THEN_FORMULA__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.IF_THEN_FORMULA__LEFT));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.IF_THEN_FORMULA__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.IF_THEN_FORMULA__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_5_2_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_5_4_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns NotFormula
	 *
	 * Constraint:
	 *     formula=Formula
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, NotFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.NOT_FORMULA__FORMULA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.NOT_FORMULA__FORMULA));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getFormulaFormulaParserRuleCall_3_2_0(), semanticObject.getFormula());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns ReferenceFormula
	 *
	 * Constraint:
	 *     (def=[Def|ID] (param=ID val=INT_T?)?)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, ReferenceFormula semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns UntilFormula
	 *
	 * Constraint:
	 *     (interval=Interval right=Formula left=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, UntilFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__INTERVAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__INTERVAL));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__RIGHT));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.UNTIL_FORMULA__LEFT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getIntervalIntervalParserRuleCall_11_2_0(), semanticObject.getInterval());
		feeder.accept(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_11_3_0(), semanticObject.getRight());
		feeder.accept(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_11_7_0(), semanticObject.getLeft());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Formula returns UntilUntimedFormula
	 *
	 * Constraint:
	 *     (right=Formula left=Formula)
	 * </pre>
	 */
	protected void sequence_Formula(ISerializationContext context, UntilUntimedFormula semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.UNTIL_UNTIMED_FORMULA__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.UNTIL_UNTIMED_FORMULA__RIGHT));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.UNTIL_UNTIMED_FORMULA__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.UNTIL_UNTIMED_FORMULA__LEFT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFormulaAccess().getRightFormulaParserRuleCall_10_2_0(), semanticObject.getRight());
		feeder.accept(grammarAccess.getFormulaAccess().getLeftFormulaParserRuleCall_10_6_0(), semanticObject.getLeft());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     IdString returns IdString
	 *
	 * Constraint:
	 *     (left=STRING | id=ID | (left=STRING id=ID) | (id=ID right=STRING) | (left=STRING id=ID right=STRING))
	 * </pre>
	 */
	protected void sequence_IdString(ISerializationContext context, IdString semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     IntervalNN returns IntervalNN
	 *
	 * Constraint:
	 *     (lb=DOUBLE_T ub=DOUBLE_T)
	 * </pre>
	 */
	protected void sequence_IntervalNN(ISerializationContext context, IntervalNN semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.INTERVAL_NN__LB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.INTERVAL_NN__LB));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.INTERVAL_NN__UB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.INTERVAL_NN__UB));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntervalNNAccess().getLbDOUBLE_TTerminalRuleCall_1_0(), semanticObject.getLb());
		feeder.accept(grammarAccess.getIntervalNNAccess().getUbDOUBLE_TTerminalRuleCall_3_0(), semanticObject.getUb());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     IntervalNS returns IntervalNS
	 *
	 * Constraint:
	 *     (lb=DOUBLE_T (ub=DOUBLE_T | infty='Infty'))
	 * </pre>
	 */
	protected void sequence_IntervalNS(ISerializationContext context, IntervalNS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     IntervalSN returns IntervalSN
	 *
	 * Constraint:
	 *     (lb=DOUBLE_T ub=DOUBLE_T)
	 * </pre>
	 */
	protected void sequence_IntervalSN(ISerializationContext context, IntervalSN semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.INTERVAL_SN__LB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.INTERVAL_SN__LB));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.INTERVAL_SN__UB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.INTERVAL_SN__UB));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntervalSNAccess().getLbDOUBLE_TTerminalRuleCall_1_0(), semanticObject.getLb());
		feeder.accept(grammarAccess.getIntervalSNAccess().getUbDOUBLE_TTerminalRuleCall_3_0(), semanticObject.getUb());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     IntervalSS returns IntervalSS
	 *
	 * Constraint:
	 *     (lb=DOUBLE_T (ub=DOUBLE_T | infty='Infty'))
	 * </pre>
	 */
	protected void sequence_IntervalSS(ISerializationContext context, IntervalSS semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Interval returns Interval
	 *
	 * Constraint:
	 *     ((iss=IntervalSS | isn=IntervalSN | ins=IntervalNS | inn=IntervalNN) timeUnit=TimeUnitEnum)
	 * </pre>
	 */
	protected void sequence_Interval(ISerializationContext context, Interval semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     KeyVal returns KeyVal
	 *
	 * Constraint:
	 *     (att=IdString val=IdString)
	 * </pre>
	 */
	protected void sequence_KeyVal(ISerializationContext context, KeyVal semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.KEY_VAL__ATT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.KEY_VAL__ATT));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.KEY_VAL__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.KEY_VAL__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getKeyValAccess().getAttIdStringParserRuleCall_0_0(), semanticObject.getAtt());
		feeder.accept(grammarAccess.getKeyValAccess().getValIdStringParserRuleCall_2_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     MtlAp returns MtlAp
	 *
	 * Constraint:
	 *     filter=AttributeFilter
	 * </pre>
	 */
	protected void sequence_MtlAp(ISerializationContext context, MtlAp semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.MTL_AP__FILTER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.MTL_AP__FILTER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0(), semanticObject.getFilter());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     MtlAp returns MtlApEnd
	 *
	 * Constraint:
	 *     filter=AttributeFilter
	 * </pre>
	 */
	protected void sequence_MtlAp(ISerializationContext context, MtlApEnd semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.MTL_AP__FILTER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.MTL_AP__FILTER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0(), semanticObject.getFilter());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     MtlAp returns MtlApStart
	 *
	 * Constraint:
	 *     filter=AttributeFilter
	 * </pre>
	 */
	protected void sequence_MtlAp(ISerializationContext context, MtlApStart semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.MTL_AP__FILTER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.MTL_AP__FILTER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMtlApAccess().getFilterAttributeFilterParserRuleCall_1_0(), semanticObject.getFilter());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns LatencySignal
	 *
	 * Constraint:
	 *     (idAtt=ID scale=TimeUnitEnum? convSpec=ConvSpec?)
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, LatencySignal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns ResourceAmountSignal
	 *
	 * Constraint:
	 *     (filter=AttributeFilter convSpec=ConvSpec?)
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, ResourceAmountSignal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns ResourceClientSignal
	 *
	 * Constraint:
	 *     (filter=AttributeFilter convSpec=ConvSpec?)
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, ResourceClientSignal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns ThroughputSignal
	 *
	 * Constraint:
	 *     ((idAtt=ID | ap=MtlAp) scale=TimeUnitEnum? convSpec=ConvSpec?)
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, ThroughputSignal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns TraceSignal
	 *
	 * Constraint:
	 *     filter=AttributeFilter
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, TraceSignal semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.TRACE_SIGNAL__FILTER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.TRACE_SIGNAL__FILTER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSignalAccess().getFilterAttributeFilterParserRuleCall_0_1_0(), semanticObject.getFilter());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Signal returns WipSignal
	 *
	 * Constraint:
	 *     (idAtt=ID convSpec=ConvSpec?)
	 * </pre>
	 */
	protected void sequence_Signal(ISerializationContext context, WipSignal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     StlAp returns StlAp
	 *
	 * Constraint:
	 *     (ref=[SignalDef|ID] compOp=CompOp val=DOUBLE_T)
	 * </pre>
	 */
	protected void sequence_StlAp(ISerializationContext context, StlAp semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__REF));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__COMP_OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__COMP_OP));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_0_0_1(), semanticObject.eGet(EtlPackage.Literals.STL_AP__REF, false));
		feeder.accept(grammarAccess.getStlApAccess().getCompOpCompOpEnumRuleCall_1_0(), semanticObject.getCompOp());
		feeder.accept(grammarAccess.getStlApAccess().getValDOUBLE_TTerminalRuleCall_2_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     StlAp returns StlApDeriv
	 *
	 * Constraint:
	 *     (ref=[SignalDef|ID] compOp=CompOp val=DOUBLE_T)
	 * </pre>
	 */
	protected void sequence_StlAp(ISerializationContext context, StlApDeriv semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__REF));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__COMP_OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__COMP_OP));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.STL_AP__VAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.STL_AP__VAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStlApAccess().getRefSignalDefIDTerminalRuleCall_0_1_2_0_1(), semanticObject.eGet(EtlPackage.Literals.STL_AP__REF, false));
		feeder.accept(grammarAccess.getStlApAccess().getCompOpCompOpEnumRuleCall_1_0(), semanticObject.getCompOp());
		feeder.accept(grammarAccess.getStlApAccess().getValDOUBLE_TTerminalRuleCall_2_0(), semanticObject.getVal());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TopLevelModelElement returns Check
	 *
	 * Constraint:
	 *     (name=ID (var=ID lb=INT_T ub=INT_T)? formula=Formula)
	 * </pre>
	 */
	protected void sequence_TopLevelModelElement(ISerializationContext context, Check semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TopLevelModelElement returns Def
	 *
	 * Constraint:
	 *     (name=ID param=ID? formula=Formula)
	 * </pre>
	 */
	protected void sequence_TopLevelModelElement(ISerializationContext context, Def semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     TopLevelModelElement returns SignalDef
	 *
	 * Constraint:
	 *     (name=ID signal=Signal)
	 * </pre>
	 */
	protected void sequence_TopLevelModelElement(ISerializationContext context, SignalDef semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.TOP_LEVEL_MODEL_ELEMENT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.TOP_LEVEL_MODEL_ELEMENT__NAME));
			if (transientValues.isValueTransient(semanticObject, EtlPackage.Literals.SIGNAL_DEF__SIGNAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EtlPackage.Literals.SIGNAL_DEF__SIGNAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getTopLevelModelElementAccess().getNameIDTerminalRuleCall_0_2_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getTopLevelModelElementAccess().getSignalSignalParserRuleCall_0_4_0(), semanticObject.getSignal());
		feeder.finish();
	}
	
	
}
