/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.analysis.stl.impl;

import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.core.IPsop;

public abstract class AbstractStlFormula implements StlFormula {
    private IPsop signal;

    @Override
    public double getRho() {
        if (signal == null) {
            signal = computeSignal();
        }
        return PsopHelper.getStartValue(signal).doubleValue();
    }

    @Override
    public IPsop getSignal() {
        if (signal == null) {
            signal = computeSignal();
        }
        return signal;
    }

    protected abstract IPsop computeSignal();
}
