/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.signal.SignalModifier;
import org.eclipse.trace4cps.analysis.signal.SignalUtil;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.dialog.ResourceClientHistogramDialog;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class ResourceUsageAction
extends AbstractTraceViewAction {
    public ResourceUsageAction(TraceView view) {
        super(view);
        this.setText("Resource-usage graph");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        ResourceClientHistogramDialog dialog = new ResourceClientHistogramDialog(this.view.getEditorSite().getShell(), this.view.getTrace().getResources(), false);
        if (dialog.open() == 1) {
            return;
        }
        double width = dialog.getPositiveDoubleValue();
        SignalModifier mod = SignalModifier.NONE;
        if (width != 0.0) {
            mod = new SignalModifier(1.0, width, TimeUnit.SECONDS);
        }
        String type = dialog.useAmount() ? "amount" : "#clients";
        for (IResource r : dialog.getSelected()) {
            IPsop p = dialog.useAmount() ? SignalUtil.getResourceAmount((ITrace)this.view.getTrace(), (IResource)r, (SignalModifier)mod) : SignalUtil.getResourceClients((ITrace)this.view.getTrace(), (IResource)r, (SignalModifier)mod);
            for (Map.Entry e : r.getAttributes().entrySet()) {
                p.setAttribute((String)e.getKey(), (String)e.getValue());
            }
            p.setAttribute("resource-usage type", type);
            p.setAttribute("convolution width", String.valueOf(Double.toString(dialog.getPositiveDoubleValue())) + " " + (Object)((Object)TimeUnit.SECONDS));
            this.view.addExtension(p, 0);
        }
        this.view.update();
    }
}

