/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.timing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.trace4cps.analysis.timing.StatisticsManager;
import org.eclipse.trace4cps.ui.view.ChartView;
import org.eclipse.trace4cps.ui.view.timing.LabeledNode;
import org.eclipse.trace4cps.ui.view.timing.RootNode;
import org.eclipse.trace4cps.ui.view.timing.SectionNode;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;

public class TimingAnalysisView
extends ViewPart
implements IDoubleClickListener {
    public static final String VIEW_ID = "org.eclipse.trace4cps.ui.view.timing.TimingAnalysisView";
    private TreeViewer viewer;
    private final List<RootNode> rootNodes = new ArrayList<RootNode>();

    public static void openView(final Map<String, Map<String, StatisticsManager>> timingData) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart view = page.showView(TimingAnalysisView.VIEW_ID);
                    TimingAnalysisView tav = (TimingAnalysisView)view;
                    tav.clearResult();
                    for (Map.Entry e : timingData.entrySet()) {
                        tav.addResult((String)e.getKey(), (Map)e.getValue());
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError(null, (String)"ETL Verification Error", (String)"Failed to update result view", (IStatus)e.getStatus());
                }
            }
        });
    }

    private void clearResult() {
        this.rootNodes.clear();
        this.viewer.setInput(new Object());
        this.viewer.refresh();
        this.viewer.expandToLevel(2);
    }

    private void addResult(String rootLabel, Map<String, StatisticsManager> timing) {
        this.rootNodes.add(new RootNode(rootLabel, timing));
        this.viewer.refresh();
        this.viewer.expandToLevel(2);
    }

    public void createPartControl(Composite c) {
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(c);
        this.viewer = new TreeViewer(c, 4);
        GridDataFactory.swtDefaults().applyTo((Control)this.viewer.getTree());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object sel = selection.getFirstElement();
        if (sel instanceof SectionNode) {
            if (this.rootNodes.size() == 1) {
                this.createHistogram(((SectionNode)sel).getLabel(), ((SectionNode)sel).getMgr());
            } else {
                this.createMultiHistogram(((SectionNode)sel).getLabel());
            }
        }
    }

    private void createHistogram(String key, StatisticsManager mgr) {
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        List timingData = mgr.getSamples();
        double[] data = timingData.stream().mapToDouble(Double::doubleValue).toArray();
        int bins = (int)Math.ceil(Math.sqrt(data.length));
        dataset.addSeries((Comparable)((Object)key), data, bins);
        PlotOrientation orientation = PlotOrientation.VERTICAL;
        String xLabel = "Time (" + mgr.getTimeUnit().toString().toLowerCase() + ")";
        JFreeChart hisChart = ChartFactory.createHistogram((String)key, (String)xLabel, (String)"Relative frequency", (IntervalXYDataset)dataset, (PlotOrientation)orientation, (boolean)false, (boolean)true, (boolean)false);
        hisChart.getXYPlot().setForegroundAlpha(0.5f);
        ChartView.showChart(hisChart, "Timing - " + key, "");
    }

    private void createMultiHistogram(String key) {
        HashMap<RootNode, SectionNode> histos = new HashMap<RootNode, SectionNode>();
        block0: for (RootNode r : this.rootNodes) {
            for (SectionNode sectionNode : r.getChildren()) {
                if (!key.equals(sectionNode.getLabel())) continue;
                histos.put(r, sectionNode);
                continue block0;
            }
        }
        HistogramDataset dataset = new HistogramDataset();
        dataset.setType(HistogramType.RELATIVE_FREQUENCY);
        Enum theTimeUnit = null;
        for (Map.Entry entry : histos.entrySet()) {
            String datasetKey = ((RootNode)entry.getKey()).getLabel();
            StatisticsManager mgr = ((SectionNode)entry.getValue()).getMgr();
            if (theTimeUnit == null) {
                theTimeUnit = mgr.getTimeUnit();
            } else if (theTimeUnit != mgr.getTimeUnit()) {
                mgr.scaleTo((TimeUnit)theTimeUnit);
            }
            double[] data = mgr.getSamples().stream().mapToDouble(Double::doubleValue).toArray();
            int bins = (int)Math.ceil(Math.sqrt(data.length));
            dataset.addSeries((Comparable)((Object)datasetKey), data, bins);
        }
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        String xLabel = "Time (" + theTimeUnit.toString().toLowerCase() + ")";
        JFreeChart hisChart = ChartFactory.createHistogram((String)key, (String)xLabel, (String)"Relative frequency", (IntervalXYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
        hisChart.getXYPlot().setForegroundAlpha(0.5f);
        ChartView.showChart(hisChart, "Timing - " + key, "");
    }

    private final class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof RootNode) {
                return ((RootNode)o).getChildren().toArray();
            }
            if (o instanceof SectionNode) {
                return ((SectionNode)o).getChildren().toArray();
            }
            if (o instanceof LabeledNode) {
                return ((LabeledNode)o).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object input) {
            return TimingAnalysisView.this.rootNodes.toArray();
        }

        public Object getParent(Object o) {
            if (o instanceof SectionNode) {
                return ((SectionNode)o).getParent();
            }
            if (o instanceof LabeledNode) {
                return ((LabeledNode)o).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object o) {
            if (o instanceof RootNode) {
                return !((RootNode)o).getChildren().isEmpty();
            }
            if (o instanceof SectionNode) {
                return !((SectionNode)o).getChildren().isEmpty();
            }
            if (o instanceof LabeledNode) {
                return !((LabeledNode)o).getChildren().isEmpty();
            }
            return false;
        }
    }

    private final class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object o) {
            return null;
        }

        public String getText(Object o) {
            if (o instanceof RootNode) {
                return ((RootNode)o).getLabel();
            }
            if (o instanceof SectionNode) {
                return ((SectionNode)o).getLabel();
            }
            if (o instanceof LabeledNode) {
                return ((LabeledNode)o).getLabel();
            }
            return o.toString();
        }
    }
}

