/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.stl.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.analysis.stl.impl.StlBinBool;
import org.eclipse.trace4cps.analysis.stl.impl.StlEq;
import org.eclipse.trace4cps.analysis.stl.impl.StlGeq;
import org.eclipse.trace4cps.analysis.stl.impl.StlLeq;
import org.eclipse.trace4cps.analysis.stl.impl.StlNeg;
import org.eclipse.trace4cps.analysis.stl.impl.StlTrue;
import org.eclipse.trace4cps.analysis.stl.impl.StlUntil;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.Shape;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.core.impl.Psop;
import org.eclipse.trace4cps.core.impl.PsopFragment;

public class STLUtil {
    private STLUtil() {
    }

    public static Set<StlFormula> getFormulas(StlFormula phi) {
        HashSet<StlFormula> r = new HashSet<StlFormula>();
        STLUtil.getFormulas(phi, r);
        return r;
    }

    private static void getFormulas(StlFormula phi, Set<StlFormula> r) {
        if (!(phi instanceof StlTrue)) {
            r.add(phi);
        }
        if (phi instanceof StlBinBool) {
            STLUtil.getFormulas(((StlBinBool)phi).getLeft(), r);
            STLUtil.getFormulas(((StlBinBool)phi).getRight(), r);
        } else if (!(phi instanceof StlEq || phi instanceof StlGeq || phi instanceof StlLeq)) {
            if (phi instanceof StlNeg) {
                STLUtil.getFormulas(((StlNeg)phi).getFormula(), r);
            } else if (phi instanceof StlUntil) {
                STLUtil.getFormulas(((StlUntil)phi).getLeft(), r);
                STLUtil.getFormulas(((StlUntil)phi).getRight(), r);
            }
        }
    }

    public static IPsop signal_greaterEqual(IPsop f, double c) {
        Psop r = new Psop();
        for (IPsopFragment frag : f.getFragments()) {
            r.add(new PsopFragment(frag.getC().doubleValue() - c, frag.getB(), frag.getA(), frag.dom()));
        }
        return r;
    }

    public static IPsop signal_lessEqual(IPsop f, double c) {
        Psop r = new Psop();
        for (IPsopFragment frag : f.getFragments()) {
            r.add(new PsopFragment(c - frag.getC().doubleValue(), -frag.getB().doubleValue(), -frag.getA().doubleValue(), frag.dom()));
        }
        return r;
    }

    public static IPsop signal_equal(IPsop f, double c) {
        IPsop f1 = STLUtil.signal_greaterEqual(f, c);
        IPsop f2 = STLUtil.signal_lessEqual(f, c);
        return STLUtil.signalAnd(f1, f2);
    }

    public static Psop signalNegate(IPsop f) {
        Psop r = new Psop();
        for (IPsopFragment frag : f.getFragments()) {
            r.add(new PsopFragment(-frag.getC().doubleValue(), -frag.getB().doubleValue(), -frag.getA().doubleValue(), frag.dom()));
        }
        return r;
    }

    public static IPsop signalImply(IPsop f1, IPsop f2) {
        Psop notf2 = STLUtil.signalNegate(f2);
        IPsop f1andnotf2 = STLUtil.signalAnd(f1, notf2);
        return STLUtil.signalNegate(f1andnotf2);
    }

    public static IPsop signalAnd(IPsop f1, IPsop f2) {
        return STLUtil.signalAndOr(f1, f2, true);
    }

    public static Psop signalOr(IPsop f1, IPsop f2) {
        return STLUtil.signalAndOr(f1, f2, false);
    }

    private static Psop signalAndOr(IPsop f1, IPsop f2, boolean applyMin) {
        Psop r = new Psop();
        Psop g1 = PsopHelper.copy(f1);
        PsopHelper.alignWith(g1, f2);
        Psop g2 = PsopHelper.copy(f2);
        PsopHelper.alignWith(g2, f1);
        int i = 0;
        while (i < g1.getFragments().size()) {
            IPsopFragment frag1 = g1.getFragments().get(i);
            IPsopFragment frag2 = g2.getFragments().get(i);
            STLUtil.signalAndOr(r, frag1, frag2, applyMin);
            ++i;
        }
        return r;
    }

    private static void signalAndOr(Psop r, IPsopFragment frag1, IPsopFragment frag2, boolean applyMin) {
        List<Double> intersects = PsopHelper.computeIntersections(frag1, frag2);
        if (intersects.size() == 0) {
            if (frag1.getC().doubleValue() < frag2.getC().doubleValue() == applyMin) {
                r.add(PsopHelper.copy(frag1));
            } else {
                r.add(PsopHelper.copy(frag2));
            }
        } else if (intersects.size() == 1) {
            STLUtil.splitSingleIntersection(r, intersects.get(0), frag1, frag2, applyMin);
        } else if (intersects.size() == 2) {
            Collections.sort(intersects);
            STLUtil.splitDoubleIntersection(r, intersects.get(0), intersects.get(1), frag1, frag2, applyMin);
        } else {
            throw new IllegalStateException();
        }
    }

    private static void splitSingleIntersection(Psop r, double tSplit, IPsopFragment frag1, IPsopFragment frag2, boolean applyMin) {
        if (tSplit == frag1.dom().lb().doubleValue()) {
            double size = frag1.dom().ub().doubleValue() - frag1.dom().lb().doubleValue();
            double tHalfway = frag1.dom().lb().doubleValue() + 0.5 * size;
            if (PsopHelper.valueAt(frag1, (Number)tHalfway).doubleValue() < PsopHelper.valueAt(frag2, (Number)tHalfway).doubleValue() == applyMin) {
                r.add(PsopHelper.copy(frag1));
            } else {
                r.add(PsopHelper.copy(frag2));
            }
        } else if (frag1.getC().doubleValue() < frag2.getC().doubleValue() == applyMin) {
            STLUtil.split(r, tSplit, frag1, frag2);
        } else {
            STLUtil.split(r, tSplit, frag2, frag1);
        }
    }

    private static void splitDoubleIntersection(Psop r, double tSplit1, double tSplit2, IPsopFragment frag1, IPsopFragment frag2, boolean applyMin) {
        if (tSplit1 == frag1.dom().lb().doubleValue()) {
            STLUtil.splitSingleIntersection(r, tSplit2, frag1, frag2, applyMin);
            return;
        }
        if (frag1.getC().doubleValue() < frag2.getC().doubleValue() == applyMin) {
            Interval d1 = new Interval(frag1.dom().lb(), tSplit1);
            Interval d2 = new Interval(tSplit1, tSplit2);
            Interval d3 = new Interval(tSplit2, frag1.dom().ub());
            r.add(new PsopFragment(frag1.getC(), frag1.getB(), frag1.getA(), d1));
            double x01 = PsopHelper.valueAt(frag2, (Number)tSplit1).doubleValue();
            double v01 = PsopHelper.valueDerivativeAt(frag2, tSplit1).doubleValue();
            r.add(new PsopFragment(x01, v01, frag2.getA(), d2));
            double x02 = PsopHelper.valueAt(frag1, (Number)tSplit2).doubleValue();
            double v02 = PsopHelper.valueDerivativeAt(frag1, tSplit2).doubleValue();
            r.add(new PsopFragment(x02, v02, frag1.getA(), d3));
        } else {
            Interval d1 = new Interval(frag1.dom().lb(), tSplit1);
            Interval d2 = new Interval(tSplit1, tSplit2);
            Interval d3 = new Interval(tSplit2, frag1.dom().ub());
            r.add(new PsopFragment(frag2.getC(), frag2.getB(), frag2.getA(), d1));
            double x01 = PsopHelper.valueAt(frag1, (Number)tSplit1).doubleValue();
            double v01 = PsopHelper.valueDerivativeAt(frag1, tSplit1).doubleValue();
            r.add(new PsopFragment(x01, v01, frag1.getA(), d2));
            double x02 = PsopHelper.valueAt(frag2, (Number)tSplit2).doubleValue();
            double v02 = PsopHelper.valueDerivativeAt(frag2, tSplit2).doubleValue();
            r.add(new PsopFragment(x02, v02, frag2.getA(), d3));
        }
    }

    private static void split(Psop r, double tSplit, IPsopFragment frag1, IPsopFragment frag2) {
        Interval d1 = new Interval(frag1.dom().lb(), tSplit);
        r.add(new PsopFragment(frag1.getC(), frag1.getB(), frag1.getA(), d1));
        Interval d2 = new Interval(tSplit, frag1.dom().ub());
        double x02 = PsopHelper.valueAt(frag2, (Number)tSplit).doubleValue();
        double v02 = PsopHelper.valueDerivativeAt(frag2, tSplit).doubleValue();
        r.add(new PsopFragment(x02, v02, frag2.getA(), d2));
    }

    public static IPsop signal_eventually(IPsop f, double x, double y) {
        if (f.getFragments().size() == 0) {
            return f;
        }
        if (x >= y) {
            throw new IllegalArgumentException("x must be strictly less than y");
        }
        if (x < 0.0 || y < 0.0) {
            throw new IllegalArgumentException("x and y must be at least 0");
        }
        Interval domain = new Interval(PsopHelper.getDomainLowerBound(f), PsopHelper.getDomainUpperBound(f).doubleValue() - x);
        Psop r = new Psop();
        r.add(new PsopFragment(Double.NEGATIVE_INFINITY, 0.0, 0.0, domain));
        f = PsopHelper.copy(f);
        List<PsopHelper.ShapeSegment> monoseg = PsopHelper.createMonotonicSegmentation(f);
        for (PsopHelper.ShapeSegment seg : monoseg) {
            double t0 = f.getFragments().get(seg.getBeginFragment()).dom().lb().doubleValue();
            double t1 = f.getFragments().get(seg.getEndFragment()).dom().ub().doubleValue();
            double valt0 = f.getFragments().get(seg.getBeginFragment()).getC().doubleValue();
            double valt1 = PsopHelper.valueAt(f.getFragments().get(seg.getEndFragment()), (Number)t1).doubleValue();
            Psop h = new Psop();
            if (seg.getShape() == Shape.INCREASING) {
                if (y != Double.POSITIVE_INFINITY) {
                    STLUtil.shiftLeft(seg, f, h, y);
                }
                h.add(new PsopFragment(valt1, 0.0, 0.0, new Interval(t1 - y, t1 - x)));
            } else if (seg.getShape() == Shape.DECREASING) {
                h.add(new PsopFragment(valt0, 0.0, 0.0, new Interval(t0 - y, t0 - x)));
                STLUtil.shiftLeft(seg, f, h, x);
            } else if (seg.getShape() == Shape.CONSTANT) {
                h.add(new PsopFragment(valt0, 0, 0, new Interval(t0 - y, t1 - x)));
            } else {
                throw new IllegalStateException();
            }
            STLUtil.pad(h, domain, Double.NEGATIVE_INFINITY);
            r = STLUtil.signalOr(r, h);
        }
        String as = Double.toString(x).replace(".", "_");
        String bs = Double.toString(y).replace(".", "_");
        r.setAttribute("id", "F_" + as + "_" + bs + "_" + f.getAttributes().get("id"));
        return r;
    }

    private static void shiftLeft(PsopHelper.ShapeSegment seg, IPsop src, Psop dst, double b) {
        int i = seg.getBeginFragment();
        while (i <= seg.getEndFragment()) {
            STLUtil.shiftLeft(src.getFragments().get(i), dst, b);
            ++i;
        }
    }

    private static void shiftLeft(IPsopFragment frag, Psop dst, double b) {
        double ub;
        double lb = frag.dom().lb().doubleValue() - b;
        if (lb < (ub = frag.dom().ub().doubleValue() - b)) {
            PsopFragment shifted = new PsopFragment(frag.getC(), frag.getB(), frag.getA(), new Interval(lb, ub));
            dst.add(shifted);
        }
    }

    private static void pad(Psop f, Interval d, double value) {
        double lb = PsopHelper.getDomainLowerBound(f).doubleValue();
        double ub = PsopHelper.getDomainUpperBound(f).doubleValue();
        boolean needProjection = false;
        if (lb > d.lb().doubleValue()) {
            f.addAtBegin(new PsopFragment(value, 0.0, 0.0, new Interval(d.lb(), lb)));
        } else if (lb < d.lb().doubleValue()) {
            needProjection = true;
        }
        if (ub < d.ub().doubleValue()) {
            f.add(new PsopFragment(value, 0.0, 0.0, new Interval(ub, d.ub())));
        } else if (ub > d.ub().doubleValue()) {
            needProjection = true;
        }
        if (needProjection) {
            PsopHelper.projectTo(f, d);
        }
    }
}

