/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.theme;

import java.awt.Color;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYMeasurementAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelClip;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.util.DefaultShadowGenerator;
import org.jfree.chart.util.ShadowGenerator;

public class DefaultChartTheme
extends StandardChartTheme {
    private static final long serialVersionUID = -6128499423748683998L;
    private static final String AZ = "ABCpqr";
    private static final FontRenderContext DEFAULT_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    public DefaultChartTheme() {
        this(DefaultChartTheme.class.getName());
    }

    protected DefaultChartTheme(String name) {
        this(name, false);
    }

    protected DefaultChartTheme(String name, boolean shadow) {
        super(name, shadow);
        this.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier());
        this.setChartBackgroundPaint(Color.WHITE);
        this.setPlotBackgroundPaint(new Color(240, 240, 245));
        this.setGridBandPaint(new Color(200, 200, 205, 64));
        this.setPlotOutlinePaint(new Color(100, 100, 100));
        this.setDomainGridlinePaint(new Color(160, 160, 160));
        this.setRangeGridlinePaint(Color.WHITE);
        this.setBarPainter((BarPainter)new StandardBarPainter());
        this.setXYBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.setShadowVisible(false);
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            FontRegistry fontRegistry = workbench.getThemeManager().getCurrentTheme().getFontRegistry();
            java.awt.Font regularFont = DefaultChartTheme.toAwtFont((Device)display, fontRegistry.getFontData("org.eclipse.jface.dialogfont")[0], true);
            java.awt.Font smallFont = regularFont.deriveFont(Math.max((float)regularFont.getSize() - 1.0f, 1.0f));
            this.setExtraLargeFont(DefaultChartTheme.toAwtFont((Device)display, fontRegistry.getFontData("org.eclipse.jface.headerfont")[0], true));
            this.setLargeFont(DefaultChartTheme.toAwtFont((Device)display, fontRegistry.getFontData("org.eclipse.jface.bannerfont")[0], true));
            this.setRegularFont(regularFont);
            this.setSmallFont(smallFont);
        } else {
            this.setExtraLargeFont(new java.awt.Font("Segoe UI", 1, 16));
            this.setLargeFont(new java.awt.Font("Segoe UI", 1, 13));
            this.setRegularFont(new java.awt.Font("Segoe UI", 0, 11));
            this.setSmallFont(new java.awt.Font("Segoe UI", 0, 10));
        }
    }

    protected void applyToPlot(Plot plot) {
        super.applyToPlot(plot);
        if (plot.getNoDataMessage() == null) {
            plot.setNoDataMessage("No data available");
        }
    }

    protected void applyToPiePlot(PiePlot plot) {
        super.applyToPiePlot(plot);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDefaultSectionOutlinePaint((Paint)Color.WHITE);
        plot.setOutlineVisible(false);
        plot.setCircular(true);
        plot.setLabelLinkStyle(PieLabelLinkStyle.STANDARD);
        plot.setLabelBackgroundPaint((Paint)new Color(255, 252, 216));
        plot.setLabelOutlinePaint((Paint)new Color(255, 252, 216).darker());
        plot.setShadowGenerator((ShadowGenerator)new DefaultShadowGenerator());
    }

    protected void applyToXYPlot(XYPlot plot) {
        super.applyToXYPlot(plot);
        int i = 0;
        while (i < plot.getRendererCount()) {
            this.applyToMarkers(plot.getRangeMarkers(i, Layer.BACKGROUND));
            this.applyToMarkers(plot.getRangeMarkers(i, Layer.FOREGROUND));
            this.applyToMarkers(plot.getDomainMarkers(i, Layer.BACKGROUND));
            this.applyToMarkers(plot.getDomainMarkers(i, Layer.FOREGROUND));
            ++i;
        }
    }

    private void applyToMarkers(Collection<Marker> markers) {
        if (markers == null) {
            return;
        }
        markers.forEach(this::applyToMarker);
    }

    protected void applyToMarker(Marker marker) {
        marker.setLabelFont(this.getSmallFont());
    }

    protected void applyToAbstractRenderer(AbstractRenderer renderer) {
        super.applyToAbstractRenderer(renderer);
        renderer.setItemLabelInsets(new RectangleInsets(1.0, 5.0, 1.0, 5.0));
        renderer.setDefaultPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, ItemLabelClip.FIT));
    }

    protected void applyToXYItemRenderer(XYItemRenderer renderer) {
        super.applyToXYItemRenderer(renderer);
        if (renderer instanceof XYBarRenderer) {
            this.applyToXYBarRenderer((XYBarRenderer)renderer);
        }
    }

    protected void applyToXYBarRenderer(XYBarRenderer renderer) {
        renderer.setDrawBarOutline(true);
        if (renderer.getAutoPopulateSeriesPaint()) {
            renderer.setAutoPopulateSeriesOutlinePaint(true);
            renderer.setComputeItemLabelContrastColor(true);
        }
        java.awt.Font font = renderer.getDefaultItemLabelFont();
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), true, true);
        Rectangle2D minimumLabelBounds = font.getStringBounds("MMM", fontRenderContext);
        renderer.setMinimumLabelSize(minimumLabelBounds.getBounds().getSize());
        renderer.setShowLabelInsideVisibleBar(true);
        renderer.setPositiveItemLabelPositionFallback(new ItemLabelPosition(ItemLabelAnchor.INSIDE9, TextAnchor.CENTER_LEFT, ItemLabelClip.CLIP));
    }

    protected void applyToXYAnnotation(XYAnnotation annotation) {
        super.applyToXYAnnotation(annotation);
        if (annotation instanceof XYMeasurementAnnotation) {
            this.applyToXYMeasurementAnnotation((XYMeasurementAnnotation)annotation);
        }
    }

    protected void applyToXYMeasurementAnnotation(XYMeasurementAnnotation annotation) {
        annotation.setFont(this.getRegularFont());
        annotation.setPaint((Paint)Color.RED);
    }

    protected void applyToValueAxis(ValueAxis axis) {
        super.applyToValueAxis(axis);
        if (axis instanceof SectionAxis) {
            this.applyToSectionsAxis((SectionAxis)axis);
        }
    }

    protected void applyToSectionsAxis(SectionAxis axis) {
        axis.setDefaultGridBandPaint(this.getGridBandPaint());
        axis.setDefaultGridBandAlternatePaint(this.getGridBandAlternatePaint());
        axis.setTickLabelMaxLength(40);
    }

    protected void applyToTitle(Title title) {
        super.applyToTitle(title);
        if (title instanceof LegendTitle) {
            title.setFrame((BlockFrame)BlockBorder.NONE);
        }
    }

    public static java.awt.Font toAwtFont(Device device, FontData fontData, boolean ensureSameSize) {
        java.awt.Font font = new java.awt.Font(fontData.getName(), fontData.getStyle(), fontData.getHeight());
        if (ensureSameSize) {
            GC tmpGC = new GC((Drawable)device);
            Font tmpFont = new Font(device, fontData);
            tmpGC.setFont(tmpFont);
            int swtHeight = tmpGC.textExtent((String)AZ).y;
            float awtHeight = (float)font.getStringBounds(AZ, DEFAULT_FONT_RENDER_CONTEXT).getHeight();
            float scaledSize = (float)(swtHeight * fontData.getHeight()) / awtHeight;
            font = font.deriveFont(scaledSize);
            tmpFont.dispose();
            tmpGC.dispose();
        }
        return font;
    }
}

