/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.trace4cps.common.jfreechart.ui.JFreeChartUIPlugin;
import org.eclipse.trace4cps.common.jfreechart.ui.widgets.ChartPanelComposite;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ChartPanelScrollbarHandler
extends SelectionAdapter
implements PropertyChangeListener,
PlotChangeListener {
    private static final int SCROLLBAR_LENGTH = 50000000;
    private final Map<ValueAxis, Range> axesAutoRanges = new WeakHashMap<ValueAxis, Range>();
    private final ChartPanelComposite chartPanelComposite;
    private double incrementFactor = 0.1;
    private double pageIncrementFactor = 0.9;
    private XYPlot currentPlot;
    private Range lastDomainRange;
    private Range lastRangeRange;

    public ChartPanelScrollbarHandler(ChartPanelComposite composite) {
        this.chartPanelComposite = composite;
        boolean scroll = false;
        if (this.chartPanelComposite.getHorizontalBar() != null) {
            this.chartPanelComposite.getHorizontalBar().addSelectionListener((SelectionListener)this);
            scroll = true;
        }
        if (this.chartPanelComposite.getVerticalBar() != null) {
            this.chartPanelComposite.getVerticalBar().addSelectionListener((SelectionListener)this);
            scroll = true;
        }
        if (scroll) {
            this.setChart(this.chartPanelComposite.getChartPanel().getChart());
            this.chartPanelComposite.getChartPanel().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void dispose() {
        boolean scroll = false;
        if (this.chartPanelComposite.getHorizontalBar() != null) {
            this.chartPanelComposite.getHorizontalBar().removeSelectionListener((SelectionListener)this);
            scroll = true;
        }
        if (this.chartPanelComposite.getVerticalBar() != null) {
            this.chartPanelComposite.getVerticalBar().removeSelectionListener((SelectionListener)this);
            scroll = true;
        }
        if (scroll) {
            this.setChart(null);
            this.chartPanelComposite.getChartPanel().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public double getIncrementFactor() {
        return this.incrementFactor;
    }

    public void setIncrementFactor(double incrementFactor) {
        this.incrementFactor = incrementFactor;
    }

    public double getPageIncrementFactor() {
        return this.pageIncrementFactor;
    }

    public void setPageIncrementFactor(double pageIncrementFactor) {
        this.pageIncrementFactor = pageIncrementFactor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("Chart".equals(event.getPropertyName())) {
            this.setChart((JFreeChart)event.getNewValue());
        }
    }

    private void setChart(JFreeChart chart) {
        if (this.currentPlot != null) {
            this.currentPlot.removeChangeListener((PlotChangeListener)this);
        }
        if (chart != null && chart.getPlot() instanceof XYPlot) {
            this.currentPlot = (XYPlot)chart.getPlot();
            this.currentPlot.addChangeListener((PlotChangeListener)this);
        }
        this.currentPlotChanged();
    }

    public void plotChanged(PlotChangeEvent event) {
        if (event.getPlot() == this.currentPlot) {
            this.currentPlotChanged();
        }
    }

    private void currentPlotChanged() {
        ValueAxis rangeAxis;
        ValueAxis domainAxis;
        boolean autoRangesChanged = this.cacheAutoRanges();
        ValueAxis valueAxis = domainAxis = this.currentPlot == null ? null : this.currentPlot.getDomainAxis();
        if (domainAxis != null) {
            Range domainRange = domainAxis.getRange();
            if (autoRangesChanged || !Objects.equals(domainRange, this.lastDomainRange)) {
                this.lastDomainRange = domainRange;
                Range domainAutoRange = this.axesAutoRanges.get(domainAxis);
                if (domainAutoRange != null) {
                    this.updateScrollBar(this::getDomainBar, domainRange, domainAutoRange);
                } else {
                    Status status = new Status(2, "org.eclipse.trace4cps.common.jfreechart.ui", "Skipped update: Unknown auto range for domain axis");
                    JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        } else {
            this.disableScrollBar(this::getDomainBar);
        }
        ValueAxis valueAxis2 = rangeAxis = this.currentPlot == null ? null : this.currentPlot.getRangeAxis();
        if (rangeAxis != null) {
            Range rangeRange = rangeAxis.getRange();
            if (autoRangesChanged || !Objects.equals(rangeRange, this.lastRangeRange)) {
                this.lastRangeRange = rangeRange;
                Range rangeAutoRange = this.axesAutoRanges.get(rangeAxis);
                if (rangeAutoRange != null) {
                    this.updateScrollBar(this::getRangeBar, rangeRange, rangeAutoRange);
                } else {
                    Status status = new Status(2, "org.eclipse.trace4cps.common.jfreechart.ui", "Skipped update: Unknown auto range for range axis");
                    JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        } else {
            this.disableScrollBar(this::getRangeBar);
        }
    }

    private void disableScrollBar(Supplier<ScrollBar> scrollBarSupplier) {
        this.chartPanelComposite.getDisplay().asyncExec(() -> {
            ScrollBar scrollBar = (ScrollBar)scrollBarSupplier.get();
            if (scrollBar != null && !scrollBar.isDisposed() && scrollBar.isEnabled()) {
                scrollBar.setEnabled(false);
            }
        });
    }

    private void updateScrollBar(Supplier<ScrollBar> scrollBarSupplier, Range viewRange, Range autoRange) {
        this.chartPanelComposite.getDisplay().asyncExec(() -> {
            ScrollBar scrollBar = (ScrollBar)scrollBarSupplier.get();
            if (scrollBar == null || scrollBar.isDisposed()) {
                return;
            }
            double thumbPercentage = viewRange.getLength() / autoRange.getLength();
            double thumb = thumbPercentage * 5.0E7;
            boolean enabled = thumb >= 1.0 && thumb < 5.0E7;
            scrollBar.setEnabled(enabled);
            if (!enabled) {
                return;
            }
            double increment = Math.max(thumb * this.incrementFactor, 1.0);
            double pageIncrement = Math.max(thumb * this.pageIncrementFactor, 1.0);
            double selectionPercentage = (viewRange.getLowerBound() - autoRange.getLowerBound()) / autoRange.getLength();
            double selection = selectionPercentage * 5.0E7;
            if (selection < 0.0) {
                selection = 0.0;
            } else if (selection > 5.0E7) {
                selection = 5.0E7;
            }
            if ((scrollBar.getStyle() & 0x200) != 0) {
                selection = 5.0E7 - selection - thumb;
            }
            scrollBar.setValues(this.round(selection), 0, 50000000, this.round(thumb), this.round(increment), this.round(pageIncrement));
        });
    }

    private int round(double value) {
        Long longValue = Math.round(value);
        return longValue.intValue();
    }

    public void widgetSelected(SelectionEvent event) {
        block6: {
            Object source;
            block5: {
                if (this.currentPlot == null || !this.currentPlot.isNotify()) {
                    return;
                }
                source = event.getSource();
                if (source != this.getDomainBar()) break block5;
                int i = 0;
                while (i < this.currentPlot.getDomainAxisCount()) {
                    ValueAxis domainAxis = this.currentPlot.getDomainAxis(i);
                    if (domainAxis != null) {
                        this.updateAxisRange((ScrollBar)source, domainAxis);
                    }
                    ++i;
                }
                break block6;
            }
            if (source != this.getRangeBar()) break block6;
            int i = 0;
            while (i < this.currentPlot.getRangeAxisCount()) {
                ValueAxis rangeAxis = this.currentPlot.getRangeAxis(i);
                if (rangeAxis != null) {
                    this.updateAxisRange((ScrollBar)source, rangeAxis);
                }
                ++i;
            }
        }
    }

    private void updateAxisRange(ScrollBar scrollBar, ValueAxis axis) {
        if (scrollBar == null || scrollBar.isDisposed()) {
            return;
        }
        Range autoRange = this.axesAutoRanges.get(axis);
        if (autoRange == null) {
            Status status = new Status(2, "org.eclipse.trace4cps.common.jfreechart.ui", String.format("Skipped update: Unknown auto range for axis: %s (type: %s)", axis.getLabel(), axis.getClass().getName()));
            JFreeChartUIPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        double length = scrollBar.getMaximum();
        double selection = scrollBar.getSelection();
        double thumb = scrollBar.getThumb();
        if ((scrollBar.getStyle() & 0x200) != 0) {
            selection = length - (selection + thumb);
        }
        double selectionPercentage = selection / length;
        double thumbPercentage = thumb / length;
        double lower = autoRange.getLowerBound() + selectionPercentage * autoRange.getLength();
        double upper = lower + thumbPercentage * autoRange.getLength();
        axis.setRange(new Range(lower, upper), true, true);
    }

    protected boolean cacheAutoRanges() {
        if (this.currentPlot == null) {
            boolean changed = !this.axesAutoRanges.isEmpty();
            this.axesAutoRanges.clear();
            return changed;
        }
        boolean changed = false;
        int i = 0;
        while (i < this.currentPlot.getRangeAxisCount()) {
            changed |= this.cacheAutoRange(this.currentPlot.getRangeAxis(i));
            ++i;
        }
        i = 0;
        while (i < this.currentPlot.getDomainAxisCount()) {
            changed |= this.cacheAutoRange(this.currentPlot.getDomainAxis(i));
            ++i;
        }
        return changed;
    }

    protected boolean cacheAutoRange(ValueAxis axis) {
        Range newRange = axis.calculateAutoRange(false);
        Range oldRange = newRange == null ? this.axesAutoRanges.remove(axis) : this.axesAutoRanges.put(axis, newRange);
        return !Objects.equals(oldRange, newRange);
    }

    protected ScrollBar getDomainBar() {
        if (this.currentPlot == null) {
            return null;
        }
        return this.currentPlot.getOrientation() == PlotOrientation.VERTICAL ? this.chartPanelComposite.getHorizontalBar() : this.chartPanelComposite.getVerticalBar();
    }

    protected ScrollBar getRangeBar() {
        if (this.currentPlot == null) {
            return null;
        }
        return this.currentPlot.getOrientation() == PlotOrientation.VERTICAL ? this.chartPanelComposite.getVerticalBar() : this.chartPanelComposite.getHorizontalBar();
    }
}

