/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.gantt;

import java.awt.geom.Rectangle2D;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.xy.XYIntervalDataItem;

public class XYGanttDataItem<T>
extends XYIntervalDataItem
implements BackReferenceProvider<T> {
    private static final long serialVersionUID = 3004235510100651118L;
    public static final double DEFAULT_OCCUPATION = 0.9;
    public static final double DEFAULT_OFFSET = 0.05;
    public static final double DEFAULT_RESOURCE_LENGTH = 1.0;
    private final transient T backReference;

    public XYGanttDataItem(Number resourceIndex, Number start, Number end) {
        this(XYGanttDataItem.calculateResourceRange(resourceIndex), start, end);
    }

    public XYGanttDataItem(Number resourceIndex, Number start, Number end, T backReference) {
        this(XYGanttDataItem.calculateResourceRange(resourceIndex), start, end, backReference);
    }

    public XYGanttDataItem(Number resourceIndex, Number resourceOccupation, Number resourceOffset, Number start, Number end, PlotOrientation orientation, T backReference) {
        this(XYGanttDataItem.calculateResourceRange(resourceIndex), resourceOccupation, resourceOffset, start, end, orientation, backReference);
    }

    public XYGanttDataItem(Range resourceRange, Number start, Number end) {
        this(resourceRange, (Number)0.9, (Number)0.05, start, end, PlotOrientation.VERTICAL, null);
    }

    public XYGanttDataItem(Range resourceRange, Number start, Number end, T backReference) {
        this(resourceRange, (Number)0.9, (Number)0.05, start, end, PlotOrientation.VERTICAL, backReference);
    }

    public XYGanttDataItem(Range resourceRange, Number resourceOccupation, Number resourceOffset, Number start, Number end, PlotOrientation orientation, T backReference) {
        this(XYGanttDataItem.calculateBounds(resourceRange, resourceOccupation, resourceOffset, start, end, orientation), backReference);
    }

    private XYGanttDataItem(Rectangle2D bounds, T backReference) {
        super(bounds.getCenterX(), bounds.getMinX(), bounds.getMaxX(), bounds.getCenterY(), bounds.getMinY(), bounds.getMaxY());
        this.backReference = backReference;
    }

    private static Range calculateResourceRange(Number resourceIndex) {
        double centralValue = resourceIndex.doubleValue();
        double lower = centralValue - 0.5;
        double upper = centralValue + 0.5;
        return new Range(lower, upper);
    }

    private static Rectangle2D calculateBounds(Range resourceRange, Number occupation, Number offset, Number start, Number end, PlotOrientation orientation) {
        double x = start.doubleValue();
        double w = end.doubleValue() - start.doubleValue();
        double y = resourceRange.getLowerBound() + offset.doubleValue() * resourceRange.getLength();
        double h = occupation.doubleValue() * resourceRange.getLength();
        if (PlotOrientation.VERTICAL == orientation) {
            return new Rectangle2D.Double(x, y, w, h);
        }
        return new Rectangle2D.Double(y, x, h, w);
    }

    @Override
    public T getBackReference() {
        return this.backReference;
    }
}

