/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class BackReferenceTextGenerator implements XYItemLabelGenerator, XYToolTipGenerator {
    private final ILabelProvider labelProvider;

    private final BackReferenceResolver backReferenceResolver;

    public BackReferenceTextGenerator() {
        this(new LabelProvider(), BackReferenceResolver.DEFAULT);
    }

    public BackReferenceTextGenerator(ILabelProvider labelProvider) {
        this(labelProvider, BackReferenceResolver.DEFAULT);
    }

    public BackReferenceTextGenerator(ILabelProvider labelProvider, BackReferenceResolver backReferenceResolver) {
        this.labelProvider = labelProvider;
        this.backReferenceResolver = backReferenceResolver;
    }

    @Override
    public String generateLabel(XYDataset dataset, int series, int item) {
        return getText(dataset, series, item);
    }

    @Override
    public String generateToolTip(XYDataset dataset, int series, int item) {
        return getText(dataset, series, item);
    }

    protected String getText(XYDataset dataset, int series, int item) {
        final BackReferenceProvider<?> backReferenceProvider = backReferenceResolver
                .resolveBackReferenceProvider(dataset, series, item);
        if (backReferenceProvider == null) {
            return null;
        }
        return labelProvider.getText(backReferenceProvider.getBackReference());
    }
}
