/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.common.jfreechart.chart.plot;

import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

/**
 * Some utility methods related to the plot classes.
 */
public class PlotUtils {

    /**
     * Private constructor prevents object creation.
     */
    private PlotUtils() {
        // Empty for utility classes
    }

    /**
     * Returns the cumulative amount of items for all datasets in the plot.
     *
     * @return the cumulative amount of items for all datasets in the plot.
     */
    public static int getItemCount(XYPlot plot) {
        int itemCount = 0;
        for (int d = 0; d < plot.getDatasetCount(); d++) {
            XYDataset dataset = plot.getDataset(d);
            for (int s = 0; s < dataset.getSeriesCount(); s++) {
                itemCount += dataset.getItemCount(s);
            }
        }
        return itemCount;
    }
}
