/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl;

import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLand;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLimply;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLnot;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLor;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLtrue;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLuntil;
import org.eclipse.trace4cps.core.impl.Interval;

public final class MtlBuilder {
    private static final MTLtrue MTL_TRUE = new MTLtrue();

    private MtlBuilder() {
    }

    public static MtlFormula TRUE() {
        return MTL_TRUE;
    }

    public static MtlFormula NOT(MtlFormula f) {
        if (f instanceof MTLnot) {
            return ((MTLnot)f).getChild();
        }
        return new MTLnot(f);
    }

    public static MtlFormula AND(MtlFormula l, MtlFormula r) {
        return new MTLand(l, r);
    }

    public static MtlFormula OR(MtlFormula l, MtlFormula r) {
        return new MTLor(l, r);
    }

    public static MtlFormula IMPLY(MtlFormula l, MtlFormula r) {
        return new MTLimply(l, r);
    }

    public static MtlFormula U(MtlFormula l, MtlFormula r, Interval i) {
        return new MTLuntil(l, r, i);
    }

    public static MtlFormula F(MtlFormula p) {
        return new MTLuntil(MtlBuilder.TRUE(), p, Interval.trivial());
    }

    public static MtlFormula F(MtlFormula p, Interval i) {
        return new MTLuntil(MtlBuilder.TRUE(), p, i);
    }

    public static MtlFormula G(MtlFormula p) {
        return MtlBuilder.NOT(MtlBuilder.F(MtlBuilder.NOT(p)));
    }

    public static MtlFormula G(MtlFormula p, Interval i) {
        return MtlBuilder.NOT(MtlBuilder.F(MtlBuilder.NOT(p), i));
    }
}

