/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.validators;

import java.util.Collection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorCompileCommandLabel
extends ValidatorUniqueString
implements ISystemValidator {
    public static final int MAX_CMDLABEL_LENGTH = 50;
    protected boolean fUnique;
    protected SystemMessage msg_Invalid;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public ValidatorCompileCommandLabel(Collection existingLabelList) {
        super(existingLabelList, false);
        this.init();
    }

    public ValidatorCompileCommandLabel(String[] existingLabelList) {
        super(existingLabelList, false);
        this.init();
    }

    public ValidatorCompileCommandLabel() {
        super(new String[0], false);
        this.init();
    }

    private void init() {
        String msg1Txt = UserActionsResources.MSG_VALIDATE_COMPILELABEL_EMPTY;
        String msg1Details = UserActionsResources.MSG_VALIDATE_COMPILELABEL_EMPTY_DETAILS;
        SimpleSystemMessage msg1 = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1195", 4, msg1Txt, msg1Details);
        String msg2Txt = UserActionsResources.MSG_VALIDATE_COMPILELABEL_NOTUNIQUE;
        String msg2Details = UserActionsResources.MSG_VALIDATE_COMPILELABEL_NOTUNIQUE_DETAILS;
        SimpleSystemMessage msg2 = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1196", 4, msg2Txt, msg2Details);
        super.setErrorMessages((SystemMessage)msg1, (SystemMessage)msg2);
        this.fUnique = true;
        String msg3Txt = UserActionsResources.MSG_VALIDATE_COMPILELABEL_NOTVALID;
        String msg3Details = UserActionsResources.MSG_VALIDATE_COMPILELABEL_NOTVALID_DETAILS;
        this.msg_Invalid = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1197", 4, msg3Txt, msg3Details);
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    protected boolean checkForBadCharacters(String newText) {
        return newText.indexOf(38) == -1 && newText.indexOf(64) == -1;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public SystemMessage isSyntaxOk(String newText) {
        this.currentMessage = newText.length() > this.getMaximumNameLength() ? this.msg_Invalid : (this.checkForBadCharacters(newText) ? null : this.msg_Invalid);
        return this.currentMessage;
    }

    public int getMaximumNameLength() {
        return 50;
    }
}

