/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.ls.core.internal.javadoc.html.SubstitutionTextReader;

public class JavaDoc2HTMLTextReader
extends SubstitutionTextReader {
    private List<String> fParameters;
    private String fReturn;
    private List<String> fExceptions;
    private List<String> fAuthors;
    private List<String> fSees;
    private List<String> fSince;
    private List<Pair> fRest;

    public JavaDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private int getTag(StringBuilder buffer) throws IOException {
        int c = this.nextChar();
        while (c == 46 || c != -1 && Character.isLetter((char)c)) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContent(StringBuilder buffer, char stopChar) throws IOException {
        int c = this.nextChar();
        while (c != -1 && c != stopChar) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContentUntilNextTag(StringBuilder buffer) throws IOException {
        int c = this.nextChar();
        boolean blockStartRead = false;
        while (c != -1) {
            if (c == 64) {
                int index = buffer.length();
                while (--index >= 0 && Character.isWhitespace(buffer.charAt(index))) {
                    switch (buffer.charAt(index)) {
                        case '\n': 
                        case '\r': {
                            return c;
                        }
                    }
                    if (index > 0) continue;
                    return c;
                }
            }
            if (blockStartRead) {
                buffer.append(this.processBlockTag());
                blockStartRead = false;
            } else {
                buffer.append((char)c);
            }
            c = this.nextChar();
            boolean bl = blockStartRead = c == 123;
        }
        return c;
    }

    private String substituteQualification(String qualification) {
        Object result;
        if (qualification.indexOf("<a") == -1) {
            result = qualification.replace('#', '.');
        } else {
            int length = qualification.length();
            result = qualification;
            boolean insideTag = false;
            int i = 0;
            while (i < length) {
                char charAt = ((String)result).charAt(i);
                if (charAt == '<' && ((String)result).charAt(i + 1) == 'a') {
                    insideTag = true;
                }
                if (charAt == '>') {
                    insideTag = false;
                }
                if (charAt == '#' && !insideTag) {
                    result = ((String)result).substring(0, i) + "." + ((String)result).substring(i + 1);
                }
                ++i;
            }
        }
        if (((String)result).startsWith(".")) {
            result = ((String)result).substring(1);
        }
        return result;
    }

    private void printDefinitions(StringBuilder buffer, List<String> list, boolean firstword) {
        for (String s : list) {
            buffer.append("<li>");
            if (!firstword) {
                buffer.append(s);
            } else {
                buffer.append("<b>");
                int i = this.getParamEndOffset(s);
                if (i <= s.length()) {
                    buffer.append(JavaDoc2HTMLTextReader.convertToHTMLContent(s.substring(0, i)));
                    buffer.append("</b>");
                    buffer.append(s.substring(i));
                } else {
                    buffer.append("</b>");
                }
            }
            buffer.append("</li>");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getParamEndOffset(String s) {
        block5: {
            i = 0;
            length = s.length();
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= length || s.charAt(i) != '<') ** GOTO lbl19
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            while (i < length && Character.isJavaIdentifierPart(s.charAt(i))) {
                ++i;
            }
            while (i < length && s.charAt(i) != '>') {
                ++i;
            }
            ++i;
            break block5;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl19:
                // 2 sources

                ** while (i < length && Character.isJavaIdentifierPart((char)s.charAt((int)i)))
            }
        }
        return i;
    }

    private void print(StringBuilder buffer, String tag, List<String> elements, boolean firstword) {
        if (!elements.isEmpty()) {
            buffer.append("<li><b>");
            buffer.append(tag);
            buffer.append("</b><ul>");
            this.printDefinitions(buffer, elements, firstword);
            buffer.append("</ul></li>");
        }
    }

    private void print(StringBuilder buffer, String tag, String content) {
        if (content != null) {
            buffer.append("<li><b>");
            buffer.append(tag);
            buffer.append("</b><ul><li>");
            buffer.append(content);
            buffer.append("</li></ul></li>");
        }
    }

    private void printRest(StringBuilder buffer) {
        if (!this.fRest.isEmpty()) {
            for (Pair p : this.fRest) {
                buffer.append("<li>");
                if (p.fTag != null) {
                    buffer.append(p.fTag);
                }
                buffer.append("<ul><li>");
                if (p.fContent != null) {
                    buffer.append(p.fContent);
                }
                buffer.append("</li></ul></li>");
            }
        }
    }

    private String printSimpleTag() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<ul>");
        this.print(buffer, "See Also:", this.fSees, false);
        this.print(buffer, "Parameters:", this.fParameters, true);
        this.print(buffer, "Returns:", this.fReturn);
        this.print(buffer, "Throws:", this.fExceptions, false);
        this.print(buffer, "Author:", this.fAuthors, false);
        this.print(buffer, "Since:", this.fSince, false);
        this.printRest(buffer);
        buffer.append("</ul>");
        return buffer.toString();
    }

    private void handleTag(String tag, String tagContent) {
        tagContent = tagContent.trim();
        if ("@param".equals(tag)) {
            this.fParameters.add(tagContent);
        } else if ("@return".equals(tag)) {
            this.fReturn = tagContent;
        } else if ("@exception".equals(tag)) {
            this.fExceptions.add(tagContent);
        } else if ("@throws".equals(tag)) {
            this.fExceptions.add(tagContent);
        } else if ("@author".equals(tag)) {
            this.fAuthors.add(this.substituteQualification(tagContent));
        } else if ("@see".equals(tag)) {
            this.fSees.add(this.substituteQualification(tagContent));
        } else if ("@since".equals(tag)) {
            this.fSince.add(this.substituteQualification(tagContent));
        } else if (tagContent != null) {
            this.fRest.add(new Pair(tag, tagContent));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList<String>();
        this.fExceptions = new ArrayList<String>();
        this.fAuthors = new ArrayList<String>();
        this.fSees = new ArrayList<String>();
        this.fSince = new ArrayList<String>();
        this.fRest = new ArrayList<Pair>();
        StringBuilder buffer = new StringBuilder();
        int c = 64;
        while (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1) {
                c = this.getContentUntilNextTag(buffer);
            }
            this.handleTag(tag, buffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String tag, String tagContent) {
        if ("@link".equals(tag) || "@linkplain".equals(tag)) {
            char[] contentChars = tagContent.toCharArray();
            boolean inParentheses = false;
            int labelStart = 0;
            int i = 0;
            while (i < contentChars.length) {
                char nextChar = contentChars[i];
                if (i == 0 && Character.isWhitespace(nextChar)) {
                    labelStart = 1;
                } else if (nextChar == '(') {
                    inParentheses = true;
                } else if (nextChar == ')') {
                    inParentheses = false;
                } else if (!inParentheses && Character.isWhitespace(nextChar)) {
                    labelStart = i + 1;
                    break;
                }
                ++i;
            }
            if ("@link".equals(tag)) {
                return "<code>" + this.substituteQualification(tagContent.substring(labelStart)) + "</code>";
            }
            return this.substituteQualification(tagContent.substring(labelStart));
        }
        if ("@literal".equals(tag) || "@code".equals(tag)) {
            return this.printLiteral(tagContent);
        }
        if ("@code".equals(tag)) {
            return "<code>" + this.printLiteral(tagContent) + "</code>";
        }
        return this.substituteQualification(tagContent);
    }

    private String printLiteral(String tagContent) {
        int contentStart = 0;
        int i = 0;
        while (i < tagContent.length()) {
            if (!Character.isWhitespace(tagContent.charAt(i))) {
                contentStart = i;
                break;
            }
            ++i;
        }
        return JavaDoc2HTMLTextReader.convertToHTMLContent(tagContent.substring(contentStart));
    }

    private String processBlockTag() throws IOException {
        int c = this.nextChar();
        if (c != 64) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            buffer.append((char)c);
            return buffer.toString();
        }
        StringBuilder buffer = new StringBuilder();
        if (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1 && c != 125) {
                buffer.append((char)c);
                this.getContent(buffer, '}');
            }
            return this.printBlockTag(tag, buffer.toString());
        }
        return null;
    }

    @Override
    protected String computeSubstitution(int c) throws IOException {
        if (c == 64 && this.fWasWhiteSpace) {
            return this.processSimpleTag();
        }
        if (c == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    private static String convertToHTMLContent(String content) {
        content = JavaDoc2HTMLTextReader.replace(content, '&', "&amp;");
        content = JavaDoc2HTMLTextReader.replace(content, '\"', "&quot;");
        content = JavaDoc2HTMLTextReader.replace(content, '<', "&lt;");
        return JavaDoc2HTMLTextReader.replace(content, '>', "&gt;");
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    private static class Pair {
        String fTag;
        String fContent;

        Pair(String tag, String content) {
            this.fTag = tag;
            this.fContent = content;
        }
    }
}

