/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Objects;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public abstract class JavacErrorMethodBinding
extends JavacMethodBinding {
    private Symbol originatingSymbol;

    public JavacErrorMethodBinding(Symbol originatingSymbol, Type.MethodType methodType, JavacBindingResolver resolver) {
        super(methodType, null, null, resolver);
        this.originatingSymbol = originatingSymbol;
    }

    @Override
    public String getKey() {
        try {
            return this.getKeyImpl();
        }
        catch (JavacBindingResolver.BindingKeyException bke) {
            return null;
        }
    }

    private String getKeyImpl() throws JavacBindingResolver.BindingKeyException {
        StringBuilder builder = new StringBuilder();
        Symbol symbol = this.originatingSymbol;
        if (symbol instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol;
            JavacTypeBinding.getKey(builder, this.resolver.getTypes().erasure(typeSymbol.type), false, this.resolver);
        }
        builder.append('(');
        for (Type param : this.methodType.getParameterTypes()) {
            JavacTypeBinding.getKey(builder, param, false, this.resolver);
        }
        builder.append(')');
        Type returnType = this.methodType.getReturnType();
        if (returnType != null && !(returnType instanceof Type.JCNoType)) {
            JavacTypeBinding.getKey(builder, returnType, false, this.resolver);
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacErrorMethodBinding)) return false;
        JavacErrorMethodBinding other = (JavacErrorMethodBinding)obj;
        if (!Objects.equals(this.methodSymbol, other.methodSymbol)) return false;
        if (!Objects.equals(this.methodType, other.methodType)) return false;
        if (!Objects.equals(this.originatingSymbol, other.originatingSymbol)) return false;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        return true;
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    @Override
    public String getName() {
        return this.originatingSymbol.getSimpleName().toString();
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        Symbol symbol = this.originatingSymbol;
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)symbol;
            symbol = clazz.owner;
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol actualOwner = (Symbol.ClassSymbol)symbol;
                return this.resolver.bindings.getTypeBinding(actualOwner.type);
            }
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return this.originatingSymbol.isDeprecated();
    }

    @Override
    public IMethodBinding getMethodDeclaration() {
        return this.resolver.bindings.getErrorMethodBinding(this.resolver.getTypes().erasure(this.methodType).asMethodType(), this.originatingSymbol.type.tsym, null);
    }

    @Override
    public IAnnotationBinding[] getAnnotations() {
        return (IAnnotationBinding[])this.originatingSymbol.getAnnotationMirrors().stream().map(ann -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)ann, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    @Override
    public boolean isVarargs() {
        return false;
    }
}

