/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.internal.SignatureUtils;

public class DOMCompletionUtils {
    private static final List<String> JAVA_MODIFIERS = List.of(Modifier.ModifierKeyword.PUBLIC_KEYWORD.toString(), Modifier.ModifierKeyword.PRIVATE_KEYWORD.toString(), Modifier.ModifierKeyword.STATIC_KEYWORD.toString(), Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString(), Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD.toString(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD.toString(), Modifier.ModifierKeyword.FINAL_KEYWORD.toString(), Modifier.ModifierKeyword.DEFAULT_KEYWORD.toString(), Modifier.ModifierKeyword.NATIVE_KEYWORD.toString(), Modifier.ModifierKeyword.STRICTFP_KEYWORD.toString(), Modifier.ModifierKeyword.TRANSIENT_KEYWORD.toString(), Modifier.ModifierKeyword.VOLATILE_KEYWORD.toString());

    public static ASTNode findParent(ASTNode nodeToSearch, int[] kindsToFind) {
        for (ASTNode cursor = nodeToSearch; cursor != null; cursor = cursor.getParent()) {
            for (int kindToFind : kindsToFind) {
                if (cursor.getNodeType() != kindToFind) continue;
                return cursor;
            }
        }
        return null;
    }

    public static <T extends ASTNode> void visitChildren(ASTNode root, final int kind, final Consumer<T> consumer) {
        ASTVisitor visitor = new ASTVisitor(){

            public void preVisit(ASTNode node) {
                if (node.getNodeType() == kind) {
                    consumer.accept(node);
                }
            }
        };
        root.accept(visitor);
    }

    public static AbstractTypeDeclaration findParentTypeDeclaration(ASTNode nodeToSearch) {
        return (AbstractTypeDeclaration)DOMCompletionUtils.findParent(nodeToSearch, new int[]{55, 71, 103, 81});
    }

    public static boolean isJavaFieldOrMethodModifier(String potentialModifer) {
        return JAVA_MODIFIERS.contains(potentialModifer);
    }

    public static boolean findInSupers(ITypeBinding root, ITypeBinding toFind) {
        ITypeBinding superFind = toFind.getErasure();
        if (superFind != null) {
            String keyToFind = superFind.getKey();
            return DOMCompletionUtils.findInSupers(root, keyToFind);
        }
        return false;
    }

    public static boolean findInSupers(ITypeBinding root, String keyOfTypeToFind) {
        String keyToFind = keyOfTypeToFind;
        LinkedList<ITypeBinding> toCheck = new LinkedList<ITypeBinding>();
        HashSet<String> alreadyChecked = new HashSet<String>();
        toCheck.add(root.getErasure());
        while (!toCheck.isEmpty()) {
            String currentKey;
            ITypeBinding current = (ITypeBinding)toCheck.poll();
            if (current == null || alreadyChecked.contains(currentKey = current.getErasure().getKey())) continue;
            alreadyChecked.add(currentKey);
            if (currentKey.equals(keyToFind)) {
                return true;
            }
            for (ITypeBinding superInterface : current.getInterfaces()) {
                toCheck.add(superInterface);
            }
            if (current.getSuperclass() == null) continue;
            toCheck.add(current.getSuperclass());
        }
        return false;
    }

    public static boolean findInSupers(IType root, String keyOfTypeToFind, WorkingCopyOwner workingCopyOwner, Map<String, ITypeHierarchy> hierarchyCache) {
        if (root.getKey().equals(keyOfTypeToFind)) {
            return true;
        }
        try {
            String signature = SignatureUtils.getSignatureForTypeKey(keyOfTypeToFind);
            IType typeToFind = root.getJavaProject().findType(Signature.getSignatureQualifier((String)signature) + "." + Signature.getSignatureSimpleName((String)signature));
            if (typeToFind != null) {
                ITypeHierarchy hierarchy;
                if (hierarchyCache.containsKey(keyOfTypeToFind)) {
                    hierarchy = hierarchyCache.get(keyOfTypeToFind);
                } else {
                    hierarchy = typeToFind.newTypeHierarchy(root.getJavaProject(), workingCopyOwner, (IProgressMonitor)new NullProgressMonitor());
                    hierarchyCache.put(keyOfTypeToFind, hierarchy);
                }
                for (IType subType : hierarchy.getAllSubtypes(typeToFind)) {
                    if (!subType.getKey().equals(root.getKey())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static boolean isInQualifiedName(ASTNode node) {
        return Set.of(QualifiedName.NAME_PROPERTY, FieldAccess.NAME_PROPERTY, ExpressionMethodReference.NAME_PROPERTY, TypeMethodReference.NAME_PROPERTY, SuperMethodReference.NAME_PROPERTY).contains(node.getLocationInParent()) || node instanceof FieldAccess || node instanceof QualifiedName || node instanceof SuperMethodReference || node instanceof TypeMethodReference;
    }

    public static TrueFalseBindings collectTrueFalseBindings(Expression e) {
        InfixExpression infixExpression;
        InfixExpression infixExpression2;
        PrefixExpression prefixExpression;
        if (e instanceof PrefixExpression && (prefixExpression = (PrefixExpression)e).getOperator() == PrefixExpression.Operator.NOT) {
            TrueFalseBindings notBindings = DOMCompletionUtils.collectTrueFalseBindings(prefixExpression.getOperand());
            return new TrueFalseBindings(notBindings.falseBindings(), notBindings.trueBindings());
        }
        if (e instanceof InfixExpression && ((infixExpression2 = (InfixExpression)e).getOperator() == InfixExpression.Operator.CONDITIONAL_AND || infixExpression2.getOperator() == InfixExpression.Operator.AND)) {
            TrueFalseBindings left = DOMCompletionUtils.collectTrueFalseBindings(infixExpression2.getLeftOperand());
            TrueFalseBindings right = DOMCompletionUtils.collectTrueFalseBindings(infixExpression2.getRightOperand());
            ArrayList<IVariableBinding> combined = new ArrayList<IVariableBinding>();
            combined.addAll(left.trueBindings());
            combined.addAll(right.trueBindings());
            return new TrueFalseBindings(combined, Collections.emptyList());
        }
        if (e instanceof InfixExpression && ((infixExpression = (InfixExpression)e).getOperator() == InfixExpression.Operator.CONDITIONAL_OR || infixExpression.getOperator() == InfixExpression.Operator.OR)) {
            TrueFalseBindings left = DOMCompletionUtils.collectTrueFalseBindings(infixExpression.getLeftOperand());
            TrueFalseBindings right = DOMCompletionUtils.collectTrueFalseBindings(infixExpression.getRightOperand());
            ArrayList<IVariableBinding> combined = new ArrayList<IVariableBinding>();
            combined.addAll(left.falseBindings());
            combined.addAll(right.falseBindings());
            return new TrueFalseBindings(Collections.emptyList(), combined);
        }
        ArrayList<IVariableBinding> typePatternBindings = new ArrayList<IVariableBinding>();
        DOMCompletionUtils.visitChildren((ASTNode)e, 106, patt -> typePatternBindings.add(patt.getPatternVariable().resolveBinding()));
        return new TrueFalseBindings(typePatternBindings, Collections.emptyList());
    }

    public static TrueFalseCasts collectTrueFalseCasts(Expression e, IVariableBinding castedBinding) {
        InfixExpression infixExpression;
        InfixExpression infixExpression2;
        PrefixExpression prefixExpression;
        if (e instanceof PrefixExpression && (prefixExpression = (PrefixExpression)e).getOperator() == PrefixExpression.Operator.NOT) {
            TrueFalseCasts notBindings = DOMCompletionUtils.collectTrueFalseCasts(prefixExpression.getOperand(), castedBinding);
            return new TrueFalseCasts(notBindings.falseCasts(), notBindings.trueCasts());
        }
        if (e instanceof InfixExpression && ((infixExpression2 = (InfixExpression)e).getOperator() == InfixExpression.Operator.CONDITIONAL_AND || infixExpression2.getOperator() == InfixExpression.Operator.AND)) {
            TrueFalseCasts left = DOMCompletionUtils.collectTrueFalseCasts(infixExpression2.getLeftOperand(), castedBinding);
            TrueFalseCasts right = DOMCompletionUtils.collectTrueFalseCasts(infixExpression2.getRightOperand(), castedBinding);
            ArrayList<ITypeBinding> combined = new ArrayList<ITypeBinding>();
            combined.addAll(left.trueCasts());
            combined.addAll(right.trueCasts());
            return new TrueFalseCasts(combined, Collections.emptyList());
        }
        if (e instanceof InfixExpression && ((infixExpression = (InfixExpression)e).getOperator() == InfixExpression.Operator.CONDITIONAL_OR || infixExpression.getOperator() == InfixExpression.Operator.OR)) {
            TrueFalseCasts left = DOMCompletionUtils.collectTrueFalseCasts(infixExpression.getLeftOperand(), castedBinding);
            TrueFalseCasts right = DOMCompletionUtils.collectTrueFalseCasts(infixExpression.getRightOperand(), castedBinding);
            ArrayList<ITypeBinding> combined = new ArrayList<ITypeBinding>();
            combined.addAll(left.falseCasts());
            combined.addAll(right.falseCasts());
            return new TrueFalseCasts(Collections.emptyList(), combined);
        }
        ArrayList<ITypeBinding> castedTypes = new ArrayList<ITypeBinding>();
        DOMCompletionUtils.visitChildren((ASTNode)e, 62, expr -> {
            FieldAccess fieldAccess;
            Name name;
            Expression leftOperand = expr.getLeftOperand();
            if (leftOperand instanceof Name && (name = (Name)leftOperand).resolveBinding() != null && name.resolveBinding().getKey().equals(castedBinding.getKey())) {
                castedTypes.add(expr.getRightOperand().resolveBinding());
            } else if (leftOperand instanceof FieldAccess && (fieldAccess = (FieldAccess)leftOperand).resolveFieldBinding() != null && fieldAccess.resolveFieldBinding().getKey().equals(castedBinding.getKey())) {
                castedTypes.add(expr.getRightOperand().resolveBinding());
            }
        });
        return new TrueFalseCasts(castedTypes, Collections.emptyList());
    }

    public record TrueFalseBindings(List<IVariableBinding> trueBindings, List<IVariableBinding> falseBindings) {
    }

    public record TrueFalseCasts(List<ITypeBinding> trueCasts, List<ITypeBinding> falseCasts) {
    }
}

