/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import jdk.javadoc.internal.doclets.formats.html.taglets.snippet.Attribute;
import jdk.javadoc.internal.doclets.formats.html.taglets.snippet.MarkupParser;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IDocElement;
import org.eclipse.jdt.core.dom.JavaDocTextElement;
import org.eclipse.jdt.core.dom.JavacConverter;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.ModuleQualifiedName;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TagProperty;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;

class JavadocConverter {
    private static final Pattern JAVA_COMMENT = Pattern.compile("^(?<payload>.*)//(?<markup>\\s*@\\s*\\w+.+?)$");
    private final AST ast;
    private final JavacConverter javacConverter;
    private final DCTree.DCDocComment docComment;
    private final int initialOffset;
    private final int endOffset;
    private boolean buildJavadoc;
    private final TreePath contextTreePath;
    private String rawContent;
    public final Map<ASTNode, DocTreePath> converted = new HashMap<ASTNode, DocTreePath>();
    private final Set<JCDiagnostic> diagnostics = new HashSet<JCDiagnostic>();
    private static final Pattern BEGIN_CHOPPER = Pattern.compile("(?:\\s+\\*)(.*)");

    private JavadocConverter(JavacConverter javacConverter, DCTree.DCDocComment docComment, TreePath contextTreePath, int initialOffset, int endPos, boolean buildJavadoc) {
        this.javacConverter = javacConverter;
        this.ast = javacConverter.ast;
        this.docComment = docComment;
        this.contextTreePath = contextTreePath;
        this.buildJavadoc = buildJavadoc;
        this.initialOffset = initialOffset;
        this.endOffset = endPos;
    }

    JavadocConverter(JavacConverter javacConverter, DCTree.DCDocComment docComment, int initialOffset, int endPos, boolean buildJavadoc) {
        this(javacConverter, docComment, null, initialOffset, endPos, buildJavadoc);
    }

    JavadocConverter(JavacConverter javacConverter, DCTree.DCDocComment docComment, TreePath contextTreePath, boolean buildJavadoc) {
        this(javacConverter, docComment, contextTreePath, docComment.comment.getPos().getStartPosition(), docComment.comment.getPos().getEndPosition(javacConverter.javacCompilationUnit.endPositions) + (docComment.comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE ? 1 : 0), buildJavadoc);
    }

    private void commonSettings(ASTNode res, DCTree javac) {
        if (javac != null) {
            int startPosition = this.docComment.getSourcePosition(javac.getStartPosition());
            int endPosition = this.docComment.getSourcePosition(javac.getEndPosition());
            int length = endPosition - startPosition;
            if (startPosition >= 0 && length >= 0) {
                res.setSourceRange(startPosition, length);
            }
            if (this.contextTreePath != null) {
                this.converted.put(res, DocTreePath.getPath(this.contextTreePath, this.docComment, javac));
            }
        }
    }

    public String getRawContent() {
        if (this.rawContent == null) {
            this.rawContent = this.javacConverter.rawText.substring(this.initialOffset, this.endOffset);
        }
        return this.rawContent;
    }

    Javadoc convertJavadoc() {
        Javadoc res = this.ast.newJavadoc();
        res.setSourceRange(this.initialOffset, this.endOffset - this.initialOffset);
        try {
            if (this.buildJavadoc) {
                List<DCTree> treeElements = Stream.of(this.docComment.preamble, this.docComment.fullBody, this.docComment.postamble, this.docComment.tags).flatMap(Collection::stream).toList();
                List<IDocElement> elements2 = this.convertElementCombiningNodes(treeElements);
                List<IDocElement> elements = this.convertNestedTagElements(elements2);
                TagElement host = null;
                for (IDocElement docElement : elements) {
                    ASTNode extraNode;
                    TagElement tag;
                    if (docElement instanceof TagElement && !JavadocConverter.isInline(tag = (TagElement)docElement)) {
                        if (host != null) {
                            res.tags().add(host);
                            host = null;
                        }
                        res.tags().add(tag);
                        continue;
                    }
                    if (host == null) {
                        host = this.ast.newTagElement();
                        if (docElement instanceof ASTNode) {
                            ASTNode astn = (ASTNode)docElement;
                            host.setSourceRange(astn.getStartPosition(), astn.getLength());
                        }
                    } else if (docElement instanceof ASTNode && (extraNode = (ASTNode)docElement).getStartPosition() >= 0 && extraNode.getLength() >= 0) {
                        host.setSourceRange(host.getStartPosition(), extraNode.getStartPosition() + extraNode.getLength() - host.getStartPosition());
                    }
                    host.fragments().add(docElement);
                }
                if (host != null) {
                    res.tags().add(host);
                }
            }
        }
        catch (Exception ex) {
            ILog.get().error("Failed to convert Javadoc", (Throwable)ex);
        }
        return res;
    }

    private List<IDocElement> convertNestedTagElements(List<IDocElement> elements2) {
        return elements2.stream().map(x -> {
            TextElement te;
            String s;
            if (x instanceof TextElement && (s = (te = (TextElement)x).getText()) != null && s.startsWith("{@") && s.trim().endsWith("}")) {
                String txt = this.javacConverter.rawText.substring(te.getStartPosition(), te.getStartPosition() + te.getLength());
                TextElement innerMost = this.ast.newTextElement();
                innerMost.setSourceRange(te.getStartPosition() + 2, te.getLength() - 3);
                innerMost.setText(txt.substring(2, txt.length() - 1));
                TagElement nested = this.ast.newTagElement();
                int atLoc = txt.indexOf("@");
                String name = atLoc == -1 ? txt : ("@" + txt.substring(atLoc + 1)).split("\\s+")[0];
                nested.setTagName(name);
                nested.setSourceRange(te.getStartPosition(), te.getLength());
                nested.fragments().add(innerMost);
                TagElement wrapper = this.ast.newTagElement();
                wrapper.setSourceRange(te.getStartPosition(), te.getLength());
                wrapper.fragments().add(nested);
                return wrapper;
            }
            return x;
        }).toList();
    }

    Set<JCDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    static boolean isInline(TagElement tag) {
        boolean bl;
        block15: {
            block14: {
                block13: {
                    if (tag.getTagName() == null) break block13;
                    switch (tag.getTagName()) {
                        case "@code": 
                        case "@docRoot": 
                        case "@inheritDoc": 
                        case "@link": 
                        case "@linkplain": 
                        case "@literal": 
                        case "@snippet": 
                        case "@value": {
                            break;
                        }
                        default: {
                            break block14;
                        }
                    }
                }
                bl = true;
                break block15;
            }
            bl = false;
        }
        return bl;
    }

    private Optional<TagElement> convertBlockTag(DCTree javac) {
        ASTNode lastFrag;
        int trueEnd;
        TagElement res = this.ast.newTagElement();
        this.commonSettings((ASTNode)res, javac);
        if (javac instanceof DCTree.DCAuthor) {
            DCTree.DCAuthor author = (DCTree.DCAuthor)javac;
            res.setTagName("@author");
            this.convertElementCombiningNodes(author.name.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCSince) {
            DCTree.DCSince since = (DCTree.DCSince)javac;
            res.setTagName("@since");
            this.convertElementCombiningNodes(since.body.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCVersion) {
            DCTree.DCVersion version = (DCTree.DCVersion)javac;
            res.setTagName("@version");
            this.convertElementCombiningNodes(version.body.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCSee) {
            DCTree.DCSee see = (DCTree.DCSee)javac;
            res.setTagName("@see");
            this.convertElementCombiningNodes(see.reference.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCDeprecated) {
            DCTree.DCDeprecated deprecated = (DCTree.DCDeprecated)javac;
            res.setTagName("@deprecated");
            this.convertElementCombiningNodes(deprecated.body.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCParam) {
            DCTree.DCParam param = (DCTree.DCParam)javac;
            res.setTagName("@param");
            int tagNameEnds = javac.getStartPosition() + res.getTagName().length();
            if (param.isTypeParameter()) {
                int stopSearchRelative = param.getEndPosition();
                if (param.description != null && param.description.size() > 0) {
                    stopSearchRelative = param.description.get(0).getEndPosition();
                }
                int stopSearchAbsolute = this.docComment.getSourcePosition(stopSearchRelative);
                int start = this.docComment.getSourcePosition(param.getStartPosition());
                int ltRaw = this.javacConverter.rawText.indexOf("<", start, stopSearchAbsolute);
                int gtRaw = this.javacConverter.rawText.indexOf(">", start, stopSearchAbsolute);
                if (ltRaw != -1) {
                    int ltStart = this.docComment.getSourcePosition(tagNameEnds + 1);
                    Region r = new Region(ltStart, 1 + (ltRaw - ltStart));
                    res.fragments().add(this.toTextElement(r));
                    res.fragments().addAll(this.convertElement(param.name).toList());
                } else {
                    res.fragments().addAll(this.convertElement(param.name).toList());
                }
                if (gtRaw != -1) {
                    Region r = new Region(gtRaw, 1);
                    res.fragments().add(this.toTextElement(r));
                }
            } else {
                res.fragments().addAll(this.convertElement(param.name).toList());
            }
            this.convertElementCombiningNodes(param.description.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCReturn) {
            DCTree.DCReturn ret = (DCTree.DCReturn)javac;
            res.setTagName("@return");
            this.convertElementCombiningNodes(ret.description.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCThrows) {
            DCTree.DCThrows thrown = (DCTree.DCThrows)javac;
            String tagName = thrown.kind == DocTree.Kind.THROWS ? "@throws" : "@exception";
            res.setTagName(tagName);
            res.fragments().addAll(this.convertElement(thrown.name).toList());
            this.convertElementCombiningNodes(thrown.description.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCUses) {
            DCTree.DCUses uses = (DCTree.DCUses)javac;
            res.setTagName("@uses");
            TextElement serviceName = this.ast.newTextElement();
            serviceName.setText(uses.serviceType.getSignature());
            this.commonSettings((ASTNode)serviceName, uses.serviceType);
            res.fragments().add(serviceName);
            this.convertElementCombiningNodes(uses.description.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCUnknownBlockTag) {
            DCTree.DCUnknownBlockTag unknown = (DCTree.DCUnknownBlockTag)javac;
            res.setTagName("@" + unknown.getTagName());
            this.convertElementCombiningNodes(unknown.content.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else if (javac instanceof DCTree.DCSerial) {
            DCTree.DCSerial serial = (DCTree.DCSerial)javac;
            res.setTagName("@serial");
            this.convertElementCombiningNodes(serial.description.stream().filter(x -> x != null).toList()).forEach(arg_0 -> res.fragments.add(arg_0));
        } else {
            return Optional.empty();
        }
        if (res != null && res.fragments().size() != 0 && (trueEnd = (lastFrag = (ASTNode)res.fragments().get(res.fragments().size() - 1)).getStartPosition() + lastFrag.getLength()) > res.getStartPosition() + res.getLength()) {
            res.setSourceRange(res.getStartPosition(), trueEnd - res.getStartPosition());
        }
        return Optional.of(res);
    }

    private Stream<IDocElement> convertInlineTag(DCTree javac) {
        ArrayList<TagElement> collector = new ArrayList<TagElement>();
        TagElement res = this.ast.newTagElement();
        this.commonSettings((ASTNode)res, javac);
        collector.add(res);
        if (javac instanceof DCTree.DCLiteral) {
            DCTree.DCLiteral literal = (DCTree.DCLiteral)javac;
            res.setTagName(switch (literal.getKind()) {
                case DocTree.Kind.CODE -> "@code";
                case DocTree.Kind.LITERAL -> "@literal";
                default -> "@literal";
            });
            res.fragments().addAll(this.convertElement(literal.body).toList());
        } else if (javac instanceof DCTree.DCLink) {
            String string;
            DCTree.DCLink link = (DCTree.DCLink)javac;
            if (this.docComment.comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE) {
                string = "@link";
            } else {
                switch (link.getKind()) {
                    case LINK: {
                        string = "@link";
                        break;
                    }
                    case LINK_PLAIN: {
                        string = "@linkplain";
                        break;
                    }
                    default: {
                        string = "@link";
                    }
                }
            }
            res.setTagName(string);
            if (link.label != null && !link.label.isEmpty() && link.ref != null && link.label.getFirst().getStartPosition() < link.ref.getStartPosition()) {
                link.label.stream().flatMap(this::convertElement).forEach(res.fragments()::add);
                res.fragments().addAll(this.convertElement(link.ref).toList());
            } else {
                res.fragments().addAll(this.convertElement(link.ref).toList());
                link.label.stream().flatMap(this::convertElement).forEach(res.fragments()::add);
            }
            if (res.getStartPosition() < 0) {
                int start = ((ASTNode)res.fragments().getFirst()).getStartPosition() - 1;
                ASTNode lastChild = (ASTNode)res.fragments().getLast();
                int end = lastChild.getStartPosition() + lastChild.getLength() + 1;
                res.setSourceRange(start, end - start);
            }
        } else if (javac instanceof DCTree.DCValue) {
            DCTree.DCValue dcv = (DCTree.DCValue)javac;
            res.setTagName("@value");
            res.fragments().addAll(this.convertElement(dcv.ref).toList());
        } else if (javac instanceof DCTree.DCInheritDoc) {
            DCTree.DCInheritDoc inheritDoc = (DCTree.DCInheritDoc)javac;
            res.setTagName("@inheritDoc");
        } else if (javac instanceof DCTree.DCSnippet) {
            DCTree.DCSnippet snippet = (DCTree.DCSnippet)javac;
            res.setTagName("@snippet");
            res.setProperty("IsSnippetValid", (Object)true);
            res.fragments().addAll(this.splitLines(snippet.body, true).map(this::toSnippetFragment).toList());
        } else if (javac instanceof DCTree.DCDocRoot) {
            res.setTagName("@docRoot");
        } else if (javac instanceof DCTree.DCSummary) {
            DCTree.DCSummary summary = (DCTree.DCSummary)javac;
            res.setTagName("@summary");
            res.fragments().addAll(summary.summary.stream().flatMap(this::convertElement).toList());
        } else if (javac instanceof DCTree.DCIndex) {
            DCTree.DCIndex index = (DCTree.DCIndex)javac;
            res.setTagName("@index");
            res.fragments().addAll(index.description.stream().flatMap(this::convertElement).toList());
        } else if (javac instanceof DCTree.DCUnknownInlineTag) {
            DCTree.DCUnknownInlineTag unknown = (DCTree.DCUnknownInlineTag)javac;
            res.fragments().add(this.toDefaultTextElement(unknown));
        } else {
            return Stream.empty();
        }
        return collector.stream();
    }

    private Name toName(JCTree expression, int parentOffset) {
        Name n = this.javacConverter.toName(expression, (dom, javac) -> {
            int start = parentOffset + javac.getStartPosition();
            int length = javac.toString().length();
            dom.setSourceRange(start, Math.max(0, length));
            this.javacConverter.domToJavac.put((ASTNode)dom, (JCTree)javac);
        });
        if (n instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)n;
            SimpleName sn = qn.getName();
            if (sn.getStartPosition() == 0 || sn.getStartPosition() == -1) {
                int qnEnd = qn.getStartPosition() + qn.getLength();
                int start = qnEnd - sn.toString().length();
                sn.setSourceRange(start, qnEnd - start);
            }
            this.cleanNameQualifierLocations(qn);
        }
        return n;
    }

    private void cleanNameQualifierLocations(QualifiedName qn) {
        Name qualifier = qn.getQualifier();
        if (qualifier != null) {
            qualifier.setSourceRange(qn.getStartPosition(), qualifier.toString().length());
            if (qualifier instanceof QualifiedName) {
                QualifiedName qn2 = (QualifiedName)qualifier;
                this.cleanNameQualifierLocations(qn2);
            }
        }
    }

    private TextElement toTextElement(Region line) {
        TextElement res = this.ast.newTextElement();
        String suggestedText = this.javacConverter.rawText.substring(line.startOffset, line.startOffset + line.length);
        String strippedLeading = suggestedText.stripLeading();
        int leadingWhitespace = suggestedText.length() - strippedLeading.length();
        res.setSourceRange(line.startOffset + leadingWhitespace, line.length - leadingWhitespace);
        res.setText(strippedLeading);
        return res;
    }

    private TextElement toTextElementPreserveWhitespace(Region line) {
        TextElement res = this.ast.newTextElement();
        res.setSourceRange(line.startOffset, line.length);
        res.setText(line.getContents());
        return res;
    }

    private Stream<Region> splitLines(DCTree.DCText text, boolean keepWhitespaces) {
        return this.splitLines(text.getBody(), text.getStartPosition(), text.getEndPosition(), keepWhitespaces);
    }

    private Stream<Region> splitLines(String body, int startPos, int endPos, boolean keepWhitespaces) {
        String[] bodySplit = body.split("\n");
        ArrayList<Region> regions = new ArrayList<Region>();
        int workingIndexWithinComment = startPos;
        for (int i = 0; i < bodySplit.length; ++i) {
            int lineStart = this.docComment.getSourcePosition(workingIndexWithinComment);
            int lineEnd = this.docComment.getSourcePosition(workingIndexWithinComment + bodySplit[i].length());
            if (!keepWhitespaces) {
                String tmp = this.javacConverter.rawText.substring(lineStart, lineEnd);
                int leadingWhite = tmp.length() - tmp.stripLeading().length();
                Region r = new Region(lineStart + leadingWhite, lineEnd - lineStart - leadingWhite);
                regions.add(r);
            } else {
                regions.add(new Region(lineStart, lineEnd - lineStart));
            }
            workingIndexWithinComment += bodySplit[i].length() + 1;
        }
        return regions.stream();
    }

    private Stream<Region> splitLines(DCTree[] allPositions) {
        if (allPositions.length > 0) {
            int[] startPosition = new int[]{this.docComment.getSourcePosition(allPositions[0].getStartPosition())};
            int lastNodeStart = this.docComment.getSourcePosition(allPositions[allPositions.length - 1].getStartPosition());
            int endPosition = this.docComment.getSourcePosition(allPositions[allPositions.length - 1].getEndPosition());
            DCTree dCTree = allPositions[allPositions.length - 1];
            if (dCTree instanceof DCTree.DCText) {
                String convertedText;
                DCTree.DCText dct = (DCTree.DCText)dCTree;
                String lastText = dct.text;
                String lastTextFromSrc = this.javacConverter.rawText.substring(lastNodeStart, endPosition);
                if (!lastTextFromSrc.equals(lastText) && (convertedText = Convert.escapeUnicode(lastText)).startsWith(lastTextFromSrc)) {
                    endPosition = lastNodeStart + convertedText.length();
                }
            }
            String sub = this.javacConverter.rawText.substring(startPosition[0], endPosition);
            String[] split = sub.split("(\r)?\n\\s*[*][ \t]*");
            ArrayList<Region> regions = new ArrayList<Region>();
            for (int i = 0; i < split.length; ++i) {
                int index = this.javacConverter.rawText.indexOf(split[i], startPosition[0]);
                if (index < 0) continue;
                regions.add(new Region(index, split[i].length()));
                startPosition[0] = index + split[i].length();
            }
            return regions.stream();
        }
        return Stream.empty();
    }

    private IDocElement toSnippetFragment(Region region) {
        String line;
        Matcher markedUpLine;
        TextElement defaultElement = this.toTextElementPreserveWhitespace(region);
        if (!defaultElement.getText().endsWith("\n")) {
            defaultElement.setText(defaultElement.getText() + "\n");
        }
        if (!(markedUpLine = JAVA_COMMENT.matcher(line = region.getContents())).matches()) {
            return defaultElement;
        }
        int markupStart = markedUpLine.start("markup");
        String markup = line.substring(markupStart);
        MarkupParser markupParser = new MarkupParser(null);
        try {
            List tags = markupParser.parse(markup);
            if (tags.isEmpty()) {
                return defaultElement;
            }
            TextElement initialTextElement = this.ast.newTextElement();
            initialTextElement.setSourceRange(region.startOffset, markupStart - 2);
            initialTextElement.setText(line.substring(0, markupStart - 2) + "\n");
            TextElement currentElement = initialTextElement;
            Class<?> tagClass = tags.getFirst().getClass();
            Field nameField = tagClass.getDeclaredField("name");
            nameField.setAccessible(true);
            Field attributesFields = tagClass.getDeclaredField("attributes");
            attributesFields.setAccessible(true);
            for (Object tag : tags) {
                String name = (String)nameField.get(tag);
                List attributes = (List)attributesFields.get(tag);
                TagElement newElement = this.ast.newTagElement();
                newElement.setSourceRange(region.startOffset, region.length);
                newElement.setTagName("@" + name);
                newElement.setProperty("SnippetInlineTagCount", (Object)1);
                attributes.stream().map(this::toTagProperty).forEach(newElement.tagProperties()::add);
                newElement.fragments().add(currentElement);
                currentElement = newElement;
            }
            return currentElement;
        }
        catch (Exception ex) {
            ILog.get().error("While trying to build snippet line " + line + ": " + ex.getMessage(), (Throwable)ex);
            return defaultElement;
        }
    }

    private TagProperty toTagProperty(Attribute snippetMarkupAttribute) {
        TagProperty res = this.ast.newTagProperty();
        try {
            Field name = Attribute.class.getDeclaredField("name");
            name.setAccessible(true);
            res.setName((String)name.get(snippetMarkupAttribute));
            Field value = snippetMarkupAttribute.getClass().getDeclaredField("value");
            value.setAccessible(true);
            res.setStringValue((String)value.get(snippetMarkupAttribute));
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    private Stream<IDocElement> convertElementGroup(DCTree[] javac) {
        return this.splitLines(javac).filter(x -> x.length != 0).flatMap(this::toTextOrTag);
    }

    private Stream<IDocElement> toTextOrTag(Region line) {
        int firstWhite;
        int closeBracket;
        String suggestedText = this.javacConverter.rawText.substring(line.startOffset, line.startOffset + line.length);
        TextElement postElement = null;
        if (suggestedText.startsWith("{@") && (closeBracket = suggestedText.indexOf("}")) > (firstWhite = this.findFirstWhitespace(suggestedText)) && firstWhite != -1) {
            Region postRegion = new Region(line.startOffset + closeBracket + 1, line.length - closeBracket - 1);
            if (postRegion.length > 0) {
                postElement = this.toTextElement(postRegion);
            }
            String tagName = suggestedText.substring(1, firstWhite).trim();
            TagElement res = this.ast.newTagElement();
            res.setTagName(tagName);
            res.fragments.add((Object)this.toTextElementPreserveWhitespace(new Region(line.startOffset + firstWhite, closeBracket - firstWhite)));
            res.setSourceRange(line.startOffset, closeBracket + 1);
            if (postElement == null) {
                return Stream.of(res);
            }
            return Stream.of(res, postElement);
        }
        return Stream.of(this.toTextElement(line));
    }

    private int findFirstWhitespace(String s) {
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            if (!Character.isWhitespace(s.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    private List<IDocElement> convertElementCombiningNodes(List<DCTree> treeElements) {
        ArrayList<IDocElement> elements = new ArrayList<IDocElement>();
        ArrayList<DCTree> combinable = new ArrayList<DCTree>();
        int size = treeElements.size();
        for (int i = 0; i < size; ++i) {
            DCTree oneTree;
            boolean lineBreakBefore;
            boolean shouldCombine;
            block11: {
                DCTree.DCErroneous derror;
                Stream<IDocElement> de;
                block8: {
                    block10: {
                        DCTree.DCRawText raw;
                        block9: {
                            shouldCombine = false;
                            lineBreakBefore = false;
                            oneTree = treeElements.get(i);
                            if (!(oneTree instanceof DCTree.DCText) && !(oneTree instanceof DCTree.DCStartElement) && !(oneTree instanceof DCTree.DCEndElement) && !(oneTree instanceof DCTree.DCEntity)) break block8;
                            shouldCombine = true;
                            if (!(oneTree instanceof DCTree.DCText)) break block9;
                            DCTree.DCText dct = (DCTree.DCText)oneTree;
                            if (dct.text.startsWith("\n")) break block10;
                        }
                        if (!(oneTree instanceof DCTree.DCRawText) || !(raw = (DCTree.DCRawText)oneTree).getContent().endsWith("\n")) break block11;
                    }
                    lineBreakBefore = true;
                    break block11;
                }
                if (oneTree instanceof DCTree.DCErroneous && (de = this.convertDCErroneousElement(derror = (DCTree.DCErroneous)oneTree)) == null) {
                    shouldCombine = true;
                    if (derror.body.startsWith("{@")) {
                        lineBreakBefore = true;
                    }
                }
            }
            if ((lineBreakBefore || !shouldCombine) && combinable.size() > 0) {
                elements.addAll(this.convertElementGroup(combinable.toArray(new DCTree[0])).toList());
                combinable.clear();
            }
            if (shouldCombine) {
                combinable.add(oneTree);
                continue;
            }
            elements.addAll(this.convertElement(oneTree).toList());
        }
        if (combinable.size() > 0) {
            elements.addAll(this.convertElementGroup(combinable.toArray(new DCTree[0])).toList());
        }
        return elements;
    }

    private Stream<? extends IDocElement> convertElement(DCTree javac) {
        if (javac instanceof DCTree.DCText) {
            DCTree.DCText text = (DCTree.DCText)javac;
            return this.splitLines(text, false).map(this::toTextElement);
        }
        if (javac instanceof DCTree.DCRawText) {
            DCTree.DCRawText rawText = (DCTree.DCRawText)javac;
            if (this.docComment.comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE && rawText.getContent().contains("\n")) {
                String[] segments = rawText.getContent().split("\n");
                ArrayList<TextElement> regions = new ArrayList<TextElement>(segments.length);
                int currentStart = this.docComment.getSourcePosition(rawText.getStartPosition());
                for (String segment : segments) {
                    int end = this.javacConverter.rawText.indexOf(10, currentStart);
                    if (end < currentStart) {
                        end = this.docComment.getSourcePosition(rawText.getEndPosition());
                    }
                    TextElement element = this.ast.newTextElement();
                    element.setSourceRange(currentStart, segment.length());
                    element.setText(segment);
                    regions.add(element);
                    currentStart = this.javacConverter.rawText.indexOf("///", end);
                }
                return regions.stream();
            }
            String content = rawText.getContent();
            char last = content.charAt(content.length() - 1);
            if (last != '\u001a') {
                TextElement element = this.ast.newTextElement();
                this.commonSettings((ASTNode)element, javac);
                element.setText(rawText.getContent());
                return Stream.of(element);
            }
            content = rawText.getContent().substring(0, content.length() - 1);
            int currentStart = this.docComment.getSourcePosition(rawText.getStartPosition());
            TextElement element = this.ast.newTextElement();
            element.setSourceRange(currentStart, content.length());
            element.setText(content);
            return Stream.of(element);
        }
        if (javac instanceof DCTree.DCIdentifier) {
            DCTree.DCIdentifier identifier = (DCTree.DCIdentifier)javac;
            Name res = this.ast.newName(identifier.getName().toString());
            this.commonSettings((ASTNode)res, javac);
            return Stream.of(res);
        }
        if (javac instanceof DCTree.DCReference) {
            DCTree.DCReference reference = (DCTree.DCReference)javac;
            return this.convertReference(javac, reference);
        }
        if (javac instanceof DCTree.DCStartElement || javac instanceof DCTree.DCEndElement || javac instanceof DCTree.DCEntity) {
            return Stream.of(this.toDefaultTextElement(javac));
        }
        if (javac instanceof DCTree.DCBlockTag || javac instanceof DCTree.DCReturn) {
            Optional<Stream> blockTag = this.convertBlockTag(javac).map(Stream::of);
            if (blockTag.isPresent()) {
                return blockTag.get();
            }
        } else {
            if (javac instanceof DCTree.DCErroneous) {
                DCTree.DCErroneous erroneous = (DCTree.DCErroneous)javac;
                Stream<IDocElement> docE = this.convertDCErroneousElement(erroneous);
                if (docE != null) {
                    return docE;
                }
                TextElement res = this.ast.newTextElement();
                this.commonSettings((ASTNode)res, erroneous);
                res.setText(erroneous.body);
                this.diagnostics.add(erroneous.diag);
                return Stream.of(res);
            }
            if (javac instanceof DCTree.DCComment) {
                DCTree.DCComment comment = (DCTree.DCComment)javac;
                TextElement res = this.ast.newTextElement();
                this.commonSettings((ASTNode)res, comment);
                res.setText(res.text);
                return Stream.of(res);
            }
            Stream<IDocElement> inlineTag = this.convertInlineTag(javac);
            return inlineTag;
        }
        String message = "\ud83d\udca5\ud83d\udc1b Not supported yet conversion of " + javac.getClass().getSimpleName() + " to element";
        ILog.get().error(message);
        JavaDocTextElement res = this.ast.newJavaDocTextElement();
        this.commonSettings((ASTNode)res, javac);
        res.setText(this.docComment.comment.getText().substring(javac.getStartPosition(), javac.getEndPosition()) + System.lineSeparator() + message);
        return Stream.of(res);
    }

    private Stream<? extends IDocElement> convertReference(DCTree javac, DCTree.DCReference reference) {
        String signature = reference.getSignature();
        if (reference.memberName == null) {
            if (reference.qualifierExpression != null) {
                Name res = this.convertReferenceToNameOnly(reference);
                return Stream.of(res);
            }
        } else if (reference.memberName != null) {
            if (signature.charAt(signature.length() - 1) == ')') {
                return Stream.of(this.convertMemberReferenceWithParens(reference));
            }
            return Stream.of(this.convertReferenceToMemberRef(reference));
        }
        int startPosition = this.docComment.getSourcePosition(reference.getPreferredPosition());
        TextElement res = this.ast.newTextElement();
        res.setText(signature);
        res.setSourceRange(startPosition, reference.getEndPos() - reference.pos);
        return Stream.of(res);
    }

    private IDocElement convertMemberReferenceWithParens(DCTree.DCReference reference) {
        MethodRef res = this.ast.newMethodRef();
        this.commonSettings((ASTNode)res, reference);
        int currentOffset = this.docComment.getSourcePosition(reference.getStartPosition());
        if (reference.qualifierExpression != null) {
            Name qualifierExpressionName = null;
            JCTree jCTree = reference.qualifierExpression;
            if (jCTree instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jCTree;
                qualifierExpressionName = this.toName(arrayType.elemtype, res.getStartPosition());
            } else {
                qualifierExpressionName = this.toName(reference.qualifierExpression, res.getStartPosition());
            }
            qualifierExpressionName.setSourceRange(currentOffset, Math.max(0, reference.qualifierExpression.toString().length()));
            res.setQualifier(qualifierExpressionName);
            currentOffset += qualifierExpressionName.getLength();
        }
        SimpleName name = this.ast.newSimpleName(reference.memberName.toString());
        name.setSourceRange(++currentOffset, Math.max(0, reference.memberName.toString().length()));
        currentOffset += name.getLength();
        res.setName(name);
        if (this.contextTreePath != null) {
            this.converted.put((ASTNode)name, DocTreePath.getPath(this.contextTreePath, this.docComment, reference));
        }
        int paramListOffset = ++currentOffset;
        ArrayList<Region> params = new ArrayList<Region>();
        int separatorOffset = currentOffset;
        while (separatorOffset < res.getStartPosition() + res.getLength() && this.javacConverter.rawText.charAt(separatorOffset) != ')') {
            while (separatorOffset < res.getStartPosition() + res.getLength() && this.javacConverter.rawText.charAt(separatorOffset) != ')' && this.javacConverter.rawText.charAt(separatorOffset) != ',') {
                ++separatorOffset;
            }
            params.add(new Region(currentOffset, separatorOffset - currentOffset));
            currentOffset = ++separatorOffset;
        }
        for (int i = 0; i < reference.paramTypes.size(); ++i) {
            JCTree type = reference.paramTypes.get(i);
            Region range = i < params.size() ? (Region)params.get(i) : null;
            res.parameters().add(this.toMethodRefParam(type, range, paramListOffset));
        }
        return res;
    }

    private IDocElement convertReferenceToMemberRef(DCTree.DCReference reference) {
        int startPos;
        MemberRef res = this.ast.newMemberRef();
        this.commonSettings((ASTNode)res, reference);
        if (this.contextTreePath != null) {
            this.converted.put((ASTNode)res, DocTreePath.getPath(this.contextTreePath, this.docComment, reference));
        }
        int memberNameStart = startPos = this.docComment.getSourcePosition(reference.pos);
        Name qualifier = this.convertReferenceToNameOnly(reference);
        if (qualifier != null) {
            res.setQualifier(qualifier);
            memberNameStart = qualifier.getStartPosition() + qualifier.getLength();
        }
        ++memberNameStart;
        if (reference.memberName != null) {
            SimpleName name = this.ast.newSimpleName(reference.memberName.toString());
            name.setSourceRange(memberNameStart, Math.max(0, reference.memberName.toString().length()));
            res.setName(name);
        }
        return res;
    }

    private Name convertReferenceToNameOnly(DCTree.DCReference reference) {
        int startPos = this.docComment.getSourcePosition(reference.getStartPosition());
        if (reference.qualifierExpression != null) {
            int moduleQualifierLen = 0;
            if (reference.moduleName != null) {
                moduleQualifierLen = this.javacConverter.commonSettingsGetLength(null, reference.moduleName) + 1;
            }
            Name qualifierExpressionName = null;
            JCTree jCTree = reference.qualifierExpression;
            if (jCTree instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jCTree;
                qualifierExpressionName = this.toName(arrayType.elemtype, startPos + moduleQualifierLen);
            } else {
                qualifierExpressionName = this.toName(reference.qualifierExpression, startPos + moduleQualifierLen);
            }
            int len = Math.max(0, reference.qualifierExpression.toString().length());
            qualifierExpressionName.setSourceRange(startPos + moduleQualifierLen, len);
            if (reference.moduleName == null) {
                return qualifierExpressionName;
            }
            ModuleQualifiedName mqn = new ModuleQualifiedName(this.ast);
            Name moduleName = this.toName(reference.moduleName, startPos);
            moduleName.setSourceRange(startPos, moduleQualifierLen);
            mqn.setModuleQualifier(moduleName);
            mqn.setName(qualifierExpressionName);
            mqn.setSourceRange(startPos, qualifierExpressionName.getStartPosition() + qualifierExpressionName.getLength() - startPos);
            return mqn;
        }
        return null;
    }

    private Stream<IDocElement> convertDCErroneousElement(DCTree.DCErroneous erroneous) {
        String body = erroneous.body;
        MethodRef match = null;
        try {
            match = this.matchesMethodReference(erroneous, body);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int start = this.docComment.getSourcePosition(erroneous.getStartPosition());
        int endInd = erroneous.getEndPosition();
        int endPosition = this.docComment.getSourcePosition(endInd);
        if (match != null) {
            TagElement res = this.ast.newTagElement();
            res.setTagName("@see");
            res.fragments.add((Object)match);
            res.setSourceRange(start, endPosition - start);
            return Stream.of(res);
        }
        if (body.startsWith("@")) {
            TagElement res = this.ast.newTagElement();
            String tagName = body.split("\\s+")[0];
            res.setTagName(tagName);
            int newStart = erroneous.getStartPosition() + tagName.length();
            List<TextElement> l = this.splitLines(body.substring(tagName.length()), newStart, endInd, false).map(x -> this.toTextElement((Region)x)).toList();
            res.fragments.addAll(l);
            res.setSourceRange(start, endPosition - start);
            return Stream.of(res);
        }
        return null;
    }

    private MethodRef matchesMethodReference(DCTree.DCErroneous tree, String body) {
        String value;
        int hash;
        if (body.startsWith("@see") && (hash = (value = body.substring(4)).indexOf("#")) != -1) {
            String suffix;
            int startPosition = this.docComment.getSourcePosition(tree.getStartPosition()) + 4;
            String prefix = value.substring(0, hash);
            int link = prefix.indexOf("@link");
            if (link != -1) {
                prefix = prefix.substring(link + 5);
                startPosition = startPosition + link + 5;
            }
            MethodRef ref = this.ast.newMethodRef();
            if (prefix != null && !prefix.isBlank()) {
                Name n = this.toName(prefix, startPosition);
                ref.setQualifier(n);
            }
            String string = suffix = hash + 1 > value.length() ? "" : value.substring(hash + 1);
            if (suffix.indexOf("(") != -1) {
                String qualifiedMethod = suffix.substring(0, suffix.indexOf("("));
                int methodNameStart = qualifiedMethod.lastIndexOf(".") + 1;
                String methodName = qualifiedMethod.substring(methodNameStart);
                SimpleName sn = (SimpleName)this.toName(methodName, startPosition + prefix.length() + 1 + methodNameStart);
                ref.setName(sn);
                this.commonSettings((ASTNode)ref, tree);
                this.diagnostics.add(tree.diag);
                return ref;
            }
        }
        return null;
    }

    private Name toName(String val, int startPosition) {
        return JavacConverter.toName(val, startPosition, this.ast);
    }

    private TextElement toDefaultTextElement(DCTree javac) {
        TextElement res = this.ast.newTextElement();
        this.commonSettings((ASTNode)res, javac);
        String r = this.docComment.comment.getText();
        String s1 = r.substring(javac.getStartPosition(), javac.getEndPosition());
        res.setText(s1);
        return res;
    }

    private MethodRefParameter toMethodRefParam(JCTree type, Region range, final int paramListOffset) {
        MethodRefParameter res = this.ast.newMethodRefParameter();
        res.setSourceRange(range != null ? range.startOffset : paramListOffset + type.getStartPosition(), range != null ? range.length : type.toString().length());
        new TreeScanner(this){

            @Override
            public void scan(JCTree tree) {
                tree.setPos(tree.pos + paramListOffset);
                super.scan(tree);
            }
        }.scan(type);
        String[] segments = (String[])Stream.of(range.getContents().split("\n")).map(t -> {
            Matcher m = BEGIN_CHOPPER.matcher((CharSequence)t);
            if (m.find()) {
                return m.group(1);
            }
            return t;
        }).map(String::trim).flatMap(t -> Stream.of(t.split(" "))).filter(t -> !t.isEmpty()).toArray(String[]::new);
        Type jdtType = null;
        if (segments.length > 0 && segments[segments.length - 1].endsWith("...")) {
            res.setVarargs(true);
            if (type instanceof JCTree.JCArrayTypeTree) {
                JCTree.JCArrayTypeTree att = (JCTree.JCArrayTypeTree)type;
                jdtType = this.javacConverter.convertToType(att.getType());
            }
        }
        if (jdtType == null) {
            jdtType = this.javacConverter.convertToType(type);
        }
        res.setType(jdtType);
        new TreeScanner(this){

            @Override
            public void scan(JCTree tree) {
                tree.setPos(tree.pos - paramListOffset);
                super.scan(tree);
            }
        }.scan(type);
        jdtType.accept(new ASTVisitor(this){

            public void preVisit(ASTNode node) {
                if (node.getLength() == 0 && node.getStartPosition() >= 0) {
                    node.setSourceRange(node.getStartPosition(), node.toString().length());
                }
                super.preVisit(node);
            }
        });
        if (jdtType.getStartPosition() + jdtType.getLength() < res.getStartPosition() + res.getLength() && segments.length > 1) {
            String nameSegment = segments[segments.length - 1];
            SimpleName name = this.ast.newSimpleName(nameSegment);
            name.setSourceRange(this.javacConverter.rawText.lastIndexOf(nameSegment, range.endPosition()), nameSegment.length());
            res.setName(name);
        }
        return res;
    }

    private class Region {
        final int startOffset;
        final int length;

        Region(int startOffset, int length) {
            this.startOffset = startOffset;
            this.length = length;
        }

        String getContents() {
            return JavadocConverter.this.javacConverter.rawText.substring(this.startOffset, this.startOffset + this.length);
        }

        public int endPosition() {
            return this.startOffset + this.length;
        }
    }
}

