/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.PullUpDescriptor;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.HierarchyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManagerCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class PullUpRefactoringProcessor
extends HierarchyProcessor {
    protected static final String ATTRIBUTE_ABSTRACT = "abstract";
    protected static final String ATTRIBUTE_DELETE = "delete";
    protected static final String ATTRIBUTE_PULL = "pull";
    protected static final String ATTRIBUTE_STUBS = "stubs";
    private static final String IDENTIFIER = "org.eclipse.jdt.ui.pullUpProcessor";
    private static final GroupCategorySet SET_PULL_UP = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.pullUp", RefactoringCoreMessages.PullUpRefactoring_category_name, RefactoringCoreMessages.PullUpRefactoring_category_description));
    protected IMethod[] fAbstractMethods = new IMethod[0];
    private ITypeHierarchy fCachedDeclaringSuperTypeHierarchy;
    private ITypeHierarchy fCachedDestinationTypeHierarchy;
    private Set<IType> fCachedSkippedSuperTypes;
    private Set<IType> fCachedSuperTypes;
    private boolean fArgumentAddedToHandleThis;
    protected Map<ICompilationUnit, CompilationUnitRewrite> fCompilationUnitRewrites;
    protected boolean fCreateMethodStubs = true;
    protected IMethod[] fDeletedMethods = new IMethod[0];
    protected IType fDestinationType;

    private static void addMatchingMember(Map<IMember, Set<IMember>> mapping, IMember key, IMember matchingMember) {
        Set<Object> matchingSet;
        if (mapping.containsKey(key)) {
            matchingSet = mapping.get(key);
        } else {
            matchingSet = new HashSet();
            mapping.put(key, matchingSet);
        }
        Assert.isTrue((!matchingSet.contains(matchingMember) ? 1 : 0) != 0);
        matchingSet.add(matchingMember);
    }

    private static Block createMethodStub(MethodDeclaration method, AST ast, ICompilationUnit cu, ASTRewrite rewrite, String targetTypeName) {
        Block body = ast.newBlock();
        Expression expression = ASTNodeFactory.newDefaultExpression(ast, method.getReturnType2(), method.getExtraDimensions());
        try {
            String placeHolder;
            String delimiter = cu.findRecommendedLineSeparator();
            String bodyStatement = "";
            if (expression != null) {
                ReturnStatement returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(expression);
                bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, FormatterProfileManagerCore.getProjectSettings(cu.getJavaProject()));
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(cu, targetTypeName, method.getName().getIdentifier(), false, bodyStatement, delimiter)) != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return body;
    }

    private static Set<IType> getAffectedSubTypes(ITypeHierarchy hierarchy, IType type) throws JavaModelException {
        IType[] types = null;
        boolean isInterface = type.isInterface();
        if (isInterface) {
            ArrayList<IType> remove = new ArrayList<IType>();
            ArrayList<IType> list = new ArrayList<IType>(Arrays.asList(hierarchy.getSubtypes(type)));
            for (IType element : list) {
                if (!element.isInterface()) continue;
                remove.add(element);
            }
            list.removeAll(remove);
            types = list.toArray(new IType[list.size()]);
        } else {
            types = hierarchy.getSubclasses(type);
        }
        HashSet<IType> result = new HashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type2 = iTypeArray[n2];
            if (!isInterface && JdtFlags.isAbstract((IMember)type2)) {
                result.addAll(PullUpRefactoringProcessor.getAffectedSubTypes(hierarchy, type2));
            } else {
                result.add(type2);
            }
            ++n2;
        }
        return result;
    }

    private static IMember[] getMembers(IMember[] members, int type) {
        List<IJavaElement> list = Arrays.asList(JavaElementUtil.getElementsOfType((IJavaElement[])members, type));
        return list.toArray(new IMember[list.size()]);
    }

    private static void mergeMaps(Map<IMember, Set<IMember>> result, Map<IMember, Set<IMember>> map) {
        for (Map.Entry<IMember, Set<IMember>> entry : result.entrySet()) {
            IMember key = entry.getKey();
            if (!map.containsKey(key)) continue;
            Set<IMember> resultSet = entry.getValue();
            Set<IMember> mapSet = map.get(key);
            resultSet.addAll(mapSet);
        }
    }

    private static void upgradeMap(Map<IMember, Set<IMember>> result, Map<IMember, Set<IMember>> map) {
        for (Map.Entry<IMember, Set<IMember>> entry : map.entrySet()) {
            IMember key = entry.getKey();
            if (result.containsKey(key)) continue;
            Set<IMember> mapSet = entry.getValue();
            HashSet<IMember> resultSet = new HashSet<IMember>(mapSet);
            result.put(key, resultSet);
        }
    }

    public PullUpRefactoringProcessor(IMember[] members, CodeGenerationSettings settings) {
        this(members, settings, false);
    }

    public PullUpRefactoringProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, null, false);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    protected PullUpRefactoringProcessor(IMember[] members, CodeGenerationSettings settings, boolean layer) {
        super(members, settings, layer);
        if (members != null) {
            IType type = RefactoringAvailabilityTesterCore.getTopLevelType(this.fMembersToMove);
            try {
                if (type != null && RefactoringAvailabilityTesterCore.getPullUpMembers(type).length != 0) {
                    this.fCachedDeclaringType = RefactoringAvailabilityTesterCore.getTopLevelType(this.fMembersToMove);
                    this.fMembersToMove = new IMember[0];
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
        }
    }

    private void addAllRequiredPullableMembers(List<IMember> queue, IMember member, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull(queue);
        Assert.isNotNull((Object)member);
        Assert.isNotNull((Object)monitor);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_calculating_required, (int)6);
        IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
        boolean isStatic = false;
        SubMonitor sub = subMonitor.newChild(1);
        sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
        isStatic = JdtFlags.isStatic(member);
        IMethod[] iMethodArray = requiredMethods;
        int n = requiredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod requiredMethod = iMethodArray[n2];
            if (!(isStatic && !JdtFlags.isStatic((IMember)requiredMethod) || !this.isRequiredPullableMember(queue, (IMember)requiredMethod) || MethodChecks.isVirtual(requiredMethod) && this.isAvailableInDestination(requiredMethod, (IProgressMonitor)sub.newChild(1)))) {
                queue.add((IMember)requiredMethod);
            }
            ++n2;
        }
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
        SubMonitor sub2 = subMonitor.newChild(1);
        sub2.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredFields.length);
        isStatic = JdtFlags.isStatic(member);
        IField[] iFieldArray = requiredFields;
        int n3 = requiredFields.length;
        n = 0;
        while (n < n3) {
            IField requiredField = iFieldArray[n];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredField)) && this.isRequiredPullableMember(queue, (IMember)requiredField)) {
                queue.add((IMember)requiredField);
            }
            ++n;
        }
        IType[] requiredTypes = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{member}, this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
        SubMonitor sub3 = subMonitor.newChild(1);
        sub3.beginTask(RefactoringCoreMessages.PullUpRefactoring_calculating_required, requiredMethods.length);
        isStatic = JdtFlags.isStatic(member);
        IType[] iTypeArray = requiredTypes;
        int n4 = requiredTypes.length;
        n3 = 0;
        while (n3 < n4) {
            IType requiredType = iTypeArray[n3];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredType)) && this.isRequiredPullableMember(queue, (IMember)requiredType)) {
                queue.add((IMember)requiredType);
            }
            ++n3;
        }
    }

    private void addMethodStubForAbstractMethod(IMethod sourceMethod, CompilationUnit declaringCuNode, AbstractTypeDeclaration typeToCreateStubIn, ICompilationUnit newCu, CompilationUnitRewrite rewriter, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        MethodDeclaration methodToCreateStubFor = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        AST ast = rewriter.getRoot().getAST();
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        ASTRewrite astRewrite = rewriter.getASTRewrite();
        newMethod.setBody(PullUpRefactoringProcessor.createMethodStub(methodToCreateStubFor, ast, newCu, astRewrite, Bindings.getFullyQualifiedName(typeToCreateStubIn.resolveBinding())));
        newMethod.setConstructor(false);
        PullUpRefactoringProcessor.copyExtraDimensions(methodToCreateStubFor, newMethod);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, JdtFlags.clearFlag(1280, methodToCreateStubFor.getModifiers()), adjustments, monitor, false, status);
        if (this.getDestinationType().isInterface()) {
            modifiers |= 1;
        }
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)methodToCreateStubFor.getName()));
        TypeVariableMaplet[] mapping = TypeVariableUtil.composeMappings(TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), this.getDestinationType()), TypeVariableUtil.superTypeToInheritedType(this.getDestinationType(), (IType)typeToCreateStubIn.resolveBinding().getJavaElement()));
        this.copyReturnType(astRewrite, this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        this.copyParameters(astRewrite, this.getDeclaringType().getCompilationUnit(), methodToCreateStubFor, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(methodToCreateStubFor, newMethod);
        PullUpRefactoringProcessor.copyTypeParameters(methodToCreateStubFor, newMethod);
        newMethod.setJavadoc(this.createJavadocForStub(typeToCreateStubIn.getName().getIdentifier(), methodToCreateStubFor, newMethod, newCu, astRewrite));
        ImportRewrite importRewrite = rewriter.getImportRewrite();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)typeToCreateStubIn, importRewrite);
        ImportRewriteUtil.addImports(rewriter, context, (ASTNode)methodToCreateStubFor, new HashMap<Name, String>(), new HashMap<Name, String>(), true);
        IJavaProject javaProject = newCu.getJavaProject();
        CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(javaProject);
        StubUtility2Core.addOverrideAnnotation(codeGenerationSettings, javaProject, astRewrite, importRewrite, newMethod, this.getDeclaringType().isInterface(), (TextEditGroup)rewriter.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_override_annotation, SET_PULL_UP));
        astRewrite.getListRewrite((ASTNode)typeToCreateStubIn, typeToCreateStubIn.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newMethod, typeToCreateStubIn.bodyDeclarations()), (TextEditGroup)rewriter.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_method_stub, SET_PULL_UP));
    }

    private void addNecessaryMethodStubs(List<IType> affected, CompilationUnit root, CompilationUnitRewrite unitRewriter, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        IType declaringType = this.getDeclaringType();
        IMethod[] methods = this.getAbstractMethods();
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)affected.size());
            for (IType type : affected) {
                if (type.equals(declaringType)) continue;
                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unitRewriter.getRoot());
                ICompilationUnit unit = type.getCompilationUnit();
                SubMonitor subsubMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)methods.length);
                try {
                    IMethod[] iMethodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), type) == null) {
                            this.addMethodStubForAbstractMethod(method, root, declaration, unit, unitRewriter, adjustments, (IProgressMonitor)subsubMonitor.newChild(1), status);
                        }
                        ++n2;
                    }
                }
                finally {
                    subsubMonitor.done();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected boolean canBeAccessedFrom(IMember member, IType target, ITypeHierarchy hierarchy) throws JavaModelException {
        if (super.canBeAccessedFrom(member, target, hierarchy)) {
            IMethod method;
            IMethod stub;
            if (target.isInterface()) {
                return true;
            }
            if (target.equals(member.getDeclaringType())) {
                return true;
            }
            if (target.equals(member)) {
                return true;
            }
            if (member instanceof IMethod && (stub = target.getMethod((method = (IMethod)member).getElementName(), method.getParameterTypes())).exists()) {
                return true;
            }
            if (member.getDeclaringType() == null) {
                if (!(member instanceof IType)) {
                    return false;
                }
                if (JdtFlags.isPublic(member)) {
                    return true;
                }
                if (!JdtFlags.isPackageVisible(member)) {
                    return false;
                }
                if (JavaModelUtil.isSamePackage(((IType)member).getPackageFragment(), target.getPackageFragment())) {
                    return true;
                }
                IType type = member.getDeclaringType();
                if (type != null) {
                    return hierarchy.contains(type);
                }
                return false;
            }
            IType declaringType = member.getDeclaringType();
            if (!this.canBeAccessedFrom((IMember)declaringType, target, hierarchy)) {
                return false;
            }
            return !declaringType.equals(this.getDeclaringType());
        }
        return false;
    }

    private RefactoringStatus checkAccessedFields(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, (int)3);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)subMonitor.newChild(1)));
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
        IType destination = this.getDestinationType();
        IField[] iFieldArray = accessedFields;
        int n = accessedFields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (field.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(field) || deletedList.contains(field) || this.canBeAccessedFrom((IMember)field, destination, hierarchy) || Flags.isEnum((int)field.getFlags());
                if (!isAccessible) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(field, 2235681801344L), JavaElementLabelsCore.getTextLabel(destination, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                } else if (this.getSkippedSuperTypes((IProgressMonitor)subMonitor.newChild(1)).contains(field.getDeclaringType())) {
                    message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_field_cannot_be_accessed, new String[]{JavaElementLabelsCore.getTextLabel(field, 2235681801344L), JavaElementLabelsCore.getTextLabel(destination, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)field));
                }
            }
            ++n2;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, (int)3);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        List<IMethod> declaredAbstractList = Arrays.asList(this.fAbstractMethods);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)subMonitor.newChild(1)));
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToMove, this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
        IType destination = this.getDestinationType();
        IMethod[] iMethodArray = accessedMethods;
        int n = accessedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(method) || deletedList.contains(method) || declaredAbstractList.contains(method) || this.canBeAccessedFrom((IMember)method, destination, hierarchy);
                if (!isAccessible) {
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(method, 2235681801344L), JavaElementLabelsCore.getTextLabel(destination, 2235681801344L)});
                    result.addError(message, JavaStatusContext.create((IMember)method));
                } else if (this.getSkippedSuperTypes((IProgressMonitor)subMonitor.newChild(1)).contains(method.getDeclaringType())) {
                    Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(method, 2235681801344L), JavaElementLabelsCore.getTextLabel(destination, 2235681801344L)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_method_cannot_be_accessed, keys);
                    result.addError(message, JavaStatusContext.create((IMember)method));
                }
            }
            ++n2;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IProgressMonitor monitor, ITypeHierarchy hierarchy) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType destination = this.getDestinationType();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToMove);
        IType[] iTypeArray = this.getTypesReferencedInMovedMembers(monitor);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.exists() && !this.canBeAccessedFrom((IMember)type, destination, hierarchy) && !pulledUpList.contains(type)) {
                String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_type_not_accessible, new String[]{JavaElementLabelsCore.getTextLabel(type, 2235681801344L), JavaElementLabelsCore.getTextLabel(destination, 2235681801344L)});
                result.addError(message, JavaStatusContext.create((IMember)type));
            }
            ++n2;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkAccesses(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking_referenced_elements, (int)4);
            ITypeHierarchy hierarchy = this.getDestinationType().newSupertypeHierarchy((WorkingCopyOwner)this.fOwner, (IProgressMonitor)subMonitor.newChild(1));
            result.merge(this.checkAccessedTypes((IProgressMonitor)subMonitor.newChild(1), hierarchy));
            result.merge(this.checkAccessedFields((IProgressMonitor)subMonitor.newChild(1), hierarchy));
            result.merge(this.checkAccessedMethods((IProgressMonitor)subMonitor.newChild(1), hierarchy));
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private void checkAccessModifiers(RefactoringStatus result, Set<IMember> notDeletedMembersInSubtypes) throws JavaModelException {
        if (this.fDestinationType.isInterface()) {
            return;
        }
        List<IMethod> toDeclareAbstract = Arrays.asList(this.fAbstractMethods);
        for (IMember member : notDeletedMembersInSubtypes) {
            if (member.getElementType() != 9 || toDeclareAbstract.contains(member)) continue;
            IMethod method = (IMethod)member;
            if (method.getDeclaringType().getPackageFragment().equals(this.fDestinationType.getPackageFragment())) {
                if (!JdtFlags.isPrivate((IMember)method)) continue;
                result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_default_visibility, new String[]{JavaElementLabelsCore.getTextLabel(method, 2235681801344L), JavaElementLabelsCore.getTextLabel(method.getDeclaringType(), 2235681801344L)}), JavaStatusContext.create((IMember)method));
                continue;
            }
            if (JdtFlags.isPublic((IMember)method) || JdtFlags.isProtected((IMember)method)) continue;
            result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_lower_protected_visibility, new String[]{JavaElementLabelsCore.getTextLabel(method, 2235681801344L), JavaElementLabelsCore.getTextLabel(method.getDeclaringType(), 2235681801344L)}), JavaStatusContext.create((IMember)method));
        }
    }

    protected RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.getCandidateTypes(result, monitor).length == 0 && !result.hasFatalError()) {
            String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_not_this_type, new String[]{JavaElementLabelsCore.getTextLabel(this.getDeclaringType(), 2235681801344L)});
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }
        return result;
    }

    @Override
    protected RefactoringStatus checkDeclaringType(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus status = super.checkDeclaringType(monitor);
        if ("java.lang.Object".equals(this.getDeclaringType().getFullyQualifiedName('.'))) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PullUpRefactoring_no_java_lang_Object));
        }
        status.merge(this.checkDeclaringSuperTypes(monitor));
        return status;
    }

    private void checkFieldTypes(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        Map<IMember, Set<IMember>> mapping = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), true);
        IMember[] iMemberArray = this.fMembersToMove;
        int n = this.fMembersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IMember element = iMemberArray[n2];
            if (element.getElementType() == 8) {
                IField field = (IField)element;
                String type = Signature.toString((String)field.getTypeSignature());
                Assert.isTrue((boolean)mapping.containsKey(field));
                for (IMember member : mapping.get(field)) {
                    IField matchingField = (IField)member;
                    if (field.equals(matchingField) || type.equals(Signature.toString((String)matchingField.getTypeSignature()))) continue;
                    Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(matchingField, 2235681801344L), JavaElementLabelsCore.getTextLabel(matchingField.getDeclaringType(), 2235681801344L)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_field_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)matchingField.getCompilationUnit(), matchingField.getSourceRange());
                    status.addError(message, context);
                }
            }
            ++n2;
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)15);
            this.clearCaches();
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.createWorkingCopyLayer((IProgressMonitor)subMonitor.newChild(4)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkGenericDeclaringType((IProgressMonitor)subMonitor.newChild(1)));
            result.merge(this.checkFinalFields((IProgressMonitor)subMonitor.newChild(1)));
            result.merge(this.checkOuterFields((IProgressMonitor)subMonitor.newChild(1)));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkAccesses((IProgressMonitor)subMonitor.newChild(1)));
            result.merge(this.checkMembersInTypeAndAllSubtypes((IProgressMonitor)subMonitor.newChild(2)));
            result.merge(this.checkIfSkippingOverElements((IProgressMonitor)subMonitor.newChild(1)));
            result.merge(this.checkIfOverridingSuperClass((IProgressMonitor)subMonitor.newChild(1)));
            result.merge(this.checkIfHidingMethod(subMonitor.newChild(1)));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!JdtFlags.isAbstract((IMember)this.getDestinationType()) && this.getAbstractMethods().length > 0) {
                result.merge(this.checkConstructorCalls(this.getDestinationType(), (IProgressMonitor)subMonitor.newChild(1)));
            } else {
                monitor.worked(1);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fCompilationUnitRewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(3);
            result.merge(PullUpRefactoringProcessor.checkProjectCompliance());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)subMonitor.newChild(1), result);
            Checks.addModifiedFilesToChecker(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), context);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkIfHidingMethod(SubMonitor newChild) throws JavaModelException {
        SearchResultGroup[] matches;
        SearchResultGroup[] searchResultGroupArray = matches = this.findImplementors(this.fDestinationType, (IProgressMonitor)newChild);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup match = searchResultGroupArray[n2];
            SearchMatch[] searchMatchArray = match.getSearchResults();
            int n3 = searchMatchArray.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchMatch result = searchMatchArray[n4];
                if (result instanceof TypeReferenceMatch) {
                    TypeReferenceMatch typeMatch = (TypeReferenceMatch)result;
                    IType type = (IType)typeMatch.getElement();
                    IMember[] iMemberArray = this.fMembersToMove;
                    int n5 = this.fMembersToMove.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMethod iMethod;
                        IMethod methodInType;
                        IMember member = iMemberArray[n6];
                        if (member instanceof IMethod && (methodInType = JavaModelUtil.findMethod((iMethod = (IMethod)member).getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type)) != null && Modifier.isStatic((int)iMethod.getFlags()) != Modifier.isStatic((int)methodInType.getFlags())) {
                            String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_will_hide_method, new Object[]{methodInType.getElementName(), type.getElementName()});
                            RefactoringStatusContext context = JavaStatusContext.create((IMember)methodInType);
                            return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)context);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    protected RefactoringStatus checkOuterFields(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
        RefactoringStatus result = new RefactoringStatus();
        IType sourceType = this.getDeclaringType();
        ICompilationUnit source = this.getDeclaringType().getCompilationUnit();
        IType destination = this.getDestinationType();
        HashMap<ICompilationUnit, CompilationUnitRewrite> compilationUnitRewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(3);
        CompilationUnitRewrite sourceRewriter = this.getCompilationUnitRewrite(compilationUnitRewrites, source);
        CompilationUnit root = sourceRewriter.getRoot();
        IMember[] iMemberArray = this.fMembersToMove;
        int n = this.fMembersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeDeclBinding;
            MethodDeclaration oldMethod;
            AbstractTypeDeclaration typeDecl;
            IMember member = iMemberArray[n2];
            if (member.getElementType() == 9 && (typeDecl = ASTNodes.getFirstAncestorOrNull((ASTNode)(oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root)), AbstractTypeDeclaration.class)) != null && (typeDecl.isLocalTypeDeclaration() || typeDecl.isMemberTypeDeclaration()) && (typeDeclBinding = typeDecl.resolveBinding()) != null) {
                CheckInvalidOuterFieldAccess checker = new CheckInvalidOuterFieldAccess(sourceType, destination, typeDeclBinding);
                try {
                    oldMethod.accept((ASTVisitor)checker);
                }
                catch (AbortSearchException e) {
                    result.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_inaccessible_outer_fields, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)member, 2298807424L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L), JavaElementLabelsCore.getElementLabel(checker.getConflictBinding().getJavaElement(), 2235681801344L)}), null);
                }
            }
            ++n2;
        }
        subMonitor.done();
        return result;
    }

    protected RefactoringStatus checkFinalFields(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
        IMember[] iMemberArray = this.fMembersToMove;
        int n = this.fMembersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member.getElementType() == 8 && !JdtFlags.isStatic(member)) {
                if (JdtFlags.isFinal(member)) {
                    context = JavaStatusContext.create(member);
                    result.addWarning(RefactoringCoreMessages.PullUpRefactoring_final_fields, context);
                } else if (this.getDestinationType().isInterface()) {
                    context = JavaStatusContext.create(member);
                    result.addWarning(RefactoringCoreMessages.PullUpRefactoring_non_final_pull_up_to_interface, context);
                }
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus checkGenericDeclaringType(IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            IMember[] pullables = this.getMembersToMove();
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, pullables.length);
            IType declaring = this.getDeclaringType();
            ITypeParameter[] parameters = declaring.getTypeParameters();
            if (parameters.length > 0) {
                TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(declaring);
                IMember member = null;
                int length = 0;
                IMember[] iMemberArray = pullables;
                int n = pullables.length;
                int n2 = 0;
                while (n2 < n) {
                    IMember pullable;
                    member = pullable = iMemberArray[n2];
                    String[] unmapped = TypeVariableUtil.getUnmappedVariables(mapping, declaring, member);
                    length = unmapped.length;
                    String superClassLabel = BasicElementLabels.getJavaElementName(declaring.getSuperclassName());
                    switch (length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable_not_available, new String[]{unmapped[0], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        case 2: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable2_not_available, new String[]{unmapped[0], unmapped[1], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        case 3: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variable3_not_available, new String[]{unmapped[0], unmapped[1], unmapped[2], superClassLabel}), JavaStatusContext.create(member));
                            break;
                        }
                        default: {
                            status.addError(Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_variables_not_available, new String[]{superClassLabel}), JavaStatusContext.create(member));
                        }
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++n2;
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus checkIfDeclaredIn(IMember element, IType type) throws JavaModelException {
        if (element instanceof IMethod) {
            return this.checkIfMethodDeclaredIn((IMethod)element, type);
        }
        if (element instanceof IField) {
            return this.checkIfFieldDeclaredIn((IField)element, type);
        }
        if (element instanceof IType) {
            return this.checkIfTypeDeclaredIn((IType)element, type);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private RefactoringStatus checkIfFieldDeclaredIn(IField iField, IType type) throws JavaModelException {
        IField fieldInType = type.getField(iField.getElementName());
        if (!fieldInType.exists() || !iField.getTypeSignature().equals(fieldInType.getTypeSignature())) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(fieldInType, 2235681801344L), JavaElementLabelsCore.getTextLabel(type, 2235681801344L)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Field_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)fieldInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfMethodDeclaredIn(IMethod iMethod, IType type) throws JavaModelException {
        IMethod methodInType = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type);
        if (methodInType == null || !methodInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(methodInType, 2235681801344L), iMethod.getElementName(), JavaElementLabelsCore.getTextLabel(methodInType, 2235681801344L)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Method_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)methodInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    private RefactoringStatus checkIfSkippingOverElements(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
        try {
            Set<IType> skippedTypes = this.getSkippedSuperTypes((IProgressMonitor)subMonitor.newChild(1));
            IType[] skipped = skippedTypes.toArray(new IType[skippedTypes.size()]);
            RefactoringStatus result = new RefactoringStatus();
            IMember[] iMemberArray = this.fMembersToMove;
            int n = this.fMembersToMove.length;
            int n2 = 0;
            while (n2 < n) {
                IMember element = iMemberArray[n2];
                IType[] iTypeArray = skipped;
                int n3 = skipped.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType element2 = iTypeArray[n4];
                    result.merge(this.checkIfDeclaredIn(element, element2));
                    ++n4;
                }
                ++n2;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkIfOverridingSuperClass(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
        try {
            Set<IType> superTypeSet = this.getAllSuperTypes((IProgressMonitor)subMonitor.newChild(1));
            IType[] superTypes = superTypeSet.toArray(new IType[superTypeSet.size()]);
            RefactoringStatus result = new RefactoringStatus();
            IMember[] iMemberArray = this.fMembersToMove;
            int n = this.fMembersToMove.length;
            int n2 = 0;
            while (n2 < n) {
                IMember element = iMemberArray[n2];
                IType[] iTypeArray = superTypes;
                int n3 = superTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType element2 = iTypeArray[n4];
                    result.merge(this.checkIfDeclaredIn(element, element2));
                    ++n4;
                }
                ++n2;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus checkIfTypeDeclaredIn(IType iType, IType type) {
        IType typeInType = type.getType(iType.getElementName());
        if (!typeInType.exists()) {
            return null;
        }
        Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(typeInType, 2235681801344L), JavaElementLabelsCore.getTextLabel(type, 2235681801344L)};
        String msg = Messages.format(RefactoringCoreMessages.PullUpRefactoring_Type_declared_in_class, keys);
        RefactoringStatusContext context = JavaStatusContext.create((IMember)typeInType);
        return RefactoringStatus.createWarningStatus((String)msg, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
            RefactoringStatus status = new RefactoringStatus();
            status.merge(this.checkDeclaringType((IProgressMonitor)subMonitor.newChild(1)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            status.merge(this.checkIfMembersExist());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void checkMembersInDestinationType(RefactoringStatus status, Set<IMember> set) throws JavaModelException {
        IMember[] destinationMembers = this.getCreatedDestinationMembers();
        ArrayList<IMember> list = new ArrayList<IMember>(destinationMembers.length);
        list.addAll(Arrays.asList(destinationMembers));
        list.addAll(set);
        list.removeAll(Arrays.asList(this.fDeletedMethods));
        IMember[] members = list.toArray(new IMember[list.size()]);
        status.merge(MemberCheckUtil.checkMembersInDestinationType(members, this.getDestinationType()));
    }

    private RefactoringStatus checkMembersInTypeAndAllSubtypes(IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)3);
        Set<IMember> notDeletedMembers = this.getNotDeletedMembers((IProgressMonitor)subMonitor.newChild(1));
        HashSet<IMember> notDeletedMembersInTargetType = new HashSet<IMember>();
        HashSet<IMember> notDeletedMembersInSubtypes = new HashSet<IMember>();
        for (IMember member : notDeletedMembers) {
            if (this.getDestinationType().equals(member.getDeclaringType())) {
                notDeletedMembersInTargetType.add(member);
                continue;
            }
            notDeletedMembersInSubtypes.add(member);
        }
        this.checkMembersInDestinationType(result, notDeletedMembersInTargetType);
        this.checkAccessModifiers(result, notDeletedMembersInSubtypes);
        this.checkMethodReturnTypes((IProgressMonitor)subMonitor.newChild(1), result, notDeletedMembersInSubtypes);
        this.checkFieldTypes((IProgressMonitor)subMonitor.newChild(1), result);
        monitor.done();
        return result;
    }

    private void checkMethodReturnTypes(IProgressMonitor monitor, RefactoringStatus status, Set<IMember> notDeletedMembersInSubtypes) throws JavaModelException {
        Map<IMember, Set<IMember>> mapping = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), true);
        IMember[] iMemberArray = this.getCreatedDestinationMembers();
        int n = iMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set<IMember> set;
            IMethod method;
            IMember member = iMemberArray[n2];
            if (member.getElementType() == 9 && mapping.containsKey(method = (IMethod)member) && (set = mapping.get(method)) != null) {
                String returnType = Signature.toString((String)Signature.getReturnType((String)method.getSignature()).toString());
                for (IMember iMember : set) {
                    IMethod matchingMethod = (IMethod)iMember;
                    if (method.equals(matchingMethod) || !notDeletedMembersInSubtypes.contains(matchingMethod) || returnType.equals(Signature.toString((String)Signature.getReturnType((String)matchingMethod.getSignature()).toString()))) continue;
                    Object[] keys = new String[]{JavaElementLabelsCore.getTextLabel(matchingMethod, 2235681801344L), JavaElementLabelsCore.getTextLabel(matchingMethod.getDeclaringType(), 2235681801344L)};
                    String message = Messages.format(RefactoringCoreMessages.PullUpRefactoring_different_method_return_type, keys);
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)matchingMethod.getCompilationUnit(), matchingMethod.getNameRange());
                    status.addError(message, context);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void clearCaches() {
        super.clearCaches();
        this.fCachedMembersReferences.clear();
        this.fCachedDestinationTypeHierarchy = null;
        this.fCachedDeclaringSuperTypeHierarchy = null;
    }

    private void copyBodyOfPulledUpMethod(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, TypeVariableMaplet[] mapping, Map<IMethod, String> newArgumentMap, IProgressMonitor monitor) throws JavaModelException {
        Block body = oldMethod.getBody();
        if (body == null) {
            newMethod.setBody(null);
            return;
        }
        try {
            Document document = new Document(method.getCompilationUnit().getBuffer().getContents());
            ASTRewrite rewrite = ASTRewrite.create((AST)body.getAST());
            ITrackedNodePosition position = rewrite.track((ASTNode)body);
            PullUpAstNodeMapper nodeMapper = new PullUpAstNodeMapper(sourceRewrite, targetRewrite, rewrite, this.getDeclaringSuperTypeHierarchy(monitor).getSuperclass(this.getDeclaringType()), mapping, oldMethod, this.fMembersToMove, newArgumentMap);
            body.accept((ASTVisitor)nodeMapper);
            rewrite.rewriteAST((IDocument)document, method.getCompilationUnit().getOptions(true)).apply((IDocument)document, 0);
            String content = document.get(position.getStartPosition(), position.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, method.getCompilationUnit(), false);
            content = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
            newMethod.setBody((Block)targetRewrite.getASTRewrite().createStringPlaceholder(content, 8));
        }
        catch (BadLocationException | MalformedTreeException exception) {
            JavaManipulationPlugin.log(exception);
        }
    }

    private void createAbstractMethod(IMethod sourceMethod, CompilationUnitRewrite sourceRewriter, CompilationUnit declaringCuNode, AbstractTypeDeclaration destination, TypeVariableMaplet[] mapping, CompilationUnitRewrite targetRewrite, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        String newJavadocString;
        MethodDeclaration oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode(sourceMethod, declaringCuNode);
        ITypeBinding destinationBinding = destination.resolveBinding();
        StubUtility2Core.addOverrideAnnotation(this.fSettings, sourceMethod.getJavaProject(), sourceRewriter.getASTRewrite(), sourceRewriter.getImportRewrite(), oldMethod, destinationBinding == null ? false : destinationBinding.isInterface(), (TextEditGroup)sourceRewriter.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_override_annotation, SET_PULL_UP));
        MethodDeclaration newMethod = targetRewrite.getAST().newMethodDeclaration();
        newMethod.setBody(null);
        newMethod.setConstructor(false);
        PullUpRefactoringProcessor.copyExtraDimensions(oldMethod, newMethod);
        Javadoc oldJavadoc = oldMethod.getJavadoc();
        if (oldJavadoc != null && (newJavadocString = ASTNodes.getNodeSource((ASTNode)oldJavadoc, false, true)) != null) {
            newMethod.setJavadoc((Javadoc)targetRewrite.getASTRewrite().createStringPlaceholder(newJavadocString, 29));
        }
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, 0x400 | JdtFlags.clearFlag(272, sourceMethod.getFlags()), adjustments, monitor, false, status);
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(targetRewrite.getAST(), modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)oldMethod.getName()));
        this.copyReturnType(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(targetRewrite.getASTRewrite(), this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PullUpRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)destination, targetRewrite.getImportRewrite());
        ImportRewriteUtil.addImports(targetRewrite, context, (ASTNode)oldMethod, new HashMap<Name, String>(), new HashMap<Name, String>(), true);
        targetRewrite.getASTRewrite().getListRewrite((ASTNode)destination, destination.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newMethod, destination.bodyDeclarations()), (TextEditGroup)targetRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_abstract_method, SET_PULL_UP));
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaProject javaProject = declaring.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
            String description = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_short, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMembersToMove[0], 0x200009L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 0x200009L)}) : Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_short_multiple, BasicElementLabels.getJavaElementName(this.fDestinationType.getElementName()));
            String header = this.fMembersToMove.length == 1 ? Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description_full, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMembersToMove[0], 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)declaring, 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L)}) : Messages.format(RefactoringCoreMessages.PullUpRefactoring_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)declaring, 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_target_element_pattern, JavaElementLabelsCore.getElementLabel((IJavaElement)this.fDestinationType, 2235681801344L)));
            this.addSuperTypeSettings(comment, true);
            PullUpDescriptor descriptor = RefactoringSignatureDescriptorFactory.createPullUpDescriptor(project, description, comment.asString(), arguments, flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fDestinationType));
            arguments.put("replace", Boolean.toString(this.fReplace));
            arguments.put("instanceof", Boolean.toString(this.fInstanceOf));
            arguments.put(ATTRIBUTE_STUBS, Boolean.toString(this.fCreateMethodStubs));
            arguments.put(ATTRIBUTE_PULL, Integer.toString(this.fMembersToMove.length));
            int offset = 0;
            while (offset < this.fMembersToMove.length) {
                arguments.put("element" + (offset + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fMembersToMove[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_DELETE, Integer.toString(this.fDeletedMethods.length));
            offset = 0;
            while (offset < this.fDeletedMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fDeletedMethods[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_ABSTRACT, Integer.toString(this.fAbstractMethods.length));
            offset = 0;
            while (offset < this.fAbstractMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fAbstractMethods[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.PullUpRefactoring_Pull_Up, (Change[])this.fChangeManager.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
            this.clearCaches();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            block54: {
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)24);
                source = this.getDeclaringType().getCompilationUnit();
                destination = this.getDestinationType();
                target = destination.getCompilationUnit();
                sourceRewriter = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, source);
                targetRewriter = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, target);
                deleteMap = this.createMembersToDeleteMap((IProgressMonitor)subMonitor.newChild(1));
                affectedMap = this.createAffectedTypesMap((IProgressMonitor)subMonitor.newChild(1));
                units = this.getAffectedCompilationUnits((IProgressMonitor)subMonitor.newChild(1));
                adjustments = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
                adjustor = null;
                sub = subMonitor.newChild(1);
                try {
                    sub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, units.length * 11);
                    var18_15 = units;
                    var17_16 = units.length;
                    var16_19 = 0;
                    while (var16_19 < var17_16) {
                        block48: {
                            block53: {
                                block49: {
                                    block47: {
                                        unit = var18_15[var16_19];
                                        if (source.equals(unit) || target.equals(unit) || deleteMap.containsKey(unit) || affectedMap.containsKey(unit)) break block47;
                                        sub.worked(10);
                                        break block48;
                                    }
                                    rewrite = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, unit);
                                    if (deleteMap.containsKey(unit)) {
                                        list = new LinkedList<IMember>((Collection)deleteMap.get(unit));
                                        if (destination.isInterface()) {
                                            iterator = list.iterator();
                                            while (iterator.hasNext()) {
                                                member = (IMember)iterator.next();
                                                if (!(member instanceof IMethod)) continue;
                                                iterator.remove();
                                            }
                                        }
                                        PullUpRefactoringProcessor.deleteDeclarationNodes(sourceRewriter.getCu().equals(targetRewriter.getCu()), rewrite, list, PullUpRefactoringProcessor.SET_PULL_UP);
                                    }
                                    root = sourceRewriter.getRoot();
                                    if (!unit.equals(target)) break block49;
                                    rewriter = rewrite.getASTRewrite();
                                    if (!JdtFlags.isAbstract((IMember)destination) && !destination.isInterface() && this.getAbstractMethods().length > 0) {
                                        declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(destination, rewrite.getRoot());
                                        ModifierRewrite.create(rewriter, (ASTNode)declaration).setModifiers(declaration.getModifiers() | 1024, (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_make_target_abstract, PullUpRefactoringProcessor.SET_PULL_UP));
                                    }
                                    if ((mapping = TypeVariableUtil.subTypeToSuperType(this.getDeclaringType(), destination)).length == 0 && destination.isInterface()) {
                                        mapping = TypeVariableUtil.subTypeToImplementedType(this.getDeclaringType(), destination);
                                    }
                                    subsub = sub.newChild(1);
                                    declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(destination, rewrite.getRoot());
                                    context = new ContextSensitiveImportRewriteContext((ASTNode)declaration, rewrite.getImportRewrite());
                                    this.fMembersToMove = JavaElementUtil.sortByOffset(this.fMembersToMove);
                                    newArgumentMap = this.getNewArgumentMap(this.fMembersToMove, root);
                                    subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fMembersToMove.length);
                                    member = null;
                                    offset = this.fMembersToMove.length - 1;
                                    while (offset >= 0) {
                                        block52: {
                                            block51: {
                                                block50: {
                                                    member = this.fMembersToMove[offset];
                                                    adjustor = new MemberVisibilityAdjustor((IJavaElement)destination, member);
                                                    adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                                    adjustor.setFailureSeverity(2);
                                                    adjustor.setOwner(this.fOwner);
                                                    adjustor.setRewrites(this.fCompilationUnitRewrites);
                                                    adjustor.setStatus(status);
                                                    adjustor.setAdjustments(adjustments);
                                                    adjustor.adjustVisibility((IProgressMonitor)subsub.newChild(1));
                                                    adjustments.remove(member);
                                                    if (!(member instanceof IField)) break block50;
                                                    oldField = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, root);
                                                    if (oldField == null) break block51;
                                                    flags = this.getModifiersWithUpdatedVisibility(member, member.getFlags(), adjustments, (IProgressMonitor)subsub.newChild(1), true, status);
                                                    newField = PullUpRefactoringProcessor.createNewFieldDeclarationNode(rewriter, root, (IField)member, oldField, mapping, flags);
                                                    rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newField, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newField, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                                    ImportRewriteUtil.addImports(rewrite, context, oldField.getParent(), new HashMap<Name, String>(), new HashMap<Name, String>(), false);
                                                    if (!(oldField.getParent() instanceof FieldDeclaration)) break block51;
                                                    vds = (FieldDeclaration)oldField.getParent();
                                                    oldTypeBinding = vds.getType().resolveBinding();
                                                    if (oldTypeBinding != null && !oldTypeBinding.isPrimitive()) {
                                                        sourcePackage = oldTypeBinding.getPackage() == null ? "" : oldTypeBinding.getPackage().getName();
                                                        targetPackage = targetRewriter.getRoot().getPackage() == null ? "" : targetRewriter.getRoot().getPackage().getName().toString();
                                                        targetTypeBinding = targetPackage + "." + oldTypeBinding.getName();
                                                        qualifiedTypeNameInTarget = true;
                                                        sourceSignature = ((IField)member).getTypeSignature();
                                                        var42_64 = this.fDestinationType.getFields();
                                                        var41_62 = var42_64.length;
                                                        var40_60 = 0;
                                                        while (var40_60 < var41_62) {
                                                            targetField = var42_64[var40_60];
                                                            if (sourceSignature.equals(targetField.getTypeSignature())) {
                                                                qualifiedTypeNameInTarget = false;
                                                                break;
                                                            }
                                                            ++var40_60;
                                                        }
                                                        findTargetType = target.getJavaProject().findType(targetTypeBinding);
                                                        if (!qualifiedTypeNameInTarget && findTargetType != null) {
                                                            if (sourcePackage.isEmpty() ^ targetPackage.isEmpty()) {
                                                                status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_moving_fromto_default_package, new String[]{JavaElementLabelsCore.getTextLabel(member, 2235681801344L)}), (RefactoringStatusContext)JavaStatusContext.create(member)));
                                                            }
                                                            if (!sourcePackage.isEmpty()) {
                                                                newName = rewrite.getAST().newName(sourcePackage);
                                                                newSimpleName = rewrite.getAST().newSimpleName(oldTypeBinding.getName());
                                                                newSimpleType = null;
                                                                if (targetPackage.equals(sourcePackage)) {
                                                                    newSimpleType = rewrite.getAST().newSimpleType((Name)newSimpleName);
                                                                } else {
                                                                    newQualifiedTypeName = rewrite.getAST().newQualifiedName(newName, newSimpleName);
                                                                    newSimpleType = rewrite.getAST().newSimpleType((Name)newQualifiedTypeName);
                                                                }
                                                                newField.setType((Type)newSimpleType);
                                                                ** GOTO lbl129
                                                            } else {
                                                                ** GOTO lbl109
                                                            }
                                                        } else {
                                                            ** GOTO lbl109
                                                        }
                                                    }
                                                    break block52;
lbl109:
                                                    // 4 sources

                                                    break block51;
                                                }
                                                if (member instanceof IMethod) {
                                                    oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root);
                                                    if (oldMethod != null) {
                                                        if (JdtFlags.isStatic(member) && this.fDestinationType.isInterface()) {
                                                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.PullUpRefactoring_moving_static_method_to_interface, new String[]{JavaElementLabelsCore.getTextLabel(member, 2235681801344L)}), (RefactoringStatusContext)JavaStatusContext.create(member)));
                                                        }
                                                        newMethod = this.createNewMethodDeclarationNode(sourceRewriter, rewrite, (IMethod)member, oldMethod, mapping, adjustments, newArgumentMap, (IProgressMonitor)subsub.newChild(1), status);
                                                        rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newMethod, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)newMethod, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                                        ImportRewriteUtil.addImports(rewrite, context, (ASTNode)oldMethod, new HashMap<Name, String>(), new HashMap<Name, String>(), newMethod.getBody() == null);
                                                    }
                                                } else if (member instanceof IType) {
                                                    oldType = ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)member, root);
                                                    if (oldType != null) {
                                                        newType = this.createNewTypeDeclarationNode((IType)member, oldType, root, mapping, rewriter);
                                                        rewriter.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newType, BodyDeclarationRewrite.getInsertionIndex(newType, declaration.bodyDeclarations()), (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.HierarchyRefactoring_add_member, PullUpRefactoringProcessor.SET_PULL_UP));
                                                        ImportRewriteUtil.addImports(rewrite, context, (ASTNode)oldType, new HashMap<Name, String>(), new HashMap<Name, String>(), false);
                                                    }
                                                } else {
                                                    Assert.isTrue((boolean)false);
                                                }
                                            }
                                            subsub.worked(1);
                                        }
                                        --offset;
                                    }
                                    subsub.done();
                                    var31_51 = this.fAbstractMethods;
                                    newType = this.fAbstractMethods.length;
                                    var29_42 = 0;
                                    while (var29_42 < newType) {
                                        abstractMethod = var31_51[var29_42];
                                        this.createAbstractMethod(abstractMethod, sourceRewriter, root, declaration, mapping, rewrite, adjustments, (IProgressMonitor)sub.newChild(1), status);
                                        ++var29_42;
                                    }
                                    break block53;
                                }
                                sub.worked(2);
                            }
                            if (unit.equals(sourceRewriter.getCu())) {
                                subsub = sub.newChild(1);
                                subsub.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, this.fAbstractMethods.length * 2);
                                var25_32 = this.fAbstractMethods;
                                declaration = this.fAbstractMethods.length;
                                subsub = 0;
                                while (subsub < declaration) {
                                    method = var25_32[subsub];
                                    adjustor = new MemberVisibilityAdjustor((IJavaElement)destination, (IMember)method);
                                    adjustor.setRewrite(sourceRewriter.getASTRewrite(), root);
                                    adjustor.setRewrites(this.fCompilationUnitRewrites);
                                    adjustor.setFailureSeverity(2);
                                    adjustor.setOwner(this.fOwner);
                                    adjustor.setStatus(status);
                                    adjustor.setAdjustments(adjustments);
                                    if (destination.isInterface() && !JdtFlags.isPublic((IMember)method)) {
                                        adjustments.put((IMember)method, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)method, Modifier.ModifierKeyword.PUBLIC_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)method), RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public}), (RefactoringStatusContext)JavaStatusContext.create((IMember)method))));
                                    } else if (this.needsVisibilityAdjustment((IMember)method, false, (IProgressMonitor)subsub.newChild(1), status)) {
                                        adjustments.put((IMember)method, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)method, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)method), RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected}), (RefactoringStatusContext)JavaStatusContext.create((IMember)method))));
                                    }
                                    ++subsub;
                                }
                            } else {
                                sub.worked(2);
                            }
                            if (affectedMap.containsKey(unit)) {
                                this.addNecessaryMethodStubs((List<IType>)affectedMap.get(unit), root, rewrite, adjustments, (IProgressMonitor)sub.newChild(2), status);
                            }
                            if (sub.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                        }
                        ++var16_19;
                    }
                }
                finally {
                    sub.done();
                }
                if (adjustor != null && !adjustments.isEmpty()) {
                    adjustor.rewriteVisibility((IProgressMonitor)subMonitor.newChild(1));
                }
                manager = new TextEditBasedChangeManager();
                if (!this.fReplace) break block54;
                entrySet = this.fCompilationUnitRewrites.entrySet();
                for (Map.Entry entry : entrySet) {
                    unit = (ICompilationUnit)entry.getKey();
                    rewrite = (CompilationUnitRewrite)entry.getValue();
                    if (rewrite == null || (change = rewrite.createChange(false)) == null) continue;
                    manager.manage(unit, (TextEditBasedChange)change);
                }
                edit = null;
                change = null;
                workingcopies = new HashMap<ICompilationUnit, ICompilationUnit>();
                subsubMonitor = subMonitor.newChild(1);
                try {
                    subsubMonitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, entrySet.size());
                    for (Map.Entry<ICompilationUnit, CompilationUnitRewrite> entry : entrySet) {
                        unit = entry.getKey();
                        change = manager.get(unit);
                        if (!(change instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null || (copy = this.createWorkingCopy(unit, edit, status, (IProgressMonitor)subsubMonitor.newChild(1))) == null) continue;
                        workingcopies.put(unit, copy);
                    }
                    current = (ICompilationUnit)workingcopies.get(sourceRewriter.getCu());
                    if (current != null) {
                        this.rewriteTypeOccurrences(manager, sourceRewriter, current, new HashSet<String>(), status, (IProgressMonitor)subMonitor.newChild(16));
                    }
                }
                finally {
                    subMonitor.done();
                    var29_45 = manager.getAllCompilationUnits();
                    var28_41 = var29_45.length;
                    var27_37 = 0;
                    if (true) ** GOTO lbl229
                }
                {
                }
                do {
                    unit = var29_45[var27_37];
                    current = (CompilationUnitChange)manager.get(unit);
                    if (change != null && current.getEdit() == null) {
                        manager.remove(unit);
                    }
                    ++var27_37;
lbl229:
                    // 2 sources

                } while (var27_37 < var28_41);
            }
            this.registerChanges(manager);
            var46_67 = manager;
            return var46_67;
        }
        finally {
            this.fCompilationUnitRewrites.clear();
            monitor.done();
        }
    }

    private Map<IMethod, String> getNewArgumentMap(IMember[] membersToMove, CompilationUnit root) throws JavaModelException {
        HashMap<IMethod, String> newArgumentsMap = new HashMap<IMethod, String>();
        IMember[] iMemberArray = membersToMove;
        int n = membersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration oldMethod;
            IMember member = iMemberArray[n2];
            if (member instanceof IMethod && (oldMethod = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, root)) != null) {
                if (JdtFlags.isStatic(member) && this.fDestinationType.isInterface()) {
                    return newArgumentsMap;
                }
                NewArgumentMethodChecker checker = new NewArgumentMethodChecker(newArgumentsMap, oldMethod, membersToMove, root);
                checker.traverseNodeInterruptibly((ASTNode)oldMethod);
            }
            ++n2;
        }
        return newArgumentsMap;
    }

    private Map<ICompilationUnit, ArrayList<IType>> createAffectedTypesMap(IProgressMonitor monitor) throws JavaModelException {
        if (!this.fCreateMethodStubs || this.getAbstractMethods().length <= 0) {
            return new HashMap<ICompilationUnit, ArrayList<IType>>(0);
        }
        Set<IType> affected = PullUpRefactoringProcessor.getAffectedSubTypes(this.getDestinationTypeHierarchy(monitor), this.getDestinationType());
        HashMap<ICompilationUnit, ArrayList<IType>> result = new HashMap<ICompilationUnit, ArrayList<IType>>();
        for (IType type : affected) {
            ICompilationUnit unit = type.getCompilationUnit();
            if (!result.containsKey(unit)) {
                result.put(unit, new ArrayList(1));
            }
            ((ArrayList)result.get(unit)).add(type);
        }
        return result;
    }

    private Javadoc createJavadocForStub(String enclosingTypeName, MethodDeclaration oldMethod, MethodDeclaration newMethodNode, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        IMethodBinding binding;
        if (this.fSettings.createComments && (binding = oldMethod.resolveBinding()) != null) {
            ITypeBinding[] params = binding.getParameterTypes();
            String fullTypeName = this.getDestinationType().getFullyQualifiedName('.');
            String[] fullParamNames = new String[params.length];
            int i = 0;
            while (i < fullParamNames.length) {
                fullParamNames[i] = Bindings.getFullyQualifiedName(params[i]);
                ++i;
            }
            String comment = CodeGeneration.getMethodComment(cu, enclosingTypeName, newMethodNode, false, binding.getName(), fullTypeName, fullParamNames, StubUtility.getLineDelimiterUsed((IJavaElement)cu));
            if (comment != null) {
                return (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            }
        }
        return null;
    }

    private Map<ICompilationUnit, ArrayList<IMember>> createMembersToDeleteMap(IProgressMonitor monitor) throws JavaModelException {
        HashMap<ICompilationUnit, ArrayList<IMember>> result = new HashMap<ICompilationUnit, ArrayList<IMember>>();
        IMember[] iMemberArray = this.getMembersToDelete(monitor);
        int n = iMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            ICompilationUnit cu = member.getCompilationUnit();
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((ArrayList)result.get(cu)).add(member);
            ++n2;
        }
        return result;
    }

    private MethodDeclaration createNewMethodDeclarationNode(CompilationUnitRewrite sourceRewrite, CompilationUnitRewrite targetRewrite, IMethod sourceMethod, MethodDeclaration oldMethod, TypeVariableMaplet[] mapping, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, Map<IMethod, String> newArgumentsMap, IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException {
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        ITypeBinding destinationBinding = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDestinationType(), targetRewrite.getRoot()).resolveBinding();
        StubUtility2Core.addOverrideAnnotation(this.fSettings, sourceMethod.getJavaProject(), sourceRewrite.getASTRewrite(), sourceRewrite.getImportRewrite(), oldMethod, destinationBinding == null ? false : destinationBinding.isInterface(), (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.PullUpRefactoring_add_override_annotation, SET_PULL_UP));
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        if (!this.getDestinationType().isInterface()) {
            this.copyBodyOfPulledUpMethod(sourceRewrite, targetRewrite, sourceMethod, oldMethod, newMethod, mapping, newArgumentsMap, monitor);
        }
        newMethod.setConstructor(oldMethod.isConstructor());
        PullUpRefactoringProcessor.copyExtraDimensions(oldMethod, newMethod);
        PullUpRefactoringProcessor.copyJavadocNode(rewrite, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        int modifiers = this.getModifiersWithUpdatedVisibility((IMember)sourceMethod, sourceMethod.getFlags(), adjustments, monitor, true, status);
        if (this.fDeletedMethods.length == 0 || this.getDestinationType().isInterface()) {
            modifiers &= 0xFFFFFFEF;
        }
        if (oldMethod.isVarargs()) {
            modifiers &= 0xFFFFFF7F;
        }
        PullUpRefactoringProcessor.copyAnnotations(oldMethod, newMethod);
        newMethod.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        newMethod.setName((SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)oldMethod.getName()));
        this.copyReturnType(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        this.copyParameters(rewrite, this.getDeclaringType().getCompilationUnit(), oldMethod, newMethod, mapping);
        String newArgument = newArgumentsMap.get(sourceMethod);
        if (newArgument != null) {
            SearchResultGroup[] matches;
            SearchResultGroup[] searchResultGroupArray = matches = this.findReferences((IMember)sourceMethod, (IProgressMonitor)new NullProgressMonitor());
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                SearchResultGroup match = searchResultGroupArray[n2];
                ICompilationUnit cu = match.getCompilationUnit();
                CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(this.fCompilationUnitRewrites, cu);
                SearchMatch[] searchMatchArray = match.getSearchResults();
                int n3 = searchMatchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch result = searchMatchArray[n4];
                    if (result instanceof MethodReferenceMatch) {
                        MethodReferenceMatch methodMatch = (MethodReferenceMatch)result;
                        MethodDeclaration methodDecl = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)methodMatch.getElement(), rewriter.getRoot());
                        methodDecl.accept((ASTVisitor)new AddParameterVisitor(rewriter, oldMethod.getName().getFullyQualifiedName()));
                    }
                    ++n4;
                }
                ++n2;
            }
            this.addParameter(rewrite, oldMethod, newMethod, targetRewrite, newArgument);
            this.fArgumentAddedToHandleThis = true;
        }
        PullUpRefactoringProcessor.copyThrownExceptions(oldMethod, newMethod);
        PullUpRefactoringProcessor.copyTypeParameters(oldMethod, newMethod);
        return newMethod;
    }

    private SearchResultGroup[] findReferences(IMember member, IProgressMonitor monitor) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24);
        if (pattern == null) {
            return new SearchResultGroup[0];
        }
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setOwner(this.fOwner);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
        engine.searchPattern(monitor);
        return (SearchResultGroup[])engine.getResults();
    }

    private SearchResultGroup[] findImplementors(IType type, IProgressMonitor monitor) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)type, (int)1, (int)24);
        if (pattern == null) {
            return new SearchResultGroup[0];
        }
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setOwner(this.fOwner);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)type));
        engine.searchPattern(monitor);
        return (SearchResultGroup[])engine.getResults();
    }

    private BodyDeclaration createNewTypeDeclarationNode(IType type, AbstractTypeDeclaration oldType, CompilationUnit declaringCuNode, TypeVariableMaplet[] mapping, ASTRewrite rewrite) throws JavaModelException {
        ICompilationUnit declaringCu = this.getDeclaringType().getCompilationUnit();
        if (!JdtFlags.isPublic((IMember)type) && !JdtFlags.isProtected((IMember)type)) {
            if (mapping.length > 0) {
                return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite);
            }
            return PullUpRefactoringProcessor.createPlaceholderForProtectedTypeDeclaration((BodyDeclaration)oldType, declaringCuNode, declaringCu, rewrite, true);
        }
        if (mapping.length > 0) {
            return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, mapping, rewrite);
        }
        return PullUpRefactoringProcessor.createPlaceholderForTypeDeclaration((BodyDeclaration)oldType, declaringCu, rewrite, true);
    }

    private ICompilationUnit createWorkingCopy(ICompilationUnit unit, TextEdit edit, RefactoringStatus status, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
            ICompilationUnit copy = this.getSharedWorkingCopy(unit.getPrimary(), (IProgressMonitor)subMonitor.newChild(1));
            Document document = new Document(unit.getBuffer().getContents());
            edit.apply((IDocument)document, 2);
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
            ICompilationUnit iCompilationUnit = copy;
            return iCompilationUnit;
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException exception) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        try {
            monitor.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 1);
            ICompilationUnit unit = this.getDeclaringType().getCompilationUnit();
            if (this.fLayer) {
                unit = unit.findWorkingCopy((WorkingCopyOwner)this.fOwner);
            }
            this.resetWorkingCopies(unit);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IMethod[] getAbstractMethods() throws JavaModelException {
        IMethod[] toDeclareAbstract = this.fAbstractMethods;
        IMethod[] abstractPulledUp = this.getAbstractMethodsToPullUp();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(toDeclareAbstract.length + abstractPulledUp.length + this.fMembersToMove.length);
        if (this.fDestinationType.isInterface()) {
            IMember[] iMemberArray = this.fMembersToMove;
            int n = this.fMembersToMove.length;
            int n2 = 0;
            while (n2 < n) {
                IMember element = iMemberArray[n2];
                if (element.getElementType() == 9) {
                    result.add(element);
                }
                ++n2;
            }
        }
        result.addAll(Arrays.asList(toDeclareAbstract));
        result.addAll(Arrays.asList(abstractPulledUp));
        return result.toArray(new IMethod[result.size()]);
    }

    private IMethod[] getAbstractMethodsToPullUp() throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMembersToMove.length);
        IMember[] iMemberArray = this.fMembersToMove;
        int n = this.fMembersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member instanceof IMethod && JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public IMember[] getAdditionalRequiredMembersToPullUp(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IMember> queue;
        IMember[] members = this.getCreatedDestinationMembers();
        try {
            IMember current;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_calculating_required, (int)this.getDeclaringType().getChildren().length);
            queue = new ArrayList<IMember>(members.length);
            queue.addAll(Arrays.asList(members));
            if (queue.isEmpty()) {
                IMember[] iMemberArray = new IMember[]{};
                return iMemberArray;
            }
            int i = 0;
            do {
                current = (IMember)queue.get(i);
                this.addAllRequiredPullableMembers(queue, current, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.setWorkRemaining(queue.size());
                if (queue.size() != ++i) continue;
                current = null;
            } while (current != null);
            subMonitor.worked(queue.size());
            queue.removeAll(Arrays.asList(members));
        }
        finally {
            monitor.done();
        }
        return queue.toArray(new IMember[queue.size()]);
    }

    private ICompilationUnit[] getAffectedCompilationUnits(IProgressMonitor monitor) throws JavaModelException {
        IType[] allSubtypes = this.getDestinationTypeHierarchy(monitor).getAllSubtypes(this.getDestinationType());
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(allSubtypes.length);
        IType[] iTypeArray = allSubtypes;
        int n = allSubtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType subtype = iTypeArray[n2];
            ICompilationUnit cu = subtype.getCompilationUnit();
            if (cu != null) {
                result.add(cu);
            }
            ++n2;
        }
        result.add(this.getDestinationType().getCompilationUnit());
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException {
        IType declaring = this.getDeclaringType();
        IType[] superTypes = declaring.newSupertypeHierarchy((WorkingCopyOwner)this.fOwner, monitor).getAllSupertypes(declaring);
        ArrayList<IType> list = new ArrayList<IType>(superTypes.length);
        int binary = 0;
        IType[] iTypeArray = superTypes;
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type != null && type.exists() && !type.isReadOnly() && !type.isBinary() && !"java.lang.Object".equals(type.getFullyQualifiedName())) {
                list.add(type);
            } else if (type != null && type.isBinary()) {
                ++binary;
            }
            ++n2;
        }
        if (superTypes.length == 1 && "java.lang.Object".equals(superTypes[0].getFullyQualifiedName())) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_not_java_lang_object);
        } else if (superTypes.length == binary) {
            status.addFatalError(RefactoringCoreMessages.PullUPRefactoring_no_all_binary);
        }
        Collections.reverse(list);
        return list.toArray(new IType[list.size()]);
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map<ICompilationUnit, CompilationUnitRewrite> rewrites, ICompilationUnit unit) {
        Assert.isNotNull(rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(this.fOwner, unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private IMember[] getCreatedDestinationMembers() {
        ArrayList<Object> result = new ArrayList<Object>(this.fMembersToMove.length + this.fAbstractMethods.length);
        result.addAll(Arrays.asList(this.fMembersToMove));
        result.addAll(Arrays.asList(this.fAbstractMethods));
        return result.toArray(new IMember[result.size()]);
    }

    public boolean getCreateMethodStubs() {
        return this.fCreateMethodStubs;
    }

    public ITypeHierarchy getDeclaringSuperTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCachedDeclaringSuperTypeHierarchy != null) {
                ITypeHierarchy iTypeHierarchy = this.fCachedDeclaringSuperTypeHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedDeclaringSuperTypeHierarchy = this.getDeclaringType().newSupertypeHierarchy((WorkingCopyOwner)this.fOwner, monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public ITypeHierarchy getDestinationTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        try {
            if (this.fCachedDestinationTypeHierarchy != null && this.fCachedDestinationTypeHierarchy.getType().equals(this.getDestinationType())) {
                ITypeHierarchy iTypeHierarchy = this.fCachedDestinationTypeHierarchy;
                return iTypeHierarchy;
            }
            ITypeHierarchy iTypeHierarchy = this.fCachedDestinationTypeHierarchy = this.getDestinationType().newTypeHierarchy((WorkingCopyOwner)this.fOwner, monitor);
            return iTypeHierarchy;
        }
        finally {
            monitor.done();
        }
    }

    public Object[] getElements() {
        return this.fMembersToMove;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IMember[] getMatchingElements(IProgressMonitor monitor, boolean includeAbstract) throws JavaModelException {
        try {
            HashSet result = new HashSet();
            IType destination = this.getDestinationType();
            Map<IMember, Set<IMember>> matching = this.getMatchingMembers(this.getDestinationTypeHierarchy(monitor), this.getDestinationType(), includeAbstract);
            for (Map.Entry<IMember, Set<IMember>> entry : matching.entrySet()) {
                IMember key = entry.getKey();
                Assert.isTrue((!key.getDeclaringType().equals(destination) ? 1 : 0) != 0);
                result.addAll(entry.getValue());
            }
            IMember[] iMemberArray = result.toArray(new IMember[result.size()]);
            return iMemberArray;
        }
        finally {
            monitor.done();
        }
    }

    private Map<IMember, Set<IMember>> getMatchingMembers(ITypeHierarchy hierarchy, IType type, boolean includeAbstract) throws JavaModelException {
        HashMap<IMember, Set<IMember>> result = new HashMap<IMember, Set<IMember>>(this.getMatchingMembersMapping(type));
        IType[] iTypeArray = hierarchy.getAllSubtypes(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType subType = iTypeArray[n2];
            Map<IMember, Set<IMember>> map = this.getMatchingMembersMapping(subType);
            PullUpRefactoringProcessor.mergeMaps(result, map);
            PullUpRefactoringProcessor.upgradeMap(result, map);
            ++n2;
        }
        if (includeAbstract) {
            return result;
        }
        iTypeArray = this.fAbstractMethods;
        n = this.fAbstractMethods.length;
        n2 = 0;
        while (n2 < n) {
            IType abstractMethod = iTypeArray[n2];
            if (result.containsKey(abstractMethod)) {
                result.remove(abstractMethod);
            }
            ++n2;
        }
        return result;
    }

    private Map<IMember, Set<IMember>> getMatchingMembersMapping(IType initial) throws JavaModelException {
        HashMap<IMember, Set<IMember>> result = new HashMap<IMember, Set<IMember>>();
        IMember[] iMemberArray = this.getCreatedDestinationMembers();
        int n = iMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMember member = iMemberArray[n2];
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                found = MemberCheckUtil.findMethod(method, initial.getMethods());
                if (found != null) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)method, (IMember)found);
                }
            } else if (member instanceof IField) {
                IField field = (IField)member;
                found = initial.getField(field.getElementName());
                if (found.exists() && field.getTypeSignature().equals(found.getTypeSignature())) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)field, (IMember)found);
                }
            } else if (member instanceof IType) {
                IType type = (IType)member;
                found = initial.getType(type.getElementName());
                if (found.exists()) {
                    PullUpRefactoringProcessor.addMatchingMember(result, (IMember)type, (IMember)found);
                }
            } else {
                Assert.isTrue((boolean)false);
            }
            ++n2;
        }
        return result;
    }

    private IMember[] getMembersToDelete(IProgressMonitor monitor) throws JavaModelException {
        try {
            IMember[] typesToDelete = PullUpRefactoringProcessor.getMembers(this.fMembersToMove, 7);
            IMember[] matchingElements = this.getMatchingElements(monitor, false);
            IMember[] matchingFields = PullUpRefactoringProcessor.getMembers(matchingElements, 8);
            ArrayList<IMember> toDelete = new ArrayList<IMember>();
            IMember[] all = JavaElementUtil.merge(matchingFields, typesToDelete);
            toDelete.addAll(Arrays.asList(this.fMembersToMove));
            toDelete.retainAll(Arrays.asList(all));
            IMember[] iMemberArray = JavaElementUtil.merge(toDelete.toArray(new IMember[0]), (IMember[])this.fDeletedMethods);
            return iMemberArray;
        }
        finally {
            monitor.done();
        }
    }

    private int getModifiersWithUpdatedVisibility(IMember member, int modifiers, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, IProgressMonitor monitor, boolean considerReferences, RefactoringStatus status) throws JavaModelException {
        if (this.getDestinationType().isInterface()) {
            int flags = JdtFlags.clearAccessModifiers(modifiers);
            flags = JdtFlags.clearFlag(1048, flags);
            return flags;
        }
        if (this.needsVisibilityAdjustment(member, considerReferences, monitor, status)) {
            MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment adjustment = new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment(member, Modifier.ModifierKeyword.PROTECTED_KEYWORD, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(member), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)member), MemberVisibilityAdjustor.getLabel(Modifier.ModifierKeyword.PROTECTED_KEYWORD)})));
            adjustment.setNeedsRewriting(false);
            adjustments.put(member, adjustment);
            return JdtFlags.clearAccessModifiers(modifiers) | 4;
        }
        return modifiers;
    }

    private Set<IMember> getNotDeletedMembers(IProgressMonitor monitor) throws JavaModelException {
        HashSet<IMember> matchingSet = new HashSet<IMember>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)2);
        matchingSet.addAll(Arrays.asList(this.getMatchingElements((IProgressMonitor)subMonitor.newChild(1), true)));
        matchingSet.removeAll(Arrays.asList(this.getMembersToDelete((IProgressMonitor)subMonitor.newChild(1))));
        monitor.done();
        return matchingSet;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.PullUpRefactoring_Pull_Up;
    }

    public IMember[] getPullableMembersOfDeclaringType() {
        try {
            return RefactoringAvailabilityTesterCore.getPullUpMembers(this.getDeclaringType());
        }
        catch (JavaModelException e) {
            return new IMember[0];
        }
    }

    private Set<IType> getSkippedSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
        try {
            if (this.fCachedSkippedSuperTypes != null && this.getDestinationTypeHierarchy((IProgressMonitor)subMonitor.newChild(1)).getType().equals(this.getDestinationType())) {
                Set<IType> set = this.fCachedSkippedSuperTypes;
                return set;
            }
            ITypeHierarchy hierarchy = this.getDestinationTypeHierarchy((IProgressMonitor)subMonitor.newChild(1));
            this.fCachedSkippedSuperTypes = new HashSet<IType>(2);
            IType current = hierarchy.getSuperclass(this.getDeclaringType());
            while (current != null && !current.equals(this.getDestinationType())) {
                this.fCachedSkippedSuperTypes.add(current);
                current = hierarchy.getSuperclass(current);
            }
            Set<IType> set = this.fCachedSkippedSuperTypes;
            return set;
        }
        finally {
            monitor.done();
        }
    }

    private Set<IType> getAllSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)1);
        try {
            if (this.fCachedSuperTypes != null) {
                Set<IType> set = this.fCachedSkippedSuperTypes;
                return set;
            }
            ITypeHierarchy hierarchy = this.getDestinationTypeHierarchy((IProgressMonitor)subMonitor.newChild(1));
            this.fCachedSuperTypes = new HashSet<IType>(2);
            IType current = hierarchy.getSuperclass(this.getDeclaringType());
            while (current != null && !current.getFullyQualifiedName().equals("java.lang.Object")) {
                this.fCachedSuperTypes.add(current);
                current = hierarchy.getSuperclass(current);
            }
            Set<IType> set = this.fCachedSuperTypes;
            return set;
        }
        finally {
            monitor.done();
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String attribute;
        IJavaElement element2;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element2 = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element2 == null || !element2.exists() || element2.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fDestinationType = (IType)element2;
        String stubs = extended.getAttribute(ATTRIBUTE_STUBS);
        if (stubs == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STUBS));
        }
        this.fCreateMethodStubs = Boolean.parseBoolean(stubs);
        String instance = extended.getAttribute("instanceof");
        if (instance == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
        }
        this.fInstanceOf = Boolean.parseBoolean(instance);
        String replace = extended.getAttribute("replace");
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
        }
        this.fReplace = Boolean.parseBoolean(replace);
        int pullCount = 0;
        int abstractCount = 0;
        int deleteCount = 0;
        String value = extended.getAttribute(ATTRIBUTE_ABSTRACT);
        if (value != null && !"".equals(value)) {
            try {
                abstractCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
        }
        value = extended.getAttribute(ATTRIBUTE_DELETE);
        if (value != null && !"".equals(value)) {
            try {
                deleteCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE));
        }
        value = extended.getAttribute(ATTRIBUTE_PULL);
        if (value != null && !"".equals(value)) {
            try {
                pullCount = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PULL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PULL));
        }
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < pullCount) {
            attribute = "element" + (index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < deleteCount) {
            attribute = "element" + (pullCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fDeletedMethods = elements.toArray(new IMethod[elements.size()]);
        elements = new ArrayList();
        index = 0;
        while (index < abstractCount) {
            attribute = "element" + (pullCount + abstractCount + index + 1);
            handle = extended.getAttribute(attribute);
            if (handle != null && !"".equals(handle)) {
                element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.pull.up"));
                } else {
                    elements.add(element);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
            }
            ++index;
        }
        this.fAbstractMethods = elements.toArray(new IMethod[elements.size()]);
        IJavaProject project = null;
        if (this.fMembersToMove.length > 0) {
            project = this.fMembersToMove[0].getJavaProject();
        }
        this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTesterCore.isPullUpAvailable(this.fMembersToMove);
    }

    private boolean isAvailableInDestination(IMethod method, IProgressMonitor monitor) throws JavaModelException {
        try {
            IType destination = this.getDestinationType();
            IMethod first = JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), false, destination);
            if (first != null && MethodChecks.isVirtual(first)) {
                return true;
            }
            ITypeHierarchy hierarchy = this.getDestinationTypeHierarchy(monitor);
            IMethod found = JavaModelUtil.findMethodInHierarchy(hierarchy, destination, method.getElementName(), method.getParameterTypes(), false);
            boolean bl = found != null && MethodChecks.isVirtual(found);
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isRequiredPullableMember(List<IMember> queue, IMember member) throws JavaModelException {
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        return declaring.equals(this.getDeclaringType()) && !queue.contains(member) && RefactoringAvailabilityTesterCore.isPullUpAvailable(member);
    }

    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        for (Map.Entry<ICompilationUnit, CompilationUnitRewrite> entry : this.fCompilationUnitRewrites.entrySet()) {
            CompilationUnitChange change;
            CompilationUnitRewrite rewrite = entry.getValue();
            if (rewrite == null || (change = rewrite.createChange(true)) == null) continue;
            manager.manage(entry.getKey(), (TextEditBasedChange)change);
        }
    }

    public void resetEnvironment() {
        ICompilationUnit unit = this.getDeclaringType().getCompilationUnit();
        if (this.fLayer) {
            unit = unit.findWorkingCopy((WorkingCopyOwner)this.fOwner);
        }
        this.resetWorkingCopies(unit);
    }

    @Override
    protected void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set<String> replacements, IProgressMonitor monitor) throws CoreException {
        try {
            CompilationUnitChange change;
            CompilationUnitRewrite existingRewrite = this.fCompilationUnitRewrites.get(unit.getPrimary());
            CompilationUnitRewrite currentRewrite = existingRewrite != null ? existingRewrite : new CompilationUnitRewrite(unit, node);
            Collection collection = (Collection)this.fTypeOccurrences.get(unit);
            if (collection != null && !collection.isEmpty() && !this.fArgumentAddedToHandleThis) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.ExtractInterfaceProcessor_creating, (int)collection.size());
                try {
                    for (ITypeConstraintVariable iTypeConstraintVariable : collection) {
                        TType estimate;
                        if (iTypeConstraintVariable == null || (estimate = (TType)iTypeConstraintVariable.getData("te")) == null) continue;
                        CompilationUnitRange range = iTypeConstraintVariable.getRange();
                        if (existingRewrite != null) {
                            this.rewriteTypeOccurrence(range, estimate, requestor, currentRewrite, node, replacements, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        } else {
                            ASTNode result = NodeFinder.perform((ASTNode)node, (ISourceRange)range.getSourceRange());
                            if (result != null) {
                                this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                            }
                        }
                        subMonitor.worked(1);
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            if (existingRewrite == null && (change = currentRewrite.createChange(true)) != null) {
                manager.manage(unit, (TextEditBasedChange)change);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, ICompilationUnit copy, final Set<String> replacements, final RefactoringStatus status, IProgressMonitor monitor) {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.PullUpRefactoring_checking, (int)100);
        try {
            final IType declaring = this.getDeclaringType();
            IJavaProject project = declaring.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setWorkingCopyOwner((WorkingCopyOwner)this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            parser.createASTs(new ICompilationUnit[]{copy}, new String[0], new ASTRequestor(){

                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                    try {
                        ITypeBinding subBinding;
                        IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)declaring);
                        AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                        if (subDeclaration != null && (subBinding = subDeclaration.resolveBinding()) != null) {
                            ITypeBinding superBinding = null;
                            ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(subBinding);
                            int n = iTypeBindingArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITypeBinding superBinding2 = iTypeBindingArray[n2];
                                String name = superBinding2.getName();
                                if (name.startsWith(PullUpRefactoringProcessor.this.fDestinationType.getElementName())) {
                                    superBinding = superBinding2;
                                }
                                ++n2;
                            }
                            if (superBinding != null) {
                                PullUpRefactoringProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)subMonitor.newChild(80), status);
                                if (!status.hasFatalError()) {
                                    PullUpRefactoringProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)subMonitor.newChild(20));
                                }
                            }
                        }
                    }
                    catch (JavaModelException exception) {
                        JavaManipulationPlugin.log(exception);
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            subMonitor.done();
        }
    }

    public void setAbstractMethods(IMethod[] methods) {
        Assert.isNotNull((Object)methods);
        this.fAbstractMethods = methods;
    }

    public void setCreateMethodStubs(boolean create) {
        this.fCreateMethodStubs = create;
    }

    public void setDeletedMethods(IMethod[] methods) {
        Assert.isNotNull((Object)methods);
        this.fDeletedMethods = methods;
    }

    public void setDestinationType(IType type) {
        Assert.isNotNull((Object)type);
        if (!type.equals(this.fDestinationType)) {
            this.fCachedDestinationTypeHierarchy = null;
        }
        this.fDestinationType = type;
    }

    public void setMembersToMove(IMember[] members) {
        Assert.isNotNull((Object)members);
        this.fMembersToMove = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])members);
    }

    private class AddParameterVisitor
    extends ASTVisitor {
        final CompilationUnitRewrite fRewrite;
        final String fMethodName;

        public AddParameterVisitor(CompilationUnitRewrite rewrite, String methodName) {
            this.fRewrite = rewrite;
            this.fMethodName = methodName;
        }

        public boolean visit(MethodInvocation node) {
            if (node.getName().getFullyQualifiedName().equals(this.fMethodName)) {
                ASTRewrite rewriter = this.fRewrite.getASTRewrite();
                AST ast = this.fRewrite.getAST();
                MethodInvocation newInvocation = ast.newMethodInvocation();
                newInvocation.setName(ast.newSimpleName(this.fMethodName));
                List arguments = node.arguments();
                for (Expression argument : arguments) {
                    Expression copyExpression = (Expression)rewriter.createCopyTarget((ASTNode)argument);
                    newInvocation.arguments().add(copyExpression);
                }
                if (node.getExpression() != null) {
                    boolean doNotCopyExpression = false;
                    if (node.getExpression() instanceof ThisExpression) {
                        IMember[] createdMembers = PullUpRefactoringProcessor.this.getCreatedDestinationMembers();
                        MethodDeclaration surroundDeclaration = ASTNodes.getFirstAncestorOrNull((ASTNode)node, MethodDeclaration.class);
                        if (surroundDeclaration != null) {
                            IMember[] iMemberArray = createdMembers;
                            int n = createdMembers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMember createdMember = iMemberArray[n2];
                                if (createdMember.getElementName().equals(surroundDeclaration.getName().getFullyQualifiedName())) {
                                    doNotCopyExpression = true;
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                    if (!doNotCopyExpression) {
                        newInvocation.setExpression((Expression)rewriter.createCopyTarget((ASTNode)node.getExpression()));
                        newInvocation.arguments().add(rewriter.createCopyTarget((ASTNode)node.getExpression()));
                    }
                }
                List typeArguments = node.typeArguments();
                newInvocation.typeArguments().addAll(typeArguments);
                rewriter.replace((ASTNode)node, (ASTNode)newInvocation, null);
            }
            return false;
        }
    }

    private class CheckInvalidOuterFieldAccess
    extends ASTVisitor {
        private final IType fTargetType;
        private final IType fSourceType;
        private final ITypeBinding fTypeDeclBinding;
        private IBinding fConflictBinding;

        public CheckInvalidOuterFieldAccess(IType sourceType, IType targetType, ITypeBinding typeDeclBinding) {
            this.fSourceType = sourceType;
            this.fTargetType = targetType;
            this.fTypeDeclBinding = typeDeclBinding;
        }

        public IBinding getConflictBinding() {
            return this.fConflictBinding;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null) {
                IVariableBinding varBinding;
                if (binding instanceof IVariableBinding && (varBinding = (IVariableBinding)binding).isField()) {
                    ITypeBinding declBinding;
                    FieldAccess fieldAccess;
                    ASTNode aSTNode;
                    if (!(node.getParent() instanceof QualifiedName || (aSTNode = node.getParent()) instanceof FieldAccess && !((fieldAccess = (FieldAccess)aSTNode).getExpression() instanceof ThisExpression) || (declBinding = varBinding.getDeclaringClass()) == null || declBinding.isEqualTo((IBinding)this.fTypeDeclBinding) || !this.isChildTypeMember(declBinding, this.fSourceType) || this.isChildTypeMember(declBinding, this.fTargetType))) {
                        this.fConflictBinding = varBinding;
                        throw new AbortSearchException();
                    }
                } else if (binding instanceof IMethodBinding) {
                    ITypeBinding declBinding;
                    MethodInvocation invocation;
                    IMethodBinding methodBinding = (IMethodBinding)binding;
                    if (!(node.getLocationInParent() != MethodInvocation.NAME_PROPERTY || Modifier.isStatic((int)methodBinding.getModifiers()) || (invocation = (MethodInvocation)node.getParent()).getExpression() != null && !(invocation.getExpression() instanceof ThisExpression) || (declBinding = methodBinding.getDeclaringClass()) == null || declBinding.isEqualTo((IBinding)this.fTypeDeclBinding) || !this.isChildTypeMember(declBinding, this.fSourceType) || this.isChildTypeMember(declBinding, this.fTargetType))) {
                        this.fConflictBinding = methodBinding;
                        throw new AbortSearchException();
                    }
                }
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            ITypeBinding typeBinding;
            if (node.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && this.isChildTypeMember(typeBinding = node.resolveTypeBinding(), this.fSourceType) && !this.isChildTypeMember(typeBinding, this.fTargetType)) {
                this.fConflictBinding = typeBinding;
                throw new AbortSearchException();
            }
            return super.visit(node);
        }

        private boolean isChildTypeMember(ITypeBinding parentTypeBinding, IType type) {
            ITypeBinding[] childTypes;
            if (parentTypeBinding.getQualifiedName().equals(type.getFullyQualifiedName('.'))) {
                return true;
            }
            ITypeBinding[] iTypeBindingArray = childTypes = parentTypeBinding.getDeclaredTypes();
            if (childTypes.length != 0) {
                ITypeBinding childType = iTypeBindingArray[0];
                return this.isChildTypeMember(childType, type);
            }
            return false;
        }
    }

    private static class NewArgumentMethodChecker
    extends InterruptibleVisitor {
        private final Map<IMethod, String> fNewArgumentMap;
        private final MethodDeclaration fEnclosingMethodDeclaration;
        private final IMethodBinding fEnclosingMethod;
        private final IMember[] fMembersToMove;
        private final CompilationUnit fRoot;
        private final Map<MethodDeclaration, Integer> fRangeMap;
        private boolean fAnonymousClassDeclaration;
        private boolean fTypeDeclarationStatement;

        public NewArgumentMethodChecker(Map<IMethod, String> argumentsMap, MethodDeclaration enclosingMethodDeclaration, IMember[] membersToMove, CompilationUnit root) {
            this(argumentsMap, enclosingMethodDeclaration, membersToMove, root, null);
        }

        public NewArgumentMethodChecker(Map<IMethod, String> argumentsMap, MethodDeclaration enclosingMethodDeclaration, IMember[] membersToMove, CompilationUnit root, Map<MethodDeclaration, Integer> rangeMap) {
            this.fNewArgumentMap = argumentsMap;
            this.fEnclosingMethodDeclaration = enclosingMethodDeclaration;
            this.fEnclosingMethod = enclosingMethodDeclaration.resolveBinding();
            this.fMembersToMove = membersToMove;
            this.fRoot = root;
            this.fRangeMap = rangeMap;
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = true;
            return super.visit(node);
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = false;
            super.endVisit(node);
        }

        public final boolean visit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = true;
            return super.visit(node);
        }

        public final void endVisit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = false;
            super.endVisit(node);
        }

        public final boolean visit(ThisExpression node) {
            Integer limit;
            if (this.fRangeMap != null && (limit = this.fRangeMap.get(this.fEnclosingMethodDeclaration)) != null && limit >= node.getStartPosition() + node.getLength()) {
                return true;
            }
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                IMethod method;
                IMethodBinding methodBinding;
                MethodInvocation methodInvocation;
                List parameters = this.fEnclosingMethodDeclaration.parameters();
                ArrayList<String> prohibited = new ArrayList<String>();
                for (SingleVariableDeclaration svd : parameters) {
                    prohibited.add(svd.getName().getFullyQualifiedName());
                }
                IVariableBinding binding = null;
                if (node.getLocationInParent() == FieldAccess.EXPRESSION_PROPERTY) {
                    FieldAccess fieldAccess = (FieldAccess)node.getParent();
                    binding = fieldAccess.resolveFieldBinding();
                } else if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                    methodInvocation = (MethodInvocation)node.getParent();
                    binding = methodInvocation.resolveMethodBinding();
                }
                if (binding != null) {
                    IJavaElement element = binding.getJavaElement();
                    IMember[] iMemberArray = this.fMembersToMove;
                    int n = this.fMembersToMove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMember member = iMemberArray[n2];
                        if (member.equals(element) && binding instanceof IMethodBinding && this.fNewArgumentMap.get(member) == null) {
                            try {
                                MethodDeclaration method2 = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, this.fRoot);
                                Map<MethodDeclaration, Integer> rangeMap = this.fRangeMap;
                                if (rangeMap == null) {
                                    rangeMap = new HashMap<MethodDeclaration, Integer>();
                                }
                                rangeMap.put(this.fEnclosingMethodDeclaration, node.getStartPosition() + node.getLength());
                                NewArgumentMethodChecker checker = new NewArgumentMethodChecker(this.fNewArgumentMap, method2, this.fMembersToMove, this.fRoot, rangeMap);
                                checker.traverseNodeInterruptibly((ASTNode)method2);
                                if (this.fNewArgumentMap.get(member) == null) {
                                    return true;
                                }
                            }
                            catch (JavaModelException e) {
                                throw new AbortSearchException();
                            }
                        }
                        ++n2;
                    }
                } else if (node.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (methodBinding = (methodInvocation = (MethodInvocation)node.getParent()).resolveMethodBinding()) != null) {
                    ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                    List args = methodInvocation.arguments();
                    int index = 0;
                    int i = 0;
                    while (i < args.size()) {
                        if (args.get(i) == node) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    ITypeBinding thisRequiredType = parameterTypes[index];
                    if (!thisRequiredType.isEqualTo((IBinding)node.resolveTypeBinding())) {
                        return true;
                    }
                }
                if (this.fEnclosingMethod != null && (method = (IMethod)this.fEnclosingMethod.getJavaElement()) != null && this.fNewArgumentMap.get(method) == null) {
                    String[] varNames = StubUtility.getArgumentNameSuggestions(method.getJavaProject(), this.fEnclosingMethod.getDeclaringClass(), prohibited.toArray(new String[0]));
                    this.fNewArgumentMap.put(method, varNames[0]);
                    throw new AbortSearchException();
                }
            }
            return false;
        }

        public final boolean visit(MethodInvocation node) {
            Integer limit;
            if (node.getExpression() instanceof ThisExpression) {
                return true;
            }
            if (this.fRangeMap != null && (limit = this.fRangeMap.get(this.fEnclosingMethodDeclaration)) != null && limit >= node.getStartPosition() + node.getLength()) {
                return true;
            }
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                List parameters = this.fEnclosingMethodDeclaration.parameters();
                ArrayList<String> prohibited = new ArrayList<String>();
                for (SingleVariableDeclaration svd : parameters) {
                    prohibited.add(svd.getName().getFullyQualifiedName());
                }
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null) {
                    IJavaElement element = binding.getJavaElement();
                    IMember[] iMemberArray = this.fMembersToMove;
                    int n = this.fMembersToMove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMember member = iMemberArray[n2];
                        if (member.equals(element)) {
                            IMethod enclosingMethod;
                            if (binding instanceof IMethodBinding && this.fNewArgumentMap.get(member) == null) {
                                try {
                                    MethodDeclaration method = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, this.fRoot);
                                    Map<MethodDeclaration, Integer> rangeMap = this.fRangeMap;
                                    if (rangeMap == null) {
                                        rangeMap = new HashMap<MethodDeclaration, Integer>();
                                    }
                                    rangeMap.put(this.fEnclosingMethodDeclaration, node.getStartPosition() + node.getLength());
                                    NewArgumentMethodChecker checker = new NewArgumentMethodChecker(this.fNewArgumentMap, method, this.fMembersToMove, this.fRoot, rangeMap);
                                    checker.traverseNodeInterruptibly((ASTNode)method);
                                    if (this.fNewArgumentMap.get(member) == null) {
                                        return true;
                                    }
                                }
                                catch (JavaModelException e) {
                                    throw new AbortSearchException();
                                }
                            }
                            if (this.fEnclosingMethod != null && (enclosingMethod = (IMethod)this.fEnclosingMethod.getJavaElement()) != null && this.fNewArgumentMap.get(enclosingMethod) == null) {
                                String[] varNames = StubUtility.getArgumentNameSuggestions(enclosingMethod.getJavaProject(), this.fEnclosingMethod.getDeclaringClass(), prohibited.toArray(new String[0]));
                                this.fNewArgumentMap.put(enclosingMethod, varNames[0]);
                                throw new AbortSearchException();
                            }
                        }
                        ++n2;
                    }
                }
            }
            return true;
        }
    }

    private static class PullUpAstNodeMapper
    extends HierarchyProcessor.TypeVariableMapper {
        private boolean fAnonymousClassDeclaration = false;
        private final CompilationUnitRewrite fSourceRewriter;
        private final IType fSuperReferenceType;
        private final CompilationUnitRewrite fTargetRewriter;
        private boolean fTypeDeclarationStatement = false;
        private final MethodDeclaration fEnclosingMethodDeclaration;
        private final IMethodBinding fEnclosingMethod;
        private final IMember[] fMembersToMove;
        private final Map<IMethod, String> fNewArgumentMap;

        public PullUpAstNodeMapper(CompilationUnitRewrite sourceRewriter, CompilationUnitRewrite targetRewriter, ASTRewrite rewrite, IType type, TypeVariableMaplet[] mapping, MethodDeclaration enclosingMethodDecl, IMember[] membersToMove, Map<IMethod, String> newArgumentMap) {
            super(rewrite, mapping);
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)type);
            this.fSourceRewriter = sourceRewriter;
            this.fTargetRewriter = targetRewriter;
            this.fSuperReferenceType = type;
            this.fEnclosingMethodDeclaration = enclosingMethodDecl;
            this.fEnclosingMethod = enclosingMethodDecl.resolveBinding();
            this.fMembersToMove = membersToMove;
            this.fNewArgumentMap = newArgumentMap;
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = false;
            super.endVisit(node);
        }

        public final void endVisit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = false;
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            this.fAnonymousClassDeclaration = true;
            return super.visit(node);
        }

        public final boolean visit(ThisExpression node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                IMethodBinding methodBinding;
                MethodInvocation methodInvocation;
                AST ast = node.getAST();
                List parameters = this.fEnclosingMethodDeclaration.parameters();
                ArrayList<String> prohibited = new ArrayList<String>();
                for (SingleVariableDeclaration svd : parameters) {
                    prohibited.add(svd.getName().getFullyQualifiedName());
                }
                IVariableBinding binding = null;
                if (node.getLocationInParent() == FieldAccess.EXPRESSION_PROPERTY) {
                    FieldAccess fieldAccess = (FieldAccess)node.getParent();
                    binding = fieldAccess.resolveFieldBinding();
                } else if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
                    methodInvocation = (MethodInvocation)node.getParent();
                    binding = methodInvocation.resolveMethodBinding();
                }
                if (binding != null) {
                    IJavaElement element = binding.getJavaElement();
                    IMember[] iMemberArray = this.fMembersToMove;
                    int n = this.fMembersToMove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMember member = iMemberArray[n2];
                        if (member.equals(element)) {
                            if (!(member instanceof IMethod) || this.fNewArgumentMap.get(member) == null) {
                                return true;
                            }
                            MethodInvocation methodInvocation2 = (MethodInvocation)node.getParent();
                            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
                            newMethodInvocation.setName(ast.newSimpleName(methodInvocation2.getName().getIdentifier()));
                            List arguments = methodInvocation2.arguments();
                            if (arguments != null && arguments.size() > 0) {
                                ListRewrite rewriter = this.fRewrite.getListRewrite((ASTNode)newMethodInvocation, MethodInvocation.ARGUMENTS_PROPERTY);
                                ListRewrite oldRewriter = this.fRewrite.getListRewrite((ASTNode)methodInvocation2, MethodInvocation.ARGUMENTS_PROPERTY);
                                ASTNode copyTarget = oldRewriter.createCopyTarget((ASTNode)arguments.get(0), (ASTNode)arguments.get(arguments.size() - 1));
                                rewriter.insertLast(copyTarget, null);
                            }
                            newMethodInvocation.arguments().add(ast.newSimpleName(this.fNewArgumentMap.get(member)));
                            this.fRewrite.replace((ASTNode)methodInvocation2, (ASTNode)newMethodInvocation, null);
                            return true;
                        }
                        ++n2;
                    }
                    if (this.fEnclosingMethod != null) {
                        String newArgument = this.fNewArgumentMap.get(this.fEnclosingMethod.getJavaElement());
                        SimpleName ref = ast.newSimpleName(newArgument);
                        this.fRewrite.replace((ASTNode)node, (ASTNode)ref, null);
                    }
                } else if (node.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (methodBinding = (methodInvocation = (MethodInvocation)node.getParent()).resolveMethodBinding()) != null) {
                    ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                    List args = methodInvocation.arguments();
                    int index = 0;
                    int i = 0;
                    while (i < args.size()) {
                        if (args.get(i) == node) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    ITypeBinding thisRequiredType = parameterTypes[index];
                    if (thisRequiredType.isEqualTo((IBinding)node.resolveTypeBinding())) {
                        String newArgument = this.fNewArgumentMap.get(this.fEnclosingMethod.getJavaElement());
                        SimpleName ref = ast.newSimpleName(newArgument);
                        this.fRewrite.replace((ASTNode)node, (ASTNode)ref, null);
                    }
                }
                return true;
            }
            return false;
        }

        public final boolean visit(MethodInvocation node) {
            if (node.getExpression() instanceof ThisExpression) {
                return true;
            }
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                AST ast = node.getAST();
                List parameters = this.fEnclosingMethodDeclaration.parameters();
                ArrayList<String> prohibited = new ArrayList<String>();
                for (SingleVariableDeclaration svd : parameters) {
                    prohibited.add(svd.getName().getFullyQualifiedName());
                }
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null) {
                    IJavaElement element = binding.getJavaElement();
                    IMember[] iMemberArray = this.fMembersToMove;
                    int n = this.fMembersToMove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMember member = iMemberArray[n2];
                        if (member.equals(element)) {
                            if (!(member instanceof IMethod) || this.fNewArgumentMap.get(member) == null) {
                                return true;
                            }
                            MethodInvocation methodInvocation = node;
                            MethodInvocation newMethodInvocation = ast.newMethodInvocation();
                            newMethodInvocation.setName(ast.newSimpleName(methodInvocation.getName().getIdentifier()));
                            List arguments = methodInvocation.arguments();
                            if (arguments != null && arguments.size() > 0) {
                                ListRewrite rewriter = this.fRewrite.getListRewrite((ASTNode)newMethodInvocation, MethodInvocation.ARGUMENTS_PROPERTY);
                                ListRewrite oldRewriter = this.fRewrite.getListRewrite((ASTNode)methodInvocation, MethodInvocation.ARGUMENTS_PROPERTY);
                                ASTNode copyTarget = oldRewriter.createCopyTarget((ASTNode)arguments.get(0), (ASTNode)arguments.get(arguments.size() - 1));
                                rewriter.insertLast(copyTarget, null);
                            }
                            newMethodInvocation.arguments().add(ast.newSimpleName(this.fNewArgumentMap.get(member)));
                            this.fRewrite.replace((ASTNode)methodInvocation, (ASTNode)newMethodInvocation, null);
                            return true;
                        }
                        ++n2;
                    }
                }
                return true;
            }
            return false;
        }

        public final boolean visit(SuperFieldAccess node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                AST ast = node.getAST();
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(node.getName().getIdentifier()));
                this.fRewrite.replace((ASTNode)node, (ASTNode)access, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(SimpleType node) {
            if (node.getName().isSimpleName()) {
                ITypeBinding binding = node.resolveBinding();
                if (binding == null) {
                    return false;
                }
                CheckTypeNameInTarget check = new CheckTypeNameInTarget(binding);
                try {
                    this.fTargetRewriter.getRoot().accept((ASTVisitor)check);
                }
                catch (AbortSearchException abortSearchException) {
                    // empty catch block
                }
                if (check.isQualificationRequired() && binding.getPackage() != null && !binding.getPackage().getName().isEmpty()) {
                    String newName = binding.getPackage().getName() + "." + node.getName().getFullyQualifiedName();
                    QualifiedType newQualifiedType = (QualifiedType)this.fRewrite.createStringPlaceholder(newName, 75);
                    this.fRewrite.replace((ASTNode)node, (ASTNode)newQualifiedType, null);
                    return false;
                }
            }
            return false;
        }

        public final boolean visit(SuperMethodInvocation node) {
            if (!this.fAnonymousClassDeclaration && !this.fTypeDeclarationStatement) {
                IBinding superBinding = node.getName().resolveBinding();
                if (superBinding instanceof IMethodBinding) {
                    IType type;
                    IMethodBinding extended = (IMethodBinding)superBinding;
                    if (this.fEnclosingMethod != null && this.fEnclosingMethod.overrides(extended)) {
                        return true;
                    }
                    ITypeBinding declaringBinding = extended.getDeclaringClass();
                    if (declaringBinding != null && !this.fSuperReferenceType.equals(type = (IType)declaringBinding.getJavaElement())) {
                        return true;
                    }
                }
                AST ast = node.getAST();
                ThisExpression expression = ast.newThisExpression();
                MethodInvocation invocation = ast.newMethodInvocation();
                SimpleName simple = ast.newSimpleName(node.getName().getIdentifier());
                invocation.setName(simple);
                invocation.setExpression((Expression)expression);
                List arguments = node.arguments();
                if (arguments != null && arguments.size() > 0) {
                    ListRewrite rewriter = this.fRewrite.getListRewrite((ASTNode)invocation, MethodInvocation.ARGUMENTS_PROPERTY);
                    ListRewrite superRewriter = this.fRewrite.getListRewrite((ASTNode)node, SuperMethodInvocation.ARGUMENTS_PROPERTY);
                    ASTNode copyTarget = superRewriter.createCopyTarget((ASTNode)arguments.get(0), (ASTNode)arguments.get(arguments.size() - 1));
                    rewriter.insertLast(copyTarget, null);
                }
                this.fRewrite.replace((ASTNode)node, (ASTNode)invocation, null);
                if (!this.fSourceRewriter.getCu().equals(this.fTargetRewriter.getCu())) {
                    this.fSourceRewriter.getImportRemover().registerRemovedNode((ASTNode)node);
                }
                return true;
            }
            return false;
        }

        public final boolean visit(TypeDeclarationStatement node) {
            this.fTypeDeclarationStatement = true;
            return super.visit(node);
        }

        private class CheckTypeNameInTarget
        extends ASTVisitor {
            private final ITypeBinding fBinding;
            private boolean fQualificationRequired;

            public CheckTypeNameInTarget(ITypeBinding binding) {
                this.fBinding = binding;
            }

            public boolean visit(SimpleType node) {
                if (!node.getName().isSimpleName() || !node.getName().getFullyQualifiedName().equals(this.fBinding.getName())) {
                    return false;
                }
                ITypeBinding binding = node.resolveBinding();
                if (binding != null && !binding.isEqualTo((IBinding)this.fBinding)) {
                    this.fQualificationRequired = true;
                    throw new AbortSearchException();
                }
                return false;
            }

            public boolean isQualificationRequired() {
                return this.fQualificationRequired;
            }
        }
    }
}

