/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.HashMap;
import java.util.Map;

public class DiagnosticsState {
    private ErrorLevel globalErrorLevel = ErrorLevel.SYNTAX_ERROR;
    private Map<String, ErrorLevel> customizedErrorLevels = new HashMap<String, ErrorLevel>();

    public boolean isOnlySyntaxReported(String uri) {
        return this.customizedErrorLevels.getOrDefault(uri, this.globalErrorLevel) == ErrorLevel.SYNTAX_ERROR;
    }

    public void setErrorLevel(String uri, boolean syntaxOnly) {
        this.customizedErrorLevels.put(uri, syntaxOnly ? ErrorLevel.SYNTAX_ERROR : ErrorLevel.COMPILATION_ERROR);
    }

    public ErrorLevel getGlobalErrorLevel() {
        return this.globalErrorLevel;
    }

    public void setGlobalErrorLevel(boolean syntaxOnly) {
        this.setGlobalErrorLevel(syntaxOnly ? ErrorLevel.SYNTAX_ERROR : ErrorLevel.COMPILATION_ERROR);
    }

    public void setGlobalErrorLevel(ErrorLevel level) {
        this.globalErrorLevel = level == null ? ErrorLevel.SYNTAX_ERROR : level;
        this.customizedErrorLevels.clear();
    }

    public static enum ErrorLevel {
        SYNTAX_ERROR,
        COMPILATION_ERROR;

    }
}

