/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import org.eclipse.jdt.internal.junit.runner.IStopListener;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit4.runner.JUnit4Identifier;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class JUnit4TestReference
implements ITestReference {
    protected final Runner fRunner;
    protected final Description fRoot;

    public JUnit4TestReference(Runner runner, Description root) {
        this.fRunner = runner;
        this.fRoot = root;
    }

    public int countTestCases() {
        return this.countTestCases(this.fRoot);
    }

    private int countTestCases(Description description) {
        if (description.isTest()) {
            return 1;
        }
        int result = 0;
        for (Description child : description.getChildren()) {
            result += this.countTestCases(child);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnit4TestReference)) {
            return false;
        }
        JUnit4TestReference ref = (JUnit4TestReference)obj;
        return ref.fRoot.equals((Object)this.fRoot);
    }

    public ITestIdentifier getIdentifier() {
        return new JUnit4Identifier(this.fRoot);
    }

    public int hashCode() {
        return this.fRoot.hashCode();
    }

    public void run(TestExecution execution) {
        final RunNotifier notifier = new RunNotifier();
        notifier.addListener((RunListener)new JUnit4TestListener(execution.getListener()));
        execution.addStopListener(new IStopListener(){

            public void stop() {
                notifier.pleaseStop();
            }
        });
        Result result = new Result();
        RunListener listener = result.createListener();
        notifier.addListener(listener);
        try {
            try {
                notifier.fireTestRunStarted(this.fRunner.getDescription());
                this.fRunner.run(notifier);
                notifier.fireTestRunFinished(result);
            }
            catch (StoppedByUserException stoppedByUserException) {
                notifier.removeListener(listener);
            }
        }
        finally {
            notifier.removeListener(listener);
        }
    }

    public void sendTree(IVisitsTestTrees notified) {
        this.sendTree(notified, this.fRoot);
    }

    private void sendTree(IVisitsTestTrees notified, Description description) {
        if (description.isTest()) {
            notified.visitTreeEntry((ITestIdentifier)new JUnit4Identifier(description), false, 1, false, "-1");
        } else {
            notified.visitTreeEntry((ITestIdentifier)new JUnit4Identifier(description), true, description.getChildren().size(), false, "-1");
            for (Description child : description.getChildren()) {
                this.sendTree(notified, child);
            }
        }
    }

    public String toString() {
        return this.fRoot.toString();
    }
}

