/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.BundleDefaultPreferences;
import org.eclipse.core.internal.preferences.ConfigurationPreferences;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.PreferenceServiceRegistryHelper;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.SortedProperties;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private static final String MATCH_TYPE_PREFIX = "prefix";
    private static List<String> DEFAULT_DEFAULT_LOOKUP_ORDER = List.of("instance", "configuration", "default");
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final char BUNDLE_VERSION_PREFIX = '@';
    private static final float EXPORT_VERSION = 3.0f;
    private static final String VERSION_KEY = "file_export_version";
    private static final String EMPTY_STRING = "";
    private static PreferencesService instance;
    private static final RootPreferences root;
    private static final Map<String, LookupOrder> DEFAULTS_REGISTRY;
    private Object registryHelper = null;
    private final Map<String, EclipsePreferences> defaultScopes = new HashMap<String, EclipsePreferences>();

    static {
        root = new RootPreferences();
        DEFAULTS_REGISTRY = new ConcurrentHashMap<String, LookupOrder>();
    }

    public static PreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    private PreferencesService() {
        this.initializeDefaultScopes();
    }

    @Override
    public void applyPreferences(IEclipsePreferences tree, IPreferenceFilter[] filters) throws CoreException {
        if (filters == null || filters.length == 0) {
            return;
        }
        try {
            this.internalApply(tree, filters);
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_applyProblems, (Throwable)e));
        }
        try {
            this.getRootNode().node(tree.absolutePath()).flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_saveProblems, (Throwable)e));
        }
    }

    @Override
    public IStatus applyPreferences(IExportedPreferences preferences) throws CoreException {
        if (preferences == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Applying exported preferences: " + ((ExportedPreferences)preferences).toDeepDebugString());
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.preferences", 0, PrefsMessages.preferences_applyProblems, null);
        IEclipsePreferences modifiedNode = this.firePreApplyEvent(preferences);
        try {
            modifiedNode.accept(node -> {
                IEclipsePreferences globalNode = node.parent() == null ? root : (IEclipsePreferences)root.node(node.absolutePath());
                ExportedPreferences epNode = (ExportedPreferences)node;
                boolean removed = false;
                if (epNode.isExportRoot()) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("Found export root: " + epNode.absolutePath());
                    }
                    globalNode.removeNode();
                    removed = true;
                }
                String[] keys = epNode.properties.keys();
                if (removed) {
                    globalNode = (IEclipsePreferences)root.node(node.absolutePath());
                }
                ArrayList<String> propsToRemove = new ArrayList<String>(Arrays.asList(globalNode.keys()));
                if (keys.length > 0) {
                    String[] stringArray = keys;
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        propsToRemove.remove(key);
                        key = key.intern();
                        String value = node.get(key, null);
                        if (value != null) {
                            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                                PrefsMessages.message("Setting: " + globalNode.absolutePath() + "/" + key + "=" + value);
                            }
                            globalNode.put(key, value);
                        }
                        ++n2;
                    }
                }
                for (String keyToRemove : propsToRemove) {
                    keyToRemove = keyToRemove.intern();
                    if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                        PrefsMessages.message("Removing: " + globalNode.absolutePath() + "/" + keyToRemove);
                    }
                    globalNode.remove(keyToRemove);
                }
                return true;
            });
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_applyProblems, (Throwable)e));
        }
        try {
            this.getRootNode().node(modifiedNode.absolutePath()).flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_saveProblems, (Throwable)e));
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Current list of all settings: " + ((EclipsePreferences)this.getRootNode()).toDeepDebugString());
        }
        return result;
    }

    private boolean containsKeys(IEclipsePreferences aRoot) throws BackingStoreException {
        boolean[] result = new boolean[1];
        aRoot.accept(node -> {
            if (node.keys().length != 0) {
                blArray[0] = true;
            }
            return !result[0];
        });
        return result[0];
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties result = new Properties();
        String prefix = "/instance/";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            int index = key.indexOf(47);
            if (index == -1) {
                result.put("@" + key, value);
                result.put("!" + prefix + key, EMPTY_STRING);
                continue;
            }
            String path = key.substring(0, index);
            key = key.substring(index + 1);
            result.put(EclipsePreferences.encodePath(prefix + path, key), value);
        }
        return result;
    }

    private IExportedPreferences convertFromProperties(Properties properties) {
        IExportedPreferences result = ExportedPreferences.newRoot();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ExportedPreferences current;
            String path = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (path.charAt(0) == '!') {
                current = (ExportedPreferences)result.node(path.substring(1));
                current.setExportRoot();
                continue;
            }
            if (path.charAt(0) == '@') {
                current = (ExportedPreferences)result.node("instance").node(path.substring(1));
                current.setVersion(value);
                continue;
            }
            String[] decoded = EclipsePreferences.decodePath(path);
            path = decoded[0] == null ? EMPTY_STRING : decoded[0];
            ExportedPreferences current2 = (ExportedPreferences)result.node(path);
            String key = decoded[1];
            current2.put(key, value);
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Converted preferences file to IExportedPreferences tree: " + ((ExportedPreferences)result).toDeepDebugString());
        }
        return result;
    }

    private SortedProperties convertToProperties(IEclipsePreferences preferences, String[] excludesList) throws BackingStoreException {
        SortedProperties result = new SortedProperties();
        int baseLength = preferences.absolutePath().length();
        preferences.accept(node -> {
            String[] keys;
            String absolutePath = node.absolutePath();
            String scope = this.getScope(absolutePath);
            if ("default".equals(scope)) {
                return false;
            }
            String path = absolutePath.length() <= baseLength ? EMPTY_STRING : EclipsePreferences.makeRelative(absolutePath.substring(baseLength));
            String[] stringArray2 = excludesList;
            int n2 = excludesList.length;
            int n3 = 0;
            while (n3 < n2) {
                String exclude = stringArray2[n3];
                String exclusion = EclipsePreferences.makeRelative(exclude);
                if (path.startsWith(exclusion)) {
                    return false;
                }
                ++n3;
            }
            boolean needToAddVersion = "instance".equals(scope);
            String[] stringArray3 = keys = node.keys();
            int n4 = keys.length;
            int n5 = 0;
            while (n5 < n4) {
                String value;
                String key = stringArray3[n5];
                boolean ignore = false;
                int j = 0;
                while (!ignore && j < excludesList.length) {
                    if (EclipsePreferences.encodePath(path, key).startsWith(EclipsePreferences.makeRelative(excludesList[j]))) {
                        ignore = true;
                    }
                    ++j;
                }
                if (!ignore && (value = node.get(key, null)) != null) {
                    if (needToAddVersion) {
                        String version;
                        String bundle = this.getBundleName(absolutePath);
                        if (bundle != null && (version = this.getBundleVersion(bundle)) != null) {
                            result.put("@" + bundle, version);
                        }
                        needToAddVersion = false;
                    }
                    result.put(EclipsePreferences.encodePath(absolutePath, key), value);
                }
                ++n5;
            }
            return true;
        });
        return result;
    }

    void copyFromTo(Preferences source, Preferences destination, String[] keys, int depth) throws BackingStoreException {
        String[] children;
        String[] keysToCopy;
        String[] stringArray = keysToCopy = keys == null ? source.keys() : keys;
        int n = keysToCopy.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = source.get(key, null);
            if (value != null) {
                destination.put(key, value);
            }
            ++n2;
        }
        if (depth == 0) {
            return;
        }
        String[] stringArray2 = children = source.childrenNames();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            String child = stringArray2[n];
            this.copyFromTo(source.node(child), destination.node(child), keys, depth);
            ++n;
        }
    }

    public WeakReference<Object> applyRuntimeDefaults(String name, WeakReference<Object> pluginReference) {
        if (this.registryHelper == null) {
            return null;
        }
        return ((PreferenceServiceRegistryHelper)this.registryHelper).applyRuntimeDefaults(name, pluginReference);
    }

    private void initializeDefaultScopes() {
        this.defaultScopes.put("bundle_defaults", new BundleDefaultPreferences());
        root.addChild("bundle_defaults", null);
        this.defaultScopes.put("default", new DefaultPreferences());
        root.addChild("default", null);
        this.defaultScopes.put("instance", new InstancePreferences());
        root.addChild("instance", null);
        this.defaultScopes.put("configuration", new ConfigurationPreferences());
        root.addChild("configuration", null);
    }

    public IEclipsePreferences createNode(String key) {
        IScope scope = this.defaultScopes.get(key);
        if (scope == null) {
            if (this.registryHelper == null) {
                return new EclipsePreferences(root, key);
            }
            return ((PreferenceServiceRegistryHelper)this.registryHelper).createNode(root, key);
        }
        return scope.create(root, key);
    }

    @Override
    public void exportPreferences(IEclipsePreferences node, IPreferenceFilter[] filters, OutputStream stream) throws CoreException {
        if (filters == null || filters.length == 0) {
            return;
        }
        try {
            this.internalExport(node, filters, stream);
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_exportProblems, (Throwable)e));
        }
    }

    @Override
    public IStatus exportPreferences(IEclipsePreferences node, OutputStream output, String[] excludesList) throws CoreException {
        if (node == null || output == null) {
            throw new IllegalArgumentException();
        }
        SortedProperties properties = null;
        if (excludesList == null) {
            excludesList = new String[]{};
        }
        try {
            properties = this.convertToProperties(node, excludesList);
            if (properties.isEmpty()) {
                return Status.OK_STATUS;
            }
            properties.put(VERSION_KEY, Float.toString(3.0f));
            properties.put("!" + node.absolutePath(), EMPTY_STRING);
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
        try {
            properties.store(output, null);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_exportProblems, (Throwable)e));
        }
        return Status.OK_STATUS;
    }

    private IEclipsePreferences firePreApplyEvent(IEclipsePreferences tree) {
        if (this.registryHelper == null) {
            return tree;
        }
        IEclipsePreferences[] result = new IEclipsePreferences[]{tree};
        ListenerList<PreferenceModifyListener> listeners = ((PreferenceServiceRegistryHelper)this.registryHelper).getModifyListeners();
        for (PreferenceModifyListener listener : listeners) {
            SafeRunner.run(() -> {
                iEclipsePreferencesArray[0] = listener.preApply(result[0]);
                return iEclipsePreferencesArray[0];
            });
        }
        return result[0];
    }

    @Override
    public String get(String key, String defaultValue, Preferences[] nodes) {
        if (nodes == null) {
            return defaultValue;
        }
        Preferences[] preferencesArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String result;
            Preferences node = preferencesArray[n2];
            if (node != null && (result = node.get(key, null)) != null) {
                return result;
            }
            ++n2;
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String qualifier, String key, boolean defaultValue, IScopeContext[] scopes) {
        String result = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Boolean.parseBoolean(result);
    }

    String getBundleName(String path) {
        if (path.length() == 0 || path.charAt(0) != '/') {
            return null;
        }
        int first = path.indexOf(47, 1);
        if (first == -1) {
            return null;
        }
        int second = path.indexOf(47, first + 1);
        return second == -1 ? path.substring(first + 1) : path.substring(first + 1, second);
    }

    /*
     * WARNING - void declaration
     */
    String getBundleVersion(String bundleName) {
        Object version;
        Object v;
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(bundleName);
        if (bundle != null && (v = (version = bundle.getHeaders(EMPTY_STRING).get("Bundle-Version"))) instanceof String) {
            void versionString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            return versionString;
        }
        return null;
    }

    @Override
    public byte[] getByteArray(String qualifier, String key, byte[] defaultValue, IScopeContext[] scopes) {
        String result = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Base64.decode(result.getBytes());
    }

    @Override
    public String[] getDefaultLookupOrder(String qualifier, String key) {
        LookupOrder order = DEFAULTS_REGISTRY.get(this.getRegistryKey(qualifier, key));
        return order == null ? null : order.getOrder();
    }

    @Override
    public double getDouble(String qualifier, String key, double defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String qualifier, String key, float defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(String qualifier, String key, int defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(String qualifier, String key, long defaultValue, IScopeContext[] scopes) {
        String value = this.get(EclipsePreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String[] getLookupOrder(String qualifier, String key) {
        String[] order = this.getDefaultLookupOrder(qualifier, key);
        if (order == null && key != null) {
            order = this.getDefaultLookupOrder(qualifier, null);
        }
        if (order == null) {
            order = (String[])DEFAULT_DEFAULT_LOOKUP_ORDER.toArray(String[]::new);
        }
        return order;
    }

    private Preferences[] getNodes(final String qualifier, String key, final IScopeContext[] contexts) {
        String[] order = this.getLookupOrder(qualifier, key);
        final String childPath = EclipsePreferences.makeRelative(EclipsePreferences.decodePath(key)[0]);
        final ArrayList result = new ArrayList();
        String[] stringArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            final String scopeString = stringArray[n2];
            final AtomicReference error = new AtomicReference();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){
                private IScopeContext context;

                public void run() throws Exception {
                    boolean found = false;
                    int j = 0;
                    while (contexts != null && j < contexts.length) {
                        IEclipsePreferences node;
                        this.context = contexts[j];
                        if (this.context != null && this.context.getName().equals(scopeString) && (node = this.context.getNode(qualifier)) != null) {
                            found = true;
                            if (childPath != null) {
                                node = node.node(childPath);
                            }
                            result.add(node);
                        }
                        ++j;
                    }
                    if (!found) {
                        Preferences node = PreferencesService.this.getRootNode().node(scopeString).node(qualifier);
                        if (childPath != null) {
                            node = node.node(childPath);
                        }
                        result.add(node);
                    }
                }

                public void handleException(Throwable exception) {
                    if (this.context instanceof InstanceScope && exception instanceof IllegalStateException && Boolean.getBoolean("osgi.dataAreaRequiresExplicitInit")) {
                        error.set((IllegalStateException)exception);
                    } else {
                        RuntimeLog.log((IStatus)Status.error((String)PrefsMessages.preferences_contextError, (Throwable)exception));
                    }
                }
            });
            IllegalStateException illegalState = (IllegalStateException)error.get();
            if (illegalState != null) {
                throw illegalState;
            }
            ++n2;
        }
        return result.toArray(new Preferences[result.size()]);
    }

    private String getRegistryKey(String qualifier, String key) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (key == null) {
            return qualifier;
        }
        return qualifier + "/" + key;
    }

    @Override
    public IEclipsePreferences getRootNode() {
        return root;
    }

    String getScope(String path) {
        if (path == null || path.length() == 0) {
            return EMPTY_STRING;
        }
        int startIndex = path.indexOf(47);
        if (startIndex == -1) {
            return path;
        }
        if (path.length() == 1) {
            return EMPTY_STRING;
        }
        int endIndex = path.indexOf(47, startIndex + 1);
        if (endIndex == -1) {
            endIndex = path.length();
        }
        return path.substring(startIndex + 1, endIndex);
    }

    @Override
    public String getString(String qualifier, String key, String defaultValue, IScopeContext[] scopes) {
        return this.get(EclipsePreferences.decodePath(key)[1], defaultValue, this.getNodes(qualifier, key, scopes));
    }

    @Override
    public IStatus importPreferences(InputStream input) throws CoreException {
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Importing preferences...");
        }
        return this.applyPreferences(this.readPreferences(input));
    }

    private void internalApply(IEclipsePreferences tree, IPreferenceFilter[] filters) throws BackingStoreException {
        ArrayList<IEclipsePreferences> trees = new ArrayList<IEclipsePreferences>();
        IPreferenceFilter[] iPreferenceFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceFilter filter = iPreferenceFilterArray[n2];
            trees.add(this.trimTree(tree, filter));
            ++n2;
        }
        IEclipsePreferences toApply = this.mergeTrees(trees.toArray(new IEclipsePreferences[trees.size()]));
        toApply = this.firePreApplyEvent(toApply);
        toApply.accept(node -> {
            String[] keys = node.keys();
            if (keys.length != 0) {
                this.copyFromTo(node, this.getRootNode().node(node.absolutePath()), keys, 0);
            }
            return true;
        });
    }

    private void internalExport(IEclipsePreferences node, IPreferenceFilter[] filters, OutputStream output) throws BackingStoreException, CoreException {
        ArrayList<IEclipsePreferences> trees = new ArrayList<IEclipsePreferences>();
        IPreferenceFilter[] iPreferenceFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceFilter filter = iPreferenceFilterArray[n2];
            trees.add(this.trimTree(node, filter));
            ++n2;
        }
        IEclipsePreferences toExport = this.mergeTrees(trees.toArray(new IEclipsePreferences[trees.size()]));
        this.exportPreferences(toExport, output, null);
    }

    private boolean internalMatches(IEclipsePreferences tree, IPreferenceFilter filter) throws BackingStoreException {
        String[] scopes = filter.getScopes();
        if (scopes == null) {
            throw new IllegalArgumentException();
        }
        String treePath = tree.absolutePath();
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            Map<String, PreferenceFilterEntry[]> mapping = filter.getMapping(scope);
            if (mapping == null) {
                if (tree.parent() == null && tree.nodeExists(scope) && this.containsKeys((IEclipsePreferences)tree.node(scope))) {
                    return true;
                }
                if (this.scopeMatches(scope, tree) && this.containsKeys(tree)) {
                    return true;
                }
            } else {
                for (String nodePath : mapping.keySet()) {
                    PreferenceFilterEntry[] entries;
                    String nodeFullPath = "/" + scope + "/" + nodePath;
                    if (!nodeFullPath.startsWith(treePath)) continue;
                    String childPath = nodeFullPath.substring(treePath.length());
                    if (!tree.nodeExists(childPath = EclipsePreferences.makeRelative(childPath))) continue;
                    try {
                        entries = mapping.get(nodePath);
                    }
                    catch (ClassCastException e) {
                        RuntimeLog.log((IStatus)Status.error((String)PrefsMessages.preferences_classCastFilterEntry, (Throwable)e));
                        continue;
                    }
                    Preferences child = tree.node(childPath);
                    if (entries == null) {
                        if (child.keys().length == 0 && child.childrenNames().length == 0) continue;
                        return true;
                    }
                    PreferenceFilterEntry[] preferenceFilterEntryArray = entries;
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PreferenceFilterEntry entry = preferenceFilterEntryArray[n4];
                        if (entry != null && (entry.getMatchType() == null ? child.get(entry.getKey(), null) != null : this.internalMatchesWithMatchType(entry, child.keys()))) {
                            return true;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    private IPreferenceFilter[] internalMatches(IEclipsePreferences tree, IPreferenceFilter[] filters) throws BackingStoreException {
        ArrayList<IPreferenceFilter> result = new ArrayList<IPreferenceFilter>();
        IPreferenceFilter[] iPreferenceFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceFilter filter = iPreferenceFilterArray[n2];
            if (this.internalMatches(tree, filter)) {
                result.add(filter);
            }
            ++n2;
        }
        return result.toArray(new IPreferenceFilter[result.size()]);
    }

    private boolean internalMatchesWithMatchType(PreferenceFilterEntry entry, String[] keys) {
        if (keys == null || keys.length == 0) {
            return false;
        }
        String key = entry.getKey();
        String matchType = entry.getMatchType();
        if (!matchType.equalsIgnoreCase(MATCH_TYPE_PREFIX)) {
            return false;
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (k.startsWith(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    @Override
    public IPreferenceFilter[] matches(IEclipsePreferences tree, IPreferenceFilter[] filters) throws CoreException {
        if (filters == null || filters.length == 0) {
            return new IPreferenceFilter[0];
        }
        try {
            return this.internalMatches(tree, filters);
        }
        catch (BackingStoreException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_matching, (Throwable)e));
        }
    }

    private IEclipsePreferences mergeTrees(IEclipsePreferences[] trees) throws BackingStoreException {
        if (trees.length == 1) {
            return trees[0];
        }
        IExportedPreferences result = ExportedPreferences.newRoot();
        if (trees.length == 0) {
            return result;
        }
        IPreferenceNodeVisitor visitor = node -> {
            Preferences destination = result.node(node.absolutePath());
            this.copyFromTo(node, destination, null, 0);
            return true;
        };
        IEclipsePreferences[] iEclipsePreferencesArray = trees;
        int n = trees.length;
        int n2 = 0;
        while (n2 < n) {
            IEclipsePreferences tree = iEclipsePreferencesArray[n2];
            tree.accept(visitor);
            ++n2;
        }
        return result;
    }

    @Override
    public IExportedPreferences readPreferences(InputStream input) throws CoreException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                try {
                    properties.load(input);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_importProblems, (Throwable)e));
        }
        if (properties.isEmpty()) {
            throw new CoreException(Status.error((String)PrefsMessages.preferences_invalidFileFormat, null));
        }
        if (this.isLegacy(properties)) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
        } else {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read preferences file.");
            }
            properties.remove(VERSION_KEY);
        }
        return this.convertFromProperties(properties);
    }

    private boolean scopeMatches(String scope, IEclipsePreferences tree) {
        String path;
        if (tree.parent() == null) {
            return false;
        }
        int index = (path = tree.absolutePath()).indexOf(47, 1);
        String sub = path.substring(1, index == -1 ? path.length() : index);
        return scope.equals(sub);
    }

    @Override
    public void setDefaultLookupOrder(String qualifier, String key, String[] order) {
        String registryKey = this.getRegistryKey(qualifier, key);
        if (order == null) {
            DEFAULTS_REGISTRY.remove(registryKey);
        } else {
            LookupOrder obj = new LookupOrder(order);
            DEFAULTS_REGISTRY.put(registryKey, obj);
        }
    }

    public void setRegistryHelper(Object registryHelper) {
        if (this.registryHelper != null && this.registryHelper != registryHelper) {
            ((PreferenceServiceRegistryHelper)this.registryHelper).stop();
        }
        this.registryHelper = registryHelper;
    }

    private IEclipsePreferences trimTree(IEclipsePreferences tree, IPreferenceFilter filter) throws BackingStoreException {
        IEclipsePreferences result = (IEclipsePreferences)ExportedPreferences.newRoot().node(tree.absolutePath());
        String[] scopes = filter.getScopes();
        if (scopes == null) {
            throw new IllegalArgumentException();
        }
        String treePath = tree.absolutePath();
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Map<String, PreferenceFilterEntry[]> mapping;
                String scope;
                block8: {
                    block9: {
                        scope = stringArray[n2];
                        mapping = filter.getMapping(scope);
                        if (mapping != null) break block8;
                        if (tree.parent() != null || !tree.nodeExists(scope)) break block9;
                        this.copyFromTo(tree.node(scope), result.node(scope), null, -1);
                        break block10;
                    }
                    if (!this.scopeMatches(scope, tree)) break block10;
                    this.copyFromTo(tree, result, null, -1);
                    break block10;
                }
                for (String nodePath : mapping.keySet()) {
                    PreferenceFilterEntry[] entries;
                    String nodeFullPath = "/" + scope + "/" + nodePath;
                    if (!nodeFullPath.startsWith(treePath)) continue;
                    String childPath = nodeFullPath.substring(treePath.length());
                    if (!tree.nodeExists(childPath = EclipsePreferences.makeRelative(childPath))) continue;
                    Preferences child = tree.node(childPath);
                    try {
                        entries = mapping.get(nodePath);
                    }
                    catch (ClassCastException e) {
                        RuntimeLog.log((IStatus)Status.error((String)PrefsMessages.preferences_classCastFilterEntry, (Throwable)e));
                        continue;
                    }
                    String[] keys = null;
                    if (entries != null) {
                        ArrayList<String> list = new ArrayList<String>();
                        PreferenceFilterEntry[] preferenceFilterEntryArray = entries;
                        int n3 = entries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PreferenceFilterEntry entry = preferenceFilterEntryArray[n4];
                            if (entry != null) {
                                this.addMatchedKeys(list, entry, child.keys());
                            }
                            ++n4;
                        }
                        keys = list.toArray(new String[list.size()]);
                    }
                    this.copyFromTo(tree.node(childPath), result.node(childPath), keys, keys == null ? -1 : 0);
                }
            }
            ++n2;
        }
        return result;
    }

    private void addMatchedKeys(List<String> list, PreferenceFilterEntry entry, String[] keys) {
        String matchType = entry.getMatchType();
        if (matchType == null) {
            list.add(entry.getKey());
            return;
        }
        if (keys == null) {
            return;
        }
        String key = entry.getKey();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (matchType.equals(MATCH_TYPE_PREFIX) && k.startsWith(key)) {
                list.add(k);
            }
            ++n2;
        }
    }

    private IStatus validatePluginVersions(String bundle, Version pref, Version installed) {
        if (installed.getMajor() == pref.getMajor() && installed.getMinor() == pref.getMinor()) {
            return null;
        }
        String msg = NLS.bind((String)PrefsMessages.preferences_incompatible, (Object[])new Object[]{pref, bundle, installed});
        boolean isError = installed.getMajor() < pref.getMajor();
        return isError ? Status.error((String)msg) : Status.warning((String)msg);
    }

    private static Version parseVersion(String version) {
        if (version != null) {
            try {
                return new Version(version);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public IStatus validateVersions(IPath path) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.preferences", 1, PrefsMessages.preferences_validate, null);
        IPreferenceNodeVisitor visitor = node -> {
            void realNode;
            IEclipsePreferences iEclipsePreferences = node;
            if (!(iEclipsePreferences instanceof ExportedPreferences)) {
                return false;
            }
            ExportedPreferences exportedPreferences = (ExportedPreferences)iEclipsePreferences;
            ExportedPreferences cfr_ignored_0 = (ExportedPreferences)iEclipsePreferences;
            Version versionInFile = PreferencesService.parseVersion(realNode.getVersion());
            if (versionInFile == null) {
                return true;
            }
            String bundleName = this.getBundleName(node.absolutePath());
            if (bundleName == null) {
                return true;
            }
            Version versionInMemory = PreferencesService.parseVersion(this.getBundleVersion(bundleName));
            if (versionInMemory == null) {
                return true;
            }
            IStatus verification = this.validatePluginVersions(bundleName, versionInFile, versionInMemory);
            if (verification != null) {
                result.add(verification);
            }
            return true;
        };
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(path.toFile()));
            IExportedPreferences prefs = this.readPreferences(input);
            prefs.accept(visitor);
        }
        catch (FileNotFoundException input) {
        }
        catch (CoreException | BackingStoreException e) {
            result.add(Status.error((String)PrefsMessages.preferences_validationException, (Throwable)e));
        }
        return result;
    }

    public void prependScopeToDefaultDefaultLookupOrder(String firstScope) {
        ArrayList<String> scopes = new ArrayList<String>(DEFAULT_DEFAULT_LOOKUP_ORDER);
        scopes.add(0, firstScope);
        DEFAULT_DEFAULT_LOOKUP_ORDER = List.copyOf(scopes);
    }
}

