/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxBundlesState;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Log;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Messages;
import org.eclipse.equinox.internal.frameworkadmin.equinox.ParserUtils;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class EquinoxFwConfigFileParser {
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>(Arrays.asList("osgi.bundles", "osgi.framework.extensions", "osgi.startLevel", "osgi.bundles.defaultStartLevel"));
    private static final String CONFIG_DIR = "@config.dir/";
    private static final String KEY_ECLIPSE_PROV_DATA_AREA = "eclipse.p2.data.area";
    private static final String KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String FILE_PROTOCOL = "file:";
    private static final String BASE_TIMESTAMP_FILE_CONFIGINI = ".baseConfigIniTimestamp";
    private static final String KEY_CONFIGINI_TIMESTAMP = "configIniTimestamp";
    private static boolean DEBUG = false;

    public EquinoxFwConfigFileParser(BundleContext context) {
    }

    private static StringBuffer toOSGiBundleListForm(BundleInfo bundleInfo, URI location) {
        StringBuffer locationString = new StringBuffer(REFERENCE_SCHEME);
        if (URIUtil.isFileURI((URI)location)) {
            locationString.append(URIUtil.toUnencodedString((URI)location));
        } else if (location.getScheme() == null) {
            locationString.append(FILE_PROTOCOL).append(URIUtil.toUnencodedString((URI)location));
        } else {
            locationString = new StringBuffer(URIUtil.toUnencodedString((URI)location));
        }
        int startLevel = bundleInfo.getStartLevel();
        boolean toBeStarted = bundleInfo.isMarkedAsStarted();
        StringBuffer sb = new StringBuffer();
        sb.append(locationString);
        if (startLevel == -1 && !toBeStarted) {
            return sb;
        }
        sb.append('@');
        if (startLevel != -1) {
            sb.append(startLevel);
        }
        if (toBeStarted) {
            sb.append(":start");
        }
        return sb;
    }

    private static boolean getMarkedAsStartedFormat(String startInfo) {
        if (startInfo == null) {
            return false;
        }
        int colon = (startInfo = startInfo.trim()).indexOf(58);
        if (colon > -1) {
            return startInfo.substring(colon + 1).equals("start");
        }
        return startInfo.equals("start");
    }

    private static int getStartLevel(String startInfo) {
        if (startInfo == null) {
            return -1;
        }
        int colon = (startInfo = startInfo.trim()).indexOf(":");
        if (colon > 0) {
            try {
                return Integer.parseInt(startInfo.substring(0, colon));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private void readBundlesList(Manipulator manipulator, URI osgiInstallArea, Properties props) throws NumberFormatException {
        BundleInfo[] bundles;
        int n;
        ConfigData configData = manipulator.getConfigData();
        BundleInfo[] fwExtensions = this.parseBundleList(manipulator, props.getProperty("osgi.framework.extensions"));
        if (fwExtensions != null) {
            BundleInfo[] bundleInfoArray = fwExtensions;
            n = fwExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                BundleInfo fwExtension = bundleInfoArray[n2];
                fwExtension.setFragmentHost("system.bundle");
                configData.addBundle(fwExtension);
                ++n2;
            }
        }
        if ((bundles = this.parseBundleList(manipulator, props.getProperty("osgi.bundles"))) != null) {
            BundleInfo[] bundleInfoArray = bundles;
            int n3 = bundles.length;
            n = 0;
            while (n < n3) {
                BundleInfo bundle = bundleInfoArray[n];
                configData.addBundle(bundle);
                ++n;
            }
        }
    }

    private BundleInfo[] parseBundleList(Manipulator manipulator, String value) {
        String[] bInfoStrings;
        if (value == null || value.length() == 0) {
            return null;
        }
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        String[] stringArray = bInfoStrings = Utils.getTokens((String)value, (String)",");
        int n = bInfoStrings.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                String bInfoString = stringArray[n2];
                String entry = bInfoString.trim();
                int indexStartInfo = (entry = FileUtils.removeEquinoxSpecificProtocols(entry)).indexOf(64);
                String location = indexStartInfo == -1 ? entry : entry.substring(0, indexStartInfo);
                URI realLocation = null;
                if (manipulator.getLauncherData().getFwJar() != null) {
                    File parentFile = manipulator.getLauncherData().getFwJar().getParentFile();
                    try {
                        realLocation = URIUtil.makeAbsolute((URI)FileUtils.fromFileURL(location), (URI)parentFile.toURI());
                    }
                    catch (URISyntaxException e) {
                        realLocation = FileUtils.getEclipsePluginFullLocation(location, parentFile);
                    }
                }
                String slAndFlag = indexStartInfo > -1 ? entry.substring(indexStartInfo + 1) : null;
                boolean markedAsStarted = EquinoxFwConfigFileParser.getMarkedAsStartedFormat(slAndFlag);
                int startLevel = EquinoxFwConfigFileParser.getStartLevel(slAndFlag);
                if (realLocation != null) {
                    bundles.add(new BundleInfo(realLocation, startLevel, markedAsStarted));
                } else {
                    if (location != null && location.startsWith(FILE_PROTOCOL)) {
                        try {
                            bundles.add(new BundleInfo(FileUtils.fromFileURL(location), startLevel, markedAsStarted));
                            break block10;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    bundles.add(new BundleInfo(location, null, null, startLevel, markedAsStarted));
                }
            }
            ++n2;
        }
        return bundles.toArray(new BundleInfo[bundles.size()]);
    }

    private void writeBundlesList(File fwJar, Properties props, BundleInfo[] bundles) {
        StringBuilder osgiBundlesList = new StringBuilder();
        StringBuilder osgiFrameworkExtensionsList = new StringBuilder();
        BundleInfo[] bundleInfoArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundle = bundleInfoArray[n2];
            if (!(fwJar == null ? "org.eclipse.osgi".equals(bundle.getSymbolicName()) : URIUtil.sameURI((URI)fwJar.toURI(), (URI)bundle.getLocation()))) {
                boolean isFrameworkExtension;
                URI location = fwJar != null ? URIUtil.makeRelative((URI)bundle.getLocation(), (URI)fwJar.getParentFile().toURI()) : bundle.getLocation();
                String fragmentHost = bundle.getFragmentHost();
                boolean bl = isFrameworkExtension = fragmentHost != null && (fragmentHost.startsWith("org.eclipse.osgi") || fragmentHost.startsWith("system.bundle"));
                if (isFrameworkExtension) {
                    bundle.setStartLevel(-1);
                    bundle.setMarkedAsStarted(false);
                    osgiFrameworkExtensionsList.append(EquinoxFwConfigFileParser.toOSGiBundleListForm(bundle, location));
                    osgiFrameworkExtensionsList.append(',');
                } else {
                    osgiBundlesList.append(EquinoxFwConfigFileParser.toOSGiBundleListForm(bundle, location));
                    osgiBundlesList.append(',');
                }
            }
            ++n2;
        }
        if (osgiFrameworkExtensionsList.length() > 0) {
            osgiFrameworkExtensionsList.deleteCharAt(osgiFrameworkExtensionsList.length() - 1);
        }
        props.setProperty("osgi.framework.extensions", osgiFrameworkExtensionsList.toString());
        if (osgiBundlesList.length() > 0) {
            osgiBundlesList.deleteCharAt(osgiBundlesList.length() - 1);
        }
        props.setProperty("osgi.bundles", osgiBundlesList.toString());
    }

    public void readFwConfig(Manipulator manipulator, File inputFile) throws IOException, URISyntaxException {
        if (inputFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_inputFileIsDirectory, (Object)inputFile));
        }
        boolean baseHasChanged = false;
        ConfigData configData = manipulator.getConfigData();
        LauncherData launcherData = manipulator.getLauncherData();
        configData.initialize();
        configData.setBundles(null);
        Properties props = EquinoxFwConfigFileParser.loadProperties(inputFile);
        Properties sharedConfigProperties = this.getSharedConfiguration(ParserUtils.getOSGiInstallArea(Arrays.asList(manipulator.getLauncherData().getProgramArgs()), props, manipulator.getLauncherData()), props.getProperty("osgi.sharedConfiguration.area"));
        if (sharedConfigProperties != null) {
            baseHasChanged = this.hasBaseChanged(inputFile, manipulator, props);
            if (!baseHasChanged) {
                sharedConfigProperties.putAll((Map<?, ?>)props);
            } else {
                sharedConfigProperties.put("osgi.sharedConfiguration.area", props.get("osgi.sharedConfiguration.area"));
            }
            props = sharedConfigProperties;
        }
        this.readFwJarLocation(configData, launcherData, props);
        URI configArea = inputFile.getParentFile().toURI();
        this.readp2DataArea(props, configArea);
        this.readSimpleConfiguratorURL(props, configArea);
        if (!baseHasChanged) {
            this.readBundlesList(manipulator, ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), props, launcherData).toURI(), props);
        }
        this.readInitialStartLeve(configData, props);
        this.readDefaultStartLevel(configData, props);
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (KNOWN_PROPERTIES.contains(key)) continue;
            String value = props.getProperty(key);
            configData.setProperty(key, value);
        }
        Log.log(3, NLS.bind((String)Messages.log_configFile, (Object)inputFile.getAbsolutePath()));
    }

    private boolean hasBaseChanged(File configIni, Manipulator manipulator, Properties configProps) {
        Properties timestamps;
        LauncherData launcherData = manipulator.getLauncherData();
        File sharedConfigIni = this.findSharedConfigIniFile(ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), configProps, launcherData), configProps.getProperty("osgi.sharedConfiguration.area"));
        File timestampFile = new File(configIni.getParentFile(), BASE_TIMESTAMP_FILE_CONFIGINI);
        try {
            timestamps = EquinoxFwConfigFileParser.loadProperties(timestampFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return !String.valueOf(sharedConfigIni.lastModified()).equals(timestamps.getProperty(KEY_CONFIGINI_TIMESTAMP));
    }

    private void readDefaultStartLevel(ConfigData configData, Properties props) {
        if (props.getProperty("osgi.bundles.defaultStartLevel") != null) {
            configData.setInitialBundleStartLevel(Integer.parseInt(props.getProperty("osgi.bundles.defaultStartLevel")));
        }
    }

    private void writeDefaultStartLevel(ConfigData configData, Properties props) {
        if (configData.getInitialBundleStartLevel() != -1) {
            props.setProperty("osgi.bundles.defaultStartLevel", Integer.toString(configData.getInitialBundleStartLevel()));
        }
    }

    private void readInitialStartLeve(ConfigData configData, Properties props) {
        if (props.getProperty("osgi.startLevel") != null) {
            configData.setBeginningFwStartLevel(Integer.parseInt(props.getProperty("osgi.startLevel")));
        }
    }

    private void writeInitialStartLevel(ConfigData configData, Properties props) {
        if (configData.getBeginingFwStartLevel() != -1) {
            props.setProperty("osgi.startLevel", Integer.toString(configData.getBeginingFwStartLevel()));
        }
    }

    private File readFwJarLocation(ConfigData configData, LauncherData launcherData, Properties props) throws URISyntaxException {
        File fwJar = null;
        if (props.getProperty("osgi.framework") != null) {
            URI absoluteFwJar = null;
            absoluteFwJar = URIUtil.makeAbsolute((URI)FileUtils.fromFileURL(props.getProperty("osgi.framework")), (URI)ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), props, launcherData).toURI());
            props.setProperty("osgi.framework", absoluteFwJar.toString());
            String fwJarString = props.getProperty("osgi.framework");
            if (fwJarString != null) {
                fwJar = URIUtil.toFile((URI)absoluteFwJar);
                if (fwJar == null) {
                    throw new IllegalStateException(Messages.exception_noFrameworkLocation);
                }
                launcherData.setFwJar(fwJar);
            } else {
                throw new IllegalStateException(Messages.exception_noFrameworkLocation);
            }
        }
        if (launcherData.getFwJar() != null) {
            configData.addBundle(new BundleInfo(launcherData.getFwJar().toURI()));
        }
        return launcherData.getFwJar();
    }

    private void writeFwJarLocation(ConfigData configData, LauncherData launcherData, Properties props) {
        if (launcherData.getFwJar() == null) {
            return;
        }
        props.setProperty("osgi.framework", FileUtils.toFileURL(URIUtil.makeRelative((URI)launcherData.getFwJar().toURI(), (URI)ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), configData.getProperties(), launcherData).toURI())));
    }

    private static Properties loadProperties(File inputFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(inputFile);
            props.load(is);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Log.log(2, NLS.bind((String)Messages.log_failed_reading_properties, (Object)inputFile));
            }
            is = null;
        }
        return props;
    }

    private File findSharedConfigIniFile(File base, String sharedConfigurationArea) {
        File sharedConfigurationFolder;
        URL rootURL;
        if (sharedConfigurationArea == null) {
            return null;
        }
        if (base == null) {
            return null;
        }
        try {
            rootURL = base.toURL();
        }
        catch (MalformedURLException e1) {
            return null;
        }
        if (rootURL == null) {
            return null;
        }
        URL sharedConfigurationURL = null;
        try {
            sharedConfigurationURL = new URL(sharedConfigurationArea);
        }
        catch (MalformedURLException e) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_url, (Object)sharedConfigurationArea));
            return null;
        }
        if (!sharedConfigurationURL.getPath().startsWith("/")) {
            if (!rootURL.getProtocol().equals(sharedConfigurationURL.getProtocol())) {
                Log.log(2, NLS.bind((String)Messages.log_shared_config_relative_url, (Object)rootURL.toExternalForm(), (Object)sharedConfigurationArea));
                return null;
            }
            try {
                sharedConfigurationURL = new URL(rootURL, sharedConfigurationArea);
            }
            catch (MalformedURLException e) {
                Log.log(2, NLS.bind((String)Messages.log_shared_config_relative_url, (Object)rootURL.toExternalForm(), (Object)sharedConfigurationArea));
                return null;
            }
        }
        if (!(sharedConfigurationFolder = EquinoxManipulatorImpl.toFile(sharedConfigurationURL)).isDirectory()) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_file_missing, (Object)sharedConfigurationFolder));
            return null;
        }
        File sharedConfigIni = new File(sharedConfigurationFolder, "config.ini");
        if (!sharedConfigIni.exists()) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_file_missing, (Object)sharedConfigIni));
            return null;
        }
        return sharedConfigIni;
    }

    private void readp2DataArea(Properties props, URI configArea) throws URISyntaxException {
        Object url;
        if (props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA) != null && (url = props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA)) != null) {
            if (((String)url).startsWith(CONFIG_DIR)) {
                url = FILE_PROTOCOL + ((String)url).substring(CONFIG_DIR.length());
            }
            props.setProperty(KEY_ECLIPSE_PROV_DATA_AREA, URIUtil.makeAbsolute((URI)FileUtils.fromFileURL((String)url), (URI)configArea).toString());
        }
    }

    private void writep2DataArea(ConfigData configData, Properties props, URI configArea) throws URISyntaxException {
        String dataArea = this.getFwProperty(configData, KEY_ECLIPSE_PROV_DATA_AREA);
        if (dataArea != null) {
            if (dataArea.startsWith(CONFIG_DIR)) {
                props.setProperty(KEY_ECLIPSE_PROV_DATA_AREA, dataArea);
                return;
            }
            URI dataAreaURI = new URI(dataArea);
            URI relative = URIUtil.makeRelative((URI)dataAreaURI, (URI)configArea);
            if (dataAreaURI.equals(relative)) {
                props.setProperty(KEY_ECLIPSE_PROV_DATA_AREA, FileUtils.toFileURL(dataAreaURI));
                return;
            }
            String result = URIUtil.toUnencodedString((URI)relative);
            if (result.startsWith("../..")) {
                result = dataArea;
            } else if (!result.equals(dataArea)) {
                props.setProperty(KEY_ECLIPSE_PROV_DATA_AREA, CONFIG_DIR + result);
                return;
            }
            props.setProperty(KEY_ECLIPSE_PROV_DATA_AREA, FileUtils.toFileURL(new URI(result)));
        }
    }

    private void readSimpleConfiguratorURL(Properties props, URI configArea) throws URISyntaxException {
        if (props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL) != null) {
            props.setProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, URIUtil.makeAbsolute((URI)FileUtils.fromFileURL(props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL)), (URI)configArea).toString());
        }
    }

    private void writeSimpleConfiguratorURL(ConfigData configData, Properties props, URI configArea) throws URISyntaxException {
        String value = this.getFwProperty(configData, KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL);
        if (value != null) {
            props.setProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, FileUtils.toFileURL(URIUtil.makeRelative((URI)URIUtil.fromString((String)value), (URI)configArea)));
        }
    }

    private String getFwProperty(ConfigData data, String key) {
        return data.getProperty(key);
    }

    public void saveFwConfig(BundleInfo[] bInfos, Manipulator manipulator, boolean backup, boolean relative) throws IOException {
        ConfigData configData = manipulator.getConfigData();
        LauncherData launcherData = manipulator.getLauncherData();
        File fwJar = EquinoxBundlesState.getSystemBundleFromBundleInfos(configData);
        launcherData.setFwJar(fwJar);
        File outputFile = launcherData.getFwConfigLocation();
        if (outputFile.exists()) {
            if (outputFile.isFile()) {
                if (!outputFile.getName().equals("config.ini")) {
                    throw new IllegalStateException(NLS.bind((String)Messages.exception_fwConfigLocationName, (Object)outputFile.getAbsolutePath(), (Object)"config.ini"));
                }
            } else {
                outputFile = new File(outputFile, "config.ini");
            }
        } else if (!outputFile.getName().equals("config.ini")) {
            if (!outputFile.mkdir()) {
                throw new IOException(NLS.bind((String)Messages.exception_failedToCreateDir, (Object)outputFile));
            }
            outputFile = new File(outputFile, "config.ini");
        }
        Properties configProps = new Properties();
        this.writeFwJarLocation(configData, launcherData, configProps);
        try {
            URI configArea = manipulator.getLauncherData().getFwConfigLocation().toURI();
            this.writep2DataArea(configData, configProps, configArea);
            this.writeSimpleConfiguratorURL(configData, configProps, configArea);
            this.writeBundlesList(launcherData.getFwJar(), configProps, bInfos);
            this.writeInitialStartLevel(configData, configProps);
            this.writeDefaultStartLevel(configData, configProps);
        }
        catch (URISyntaxException e) {
            throw new FrameworkAdminRuntimeException((Throwable)e, Messages.exception_errorSavingConfigIni);
        }
        Properties original = configData.getProperties();
        original.putAll((Map<?, ?>)configProps);
        configProps = original;
        if (configProps == null || configProps.size() == 0) {
            Log.log(2, (Object)this, "saveFwConfig() ", Messages.log_configProps);
            return;
        }
        if (!Utils.createParentDir((File)outputFile)) {
            throw new IllegalStateException(NLS.bind((String)Messages.exception_failedToCreateDir, (Object)outputFile.getParent()));
        }
        if (DEBUG) {
            Utils.printoutProperties((PrintStream)System.out, (String)"configProps", (Properties)configProps);
        }
        if (backup && outputFile.exists()) {
            File dest = Utils.getSimpleDataFormattedFile((File)outputFile);
            if (!outputFile.renameTo(dest)) {
                throw new IOException(NLS.bind((String)Messages.exception_failedToRename, (Object)outputFile, (Object)dest));
            }
            Log.log(3, (Object)this, "saveFwConfig()", NLS.bind((String)Messages.log_renameSuccessful, (Object)outputFile, (Object)dest));
        }
        this.filterPropertiesFromSharedArea(configProps, manipulator);
        this.saveProperties(outputFile, configProps);
        this.rememberSharedConfigurationTimestamp(configProps, manipulator, outputFile.getParentFile());
    }

    private void saveProperties(File outputFile, Properties configProps) throws IOException {
        String header = "This configuration file was written by: " + this.getClass().getName();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            configProps.store(out, header);
            Log.log(3, NLS.bind((String)Messages.log_propertiesSaved, (Object)outputFile));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void filterPropertiesFromSharedArea(Properties configProps, Manipulator manipulator) {
        LauncherData launcherData = manipulator.getLauncherData();
        Properties sharedConfigProperties = this.getSharedConfiguration(ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), configProps, launcherData), configProps.getProperty("osgi.sharedConfiguration.area"));
        if (sharedConfigProperties == null) {
            return;
        }
        Enumeration<?> keys = configProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String sharedValue = sharedConfigProperties.getProperty(key);
            if (sharedValue == null) continue;
            String value = configProps.getProperty(key);
            if (this.equalsIgnoringSeparators(sharedValue, value)) {
                configProps.remove(key);
                continue;
            }
            if (key.equals("osgi.framework")) {
                configProps.remove(key);
                continue;
            }
            if (key.equals("osgi.bundles") && this.equalBundleLists(manipulator, value, sharedValue)) {
                configProps.remove(key);
                continue;
            }
            if (!key.equals("osgi.framework.extensions") || !this.equalBundleLists(manipulator, value, sharedValue)) continue;
            configProps.remove(key);
        }
    }

    private boolean equalBundleLists(Manipulator manipulator, String value, String sharedValue) {
        BundleInfo[] bundles = this.parseBundleList(manipulator, value);
        BundleInfo[] sharedBundles = this.parseBundleList(manipulator, sharedValue);
        if (bundles == null || sharedBundles == null || bundles.length != sharedBundles.length) {
            return false;
        }
        ArrayList<BundleInfo> compareList = new ArrayList<BundleInfo>(Arrays.asList(bundles));
        compareList.removeAll(Arrays.asList(sharedBundles));
        return compareList.isEmpty();
    }

    private boolean equalsIgnoringSeparators(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        StringBuffer sb1 = new StringBuffer(s1);
        StringBuffer sb2 = new StringBuffer(s2);
        this.canonicalizePathsForComparison(sb1);
        this.canonicalizePathsForComparison(sb2);
        return sb1.toString().equals(sb2.toString());
    }

    private void canonicalizePathsForComparison(StringBuffer s) {
        String[] tokens;
        String[] stringArray = tokens = new String[]{"\\\\", "\\", "//", "/"};
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            int idx = s.length();
            int i = s.length();
            while (i != 0 && idx != -1) {
                idx = s.toString().lastIndexOf(token, idx);
                if (idx != -1) {
                    s.replace(idx, idx + token.length(), "^");
                }
                --i;
            }
            ++n2;
        }
    }

    private void rememberSharedConfigurationTimestamp(Properties configProps, Manipulator manipulator, File folder) throws IOException {
        Properties timestamps;
        LauncherData launcherData = manipulator.getLauncherData();
        File sharedConfigIni = this.findSharedConfigIniFile(ParserUtils.getOSGiInstallArea(Arrays.asList(launcherData.getProgramArgs()), configProps, launcherData), configProps.getProperty("osgi.sharedConfiguration.area"));
        if (sharedConfigIni == null) {
            return;
        }
        File timestampFile = new File(folder, BASE_TIMESTAMP_FILE_CONFIGINI);
        try {
            timestamps = EquinoxFwConfigFileParser.loadProperties(timestampFile);
        }
        catch (IOException e) {
            timestamps = new Properties();
        }
        timestamps.setProperty(KEY_CONFIGINI_TIMESTAMP, String.valueOf(sharedConfigIni.lastModified()));
        this.saveProperties(timestampFile, timestamps);
    }

    private Properties getSharedConfiguration(File baseFile, String sharedConfigurationArea) {
        if (sharedConfigurationArea == null) {
            return null;
        }
        File sharedConfigIni = this.findSharedConfigIniFile(baseFile, sharedConfigurationArea);
        if (sharedConfigIni != null && sharedConfigIni.exists()) {
            try {
                return EquinoxFwConfigFileParser.loadProperties(sharedConfigIni);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

