/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.surround.ExceptionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesRefactoringCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class AssignToVariableAssistProposalCore
extends LinkedCorrectionProposalCore {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int TRY_WITH_RESOURCES = 3;
    static final String KEY_NAME = "name";
    static final String KEY_TYPE = "type";
    static final String GROUP_EXC_TYPE = "exc_type";
    static final String GROUP_EXC_NAME = "exc_name";
    static final String VAR_TYPE = "var";
    private final int fVariableKind;
    private final List<ASTNode> fNodesToAssign;
    private final ITypeBinding fTypeBinding;
    private final ICompilationUnit fCUnit;
    private final List<String> fParamNames;
    private VariableDeclarationFragment fExistingFragment;

    public AssignToVariableAssistProposalCore(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fCUnit = cu;
        this.fVariableKind = variableKind;
        this.fParamNames = null;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.add((ASTNode)node);
        this.fTypeBinding = Bindings.normalizeForDeclarationUse(typeBinding, node.getAST());
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntolocal_description);
        } else if (variableKind == 2) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntofield_description);
        } else {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignintrywithresources_description);
        }
        this.createImportRewrite((CompilationUnit)node.getRoot());
    }

    public AssignToVariableAssistProposalCore(ICompilationUnit cu, SingleVariableDeclaration parameter, VariableDeclarationFragment existingFragment, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fCUnit = cu;
        this.fVariableKind = 2;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.add((ASTNode)parameter);
        this.fParamNames = null;
        this.fTypeBinding = typeBinding;
        this.fExistingFragment = existingFragment;
        if (existingFragment == null) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignparamtofield_description);
        } else {
            this.setDisplayName(Messages.format(CorrectionMessages.AssignToVariableAssistProposal_assigntoexistingfield_description, BasicElementLabels.getJavaElementName(existingFragment.getName().getIdentifier())));
        }
    }

    public AssignToVariableAssistProposalCore(ICompilationUnit cu, List<SingleVariableDeclaration> parameters, int relevance) {
        super("", cu, (ASTRewrite)null, relevance);
        this.fCUnit = cu;
        this.fVariableKind = 2;
        this.fNodesToAssign = new ArrayList<ASTNode>();
        this.fNodesToAssign.addAll(parameters);
        this.fTypeBinding = null;
        this.fParamNames = new ArrayList<String>();
        this.populateNames(parameters);
        this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignallparamstofields_description);
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fNodesToAssign.get(0).getAST());
            if (this.fNodesToAssign.size() == 1) {
                return this.doAddField(rewrite, this.fNodesToAssign.get(0), this.fTypeBinding, 0);
            }
            return this.doAddAllFields(rewrite);
        }
        return this.doAddLocal();
    }

    private void populateNames(List<SingleVariableDeclaration> parameters) {
        if (parameters != null && parameters.size() > 0) {
            for (SingleVariableDeclaration param : parameters) {
                if (param.getName() == null) continue;
                this.fParamNames.add(param.getName().getIdentifier());
            }
        }
    }

    private ASTRewrite doAddLocal() throws CoreException {
        String[] varNames;
        ASTNode nodeToAssign = this.fNodesToAssign.get(0);
        Expression expression = ((ExpressionStatement)nodeToAssign).getExpression();
        AST ast = nodeToAssign.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)nodeToAssign.getRoot());
        String[] stringArray = varNames = this.suggestLocalVariableNames(this.fTypeBinding, expression);
        int n = varNames.length;
        int n2 = 0;
        while (n2 < n) {
            String varName = stringArray[n2];
            this.addLinkedPositionProposal(KEY_NAME, varName);
            ++n2;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varNames[0]));
        newDeclFrag.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)expression));
        Type type = this.evaluateType(ast, nodeToAssign, this.fTypeBinding, KEY_TYPE, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
        ICompilationUnit cu = this.getCompilationUnit();
        if (type != null && cu != null && JavaModelUtil.is10OrHigher(cu.getJavaProject())) {
            this.addLinkedPositionProposal(KEY_TYPE, VAR_TYPE);
        }
        if (this.fVariableKind == 1) {
            if (ASTNodes.isControlStatementBody(nodeToAssign.getLocationInParent())) {
                Block block = ast.newBlock();
                block.statements().add(rewrite.createMoveTarget(nodeToAssign));
                rewrite.replace(nodeToAssign, (ASTNode)block, null);
            }
            if (this.needsSemicolon(expression)) {
                VariableDeclarationStatement varStatement = ast.newVariableDeclarationStatement(newDeclFrag);
                varStatement.setType(type);
                rewrite.replace((ASTNode)expression, (ASTNode)varStatement, null);
            } else {
                VariableDeclarationExpression varExpression = ast.newVariableDeclarationExpression(newDeclFrag);
                varExpression.setType(type);
                rewrite.replace((ASTNode)expression, (ASTNode)varExpression, null);
            }
            this.setEndPosition(rewrite.track(nodeToAssign));
        } else {
            List<ITypeBinding> catchExceptions;
            IMethodBinding close;
            TryStatement tryStatement = null;
            boolean modifyExistingTry = false;
            TryStatement enclosingTry = (TryStatement)ASTResolving.findAncestor(nodeToAssign, 54);
            ListRewrite resourcesRewriter = null;
            ListRewrite clausesRewriter = null;
            if (enclosingTry == null || enclosingTry.getBody() == null || enclosingTry.getBody().statements().get(0) != nodeToAssign) {
                tryStatement = ast.newTryStatement();
            } else {
                modifyExistingTry = true;
                resourcesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.RESOURCES2_PROPERTY);
                clausesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.CATCH_CLAUSES_PROPERTY);
            }
            VariableDeclarationExpression varExpression = ast.newVariableDeclarationExpression(newDeclFrag);
            varExpression.setType(type);
            EmptyStatement blankLine = null;
            if (modifyExistingTry) {
                resourcesRewriter.insertLast((ASTNode)varExpression, null);
            } else {
                tryStatement.resources().add(varExpression);
                blankLine = (EmptyStatement)rewrite.createStringPlaceholder("", 20);
                tryStatement.getBody().statements().add(blankLine);
            }
            CatchClause catchClause = ast.newCatchClause();
            SingleVariableDeclaration decl = ast.newSingleVariableDeclaration();
            Selection selection = Selection.createFromStartLength(expression.getStartPosition(), expression.getLength());
            String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
            SurroundWithTryWithResourcesAnalyzer analyzer = new SurroundWithTryWithResourcesAnalyzer(this.fCUnit, selection);
            expression.getRoot().accept((ASTVisitor)analyzer);
            CodeScopeBuilder.Scope scope = CodeScopeBuilder.perform(analyzer.getEnclosingBodyDeclaration(), selection).findScope(selection.getOffset(), selection.getLength());
            scope.setCursor(selection.getOffset());
            String name = scope.createName(varName, false);
            decl.setName(ast.newSimpleName(name));
            ITypeBinding[] exceptions = ExceptionAnalyzer.perform(expression.getParent(), selection, false);
            ArrayList<ITypeBinding> allExceptions = new ArrayList<ITypeBinding>(Arrays.asList(exceptions));
            ArrayList<ITypeBinding> mustRethrowList = new ArrayList<ITypeBinding>();
            if (this.fTypeBinding != null && (close = SurroundWithTryWithResourcesRefactoringCore.findAutocloseMethod(this.fTypeBinding)) != null) {
                ITypeBinding[] iTypeBindingArray = close.getExceptionTypes();
                int n3 = iTypeBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding exceptionType = iTypeBindingArray[n4];
                    if (!allExceptions.contains(exceptionType)) {
                        allExceptions.add(exceptionType);
                    }
                    ++n4;
                }
            }
            if ((catchExceptions = analyzer.calculateCatchesAndRethrows(ASTNodes.filterSubtypes(allExceptions), mustRethrowList)).size() > 0) {
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)analyzer.getEnclosingBodyDeclaration(), importRewrite);
                LinkedProposalModelCore linkedProposalModel = this.createProposalModel();
                int i = 0;
                if (!modifyExistingTry) {
                    for (ITypeBinding mustThrow : mustRethrowList) {
                        CatchClause newClause = ast.newCatchClause();
                        SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                        newDecl.setName(ast.newSimpleName(name));
                        Type importType = importRewrite.addImport(mustThrow, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                        newDecl.setType(importType);
                        newClause.setException(newDecl);
                        ThrowStatement newThrowStatement = ast.newThrowStatement();
                        newThrowStatement.setExpression((Expression)ast.newSimpleName(name));
                        linkedProposalModel.getPositionGroup(GROUP_EXC_NAME + i, true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
                        newClause.getBody().statements().add(newThrowStatement);
                        tryStatement.catchClauses().add(newClause);
                        ++i;
                    }
                }
                List<ITypeBinding> filteredExceptions = ASTNodes.filterSubtypes(catchExceptions);
                UnionType unionType = ast.newUnionType();
                List types = unionType.types();
                for (ITypeBinding exception : filteredExceptions) {
                    Type importType = importRewrite.addImport(exception, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                    types.add(importType);
                    linkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(rewrite.track((ASTNode)type), i == 0);
                    ++i;
                }
                decl.setType((Type)unionType);
                catchClause.setException(decl);
                linkedProposalModel.getPositionGroup("exc_name0", true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
                Statement st = this.getCatchBody(rewrite, expression, "Exception", name, this.fCUnit.findRecommendedLineSeparator());
                if (st != null) {
                    catchClause.getBody().statements().add(st);
                }
                if (modifyExistingTry) {
                    clausesRewriter.insertLast((ASTNode)catchClause, null);
                } else {
                    tryStatement.catchClauses().add(catchClause);
                }
            }
            if (modifyExistingTry) {
                rewrite.remove(nodeToAssign, null);
            } else {
                rewrite.replace((ASTNode)expression, (ASTNode)tryStatement, null);
                this.setEndPosition(rewrite.track((ASTNode)blankLine));
            }
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), true, KEY_NAME);
        this.addLinkedPosition(rewrite.track((ASTNode)type), false, KEY_TYPE);
        return rewrite;
    }

    protected LinkedProposalModelCore createProposalModel() {
        return new LinkedProposalModelCore();
    }

    private Statement getCatchBody(ASTRewrite rewrite, Expression expression, String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, (ASTNode)expression, lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)rewrite.createStringPlaceholder(s, 41);
    }

    private boolean needsSemicolon(Expression expression) {
        if ((expression.getParent().getFlags() & 8) != 0) {
            try {
                TokenScanner scanner = new TokenScanner((ITypeRoot)this.getCompilationUnit());
                return scanner.readNext(expression.getStartPosition() + expression.getLength(), true) != 64;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private ASTRewrite doAddField(ASTRewrite rewrite, ASTNode nodeToAssign, ITypeBinding typeBinding, int index) {
        ASTNode selectionNode;
        Block body;
        boolean isParamToField = nodeToAssign.getNodeType() == 44;
        ASTNode newTypeDecl = ASTResolving.findParentType(nodeToAssign);
        if (newTypeDecl == null) {
            return null;
        }
        SimpleName expression = isParamToField ? ((SingleVariableDeclaration)nodeToAssign).getName() : ((ExpressionStatement)nodeToAssign).getExpression();
        AST ast = newTypeDecl.getAST();
        this.createImportRewrite((CompilationUnit)nodeToAssign.getRoot());
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(nodeToAssign);
        if (bodyDecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)bodyDecl).getBody();
        } else if (bodyDecl instanceof Initializer) {
            body = ((Initializer)bodyDecl).getBody();
        } else {
            return null;
        }
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        boolean isStatic = Modifier.isStatic((int)bodyDecl.getModifiers()) && !isAnonymous;
        boolean isConstructorParam = isParamToField && nodeToAssign.getParent() instanceof MethodDeclaration && ((MethodDeclaration)nodeToAssign.getParent()).isConstructor();
        int modifiers = 2;
        if (isStatic) {
            modifiers |= 8;
        } else if (isConstructorParam) {
            String saveActionsKey = "editor_save_participant_org.eclipse.jdt.ui.postsavelistener.cleanup";
            IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, new ProjectScope(project.getProject())};
            boolean safeActionsEnabled = Platform.getPreferencesService().getBoolean(JavaManipulation.getPreferenceNodeId(), saveActionsKey, false, scopes);
            String prefix = "sp_";
            if (safeActionsEnabled && "true".equals(JavaManipulation.getPreference(prefix + "cleanup.on_save_use_additional_actions", project)) && "true".equals(JavaManipulation.getPreference(prefix + "cleanup.make_variable_declarations_final", project)) && "true".equals(JavaManipulation.getPreference(prefix + "cleanup.make_private_fields_final", project))) {
                int constructors = 0;
                if (newTypeDecl instanceof AbstractTypeDeclaration) {
                    List bodyDeclarations = ((AbstractTypeDeclaration)newTypeDecl).bodyDeclarations();
                    for (BodyDeclaration decl : bodyDeclarations) {
                        if (!(decl instanceof MethodDeclaration) || !((MethodDeclaration)decl).isConstructor()) continue;
                        ++constructors;
                    }
                }
                if (constructors == 1) {
                    modifiers |= 0x10;
                }
            }
        }
        VariableDeclarationFragment newDeclFrag = this.addFieldDeclaration(rewrite, newTypeDecl, modifiers, (Expression)expression, nodeToAssign, typeBinding, index);
        String varName = newDeclFrag.getName().getIdentifier();
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)expression));
        boolean needsThis = StubUtility.useThisForFieldAccess(project);
        if (isParamToField) {
            needsThis |= varName.equals(expression.getIdentifier());
        }
        SimpleName accessName = ast.newSimpleName(varName);
        if (needsThis) {
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(accessName);
            if (isStatic) {
                String typeName = ((AbstractTypeDeclaration)newTypeDecl).getName().getIdentifier();
                fieldAccess.setExpression((Expression)ast.newSimpleName(typeName));
            } else {
                fieldAccess.setExpression((Expression)ast.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)accessName);
        }
        if (isParamToField) {
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            int insertIdx = this.findAssignmentInsertIndex(body.statements(), nodeToAssign) + index;
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIdx, null);
            selectionNode = statement;
        } else {
            if (this.needsSemicolon((Expression)expression)) {
                rewrite.replace((ASTNode)expression, (ASTNode)ast.newExpressionStatement((Expression)assignment), null);
            } else {
                rewrite.replace((ASTNode)expression, (ASTNode)assignment, null);
            }
            selectionNode = nodeToAssign;
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), false, KEY_NAME + index);
        if (!isParamToField) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)newDeclFrag.getParent();
            this.addLinkedPosition(rewrite.track((ASTNode)fieldDeclaration.getType()), false, KEY_TYPE);
        }
        this.addLinkedPosition(rewrite.track((ASTNode)accessName), true, KEY_NAME + index);
        IVariableBinding variableBinding = newDeclFrag.resolveBinding();
        if (variableBinding != null) {
            SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding(nodeToAssign.getRoot(), (IBinding)variableBinding);
            int n = simpleNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleName linkedNode = simpleNameArray[n2];
                this.addLinkedPosition(rewrite.track((ASTNode)linkedNode), false, KEY_NAME + index);
                ++n2;
            }
        }
        this.setEndPosition(rewrite.track(selectionNode));
        return rewrite;
    }

    private ASTRewrite doAddAllFields(ASTRewrite rewrite) {
        int i = 0;
        while (rewrite != null && i < this.fNodesToAssign.size()) {
            ASTNode nodeToAssign = this.fNodesToAssign.get(i);
            ITypeBinding typeBinding = ((SingleVariableDeclaration)nodeToAssign).resolveBinding().getType();
            rewrite = this.doAddField(rewrite, nodeToAssign, typeBinding, i);
            ++i;
        }
        return rewrite;
    }

    private VariableDeclarationFragment addFieldDeclaration(ASTRewrite rewrite, ASTNode newTypeDecl, int modifiers, Expression expression, ASTNode nodeToAssign, ITypeBinding typeBinding, int index) {
        String varName;
        String[] varNames;
        if (this.fExistingFragment != null) {
            return this.fExistingFragment;
        }
        ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
        List<BodyDeclaration> decls = ASTNodes.getBodyDeclarations(newTypeDecl);
        AST ast = newTypeDecl.getAST();
        String[] stringArray = varNames = this.suggestFieldNames(typeBinding, expression, modifiers, nodeToAssign);
        int n = varNames.length;
        int n2 = 0;
        while (n2 < n) {
            varName = stringArray[n2];
            this.addLinkedPositionProposal(KEY_NAME + index, varName);
            ++n2;
        }
        varName = varNames[0];
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        Type type = this.evaluateType(ast, nodeToAssign, typeBinding, KEY_TYPE + index, ImportRewrite.TypeLocation.FIELD);
        newDecl.setType(type);
        newDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, newDecl.modifiers(), false, "modifier" + index);
        int insertIndex = this.findFieldInsertIndex(decls, nodeToAssign.getStartPosition()) + index;
        rewrite.getListRewrite(newTypeDecl, property).insertAt((ASTNode)newDecl, insertIndex, null);
        return newDeclFrag;
    }

    private Type evaluateType(AST ast, ASTNode nodeToAssign, ITypeBinding typeBinding, String groupID, ImportRewrite.TypeLocation location) {
        ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(ast, typeBinding);
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding proposal = iTypeBindingArray[n2];
            if (this.fVariableKind != 3 || Bindings.findTypeInHierarchy(proposal, "java.lang.AutoCloseable") != null) {
                this.addLinkedPositionProposal(groupID, proposal);
            }
            ++n2;
        }
        ImportRewrite importRewrite = this.getImportRewrite();
        CompilationUnit cuNode = (CompilationUnit)nodeToAssign.getRoot();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(cuNode, nodeToAssign.getStartPosition(), importRewrite);
        return importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context, location);
    }

    private String[] suggestLocalVariableNames(ITypeBinding binding, Expression expression) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        return StubUtility.getVariableNameSuggestions(5, project, binding, expression, this.getUsedVariableNames(this.fNodesToAssign.get(0)));
    }

    private String[] suggestFieldNames(ITypeBinding binding, Expression expression, int modifiers, ASTNode nodeToAssign) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        int varKind = Modifier.isStatic((int)modifiers) ? 1 : 2;
        return StubUtility.getVariableNameSuggestions(varKind, project, binding, expression, this.getUsedVariableNames(nodeToAssign));
    }

    private Collection<String> getUsedVariableNames(ASTNode nodeToAssign) {
        List<String> usedVarNames = Arrays.asList(ASTResolving.getUsedVariableNames(nodeToAssign));
        ArrayList<String> additionalVarNames = this.getRemainingParamNamed(nodeToAssign);
        if (additionalVarNames != null) {
            usedVarNames = new ArrayList<String>(Arrays.asList(ASTResolving.getUsedVariableNames(nodeToAssign)));
            usedVarNames.addAll(additionalVarNames);
        }
        return usedVarNames;
    }

    private ArrayList<String> getRemainingParamNamed(ASTNode nodeToAssign) {
        ArrayList<String> paramNames = null;
        if (this.fParamNames != null) {
            int index;
            paramNames = new ArrayList<String>();
            paramNames.addAll(this.fParamNames);
            if (nodeToAssign instanceof SingleVariableDeclaration && ((SingleVariableDeclaration)nodeToAssign).getName() != null && (index = this.fNodesToAssign.indexOf(nodeToAssign)) >= 0 && index < paramNames.size()) {
                paramNames.remove(index);
            }
        }
        return paramNames;
    }

    private int findAssignmentInsertIndex(List<Statement> statements, ASTNode nodeToAssign) {
        HashSet<String> paramsBefore = new HashSet<String>();
        List params = ((MethodDeclaration)nodeToAssign.getParent()).parameters();
        int i = 0;
        while (i < params.size() && params.get(i) != nodeToAssign) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i);
            paramsBefore.add(decl.getName().getIdentifier());
            ++i;
        }
        i = 0;
        i = 0;
        while (i < statements.size()) {
            Statement curr = statements.get(i);
            switch (curr.getNodeType()) {
                case 17: 
                case 46: {
                    break;
                }
                case 21: {
                    IVariableBinding binding;
                    Assignment assignment;
                    Expression rightHand;
                    Expression expr = ((ExpressionStatement)curr).getExpression();
                    if (expr instanceof Assignment && (rightHand = (assignment = (Assignment)expr).getRightHandSide()) instanceof SimpleName && paramsBefore.contains(((SimpleName)rightHand).getIdentifier()) && ((binding = Bindings.getAssignedVariable(assignment)) == null || binding.isField())) break;
                    return i;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int findFieldInsertIndex(List<BodyDeclaration> decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

