/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.google.gson.Gson;
import com.microsoft.java.maven.ArtifactResult;
import com.microsoft.java.maven.NetResponseResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class NetSearcher {
    private OkHttpClient client = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.SECONDS).build();
    private final String urlPrefix;
    private final String urlSuffix;
    private final int maxResult;

    public NetSearcher() {
        this.urlPrefix = "https://search.maven.org/solrsearch/select?q=";
        this.urlSuffix = "&rows=10&wt=json";
        this.maxResult = 5;
    }

    public Map<String, ArtifactResult> searchByClassName(String className) {
        String prefixSearchUrl;
        String exactSearchUrl;
        if (className.indexOf(46) != -1) {
            exactSearchUrl = String.valueOf(this.urlPrefix) + "fc:" + className + this.urlSuffix;
            prefixSearchUrl = String.valueOf(this.urlPrefix) + "fc:" + className + "*" + this.urlSuffix;
        } else {
            exactSearchUrl = String.valueOf(this.urlPrefix) + "c:" + className + this.urlSuffix;
            prefixSearchUrl = String.valueOf(this.urlPrefix) + "c:" + className + "*" + this.urlSuffix;
        }
        Request exactRequest = new Request.Builder().url(exactSearchUrl).build();
        Request prefixRequest = new Request.Builder().url(prefixSearchUrl).build();
        final CountDownLatch latch = new CountDownLatch(2);
        final String[] exactResponse = new String[]{""};
        final String[] prefixResponse = new String[]{""};
        this.client.newCall(exactRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                latch.countDown();
            }

            public void onResponse(Call call, Response response) {
                try {
                    exactResponse[0] = response.body().string();
                }
                catch (IOException iOException) {}
                latch.countDown();
            }
        });
        this.client.newCall(prefixRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                latch.countDown();
            }

            public void onResponse(Call call, Response response) {
                try {
                    prefixResponse[0] = response.body().string();
                }
                catch (IOException iOException) {}
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            return new HashMap<String, ArtifactResult>();
        }
        return this.processResponse(exactResponse[0], prefixResponse[0], className);
    }

    private Map<String, ArtifactResult> processResponse(String exactResponse, String prefixResponse, String queryClassName) {
        HashMap<String, ArtifactResult> resultMap = new HashMap<String, ArtifactResult>();
        if (!exactResponse.isEmpty()) {
            NetResponseResult exactResult = (NetResponseResult)new Gson().fromJson(exactResponse, NetResponseResult.class);
            this.addResult(exactResult, resultMap, queryClassName, 1);
        }
        if (!prefixResponse.isEmpty()) {
            NetResponseResult prefixResult = (NetResponseResult)new Gson().fromJson(prefixResponse, NetResponseResult.class);
            this.addResult(prefixResult, resultMap, queryClassName, 1);
        }
        return resultMap;
    }

    private void addResult(NetResponseResult responseResult, Map<String, ArtifactResult> resultMap, String queryClassName, int kind) {
        if (resultMap.size() >= this.maxResult) {
            return;
        }
        HashMap<String, NetResponseResult.FullClassNameList> consultMap = responseResult.getHighlighting();
        for (NetResponseResult.Info info : responseResult.getResponse().getDocs()) {
            String id = info.getId();
            if (!consultMap.containsKey(id)) continue;
            ArrayList<String> fullClassNames = ((NetResponseResult.FullClassNameList)consultMap.get(id)).getFch();
            for (String fullClassName : fullClassNames) {
                if (resultMap.containsKey(fullClassName = fullClassName.replaceAll("<em>", "").replaceAll("</em>", "")) || !this.isMatch(fullClassName, queryClassName).booleanValue()) continue;
                resultMap.put(fullClassName, new ArtifactResult(info.getG(), info.getA(), info.getV(), fullClassName.substring(fullClassName.lastIndexOf(46) + 1), fullClassName, -1, kind));
                if (resultMap.size() < this.maxResult) continue;
                return;
            }
        }
    }

    private Boolean isMatch(String fullClassName, String queryClassName) {
        String fc = fullClassName.substring(fullClassName.lastIndexOf(".") + 1).toLowerCase();
        String qc = queryClassName.indexOf(46) != -1 ? queryClassName.substring(queryClassName.lastIndexOf(".") + 1).toLowerCase() : queryClassName;
        return fc.startsWith(qc);
    }
}

