/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.IMavenArtifactIdentifier;
import org.eclipse.m2e.core.embedder.ArtifactKey;

public class MavenPropertiesIdentifier
implements IMavenArtifactIdentifier {
    @Override
    public ArtifactKey identify(IPath path, IProgressMonitor monitor) {
        if (path == null) {
            return null;
        }
        return this.identify(path.toFile());
    }

    private ArtifactKey identify(File file) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile jar = new ZipFile(file);){
                return this.getArtifactFromPomProperties(jar);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logError("Failed to identify " + String.valueOf(file) + " : " + String.valueOf(e));
            return null;
        }
    }

    private ArtifactKey getArtifactFromPomProperties(ZipFile jar) throws IOException {
        ZipEntry mavenEntry = jar.getEntry("META-INF/maven");
        if (mavenEntry == null) {
            return null;
        }
        String jarName = jar.getName();
        String entryName = mavenEntry.getName();
        Enumeration<? extends ZipEntry> zipEntries = jar.entries();
        ArtifactKey artifact = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (!zipEntry.getName().endsWith("pom.properties") || !zipEntry.getName().startsWith(entryName)) continue;
            Properties props = new Properties();
            props.load(jar.getInputStream(zipEntry));
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            String version = props.getProperty("version");
            String classifier = props.getProperty("classifier");
            if (groupId == null || artifactId == null || version == null) continue;
            ArtifactKey currentArtifact = new ArtifactKey(groupId, artifactId, version, classifier);
            if (artifact == null) {
                artifact = currentArtifact;
                continue;
            }
            if (!jarName.contains(artifactId + "-" + version)) continue;
            artifact = currentArtifact;
        }
        return artifact;
    }
}

