/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildClient;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.GradleBuildClient;
import com.microsoft.java.builder.BuildStateManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ImporterPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.microsoft.gradle.buildServer.importer";
    private Map<IPath, Pair<BuildServerConnection, BuildClient>> buildServers = new ConcurrentHashMap<IPath, Pair<BuildServerConnection, BuildClient>>();
    private static ImporterPlugin instance;
    private DigestStore digestStore;
    private static String bundleDirectory;
    private static String bundleVersion;

    static {
        bundleVersion = "";
    }

    public void start(BundleContext context) throws Exception {
        BuildStateManager.getBuildStateManager().startup();
        instance = this;
        bundleVersion = context.getBundle().getVersion().toString();
        this.digestStore = new DigestStore(this.getStateLocation().toFile());
        Optional bundleFile = FileLocator.getBundleFileLocation((Bundle)context.getBundle());
        if (!bundleFile.isPresent()) {
            throw new IllegalStateException("Failed to get bundle location.");
        }
        bundleDirectory = ((File)bundleFile.get()).getParent();
    }

    public void stop(BundleContext context) throws Exception {
        for (Pair<BuildServerConnection, BuildClient> pair : this.buildServers.values()) {
            ((BuildServerConnection)pair.getLeft()).buildShutdown();
            ((BuildServerConnection)pair.getLeft()).onBuildExit();
        }
    }

    public static ImporterPlugin getInstance() {
        return instance;
    }

    public static String getBundleVersion() {
        return bundleVersion;
    }

    public static DigestStore getDigestStore() {
        return ImporterPlugin.instance.digestStore;
    }

    public static BuildServerConnection getBuildServerConnection(IPath rootPath) throws CoreException {
        return ImporterPlugin.getBuildServerConnection(rootPath, false);
    }

    public static BuildServerConnection getBuildServerConnection(IPath rootPath, boolean createIfMissing) throws CoreException {
        Pair<BuildServerConnection, BuildClient> pair = ImporterPlugin.instance.buildServers.get(rootPath);
        if (pair != null) {
            return (BuildServerConnection)pair.getLeft();
        }
        if (!createIfMissing) {
            return null;
        }
        String javaExecutablePath = ImporterPlugin.getJavaExecutablePath();
        CharSequence[] classpaths = ImporterPlugin.getBuildServerClasspath();
        String pluginPath = ImporterPlugin.getBuildServerPluginPath();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutablePath);
        if (Boolean.parseBoolean(System.getenv("DEBUG_GRADLE_BUILD_SERVER"))) {
            command.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8989");
        }
        command.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        command.add("--add-opens=java.base/java.io=ALL-UNNAMED");
        command.add("--add-opens=java.base/java.util=ALL-UNNAMED");
        command.add("-Dplugin.dir=" + pluginPath);
        command.add("-cp");
        command.add(String.join((CharSequence)ImporterPlugin.getClasspathSeparator(), classpaths));
        command.add("com.microsoft.java.bs.core.Launcher");
        ProcessBuilder build = new ProcessBuilder(command);
        try {
            Process process = build.start();
            GradleBuildClient client = new GradleBuildClient();
            Launcher launcher = new Launcher.Builder().setOutput(process.getOutputStream()).setInput(process.getInputStream()).setLocalService((Object)client).setExecutorService(Executors.newCachedThreadPool()).setRemoteInterface(BuildServerConnection.class).create();
            launcher.startListening();
            BuildServerConnection server = (BuildServerConnection)launcher.getRemoteProxy();
            client.onConnectWithServer(server);
            ImporterPlugin.instance.buildServers.put(rootPath, (Pair<BuildServerConnection, BuildClient>)Pair.of((Object)server, (Object)client));
            return server;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Failed to start build server.", (Throwable)e));
        }
    }

    private static String getJavaExecutablePath() {
        Optional<String> command = ProcessHandle.current().info().command();
        if (command.isPresent()) {
            return command.get();
        }
        throw new IllegalStateException("Failed to get Java executable path.");
    }

    private static String[] getBuildServerClasspath() {
        return new String[]{Paths.get(bundleDirectory, "server.jar").toString(), String.valueOf(Paths.get(bundleDirectory, "runtime").toString()) + File.separatorChar + "*"};
    }

    private static String getBuildServerPluginPath() {
        return Paths.get(bundleDirectory, "plugins").toString();
    }

    private static String getClasspathSeparator() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ";";
        }
        return ":";
    }
}

