/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.DOMPatternLocatorFactory;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.AndLocator;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

public class DOMAndLocator
extends DOMPatternLocator {
    private final DOMPatternLocator[] children;

    public DOMAndLocator(AndLocator andLocator, AndPattern pattern) {
        super((SearchPattern)pattern);
        this.children = (DOMPatternLocator[])Arrays.stream(DOMAndLocator.children(andLocator)).map(child -> DOMPatternLocatorFactory.createWrapper(child, null)).toArray(DOMPatternLocator[]::new);
    }

    private static PatternLocator[] children(AndLocator andLocator) {
        try {
            Field locatorsField = AndLocator.class.getDeclaredField("patternLocators");
            locatorsField.setAccessible(true);
            return (PatternLocator[])locatorsField.get(andLocator);
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return new PatternLocator[0];
        }
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(Expression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(FieldDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(MemberValuePair node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(ModuleDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(FieldAccess node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(AbstractTypeDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(TypeParameter node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.and(child -> child.match(node, nodeSet, locator));
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, MatchLocator locator) {
        return this.and(child -> child.resolveLevel(node, locator));
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        return this.and(child -> child.resolveLevel(node, binding, locator));
    }

    private LocatorResponse and(Function<DOMPatternLocator, LocatorResponse> query) {
        return Arrays.stream(this.children).map(query::apply).min(Comparator.comparingInt(LocatorResponse::level)).orElse(this.toResponse(0));
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        for (DOMPatternLocator patternLocator : this.children) {
            patternLocator.initializePolymorphicSearch(locator);
        }
    }
}

