"use strict";
/********************************************************************************
 * Copyright (c) 2021 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 *******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.deactivate = exports.activate = void 0;
const vscode = require("vscode");
const build_configuration_1 = require("./build-configuration");
const ignore_gcc_flags_command_1 = require("./ignore-gcc-flags-command");
async function activate(context) {
    context.subscriptions.push(vscode.commands.registerCommand(build_configuration_1.CHANGE_BUILD_CONFIGURATION_COMMAND, () => build_configuration_1.changeBuildConfigurationCommandHandler(build_configuration_1.buildConfigurations)));
    context.subscriptions.push(vscode.commands.registerCommand(ignore_gcc_flags_command_1.IGNORE_GCC_FLAGS_COMMAND, (...args) => ignore_gcc_flags_command_1.ignoreGCCFlagsCommandHandler(args)));
    context.subscriptions.push(vscode.workspace.onDidChangeWorkspaceFolders(() => build_configuration_1.loadBuildConfiguration()));
    const cdbWatcher = vscode.workspace.createFileSystemWatcher(`**/${build_configuration_1.COMPILATION_DATABASE_FILE}`, false, true, false);
    context.subscriptions.push(cdbWatcher);
    context.subscriptions.push(cdbWatcher.onDidCreate(handleFileChange));
    context.subscriptions.push(cdbWatcher.onDidDelete(clearBuildConfigStatus));
    const configWatcher = vscode.workspace.createFileSystemWatcher(`**/${build_configuration_1.CLANGD_CONFIG_FILE}`, false, false, false);
    context.subscriptions.push(configWatcher);
    context.subscriptions.push(configWatcher.onDidCreate(handleFileChange));
    context.subscriptions.push(configWatcher.onDidChange(handleFileChange));
    context.subscriptions.push(configWatcher.onDidDelete(clearBuildConfigStatus));
    // Unlike the CLI example, this example does not use nor recognize `.clangd-contexts` files
    build_configuration_1.createBuildConfigurationStatusItem();
    build_configuration_1.loadBuildConfiguration();
}
exports.activate = activate;
function handleFileChange(uri) {
    if (uri.path.endsWith(build_configuration_1.COMPILATION_DATABASE_FILE) || uri.path.endsWith(build_configuration_1.CLANGD_CONFIG_FILE)) {
        build_configuration_1.loadBuildConfiguration();
    }
}
function clearBuildConfigStatus(uri) {
    build_configuration_1.updateBuildConfigStatus();
}
// this method is called when your extension is deactivated
function deactivate() { }
exports.deactivate = deactivate;
//# sourceMappingURL=extension.js.map