/*********************************************************************
 * Copyright (c) 2020 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
/// <reference types="node" />
/// <reference types="node" />
import { ChildProcess } from 'child_process';
import { Readable, Writable } from 'stream';
/**
 * Open and read a file from a subprocess (mode `r+` only).
 *
 * This is useful when opening a ptmx/pts pair at the same time.
 * When both files are opened by the same process, closing does not correctly release
 * the read callbacks, leaving node hanging at exit.
 *
 * Instead, we open one of the two files in a subprocess in order to kill it once done,
 * which will properly release read callbacks for some reason.
 */
export declare class ForkedFile {
    readonly path: string;
    protected _fork: ChildProcess;
    get reader(): Readable;
    get writer(): Writable;
    constructor(path: string);
    destroy(): void;
}
