/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.DimensionRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeAnnotationRewrite;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;

public class ChangeMethodSignatureProposal
extends LinkedCorrectionProposal {
    private ASTNode fInvocationNode;
    private IMethodBinding fSenderBinding;
    private ChangeDescription[] fParameterChanges;
    private ChangeDescription[] fExceptionChanges;

    public ChangeMethodSignatureProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, IMethodBinding binding, ChangeDescription[] paramChanges, ChangeDescription[] exceptionChanges, int relevance) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
        this.fParameterChanges = paramChanges;
        this.fExceptionChanges = exceptionChanges;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = (CompilationUnit)this.fInvocationNode.getRoot();
        ASTNode methodDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newMethodDecl = null;
        if (methodDecl != null) {
            newMethodDecl = methodDecl;
        } else {
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newMethodDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        ASTNode aSTNode = newMethodDecl;
        if (aSTNode instanceof MethodDeclaration) {
            void decl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            if (this.fParameterChanges != null) {
                this.modifyParameters(rewrite, (MethodDeclaration)decl);
            }
            if (this.fExceptionChanges != null) {
                this.modifyExceptions(rewrite, (MethodDeclaration)decl);
            }
            return rewrite;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void modifyParameters(ASTRewrite rewrite, MethodDeclaration methodDecl) {
        AST ast = methodDecl.getAST();
        ArrayList<String> usedNames = new ArrayList<String>();
        boolean hasCreatedVariables = false;
        IVariableBinding[] declaredFields = this.fSenderBinding.getDeclaringClass().getDeclaredFields();
        int i = 0;
        while (i < declaredFields.length) {
            usedNames.add(declaredFields[i].getName());
            ++i;
        }
        ImportRewrite imports = this.getImportRewrite();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)methodDecl, imports);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, MethodDeclaration.PARAMETERS_PROPERTY);
        List parameters = methodDecl.parameters();
        int k = 0;
        int i2 = 0;
        while (i2 < this.fParameterChanges.length) {
            ChangeDescription curr = this.fParameterChanges[i2];
            if (curr == null) {
                Object oldParam = (SingleVariableDeclaration)parameters.get(k);
                usedNames.add(oldParam.getName().getIdentifier());
                ++k;
            } else {
                ChangeDescription changeDescription = curr;
                if (changeDescription instanceof InsertDescription) {
                    void desc;
                    InsertDescription cfr_ignored_0 = (InsertDescription)changeDescription;
                    InsertDescription cfr_ignored_1 = (InsertDescription)changeDescription;
                    SingleVariableDeclaration newNode = ast.newSingleVariableDeclaration();
                    newNode.setType(imports.addImport(desc.type, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.PARAMETER));
                    newNode.setName(ast.newSimpleName("x"));
                    desc.resultingParamName = new SimpleName[]{newNode.getName()};
                    desc.resultingParamType = newNode.getType();
                    hasCreatedVariables = true;
                    listRewrite.insertAt((ASTNode)newNode, i2, null);
                    Javadoc javadoc = methodDecl.getJavadoc();
                    if (javadoc != null) {
                        TagElement newTagElement = ast.newTagElement();
                        newTagElement.setTagName("@param");
                        SimpleName arg = ast.newSimpleName("x");
                        newTagElement.fragments().add(arg);
                        this.insertParamTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), parameters, k, newTagElement);
                        desc.resultingTagArg = arg;
                    } else {
                        desc.resultingTagArg = null;
                    }
                } else if (curr instanceof RemoveDescription) {
                    Object decl = (SingleVariableDeclaration)parameters.get(k);
                    listRewrite.remove((ASTNode)decl, null);
                    ++k;
                    TagElement tagNode = this.findParamTag(methodDecl, (SingleVariableDeclaration)decl);
                    if (tagNode != null) {
                        rewrite.remove((ASTNode)tagNode, null);
                    }
                } else {
                    ChangeDescription changeDescription2 = curr;
                    if (changeDescription2 instanceof EditDescription) {
                        List fragments;
                        void desc;
                        EditDescription cfr_ignored_2 = (EditDescription)changeDescription2;
                        EditDescription cfr_ignored_3 = (EditDescription)changeDescription2;
                        ITypeBinding newTypeBinding = desc.type;
                        SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(k);
                        if (k == parameters.size() - 1 && i2 == this.fParameterChanges.length - 1 && decl.isVarargs() && newTypeBinding.isArray()) {
                            newTypeBinding = newTypeBinding.getElementType();
                        } else {
                            rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)Boolean.FALSE, null);
                        }
                        Type newType = imports.addImport(newTypeBinding, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.PARAMETER);
                        rewrite.replace((ASTNode)decl.getType(), (ASTNode)newType, null);
                        DimensionRewrite.removeAllChildren((ASTNode)decl, (ChildListPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY, (ASTRewrite)rewrite, null);
                        TypeAnnotationRewrite.removePureTypeAnnotations((ASTNode)decl, (ChildListPropertyDescriptor)SingleVariableDeclaration.MODIFIERS2_PROPERTY, (ASTRewrite)rewrite, null);
                        IBinding binding = decl.getName().resolveBinding();
                        if (binding != null) {
                            SimpleName[] names = LinkedNodeFinder.findByBinding((ASTNode)decl.getRoot(), (IBinding)binding);
                            SimpleName[] newNames = new SimpleName[names.length];
                            int j = 0;
                            while (j < names.length) {
                                SimpleName newName;
                                newNames[j] = newName = ast.newSimpleName("x");
                                rewrite.replace((ASTNode)names[j], (ASTNode)newName, null);
                                ++j;
                            }
                            desc.resultingParamName = newNames;
                        } else {
                            SimpleName newName = ast.newSimpleName("x");
                            rewrite.replace((ASTNode)decl.getName(), (ASTNode)newName, null);
                            desc.resultingParamName = new SimpleName[]{newName};
                        }
                        desc.resultingParamType = newType;
                        desc.orginalName = decl.getName().getIdentifier();
                        hasCreatedVariables = true;
                        ++k;
                        TagElement tagNode = this.findParamTag(methodDecl, decl);
                        if (tagNode != null && !(fragments = tagNode.fragments()).isEmpty()) {
                            SimpleName arg = ast.newSimpleName("x");
                            rewrite.replace((ASTNode)fragments.get(0), (ASTNode)arg, null);
                            desc.resultingTagArg = arg;
                        }
                    } else if (curr instanceof SwapDescription) {
                        SingleVariableDeclaration decl1 = (SingleVariableDeclaration)parameters.get(k);
                        SingleVariableDeclaration decl2 = (SingleVariableDeclaration)parameters.get(((SwapDescription)curr).index);
                        rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                        rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                        usedNames.add(decl1.getName().getIdentifier());
                        ++k;
                        TagElement tagNode1 = this.findParamTag(methodDecl, decl1);
                        TagElement tagNode2 = this.findParamTag(methodDecl, decl2);
                        if (tagNode1 != null && tagNode2 != null) {
                            rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                            rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                        }
                    }
                }
            }
            ++i2;
        }
        if (!hasCreatedVariables) {
            return;
        }
        if (methodDecl.getBody() != null) {
            CompilationUnit root = (CompilationUnit)methodDecl.getRoot();
            IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsAfter(methodDecl.getBody().getStartPosition(), 2);
            int i3 = 0;
            while (i3 < bindings.length) {
                usedNames.add(bindings[i3].getName());
                ++i3;
            }
        }
        this.fixupNames(rewrite, usedNames);
    }

    /*
     * WARNING - void declaration
     */
    private void fixupNames(ASTRewrite rewrite, ArrayList<String> usedNames) {
        AST ast = rewrite.getAST();
        int i = 0;
        while (i < this.fParameterChanges.length) {
            ChangeDescription curr = this.fParameterChanges[i];
            ChangeDescription changeDescription = curr;
            if (changeDescription instanceof ModifyDescription) {
                void desc;
                ModifyDescription cfr_ignored_0 = (ModifyDescription)changeDescription;
                ModifyDescription cfr_ignored_1 = (ModifyDescription)changeDescription;
                String typeKey = this.getParamTypeGroupId(i);
                String nameKey = this.getParamNameGroupId(i);
                String favourite = null;
                String[] excludedNames = usedNames.toArray(new String[usedNames.size()]);
                String suggestedName = desc.name;
                if (suggestedName != null) {
                    favourite = StubUtility.suggestArgumentName((IJavaProject)this.getCompilationUnit().getJavaProject(), (String)suggestedName, (String[])excludedNames);
                }
                Type type = desc.resultingParamType;
                String[] suggestedNames = StubUtility.getArgumentNameSuggestions((IJavaProject)this.getCompilationUnit().getJavaProject(), (Type)type, (String[])excludedNames);
                if (favourite == null) {
                    favourite = suggestedNames[0];
                }
                usedNames.add(favourite);
                SimpleName[] names = desc.resultingParamName;
                int j = 0;
                while (j < names.length) {
                    names[j].setIdentifier(favourite);
                    ++j;
                }
                SimpleName tagArg = desc.resultingTagArg;
                if (tagArg != null) {
                    tagArg.setIdentifier(favourite);
                }
            }
            ++i;
        }
    }

    private TagElement findParamTag(MethodDeclaration decl, SingleVariableDeclaration param) {
        Javadoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            return JavadocTagsSubProcessor.findParamTag(javadoc, param.getName().getIdentifier());
        }
        return null;
    }

    private TagElement insertParamTag(ListRewrite tagRewriter, List<SingleVariableDeclaration> parameters, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            SingleVariableDeclaration var = parameters.get(n);
            previousNames.add(var.getName().getIdentifier());
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    /*
     * WARNING - void declaration
     */
    private void modifyExceptions(ASTRewrite rewrite, MethodDeclaration methodDecl) {
        AST ast = methodDecl.getAST();
        ImportRewrite imports = this.getImportRewrite();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)methodDecl, imports);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
        List exceptions = methodDecl.thrownExceptionTypes();
        int k = 0;
        int i = 0;
        while (i < this.fExceptionChanges.length) {
            ChangeDescription curr = this.fExceptionChanges[i];
            if (curr == null) {
                ++k;
            } else {
                ChangeDescription changeDescription = curr;
                if (changeDescription instanceof InsertDescription) {
                    void desc;
                    InsertDescription cfr_ignored_0 = (InsertDescription)changeDescription;
                    InsertDescription cfr_ignored_1 = (InsertDescription)changeDescription;
                    String type = imports.addImport(desc.type, (ImportRewrite.ImportRewriteContext)context);
                    Type newNode = imports.addImport(desc.type, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                    listRewrite.insertAt((ASTNode)newNode, i, null);
                    String key = this.getExceptionTypeGroupId(i);
                    Javadoc javadoc = methodDecl.getJavadoc();
                    if (javadoc != null && JavadocTagsSubProcessor.findThrowsTag(javadoc, type) == null) {
                        TagElement newTagElement = ast.newTagElement();
                        newTagElement.setTagName("@throws");
                        Name newRef = ASTNodeFactory.newName((AST)ast, (String)type);
                        newTagElement.fragments().add(newRef);
                        this.insertThrowsTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), exceptions, k, newTagElement);
                    }
                } else if (curr instanceof RemoveDescription) {
                    Object node = (Type)exceptions.get(k);
                    listRewrite.remove((ASTNode)node, null);
                    ++k;
                    TagElement tagNode = this.findThrowsTag(methodDecl, (Type)node);
                    if (tagNode != null) {
                        rewrite.remove((ASTNode)tagNode, null);
                    }
                } else {
                    ChangeDescription changeDescription2 = curr;
                    if (changeDescription2 instanceof EditDescription) {
                        void desc;
                        EditDescription cfr_ignored_2 = (EditDescription)changeDescription2;
                        EditDescription cfr_ignored_3 = (EditDescription)changeDescription2;
                        SwapDescription oldNode = (Type)exceptions.get(k);
                        String type = imports.addImport(desc.type, (ImportRewrite.ImportRewriteContext)context);
                        Type newNode = imports.addImport(desc.type, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION);
                        listRewrite.replace((ASTNode)oldNode, (ASTNode)newNode, null);
                        ++k;
                        TagElement tagNode = this.findThrowsTag(methodDecl, (Type)oldNode);
                        if (tagNode != null) {
                            Type newRef = ASTNodeFactory.newType((AST)ast, (String)type);
                            rewrite.replace((ASTNode)tagNode.fragments().get(0), (ASTNode)newRef, null);
                        }
                    } else {
                        ChangeDescription changeDescription3 = curr;
                        if (changeDescription3 instanceof SwapDescription) {
                            void desc;
                            SwapDescription cfr_ignored_4 = (SwapDescription)changeDescription3;
                            SwapDescription cfr_ignored_5 = (SwapDescription)changeDescription3;
                            Type decl1 = (Type)exceptions.get(k);
                            Type decl2 = (Type)exceptions.get(desc.index);
                            rewrite.replace((ASTNode)decl1, rewrite.createCopyTarget((ASTNode)decl2), null);
                            rewrite.replace((ASTNode)decl2, rewrite.createCopyTarget((ASTNode)decl1), null);
                            ++k;
                            TagElement tagNode1 = this.findThrowsTag(methodDecl, decl1);
                            TagElement tagNode2 = this.findThrowsTag(methodDecl, decl2);
                            if (tagNode1 != null && tagNode2 != null) {
                                rewrite.replace((ASTNode)tagNode1, rewrite.createCopyTarget((ASTNode)tagNode2), null);
                                rewrite.replace((ASTNode)tagNode2, rewrite.createCopyTarget((ASTNode)tagNode1), null);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private TagElement findThrowsTag(MethodDeclaration decl, Type exception) {
        Javadoc javadoc = decl.getJavadoc();
        if (javadoc != null) {
            String name = ASTNodes.getTypeName((Type)exception);
            return JavadocTagsSubProcessor.findThrowsTag(javadoc, name);
        }
        return null;
    }

    private TagElement insertThrowsTag(ListRewrite tagRewriter, List<Type> exceptions, int currentIndex, TagElement newTagElement) {
        HashSet<String> previousNames = new HashSet<String>();
        int n = 0;
        while (n < currentIndex) {
            Type curr = exceptions.get(n);
            previousNames.add(ASTNodes.getTypeName((Type)curr));
            ++n;
        }
        JavadocTagsSubProcessor.insertTag(tagRewriter, newTagElement, previousNames);
        return newTagElement;
    }

    public String getParamNameGroupId(int idx) {
        return "param_name_" + idx;
    }

    public String getParamTypeGroupId(int idx) {
        return "param_type_" + idx;
    }

    public String getExceptionTypeGroupId(int idx) {
        return "exc_type_" + idx;
    }

    public static interface ChangeDescription {
    }

    public static class EditDescription
    extends ModifyDescription {
        String orginalName;

        public EditDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    public static class InsertDescription
    extends ModifyDescription {
        public InsertDescription(ITypeBinding type, String name) {
            super(type, name);
        }
    }

    static class ModifyDescription
    implements ChangeDescription {
        public final String name;
        public final ITypeBinding type;
        Type resultingParamType;
        SimpleName[] resultingParamName;
        SimpleName resultingTagArg;

        private ModifyDescription(ITypeBinding type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static class RemoveDescription
    implements ChangeDescription {
    }

    public static class SwapDescription
    implements ChangeDescription {
        final int index;

        public SwapDescription(int index) {
            this.index = index;
        }
    }
}

