/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IStepFilter;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.DebugOptions;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.core.LogicalStructureManager;
import org.eclipse.debug.internal.core.MemoryBlockManager;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.core.commands.CommandAdapterFactory;
import org.eclipse.debug.internal.core.groups.GroupMemberChangeListener;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DebugPlugin
extends Plugin {
    private static final String PI_DEBUG_CORE = "org.eclipse.debug.core";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_TYPES = "launchConfigurationTypes";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_COMPARATORS = "launchConfigurationComparators";
    public static final String EXTENSION_POINT_BREAKPOINTS = "breakpoints";
    public static final String EXTENSION_POINT_STATUS_HANDLERS = "statusHandlers";
    public static final String EXTENSION_POINT_SOURCE_LOCATORS = "sourceLocators";
    public static final String EXTENSION_POINT_LAUNCH_MODES = "launchModes";
    public static final String EXTENSION_POINT_LAUNCH_DELEGATES = "launchDelegates";
    public static final String EXTENSION_POINT_PROCESS_FACTORIES = "processFactories";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_TYPES = "logicalStructureTypes";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_PROVIDERS = "logicalStructureProviders";
    public static final String EXTENSION_POINT_SOURCE_CONTAINER_TYPES = "sourceContainerTypes";
    public static final String EXTENSION_POINT_SOURCE_PATH_COMPUTERS = "sourcePathComputers";
    public static final String EXTENSION_POINT_LAUNCH_OPTIONS = "launchOptions";
    public static final String EXTENSION_POINT_BREAKPOINT_IMPORT_PARTICIPANTS = "breakpointImportParticipants";
    public static final String EXTENSION_POINT_STEP_FILTERS = "stepFilters";
    public static final int ERROR = 125;
    public static final int INTERNAL_ERROR = 120;
    public static final int ERR_WORKING_DIRECTORY_NOT_SUPPORTED = 115;
    public static final String ATTR_PROCESS_FACTORY_ID = "process_factory_id";
    public static final String ATTR_CAPTURE_OUTPUT = "org.eclipse.debug.core.capture_output";
    public static final String ATTR_LAUNCH_TIMESTAMP = "org.eclipse.debug.core.launch.timestamp";
    public static final String ATTR_TERMINATE_TIMESTAMP = "org.eclipse.debug.core.terminate.timestamp";
    public static final String ATTR_CONSOLE_ENCODING = "org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING";
    public static final String ATTR_FORCE_SYSTEM_CONSOLE_ENCODING = "org.eclipse.debug.core.ATTR_FORCE_SYSTEM_CONSOLE_ENCODING";
    public static final String ATTR_MERGE_OUTPUT = "org.eclipse.debug.core.ATTR_MERGE_OUTPUT";
    public static final String PREF_DELETE_CONFIGS_ON_PROJECT_DELETE = "org.eclipse.debug.core.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE";
    public static final String ATTR_BREAKPOINT_IS_DELETED = "org.eclipse.debug.core.breakpointIsDeleted";
    public static final String ATTR_ENVIRONMENT = "org.eclipse.debug.core.ATTR_ENVIRONMENT";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.debug.core.ATTR_WORKING_DIRECTORY";
    public static final String ATTR_PATH = "org.eclipse.debug.core.ATTR_PATH";
    public static final String ATTR_TERMINATE_DESCENDANTS = "org.eclipse.debug.core.TERMINATE_DESCENDANTS";
    private static DebugPlugin fgDebugPlugin = null;
    private BreakpointManager fBreakpointManager;
    private ExpressionManager fExpressionManager;
    private LaunchManager fLaunchManager;
    private MemoryBlockManager fMemoryBlockManager;
    private final ListenerList<IDebugEventSetListener> fEventListeners = new ListenerList();
    private final ListenerList<IDebugEventFilter> fEventFilters = new ListenerList();
    private boolean fShuttingDown = false;
    private HashMap<StatusHandlerKey, IConfigurationElement> fStatusHandlers = null;
    private HashMap<String, IConfigurationElement> fProcessFactories = null;
    private ServiceTracker<IWorkspace, IWorkspace> fWorkspaceServiceTracker = null;
    private static final int NOTIFY_FILTERS = 0;
    private static final int NOTIFY_EVENTS = 1;
    private final List<Object> fEventQueue = new ArrayList<Object>();
    private final EventDispatchJob fEventDispatchJob = new EventDispatchJob();

    public static DebugPlugin getDefault() {
        return fgDebugPlugin;
    }

    private static void setDefault(DebugPlugin plugin) {
        fgDebugPlugin = plugin;
    }

    public static String getUniqueIdentifier() {
        return PI_DEBUG_CORE;
    }

    public DebugPlugin() {
        DebugPlugin.setDefault(this);
    }

    public void addDebugEventListener(IDebugEventSetListener listener) {
        this.fEventListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEventSet(DebugEvent[] events) {
        if (this.isShuttingDown() || events == null || this.fEventListeners.isEmpty()) {
            return;
        }
        List<Object> list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(events);
        }
        this.fEventDispatchJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable r) {
        List<Object> list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(r);
        }
        this.fEventDispatchJob.schedule();
    }

    public synchronized IBreakpointManager getBreakpointManager() {
        if (this.fBreakpointManager == null) {
            this.fBreakpointManager = new BreakpointManager();
        }
        return this.fBreakpointManager;
    }

    public synchronized ILaunchManager getLaunchManager() {
        if (this.fLaunchManager == null) {
            this.fLaunchManager = new LaunchManager();
            this.fLaunchManager.getAllLaunchConfigurations();
            this.fLaunchManager.addLaunchConfigurationListener(new GroupMemberChangeListener());
        }
        return this.fLaunchManager;
    }

    public synchronized IMemoryBlockManager getMemoryBlockManager() {
        if (this.fMemoryBlockManager == null) {
            this.fMemoryBlockManager = new MemoryBlockManager();
        }
        return this.fMemoryBlockManager;
    }

    public IStatusHandler getStatusHandler(IStatus status) {
        IConfigurationElement config;
        boolean enabled = Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, true, null);
        if (!enabled) {
            return null;
        }
        StatusHandlerKey key = new StatusHandlerKey(status.getPlugin(), status.getCode());
        if (this.fStatusHandlers == null) {
            this.initializeStatusHandlers();
        }
        if ((config = this.fStatusHandlers.get(key)) != null) {
            try {
                Object handler = config.createExecutableExtension("class");
                if (handler instanceof IStatusHandler) {
                    return (IStatusHandler)handler;
                }
                this.invalidStatusHandler(null, MessageFormat.format("Registered status handler {0} does not implement required interface IStatusHandler.", config.getDeclaringExtension().getUniqueIdentifier()));
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
        return null;
    }

    public synchronized IExpressionManager getExpressionManager() {
        if (this.fExpressionManager == null) {
            this.fExpressionManager = new ExpressionManager();
        }
        return this.fExpressionManager;
    }

    public void removeDebugEventListener(IDebugEventSetListener listener) {
        this.fEventListeners.remove((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.setShuttingDown(true);
            if (this.fLaunchManager != null) {
                this.fLaunchManager.shutdown();
            }
            if (this.fBreakpointManager != null) {
                this.fBreakpointManager.shutdown();
            }
            if (this.fMemoryBlockManager != null) {
                this.fMemoryBlockManager.shutdown();
            }
            this.fEventListeners.clear();
            this.fEventFilters.clear();
            SourceLookupUtils.shutdown();
            Preferences.savePreferences(DebugPlugin.getUniqueIdentifier());
            this.fWorkspaceServiceTracker.close();
        }
        finally {
            super.stop(context);
            DebugPlugin.setDefault(null);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new DebugOptions(context);
        this.fWorkspaceServiceTracker = new ServiceTracker<IWorkspace, IWorkspace>(context, IWorkspace.class, null){

            public IWorkspace addingService(ServiceReference<IWorkspace> reference) {
                IWorkspace workspace = (IWorkspace)this.context.getService(reference);
                if (workspace == null) {
                    DebugPlugin.logMessage("Could not add save participant as IWorkspace service is unavailable", null);
                    return null;
                }
                try {
                    workspace.addSaveParticipant(DebugPlugin.getUniqueIdentifier(), new ISaveParticipant(){

                        public void saving(ISaveContext saveContext) throws CoreException {
                            if ((this).DebugPlugin.this.fExpressionManager != null) {
                                (this).DebugPlugin.this.fExpressionManager.storeWatchExpressions();
                            }
                            Preferences.savePreferences(DebugPlugin.getUniqueIdentifier());
                        }

                        public void rollback(ISaveContext saveContext) {
                        }

                        public void prepareToSave(ISaveContext saveContext) throws CoreException {
                        }

                        public void doneSaving(ISaveContext saveContext) {
                        }
                    });
                }
                catch (CoreException e) {
                    DebugPlugin.log(e.getStatus());
                    this.context.ungetService(reference);
                    return null;
                }
                return workspace;
            }

            public void removedService(ServiceReference<IWorkspace> reference, IWorkspace service) {
                service.removeSaveParticipant(DebugPlugin.getUniqueIdentifier());
                this.context.ungetService(reference);
            }
        };
        this.fWorkspaceServiceTracker.open();
        IAdapterManager manager = Platform.getAdapterManager();
        CommandAdapterFactory actionFactory = new CommandAdapterFactory();
        manager.registerAdapters((IAdapterFactory)actionFactory, IDisconnect.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IDropToFrame.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IStep.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IStepFilters.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ISuspendResume.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ITerminate.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, ILaunch.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IProcess.class);
        manager.registerAdapters((IAdapterFactory)actionFactory, IDebugElement.class);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label) {
        return DebugPlugin.newProcess(launch, process, label, null);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label, Map<String, String> attributes) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String processFactoryID = null;
        if (config != null) {
            try {
                processFactoryID = config.getAttribute(ATTR_PROCESS_FACTORY_ID, (String)null);
            }
            catch (CoreException coreException) {}
        }
        if (processFactoryID != null) {
            IConfigurationElement element;
            DebugPlugin plugin = DebugPlugin.getDefault();
            if (plugin.fProcessFactories == null) {
                plugin.initializeProcessFactories();
            }
            if ((element = plugin.fProcessFactories.get(processFactoryID)) == null) {
                return null;
            }
            IProcessFactory processFactory = null;
            try {
                processFactory = (IProcessFactory)element.createExecutableExtension("class");
            }
            catch (CoreException exception) {
                DebugPlugin.log(exception);
                return null;
            }
            return processFactory.newProcess(launch, process, label, attributes);
        }
        return new RuntimeProcess(launch, process, label, attributes);
    }

    public static ILogicalStructureType[] getLogicalStructureTypes(IValue value) {
        return LogicalStructureManager.getDefault().getLogicalStructureTypes(value);
    }

    public static ILogicalStructureType getDefaultStructureType(ILogicalStructureType[] types) {
        return LogicalStructureManager.getDefault().getSelectedStructureType(types);
    }

    public static void setDefaultStructureType(ILogicalStructureType[] types, ILogicalStructureType def) {
        LogicalStructureManager.getDefault().setEnabledType(types, def);
    }

    public static Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        return DebugPlugin.exec(cmdLine, workingDirectory, null);
    }

    public static Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        return DebugPlugin.exec(cmdLine, workingDirectory, envp, false);
    }

    public static Process exec(String[] cmdLine, File workingDirectory, String[] envp, boolean mergeOutput) throws CoreException {
        Process p;
        block8: {
            p = null;
            try {
                if (mergeOutput) {
                    ProcessBuilder pb = new ProcessBuilder(cmdLine);
                    pb.directory(workingDirectory);
                    pb.redirectErrorStream(mergeOutput);
                    if (envp != null) {
                        Map<String, String> env = pb.environment();
                        env.clear();
                        String[] stringArray = envp;
                        int n = envp.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String e = stringArray[n2];
                            int index = e.indexOf(61);
                            if (index != -1) {
                                env.put(e.substring(0, index), e.substring(index + 1));
                            }
                            ++n2;
                        }
                    }
                    p = pb.start();
                } else {
                    p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_0, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 115, DebugCoreMessages.DebugPlugin_Eclipse_runtime_does_not_support_working_directory_2, (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, null)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block8;
                p = DebugPlugin.exec(cmdLine, null);
            }
        }
        return p;
    }

    private boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    public void addDebugEventFilter(IDebugEventFilter filter) {
        this.fEventFilters.add((Object)filter);
    }

    public void removeDebugEventFilter(IDebugEventFilter filter) {
        this.fEventFilters.remove((Object)filter);
    }

    public static void logDebugMessage(String message) {
        if (DebugPlugin.getDefault().isDebugging()) {
            DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_2, message), null));
        }
    }

    public static void logMessage(String message, Throwable throwable) {
        DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 125, message, throwable));
    }

    public static void log(IStatus status) {
        DebugPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_3, t);
        DebugPlugin.log((IStatus)status);
    }

    private void initializeStatusHandlers() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_STATUS_HANDLERS);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fStatusHandlers = new HashMap(infos.length);
        IConfigurationElement[] iConfigurationElementArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("plugin");
            String code = configurationElement.getAttribute("code");
            if (id != null && code != null) {
                try {
                    StatusHandlerKey key = new StatusHandlerKey(id, Integer.parseInt(code));
                    this.fStatusHandlers.put(key, configurationElement);
                }
                catch (NumberFormatException e) {
                    this.invalidStatusHandler(e, configurationElement.getAttribute("id"));
                }
            } else {
                this.invalidStatusHandler(null, configurationElement.getAttribute("id"));
            }
            ++n2;
        }
    }

    private void initializeProcessFactories() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_PROCESS_FACTORIES);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fProcessFactories = new HashMap(infos.length);
        IConfigurationElement[] iConfigurationElementArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("id");
            String clss = configurationElement.getAttribute("class");
            if (id != null && clss != null) {
                this.fProcessFactories.put(id, configurationElement);
            } else {
                String badDefiner = configurationElement.getContributor().getName();
                DebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_4, badDefiner, id), null));
            }
            ++n2;
        }
    }

    private void invalidStatusHandler(Exception e, String id) {
        DebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_5, id), (Throwable)e));
    }

    public static Document newDocument() throws CoreException {
        try {
            return LaunchManager.getDocument();
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.abort("Unable to create new XML document.", e);
            return null;
        }
    }

    public static String serializeDocument(Document document) throws CoreException {
        try {
            return LaunchManager.serializeDocument(document);
        }
        catch (IOException | TransformerException e) {
            DebugPlugin.abort("Unable to serialize XML document.", e);
            return null;
        }
    }

    public static Element parseDocument(String document) throws CoreException {
        Element root = null;
        try {
            DocumentBuilder parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            parser.setErrorHandler(new DefaultHandler());
            Throwable throwable = null;
            Object var4_9 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(document.getBytes(StandardCharsets.UTF_8));){
                root = parser.parse(stream).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.abort("Unable to parse XML document.", e);
        }
        catch (FactoryConfigurationError e) {
            DebugPlugin.abort("Unable to parse XML document.", e);
        }
        catch (SAXException e) {
            DebugPlugin.abort("Unable to parse XML document.", e);
        }
        catch (IOException e) {
            DebugPlugin.abort("Unable to parse XML document.", e);
        }
        return root;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, message, exception);
        throw new CoreException((IStatus)status);
    }

    /*
     * Exception decompiling
     */
    private static String[] parseArgumentsWindows(String args, boolean split) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String[] parseArgumentsImpl(String args, boolean split) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        if ("win32".equals(Platform.getOS())) {
            return DebugPlugin.parseArgumentsWindows(args, false);
        }
        return DebugPlugin.parseArgumentsImpl(args, false);
    }

    public static String[] splitArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        if ("win32".equals(Platform.getOS())) {
            return DebugPlugin.parseArgumentsWindows(args, true);
        }
        return DebugPlugin.parseArgumentsImpl(args, true);
    }

    public static String renderArguments(String[] arguments, int[] segments) {
        boolean isWin32 = Platform.getOS().equals("win32");
        StringBuilder buf = new StringBuilder();
        int count = arguments.length;
        int i = 0;
        while (i < count) {
            char[] characters;
            if (i > 0) {
                buf.append(' ');
            }
            boolean containsSpace = false;
            char[] cArray = characters = arguments[i].toCharArray();
            int n = characters.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == ' ' || ch == '\t') {
                    containsSpace = true;
                    buf.append('\"');
                    break;
                }
                ++n2;
            }
            int backslashes = 0;
            int j = 0;
            while (j < characters.length) {
                char ch = characters[j];
                if (ch == '\"') {
                    if (isWin32) {
                        if (j == 0 && characters.length == 2 && characters[1] == '\"') {
                            buf.append("\"\"");
                            break;
                        }
                        if (backslashes > 0) {
                            while (backslashes > 0) {
                                buf.append('\\');
                                --backslashes;
                            }
                        }
                    }
                    buf.append('\\');
                } else if (ch == '\\') {
                    if (isWin32) {
                        ++backslashes;
                    } else {
                        buf.append('\\');
                    }
                } else if (isWin32) {
                    backslashes = 0;
                }
                buf.append(ch);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
            } else if (characters.length == 0) {
                buf.append("\"\"");
            }
            if (segments != null && i < count - 1) {
                segments[i] = buf.length() + 1;
            }
            ++i;
        }
        return buf.toString();
    }

    public static void setUseStepFilters(boolean useStepFilters) {
        DebugPlugin.getStepFilterManager().setUseStepFilters(useStepFilters);
    }

    public static boolean isUseStepFilters() {
        return DebugPlugin.getStepFilterManager().isUseStepFilters();
    }

    public static IStepFilter[] getStepFilters(String modelIdentifier) {
        return DebugPlugin.getStepFilterManager().getStepFilters(modelIdentifier);
    }

    private static StepFilterManager getStepFilterManager() {
        return ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getStepFilterManager();
    }

    public static Object getAdapter(Object element, Class<?> type) {
        Object adapter = null;
        if (element != null) {
            if (type.isInstance(element)) {
                return element;
            }
            if (element instanceof IAdaptable) {
                adapter = ((IAdaptable)element).getAdapter(type);
            }
            if (adapter == null && !(element instanceof PlatformObject)) {
                adapter = Platform.getAdapterManager().getAdapter(element, type);
            }
            if (adapter == null) {
                adapter = Platform.getAdapterManager().loadAdapter(element, type.getName());
            }
        }
        return adapter;
    }

    class AsynchRunner
    implements ISafeRunnable {
        private Runnable fRunnable = null;

        AsynchRunner() {
        }

        void async(Runnable runnable) {
            this.fRunnable = runnable;
            SafeRunner.run((ISafeRunnable)this);
            this.fRunnable = null;
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_6, exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fRunnable.run();
        }
    }

    class EventDispatchJob
    extends Job {
        EventNotifier fNotifier;
        AsynchRunner fRunner;

        public EventDispatchJob() {
            super(DebugCoreMessages.DebugPlugin_1);
            this.fNotifier = new EventNotifier();
            this.fRunner = new AsynchRunner();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!DebugPlugin.this.fEventQueue.isEmpty()) {
                Object next = null;
                List<Object> list = DebugPlugin.this.fEventQueue;
                synchronized (list) {
                    if (!DebugPlugin.this.fEventQueue.isEmpty()) {
                        next = DebugPlugin.this.fEventQueue.remove(0);
                    }
                }
                if (next instanceof Runnable) {
                    this.fRunner.async((Runnable)next);
                    continue;
                }
                if (next == null) continue;
                this.fNotifier.dispatch((DebugEvent[])next);
            }
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        public boolean shouldSchedule() {
            return !DebugPlugin.this.isShuttingDown() && !DebugPlugin.this.fEventListeners.isEmpty();
        }
    }

    class EventNotifier
    implements ISafeRunnable {
        private DebugEvent[] fEvents;
        private IDebugEventSetListener fListener;
        private IDebugEventFilter fFilter;
        private int fMode;

        EventNotifier() {
        }

        public void handleException(Throwable exception) {
            switch (this.fMode) {
                case 0: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_7, exception);
                    DebugPlugin.log((IStatus)status);
                    break;
                }
                case 1: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_8, exception);
                    DebugPlugin.log((IStatus)status);
                    break;
                }
            }
        }

        public void run() throws Exception {
            switch (this.fMode) {
                case 0: {
                    this.fEvents = this.fFilter.filterDebugEvents(this.fEvents);
                    break;
                }
                case 1: {
                    this.fListener.handleDebugEvents(this.fEvents);
                    break;
                }
            }
        }

        void dispatch(DebugEvent[] events) {
            Iterator iterator;
            this.fEvents = events;
            if (!DebugPlugin.this.fEventFilters.isEmpty()) {
                this.fMode = 0;
                iterator = DebugPlugin.this.fEventFilters.iterator();
                while (iterator.hasNext()) {
                    IDebugEventFilter iDebugEventFilter;
                    this.fFilter = iDebugEventFilter = (IDebugEventFilter)iterator.next();
                    SafeRunner.run((ISafeRunnable)this);
                    if (this.fEvents != null && this.fEvents.length != 0) continue;
                    return;
                }
            }
            this.fMode = 1;
            if (DebugOptions.DEBUG_EVENTS) {
                DebugEvent[] debugEventArray = this.fEvents;
                int n = this.fEvents.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    DebugOptions.trace(event.toString());
                    ++n2;
                }
            }
            iterator = DebugPlugin.this.fEventListeners.iterator();
            while (iterator.hasNext()) {
                IDebugEventSetListener iDebugEventSetListener;
                this.fListener = iDebugEventSetListener = (IDebugEventSetListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fEvents = null;
            this.fFilter = null;
            this.fListener = null;
        }
    }

    class StatusHandlerKey {
        String fPluginId;
        int fCode;

        StatusHandlerKey(String pluginId, int code) {
            this.fPluginId = pluginId;
            this.fCode = code;
        }

        public int hashCode() {
            return this.fPluginId.hashCode() + this.fCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusHandlerKey) {
                StatusHandlerKey s = (StatusHandlerKey)obj;
                return this.fCode == s.fCode && this.fPluginId.equals(s.fPluginId);
            }
            return false;
        }
    }
}

