/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.EventType;
import org.eclipse.jdt.ls.core.internal.IProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.handlers.ProjectEncodingMode;
import org.eclipse.jdt.ls.core.internal.managers.BuildSupportManager;
import org.eclipse.jdt.ls.core.internal.managers.EclipseBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public abstract class ProjectsManager
implements ISaveParticipant,
IProjectsManager {
    public static final String DEFAULT_PROJECT_NAME = "jdt.ls-java-project";
    public static final String PROJECTS_IMPORTED = "__PROJECTS_IMPORTED__";
    private static final String CORE_RESOURCES_MATCHER_ID = "org.eclipse.core.resources.regexFilterMatcher";
    public static final String CREATED_BY_JAVA_LANGUAGE_SERVER = "__CREATED_BY_JAVA_LANGUAGE_SERVER__";
    public static final String BUILD_FILE_MARKER_TYPE = "org.eclipse.jdt.ls.buildFileMarker";
    private static final int JDTLS_FILTER_TYPE = 30;
    private PreferenceManager preferenceManager;
    protected JavaClientConnection.JavaLanguageClient client;

    public ProjectsManager(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    @Override
    public void initializeProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (!this.preferenceManager.getClientPreferences().skipProjectConfiguration()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.cleanInvalidProjects(rootPaths, (IProgressMonitor)subMonitor.split(20));
            ProjectsManager.createJavaProject(ProjectsManager.getDefaultProject(), (IProgressMonitor)subMonitor.split(10));
            this.cleanupResources(ProjectsManager.getDefaultProject());
            Collection<IPath> projectConfigurations = this.preferenceManager.getPreferences().getProjectConfigurations();
            if (projectConfigurations == null) {
                this.importProjects(rootPaths, (IProgressMonitor)subMonitor.split(70));
            } else {
                this.importProjectsFromConfigurationFiles(rootPaths, projectConfigurations, monitor);
            }
            this.updateEncoding(monitor);
            this.reportProjectsStatus();
            subMonitor.done();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateEncoding(IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace;
        IWorkspace iWorkspace;
        if (this.preferenceManager != null && ProjectEncodingMode.SETDEFAULT.equals((Object)this.preferenceManager.getPreferences().getProjectEncoding()) && (iWorkspace = (workspace = ResourcesPlugin.getWorkspace())) instanceof Workspace) {
            void ws;
            Workspace workspace2 = (Workspace)iWorkspace;
            Workspace cfr_ignored_0 = (Workspace)iWorkspace;
            CharsetManager charsetManager = ws.getCharsetManager();
            String encoding = ResourcesPlugin.getEncoding();
            IProject[] iProjectArray = ProjectUtils.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!Objects.equals(encoding, project.getDefaultCharset(false))) {
                    try {
                        charsetManager.setCharsetFor(project.getFullPath(), encoding);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
                ++n2;
            }
        }
    }

    protected void importProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(rootPaths.size() * 100));
        MultiStatus importStatusCollection = new MultiStatus("org.eclipse.jdt.ls.core", -1, "Failed to import projects", null);
        block2: for (IPath rootPath : rootPaths) {
            File rootFolder = rootPath.toFile();
            try {
                for (IProjectImporter importer : ProjectsManager.importers()) {
                    importer.initialize(rootFolder);
                    if (!importer.applies((IProgressMonitor)subMonitor.split(1))) continue;
                    importer.importToWorkspace((IProgressMonitor)subMonitor.split(70));
                    if (importer.isResolved(rootFolder)) continue block2;
                }
            }
            catch (CoreException e) {
                importStatusCollection.add(e.getStatus());
                JavaLanguageServerPlugin.logException("Failed to import projects", e);
            }
        }
        if (!importStatusCollection.isOK()) {
            throw new CoreException((IStatus)importStatusCollection);
        }
    }

    protected void importProjectsFromConfigurationFiles(Collection<IPath> rootPaths, Collection<IPath> projectConfigurations, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(rootPaths.size() * 100));
        MultiStatus importStatusCollection = new MultiStatus("org.eclipse.jdt.ls.core", -1, "Failed to import projects", null);
        for (IPath rootPath : rootPaths) {
            File rootFolder = rootPath.toFile();
            try {
                for (IProjectImporter importer : ProjectsManager.importers()) {
                    importer.initialize(rootFolder);
                    if (!importer.applies(projectConfigurations, (IProgressMonitor)subMonitor.split(1))) continue;
                    importer.importToWorkspace((IProgressMonitor)subMonitor.split(70));
                }
            }
            catch (CoreException e) {
                importStatusCollection.add(e.getStatus());
                JavaLanguageServerPlugin.logException("Failed to import projects", e);
            }
        }
        if (!importStatusCollection.isOK()) {
            throw new CoreException((IStatus)importStatusCollection);
        }
    }

    public void importProjects(IProgressMonitor monitor) {
        WorkspaceJob job = new WorkspaceJob("Importing projects in workspace..."){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    ProjectsManager.this.importProjects(ProjectsManager.this.preferenceManager.getPreferences().getRootPaths(), monitor);
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.eclipse.jdt.ls.core", "Importing projects failed.", (Throwable)e);
                }
                List projectUris = Arrays.stream(ProjectsManager.getWorkspaceRoot().getProjects()).map(project -> ProjectUtils.getProjectRealFolder(project).toFile().toURI()).collect(Collectors.toList());
                EventNotification notification = new EventNotification().withType(EventType.ProjectsImported).withData(projectUris);
                ProjectsManager.this.client.sendEventNotification(notification);
                ProjectsManager.this.reportProjectsStatus();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ProjectsManager.getWorkspaceRoot());
        job.schedule();
    }

    @Override
    public Job updateWorkspaceFolders(final Collection<IPath> addedRootPaths, final Collection<IPath> removedRootPaths) {
        Job[] removedJobs;
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating workspace folders: Adding " + addedRootPaths.size() + " folder(s), removing " + removedRootPaths.size() + " folders.");
        Job[] jobArray = removedJobs = Job.getJobManager().find(removedRootPaths);
        int n = removedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job removedJob = jobArray[n2];
            if (removedJob.belongsTo((Object)"org.eclipse.jdt.ls.core.jobs.updateWorkspaceFolders") || removedJob.belongsTo((Object)"java-ls-initialization-jobs")) {
                removedJob.cancel();
            }
            ++n2;
        }
        WorkspaceJob job = new WorkspaceJob("Updating workspace folders"){

            public boolean belongsTo(Object family) {
                Collection addedRootPathsSet = addedRootPaths.stream().collect(Collectors.toSet());
                boolean equalToRootPaths = false;
                if (family instanceof Collection) {
                    equalToRootPaths = addedRootPathsSet.equals(((Collection)family).stream().collect(Collectors.toSet()));
                }
                return "org.eclipse.jdt.ls.core.jobs.updateWorkspaceFolders".equals(family) || "org.eclipse.jdt.ls.core.jobs".equals(family) || equalToRootPaths;
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(addedRootPaths.size() + removedRootPaths.size()));
                try {
                    IProject[] projects;
                    long start = System.currentTimeMillis();
                    IProject[] iProjectArray = projects = ProjectsManager.getWorkspaceRoot().getProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (ResourceUtils.isContainedIn(project.getLocation(), removedRootPaths)) {
                            try {
                                project.delete(false, true, (IProgressMonitor)subMonitor.split(1));
                            }
                            catch (CoreException e) {
                                JavaLanguageServerPlugin.logException("Problems removing '" + project.getName() + "' from workspace.", e);
                            }
                        }
                        ++n2;
                    }
                    ProjectsManager.this.importProjects(addedRootPaths, (IProgressMonitor)subMonitor.split(addedRootPaths.size()));
                    ProjectsManager.this.registerWatchers(true);
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated workspace folders in " + elapsed + " ms: Added " + addedRootPaths.size() + " folder(s), removed" + removedRootPaths.size() + " folders.");
                    JavaLanguageServerPlugin.logInfo(ProjectsManager.this.getWorkspaceInfo());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String msg = "Error updating workspace folders";
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                    ProjectsManager.this.cleanInvalidProjects(ProjectsManager.this.preferenceManager.getPreferences().getRootPaths(), monitor);
                    return status;
                }
            }
        };
        job.setRule((ISchedulingRule)ProjectsManager.getWorkspaceRoot());
        job.schedule();
        return job;
    }

    public void cleanupResources(IProject project) throws CoreException {
        IJavaProject javaProj = JavaCore.create((IProject)project);
        if (javaProj == null) {
            return;
        }
        Arrays.stream(javaProj.getPackageFragments()).filter(packageFragment -> {
            try {
                return packageFragment.containsJavaResources() && packageFragment.getKind() == 1;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to collect " + project.getName() + "' package fragements", e);
                return false;
            }
        }).flatMap(packageFragment -> {
            try {
                return Arrays.stream(packageFragment.getCompilationUnits());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to collect " + project.getName() + "'s compilation units", e);
                return null;
            }
        }).forEach(cu -> {
            try {
                File f;
                IResource resource = cu.getResource();
                if (resource.isLinked() && !(f = new File(cu.getUnderlyingResource().getLocationURI())).exists()) {
                    cu.delete(true, null);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to delete missing compilation unit (" + cu.getElementName() + ") from " + project.getName(), e);
            }
        });
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return this.buildSupports().filter(bs -> bs.isBuildFile(resource)).findAny().isPresent();
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return this.buildSupports().filter(bs -> bs.isBuildLikeFileName(fileName)).findAny().isPresent();
    }

    public static IProject getDefaultProject() {
        return ProjectsManager.getWorkspaceRoot().getProject(DEFAULT_PROJECT_NAME);
    }

    public static Collection<IProjectImporter> importers() {
        TreeMap<Integer, IProjectImporter> importers = new TreeMap<Integer, IProjectImporter>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.ls.core", "importers");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            try {
                Integer order = Integer.valueOf(configs[i].getAttribute("order"));
                importers.put(order, (IProjectImporter)configs[i].createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e.getStatus());
            }
            ++i;
        }
        return importers.values();
    }

    public static IProject createJavaProject(IProject project, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return ProjectsManager.createJavaProject(project, null, "src", "bin", monitor);
    }

    public static IProject createJavaProject(IProject project, IPath projectLocation, String src, String bin, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (project.exists()) {
            return project;
        }
        JavaLanguageServerPlugin.logInfo("Creating the Java project " + project.getName());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        if (projectLocation != null) {
            description.setLocation(projectLocation);
        }
        project.create(description, monitor);
        project.open(monitor);
        description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        JVMConfigurator.configureJVMSettings(javaProject);
        if (!JDTEnvironmentUtils.isSyntaxServer()) {
            JobHelpers.waitForAutoBuildJobs(300000);
        }
        if (StringUtils.isNotBlank((CharSequence)bin)) {
            IFolder output = project.getFolder(bin);
            if (!output.exists()) {
                output.create(true, true, monitor);
            }
            javaProject.setOutputLocation(output.getFullPath(), monitor);
        }
        ArrayList<IClasspathEntry> classpaths = new ArrayList<IClasspathEntry>();
        if (StringUtils.isNotBlank((CharSequence)src)) {
            IFolder source = project.getFolder(src);
            if (!source.exists()) {
                source.create(true, true, monitor);
            }
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)source);
            IClasspathEntry srcClasspath = JavaCore.newSourceEntry((IPath)root.getPath());
            classpaths.add(srcClasspath);
        }
        IClasspathEntry jre = JavaRuntime.getDefaultJREContainerEntry();
        classpaths.add(jre);
        javaProject.setRawClasspath(classpaths.toArray(new IClasspathEntry[0]), monitor);
        JavaLanguageServerPlugin.logInfo("Finished creating the Java project " + project.getName());
        return project;
    }

    @Override
    public Job updateProject(final IProject project, final boolean force) {
        if (project == null || ProjectUtils.isInternalBuildSupport(BuildSupportManager.find(project).orElse(null))) {
            return null;
        }
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating " + project.getName() + " configuration");
        WorkspaceJob job = new WorkspaceJob("Update project " + project.getName()){

            public boolean belongsTo(Object family) {
                return "org.eclipse.jdt.ls.core.jobs.updateProject".equals(family) || ("org.eclipse.jdt.ls.core.jobs." + project.getName()).equals(family) || "org.eclipse.jdt.ls.core.jobs".equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                String projectName = project.getName();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).checkCanceled();
                try {
                    long start = System.currentTimeMillis();
                    project.refreshLocal(2, (IProgressMonitor)progress.split(5));
                    Optional<IBuildSupport> buildSupport = ProjectsManager.this.getBuildSupport(project);
                    if (buildSupport.isPresent()) {
                        buildSupport.get().update(project, force, (IProgressMonitor)progress.split(95));
                        ProjectsManager.this.registerWatchers(true);
                    }
                    ProjectsManager.this.updateEncoding(monitor);
                    project.deleteMarkers(ProjectsManager.BUILD_FILE_MARKER_TYPE, false, 1);
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated " + projectName + " in " + elapsed + " ms");
                }
                catch (Exception e) {
                    String msg = "Error updating " + projectName;
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                }
                ProjectsManager.this.reportProjectsStatus();
                return status;
            }
        };
        job.schedule();
        return job;
    }

    @Override
    public Job updateProjects(Collection<IProject> projects, boolean force) {
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating project configurations...");
        UpdateProjectsWorkspaceJob job = new UpdateProjectsWorkspaceJob(projects, force);
        job.schedule();
        return job;
    }

    @Override
    public Optional<IBuildSupport> getBuildSupport(IProject project) {
        return this.buildSupports().filter(bs -> bs.applies(project)).findFirst();
    }

    public boolean useDefaultVM(IProject project, IVMInstall defaultVM) {
        if (project == null) {
            return false;
        }
        IBuildSupport buildSupport = this.getBuildSupport(project).orElse(null);
        if (buildSupport != null) {
            return buildSupport.useDefaultVM(project, defaultVM);
        }
        return false;
    }

    protected Stream<IBuildSupport> buildSupports() {
        return Stream.of(new EclipseBuildSupport());
    }

    public void setConnection(JavaClientConnection.JavaLanguageClient client) {
        this.client = client;
    }

    public JavaClientConnection.JavaLanguageClient getConnection() {
        return this.client;
    }

    private String getWorkspaceInfo() {
        StringBuilder b = new StringBuilder();
        b.append("Projects:\n");
        IProject[] iProjectArray = ProjectsManager.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            b.append(project.getName()).append(": ").append(project.getLocation().toOSString()).append('\n');
            if (ProjectUtils.isJavaProject(project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    IClasspathEntry[] cpEntries;
                    b.append("  resolved classpath:\n");
                    IClasspathEntry[] iClasspathEntryArray = cpEntries = javaProject.getRawClasspath();
                    int n3 = cpEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        b.append("  ").append(cpe.getPath().toString()).append('\n');
                        if (cpe.getEntryKind() == 5) {
                            IPackageFragmentRoot[] roots;
                            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.findPackageFragmentRoots(cpe);
                            int n5 = roots.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPackageFragmentRoot root = iPackageFragmentRootArray[n6];
                                b.append("    ").append(root.getPath().toString()).append('\n');
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                b.append("  non-Java project\n");
            }
            ++n2;
        }
        b.append("Java Runtimes:\n");
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        b.append("  default: ");
        if (defaultVMInstall != null) {
            b.append(defaultVMInstall.getInstallLocation().toString());
        } else {
            b.append("-");
        }
        IExecutionEnvironmentsManager eem = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = eem.getExecutionEnvironments();
        int n7 = iExecutionEnvironmentArray.length;
        int n8 = 0;
        while (n8 < n7) {
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n8];
            IVMInstall[] vms = ee.getCompatibleVMs();
            b.append("  ").append(ee.getDescription()).append(": ");
            if (vms.length > 0) {
                b.append(vms[0].getInstallLocation().toString());
            } else {
                b.append("-");
            }
            b.append("\n");
            ++n8;
        }
        return b.toString();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public static boolean setAutoBuilding(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean changed = description.isAutoBuilding() ^ enable;
        if (changed) {
            description.setAutoBuilding(enable);
            workspace.setDescription(description);
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    public static Runnable interruptAutoBuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspace iWorkspace = workspace;
        if (iWorkspace instanceof Workspace) {
            void ws;
            Workspace workspace2 = (Workspace)iWorkspace;
            Workspace cfr_ignored_0 = (Workspace)iWorkspace;
            ws.getBuildManager().interrupt();
            return () -> {};
        }
        boolean changed = ProjectsManager.setAutoBuilding(false);
        if (changed) {
            return () -> {
                try {
                    ProjectsManager.setAutoBuilding(true);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            };
        }
        return () -> {};
    }

    public void configureFilters(IProgressMonitor monitor) throws CoreException {
        List<String> resourceFilters = this.preferenceManager.getPreferences().getResourceFilters();
        if (resourceFilters != null && !resourceFilters.isEmpty()) {
            resourceFilters = new ArrayList<String>(resourceFilters);
            resourceFilters.add(CREATED_BY_JAVA_LANGUAGE_SERVER);
        }
        String resourceFilter = resourceFilters == null ? null : String.join((CharSequence)"|", resourceFilters);
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.equals((Object)ProjectsManager.getDefaultProject())) {
                List filters = Stream.of(project.getFilters()).filter(f -> {
                    Object object;
                    FileInfoMatcherDescription matcher = f.getFileInfoMatcherDescription();
                    if (CORE_RESOURCES_MATCHER_ID.equals(matcher.getId()) && (object = matcher.getArguments()) instanceof String) {
                        void args;
                        String string = (String)object;
                        String cfr_ignored_0 = (String)object;
                        if (args.contains(CREATED_BY_JAVA_LANGUAGE_SERVER)) {
                            return true;
                        }
                    }
                    return false;
                }).collect(Collectors.toList());
                boolean filterExists = false;
                for (IResourceFilterDescription filter : filters) {
                    if (resourceFilter == null || resourceFilter.isEmpty()) {
                        filter.delete(128, monitor);
                        continue;
                    }
                    if (!Objects.equals(resourceFilter, filter.getFileInfoMatcherDescription().getArguments())) {
                        filter.delete(128, monitor);
                        continue;
                    }
                    filterExists = true;
                    break;
                }
                if (!filterExists && resourceFilter != null && !resourceFilter.isEmpty()) {
                    project.createFilter(30, new FileInfoMatcherDescription(CORE_RESOURCES_MATCHER_ID, (Object)resourceFilter), 128, monitor);
                }
            }
            ++n2;
        }
    }

    public void reportProjectsStatus() {
        int maxProjectProblemSeverity = ProjectUtils.getMaxProjectProblemSeverity();
        if (maxProjectProblemSeverity == 2) {
            JavaLanguageServerPlugin.sendStatus(ServiceStatus.ProjectStatus, "WARNING");
        } else {
            JavaLanguageServerPlugin.sendStatus(ServiceStatus.ProjectStatus, "OK");
        }
    }

    public static enum CHANGE_TYPE {
        CREATED,
        CHANGED,
        DELETED;

    }

    class UpdateProjectsWorkspaceJob
    extends WorkspaceJob {
        private final Collection<IProject> projects;
        private final boolean force;

        public UpdateProjectsWorkspaceJob(Collection<IProject> projects, boolean force) {
            super("Updating project configurations");
            this.projects = projects;
            this.force = force;
        }

        public boolean belongsTo(Object family) {
            return "org.eclipse.jdt.ls.core.jobs.updateProject".equals(family) || "org.eclipse.jdt.ls.core.jobs".equals(family);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            long start = System.currentTimeMillis();
            MultiStatus status = new MultiStatus("org.eclipse.jdt.ls.core", 0, "Update project configurations");
            for (Map.Entry<IBuildSupport, List<IProject>> entry : this.groupByBuildSupport(this.projects).entrySet()) {
                IStatus onWillUpdateStatus = this.onWillConfigurationUpdate(entry.getKey(), (Collection<IProject>)entry.getValue(), monitor);
                if (!onWillUpdateStatus.isOK()) {
                    status.add(onWillUpdateStatus);
                    continue;
                }
                for (IProject project : entry.getValue()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.updateProject(entry.getKey(), project, this.force, status, monitor);
                }
            }
            this.onDidConfigurationUpdated(status, monitor);
            long elapsed = System.currentTimeMillis() - start;
            JavaLanguageServerPlugin.logInfo("Projects updated in " + elapsed + " ms");
            return status;
        }

        private Map<IBuildSupport, List<IProject>> groupByBuildSupport(Collection<IProject> projects) {
            HashMap<IBuildSupport, List<IProject>> groupByBuildSupport = new HashMap<IBuildSupport, List<IProject>>();
            List<IBuildSupport> buildSupports = ProjectsManager.this.buildSupports().toList();
            for (IProject project : projects) {
                Optional<IBuildSupport> buildSupport = buildSupports.stream().filter(bs -> bs.applies(project)).findFirst();
                if (!buildSupport.isPresent()) continue;
                IBuildSupport bs2 = buildSupport.get();
                groupByBuildSupport.computeIfAbsent(bs2, k -> new ArrayList()).add(project);
            }
            return groupByBuildSupport;
        }

        private IStatus onWillConfigurationUpdate(IBuildSupport buildSupport, Collection<IProject> projects, IProgressMonitor monitor) {
            try {
                buildSupport.onWillUpdate(projects, monitor);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                return StatusFactory.newErrorStatus("Failed to prepare update from " + buildSupport.buildToolName(), e);
            }
        }

        private void updateProject(IBuildSupport buildSupport, IProject project, boolean force, MultiStatus status, IProgressMonitor monitor) {
            try {
                project.refreshLocal(2, monitor);
                buildSupport.update(project, force, monitor);
                project.deleteMarkers(ProjectsManager.BUILD_FILE_MARKER_TYPE, false, 1);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                status.add(StatusFactory.newErrorStatus("Error updating " + project.getName(), e));
            }
        }

        private void onDidConfigurationUpdated(MultiStatus status, IProgressMonitor monitor) {
            try {
                ProjectsManager.this.registerWatchers(true);
                ProjectsManager.this.updateEncoding(monitor);
                ProjectsManager.this.reportProjectsStatus();
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                status.add(StatusFactory.newErrorStatus("Error updating encoding", e));
            }
        }
    }
}

