/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameNodeCorrectionProposal
extends CUCorrectionProposal {
    private String fNewName;
    private int fOffset;
    private int fLength;

    public RenameNodeCorrectionProposal(String name, ICompilationUnit cu, int offset, int length, String newName, int relevance) {
        super(name, "quickfix", cu, null, relevance);
        this.fOffset = offset;
        this.fLength = length;
        this.fNewName = newName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addEdits(IDocument doc, TextEdit root) throws CoreException {
        super.addEdits(doc, root);
        CompilationUnit unit = CoreASTProvider.getInstance().getAST((ITypeRoot)this.getCompilationUnit(), CoreASTProvider.WAIT_YES, null);
        if (unit == null) {
            return;
        }
        ASTNode name = NodeFinder.perform((ASTNode)unit, (int)this.fOffset, (int)this.fLength);
        ASTNode aSTNode = name;
        if (aSTNode instanceof SimpleName) {
            void simpleName;
            SimpleName simpleName2 = (SimpleName)aSTNode;
            SimpleName cfr_ignored_0 = (SimpleName)aSTNode;
            SimpleName[] names = LinkedNodeFinder.findByProblems((ASTNode)unit, (SimpleName)simpleName);
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    SimpleName curr = names[i];
                    root.addChild((TextEdit)new ReplaceEdit(curr.getStartPosition(), curr.getLength(), this.fNewName));
                    ++i;
                }
                return;
            }
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fOffset, this.fLength, this.fNewName));
    }
}

